/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.ObjectDb;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.Date;
import java.text.SimpleDateFormat;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;

public class AppInfoPane
extends UIParent {
    @FXML
    private Label lblVersion;
    @FXML
    private Label lblInvoice;
    @FXML
    private Label lblCurrAppDate;
    @FXML
    private Label lblLastProdPush;
    @FXML
    private Label lblLastCustPush;
    @FXML
    private Label lblLastCustPull;
    @FXML
    private Label lblLastSalePush;
    @FXML
    private Label lblLastSalePull;
    @FXML
    public Button btnSaveCustomer;

    public AppInfoPane(Santa app) throws Exception {
        super("AppInfoPane.fxml", app);
        this.title = "Application Information Page";
        SimpleDateFormat sf = new SimpleDateFormat("d-MMM-yyyy hh:mm:ss");
        this.lblVersion.setText(ObjectDb.VERSION + "         " + sf.format(ObjectDb.loadLocalDb().getLastUpdateDate()));
        this.lblInvoice.setText(Integer.toString(app.currentUser.getParentCompany().getLastInvoiceNumber()));
        this.lblCurrAppDate.setText(sf.format(Date.valueOf(app.currentUser.getParentCompany().getCurrentDay())));
        this.lblLastProdPush.setText(sf.format(app.syncSetting.getProdDateLastRead()));
        this.lblLastCustPush.setText(sf.format(app.syncSetting.getCustDateLastSync()));
        this.lblLastCustPull.setText(sf.format(app.syncSetting.getCustDateLastRead()));
        this.lblLastSalePush.setText(sf.format(app.syncSetting.getSaleDateLastSync()));
        this.lblLastSalePull.setText(sf.format(app.syncSetting.getSaleDateLastSync()));
    }
}

