/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextArea;
import com.xputertechnologies.santa.Account;
import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.ISaleCallBack;
import com.xputertechnologies.santa.IWebCallBack;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SaleAccountDetailResolver;
import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.SaleStatus;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.AccountDataList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.list.SyncSettingDataList;
import com.xputertechnologies.santa.list.UnitDataList;
import com.xputertechnologies.santa.report.ReportType;
import com.xputertechnologies.santa.ui.AdminSalesViewItem;
import com.xputertechnologies.santa.ui.CustomEditableTableColumnsAutocomplete;
import com.xputertechnologies.santa.ui.CustomEditableTableColumnsSaleItemItemCodeAutocomplete;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.MainPage;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.ReportPane;
import com.xputertechnologies.santa.ui.SalesReturnPaneAudit;
import com.xputertechnologies.santa.ui.SerialView;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import org.controlsfx.glyphfont.FontAwesome;

public class AdminSalesView
extends UIParent {
    @FXML
    private StackPane stackPane;
    @FXML
    private Label lblcount;
    @FXML
    private Label naira;
    @FXML
    private Label total;
    @FXML
    private JFXDatePicker fromDate;
    @FXML
    private JFXDatePicker toDate;
    @FXML
    private JFXTextArea textAreaInvoice;
    @FXML
    private JFXComboBox<Store> cmbStore;
    @FXML
    private JFXButton SearchButton;
    @FXML
    private JFXComboBox<String> cmbFilter;
    @FXML
    private ListView<Sale> listView;
    @FXML
    private MenuItem summaryRpt;
    @FXML
    private MenuItem detailRpt;
    @FXML
    private TableView<SaleItem> tbItem;
    @FXML
    private TableView<SaleAccountDetailResolver> tbPayment;
    @FXML
    private TableColumn<SaleItem, String> colItemCode;
    @FXML
    private TableColumn<SaleItem, String> colDescription;
    @FXML
    private TableColumn<SaleItem, String> colStore;
    @FXML
    private TableColumn<SaleItem, String> colRet;
    @FXML
    private TableColumn<SaleItem, Float> colQty;
    @FXML
    private TableColumn<Integer, SaleItem> colTotQty;
    @FXML
    private TableColumn<SaleItem, Double> colPrice;
    @FXML
    private TableColumn<SaleAccountDetailResolver, Double> colAmount;
    @FXML
    private TableColumn<SaleAccountDetailResolver, String> colAccNo;
    @FXML
    private TableColumn<SaleAccountDetailResolver, String> colAccType;
    @FXML
    private TableColumn<SaleAccountDetailResolver, String> colpaycode;
    @FXML
    private TableColumn<SaleAccountDetailResolver, String> colAccName;
    @FXML
    private TableColumn colSerial;
    @FXML
    private TableColumn colLineStatus;
    UnitDataList unitDataList;
    Customer currentCustomer;
    Double Total = 0.0;
    SyncSettingDataList syncSettingDataList = null;
    StoreDataList storeDataList = null;
    AccountDataList accontDataList = null;
    String errormsg;
    Sale oldselectedSale;
    int i = 0;
    private Sale sale = null;
    private ArrayList<ParameterValue> tempParamValue = new ArrayList();
    private SaleList saleList;
    Double tot = 0.0;

    public AdminSalesView(MainPage mp) {
        super("AdminSalesView.fxml", mp.santa);
        this.title = "Global Sales";
        this.saleList = new SaleList(this.da);
        this.fromDate.setValue((Object)LocalDate.now());
        this.toDate.setValue((Object)LocalDate.now());
        this.syncSettingDataList = new SyncSettingDataList(this.da);
        this.syncSettingDataList.selectAll("Select * From SyncSetting", this.da);
        this.storeDataList = new StoreDataList(this.da);
        this.storeDataList.selectAll(this.da);
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ObservableList reportFilter = FXCollections.observableArrayList();
        for (int i = 0; i < SaleStatus.values().length; ++i) {
            reportFilter.add((Object)SaleStatus.values()[i].name());
        }
        this.cmbFilter.setItems(reportFilter);
        this.cmbFilter.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String value;
                SaleList sales = new SaleList(AdminSalesView.this.da);
                String string = value = newValue == null ? oldValue : newValue;
                if (AdminSalesView.this.saleList.getOriginalList().size() > 0) {
                    if (value.equals((Object)SaleStatus.ALL)) {
                        AdminSalesView.this.setData(null);
                    } else {
                        sales.getOriginalList().clear();
                        sales.getOriginalList().addAll((Collection)AdminSalesView.this.saleList.getOriginalList().stream().filter(prdct -> prdct.getSaleStatus().equals(value)).collect(Collectors.toList()));
                        AdminSalesView.this.listView.getItems().clear();
                        AdminSalesView.this.listView.getItems().addAll(sales.getOriginalList());
                        AdminSalesView.this.tbItem.getItems().clear();
                        AdminSalesView.this.tbPayment.getItems().clear();
                    }
                    if (sales.getOriginalList().size() == 1) {
                        AdminSalesView.this.listView.getSelectionModel().select(0);
                        AdminSalesView.this.tbItem.setItems(((Sale)sales.getOriginalList().get(0)).getSaleItemsList());
                        AdminSalesView.this.tbItem.refresh();
                        AdminSalesView.this.tbPayment.setItems(((Sale)sales.getOriginalList().get(0)).getPayments().getOriginalList());
                        AdminSalesView.this.tbPayment.refresh();
                    } else if (AdminSalesView.this.sale != null) {
                        AdminSalesView.this.tbItem.setItems(AdminSalesView.this.sale.getSaleItemsList());
                        AdminSalesView.this.tbItem.refresh();
                        AdminSalesView.this.tbPayment.setItems(AdminSalesView.this.sale.getPayments().getOriginalList());
                        AdminSalesView.this.tbPayment.refresh();
                    }
                }
            }
        });
        Callback<TableColumn<SaleItem, String>, TableCell<SaleItem, String>> cellFactoryVieSerial = new Callback<TableColumn<SaleItem, String>, TableCell<SaleItem, String>>(){

            public TableCell call(TableColumn<SaleItem, String> param) {
                TableCell<SaleItem, String> cell = new TableCell<SaleItem, String>(){
                    final JFXButton lbl = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            SaleItem req = (SaleItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getSerials().getOriginalList().isEmpty()) {
                                this.lbl.setPrefHeight(30.0);
                                this.lbl.setPrefWidth(30.0);
                                this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                                this.lbl.setGraphic((Node)AdminSalesView.this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.GREEN).size(15.0));
                                this.lbl.setOnAction(c -> {
                                    ObservableList observableList = FXCollections.observableArrayList();
                                    AdminSalesView.this.i = 0;
                                    req.getSerials().getOriginalList().forEach(x -> {
                                        ++AdminSalesView.this.i;
                                        NameValueObject valuePair = new NameValueObject(AdminSalesView.this.da);
                                        valuePair.setKey(Integer.toString(AdminSalesView.this.i));
                                        valuePair.setData(x.getSerial());
                                        observableList.add((Object)valuePair);
                                    });
                                    JFXDialog dialog = new JFXDialog();
                                    dialog.setDialogContainer(AdminSalesView.this.stackPane);
                                    dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
                                    dialog.setContent((Region)new SerialView(AdminSalesView.this.santa, dialog, req.getItemName(), (ObservableList<NameValueObject>)observableList));
                                    dialog.setOverlayClose(false);
                                    dialog.show();
                                });
                                this.setGraphic((Node)this.lbl);
                            } else {
                                this.setGraphic(null);
                            }
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colSerial.setCellFactory((Callback)cellFactoryVieSerial);
        Comparator<Store> comparatorMyObject_Name = new Comparator<Store>(){

            @Override
            public int compare(Store o1, Store o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        this.colTotQty.setCellValueFactory((Callback)new PropertyValueFactory("totalQty"));
        this.colRet.setCellValueFactory((Callback)new PropertyValueFactory("returnQty"));
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        Callback itemCodeFactory = param -> new CustomEditableTableColumnsSaleItemItemCodeAutocomplete(this.santa.Products);
        this.colItemCode.setCellFactory(itemCodeFactory);
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colDescription.setCellFactory(param -> {
            TableCell<SaleItem, String> cell = new TableCell<SaleItem, String>(){

                public void updateItem(String value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(value);
                        SaleItem item = (SaleItem)this.getTableRow().getItem();
                        if (item != null) {
                            Tooltip tooltip = new Tooltip(item.serialToolTipProperty());
                            lbl.setTooltip(tooltip);
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("sellingPrice"));
        this.colAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountPaid"));
        Callback<TableColumn<SaleItem, String>, TableCell<SaleItem, String>> cellFactorycolLineStatus = new Callback<TableColumn<SaleItem, String>, TableCell<SaleItem, String>>(){

            public TableCell call(TableColumn<SaleItem, String> param) {
                TableCell<SaleItem, String> cell = new TableCell<SaleItem, String>(){
                    final Label lbl = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            SaleItem req = (SaleItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getLineStatus().isEmpty()) {
                                if (req.getLineStatus().equals("Invoiced")) {
                                    this.lbl.setStyle("-fx-background-color:#CCFFFF;-fx-font-size: 12.0px;");
                                } else {
                                    this.lbl.setStyle("-fx-background-color:#FC02DD;-fx-font-size: 12.0px;");
                                }
                                this.lbl.setText(req.getLineStatus());
                                this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                                this.setGraphic((Node)this.lbl);
                                this.setAlignment(Pos.CENTER);
                                this.setGraphic((Node)this.lbl);
                            } else {
                                this.setGraphic(null);
                            }
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colLineStatus.setCellFactory((Callback)cellFactorycolLineStatus);
        this.colAccName.setCellValueFactory((Callback)new PropertyValueFactory("accountName"));
        Callback accNameFactory = param -> new CustomEditableTableColumnsAutocomplete((List<Account>)this.accontDataList.getOriginalList());
        this.colAccName.setCellFactory(accNameFactory);
        this.colAccNo.setCellValueFactory((Callback)new PropertyValueFactory("accNumber"));
        this.colAccType.setCellValueFactory((Callback)new PropertyValueFactory("accType"));
        this.colpaycode.setCellValueFactory((Callback)new PropertyValueFactory("paymentCode"));
        Collections.sort(this.storeDataList.getOriginalList(), comparatorMyObject_Name);
        Store store = new Store(this.da);
        store.setCode("-1");
        store.setName("All");
        this.storeDataList.getOriginalList().add(0, (Object)store);
        this.accontDataList = new AccountDataList(this.da);
        this.accontDataList.selectAll("Select *from Account", this.da.getEmptyParameterValues());
        Comparator<Account> comparatorMyObject_Name_Account = new Comparator<Account>(){

            @Override
            public int compare(Account o1, Account o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        Collections.sort(this.accontDataList.getOriginalList(), comparatorMyObject_Name_Account);
        this.cmbStore.setItems(this.storeDataList.getOriginalList());
        this.cmbStore.getSelectionModel().select(0);
        this.cmbStore.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            }
        });
        this.cmbStore.setItems(this.storeDataList.getOriginalList());
        this.cmbStore.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            }
        });
        this.listView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Sale>(){

            public void changed(ObservableValue<? extends Sale> observable, Sale oldValue, Sale newValue) {
                if (newValue != null) {
                    AdminSalesView.this.oldselectedSale = oldValue;
                    AdminSalesView.this.Total = 0.0;
                    newValue.getPayments().getOriginalList().forEach(val -> {
                        AdminSalesView.this.Total = AdminSalesView.this.Total + val.getAmountPaid();
                    });
                    AdminSalesView.this.setSelectionChange();
                }
            }
        });
        this.listView.setCellFactory((Callback)new Callback<ListView<Sale>, ListCell<Sale>>(){

            public ListCell<Sale> call(ListView<Sale> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<Sale> cell = new ListCell<Sale>(){

                    public void updateItem(Sale sale, boolean empty) {
                        super.updateItem((Object)sale, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            tooltip.setText(sale.getSyncError());
                            this.setTooltip(tooltip);
                            AdminSalesViewItem srp = new AdminSalesViewItem(sale, AdminSalesView.this);
                            this.setGraphic((Node)srp);
                        }
                    }
                };
                return cell;
            }
        });
        this.listView.setItems(this.saleList.getOriginalList());
        this.SearchButton.setOnAction(v -> {
            if (this.cmbStore.getSelectionModel().getSelectedItem() != null) {
                this.saleList.getOriginalList().clear();
                this.setData(null);
                this.reloadSale("");
            } else {
                this.santa.mainpage.showNotification(NotificationType.Error, "Please Select Store", this);
            }
        });
        this.summaryRpt.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (AdminSalesView.this.listView.getItems().size() > 0) {
                    Dialog dialog = new Dialog();
                    dialog.initStyle(StageStyle.DECORATED);
                    dialog.initOwner((Window)AdminSalesView.this.santa.stage);
                    dialog.setTitle("Sales Report");
                    dialog.setResizable(true);
                    try {
                        ReportPane.FromDt = Date.valueOf((LocalDate)AdminSalesView.this.fromDate.getValue());
                        ReportPane.ToDt = Date.valueOf((LocalDate)AdminSalesView.this.toDate.getValue());
                        dialog.getDialogPane().setContent((Node)new ReportPane(AdminSalesView.this.santa, ReportType.AuditDailySalesByAccount, null, (ObservableList<Sale>)AdminSalesView.this.listView.getItems(), ((Store)AdminSalesView.this.cmbStore.getSelectionModel().getSelectedItem()).getName()));
                    }
                    catch (JRException ex) {
                        Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                    dialog.show();
                }
            }
        });
        this.detailRpt.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (AdminSalesView.this.listView.getItems().size() > 0) {
                    Dialog dialog = new Dialog();
                    dialog.initStyle(StageStyle.DECORATED);
                    dialog.initOwner((Window)AdminSalesView.this.santa.stage);
                    dialog.setTitle("Sales Report");
                    dialog.setResizable(true);
                    try {
                        ReportPane.FromDt = Date.valueOf((LocalDate)AdminSalesView.this.fromDate.getValue());
                        ReportPane.ToDt = Date.valueOf((LocalDate)AdminSalesView.this.toDate.getValue());
                        dialog.getDialogPane().setContent((Node)new ReportPane(AdminSalesView.this.santa, ReportType.DailySalesSummary, null, (ObservableList<Sale>)AdminSalesView.this.listView.getItems(), ((Store)AdminSalesView.this.cmbStore.getSelectionModel().getSelectedItem()).getName()));
                    }
                    catch (JRException ex) {
                        Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                    dialog.show();
                }
            }
        });
        this.naira.setText(General.toNaira());
    }

    void reloadSale(final String invoiceNo) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        String store = ((Store)AdminSalesView.this.cmbStore.getSelectionModel().getSelectedItem()).getName().equals("All") ? "All" : ((Store)AdminSalesView.this.cmbStore.getSelectionModel().getSelectedItem()).getCode();
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        LocalDateTime Strtdatetime = LocalDate.of(((LocalDate)AdminSalesView.this.fromDate.getValue()).getYear(), ((LocalDate)AdminSalesView.this.fromDate.getValue()).getMonth().getValue(), ((LocalDate)AdminSalesView.this.fromDate.getValue()).getDayOfMonth()).atTime(0, 0, 0);
                        LocalDateTime Enddatetime = LocalDate.of(((LocalDate)AdminSalesView.this.toDate.getValue()).getYear(), ((LocalDate)AdminSalesView.this.toDate.getValue()).getMonth().getValue(), ((LocalDate)AdminSalesView.this.toDate.getValue()).getDayOfMonth()).atTime(23, 59, 0);
                        String fromDt = format.format(Date.from(Strtdatetime.atZone(ZoneId.systemDefault()).toInstant()));
                        String toDt = format.format(Date.from(Enddatetime.atZone(ZoneId.systemDefault()).toInstant()));
                        String url = "salesorder/getDateChange/" + fromDt + "/" + toDt + "/" + store;
                        if (!AdminSalesView.this.textAreaInvoice.getText().isEmpty() || !invoiceNo.isEmpty()) {
                            String param = invoiceNo.isEmpty() ? AdminSalesView.this.textAreaInvoice.getText() : invoiceNo;
                            url = url + "?condition=" + param;
                        }
                        new SyncData(AdminSalesView.this.santa, AdminSalesView.this.da, null).getSale(url, AdminSalesView.this.da, new ISaleCallBack(){

                            @Override
                            public void onSuccess(SaleList data) {
                                if (invoiceNo.isEmpty()) {
                                    AdminSalesView.this.saleList.getOriginalList().clear();
                                    AdminSalesView.this.saleList.getOriginalList().addAll(data.getOriginalList());
                                }
                                if (data.getOriginalList().isEmpty()) {
                                    AdminSalesView.this.mainPage.showNotification(NotificationType.Information, "No result found", AdminSalesView.this);
                                } else {
                                    AdminSalesView.this.setData(invoiceNo.isEmpty() ? null : (Sale)data.getOriginalList().get(0));
                                    AdminSalesView.this.mainPage.showNotification(NotificationType.Success, "Operation successful", AdminSalesView.this);
                                }
                                AdminSalesView.this.stackPane.getChildren().remove((Object)box);
                            }

                            @Override
                            public void onError(String data) {
                                AdminSalesView.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, AdminSalesView.this);
                                AdminSalesView.this.stackPane.getChildren().remove((Object)box);
                            }

                            @Override
                            public void onTimeOut(String data) {
                                AdminSalesView.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", AdminSalesView.this);
                                AdminSalesView.this.stackPane.getChildren().remove((Object)box);
                            }
                        });
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void pushSales(final Sale s, final String url) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        new SyncData(AdminSalesView.this.santa, AdminSalesView.this.da, AdminSalesView.this.currentUser.getParentCompany()).pushSales(AdminSalesView.this.santa.syncSetting, s, url, new IWebCallBack(){

                            @Override
                            public void onSuccess(String data) {
                                AdminSalesView.this.stackPane.getChildren().remove((Object)box);
                                AdminSalesView.this.santa.mainpage.showNotification(NotificationType.Success, "Operation successful, Please reload the sale", AdminSalesView.this);
                            }

                            @Override
                            public void onError(String data) {
                                AdminSalesView.this.santa.mainpage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, AdminSalesView.this);
                                AdminSalesView.this.stackPane.getChildren().remove((Object)box);
                            }

                            @Override
                            public void onTimeOut(String data) {
                                AdminSalesView.this.santa.mainpage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", AdminSalesView.this);
                                AdminSalesView.this.stackPane.getChildren().remove((Object)box);
                            }
                        });
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    private void setData(Sale s) {
        if (s != null) {
            Sale sl = this.saleList.getOriginalList().stream().filter(sale -> sale.getInvoiceNumber() == s.getInvoiceNumber()).findAny().get();
            Sale sale2 = s;
        } else {
            this.listView.setItems(this.saleList.getOriginalList());
        }
        this.listView.refresh();
        this.tbItem.getItems().clear();
        this.tbItem.refresh();
        this.tbPayment.getItems().clear();
        this.tbPayment.refresh();
        this.sale = null;
        this.lblcount.setText(this.saleList.getOriginalList().size() + " Sale(s) Loaded");
        this.total.setText("0.0");
    }

    private void setSelectionChange() {
        this.tempParamValue.clear();
        this.sale = (Sale)this.listView.getSelectionModel().getSelectedItem();
        if (this.sale != null) {
            this.tbItem.setItems(this.sale.getSaleItemsList());
            this.tbItem.refresh();
            this.tbPayment.setItems(this.sale.getSaleAccountDetailResolvers());
            this.tbPayment.refresh();
            this.tot = 0.0;
            this.sale.getSaleAccountDetailResolvers().forEach(sdr -> {
                this.tot = this.tot + sdr.getAmountPaid();
            });
            this.total.setText(General.formatDecimalToMoneyString(this.tot));
        }
    }
}

