/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.Request;
import com.xputertechnologies.santa.RequestStatus;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.DataList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.UserDataList;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RequestDataList
extends DataList<Request> {
    public RequestDataList(DataAccess da) {
        this.t = new Request(da);
    }

    public RequestDataList() {
    }

    @Override
    public void select() {
    }

    public void selectAllWithCode(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.getDataAccess().select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    Request request = new Request(rs.getString("transferId"), rs.getInt("docEntry"), rs.getString("code"), rs.getString("reason"), rs.getString("status"), rs.getBoolean("syncFlag"), rs.getString("fromStoreCode"), rs.getString("requestType"), rs.getDate("requestDate"), rs.getDate("dateAccept"), rs.getString("originatedUser"), rs.getBoolean("isNew"), rs.getString("approvingUser"), rs.getString("releasingUser"), rs.getString("acceptingUser"), rs.getString("approvalComment"), rs.getString("releaseComment"), rs.getString("acceptedComment"), rs.getString("toStoreCode"), rs.getDate("lastUpdatedDate"), rs.getDate("approvalDate"), rs.getDate("releaseDate"), rs.getDate("returnDate"), rs.getString("returningUser"), rs.getString("returningComment"), rs.getBoolean("isPrinted"), rs.getString("toStoreName"), rs.getString("fromStoreName"), rs.getBoolean("autoRelease"), rs.getString("declineBy"), rs.getBoolean("isRecall"), rs.getBoolean("isB2B"), this.getDataAccess());
                    request.vClone = request.clone();
                    this.getOriginalList().add((Object)request);
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void selectAll(String query, DataAccess da) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = da.select(query, da.getEmptyParameterValues());
            if (rs != null) {
                while (rs.next()) {
                    Request request = new Request(rs.getString("transferId"), rs.getInt("docEntry"), rs.getString("code"), rs.getString("reason"), rs.getString("status"), rs.getBoolean("syncFlag"), rs.getString("fromStoreCode"), rs.getString("requestType"), rs.getDate("requestDate"), rs.getDate("dateAccept"), rs.getString("originatedUser"), rs.getBoolean("isNew"), rs.getString("approvingUser"), rs.getString("releasingUser"), rs.getString("acceptingUser"), rs.getString("approvalComment"), rs.getString("releaseComment"), rs.getString("acceptedComment"), rs.getString("toStoreCode"), rs.getDate("lastUpdatedDate"), rs.getDate("approvalDate"), rs.getDate("releaseDate"), rs.getDate("returnDate"), rs.getString("returningUser"), rs.getString("returningComment"), rs.getBoolean("isPrinted"), rs.getString("toStoreName"), rs.getString("fromStoreName"), rs.getBoolean("autoRelease"), rs.getString("declineBy"), rs.getBoolean("isRecall"), rs.getBoolean("isB2B"), da);
                    request.vClone = request.clone();
                    this.getOriginalList().add((Object)request);
                }
                rs.close();
                da.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void selectAllByDateWithNotCompleted(Date from, Date to, DataAccess da, String storeCode) {
        try {
            Date start = new Date(from.getYear(), from.getMonth(), from.getDate(), 0, 0, 0);
            Date end = new Date(to.getYear(), to.getMonth(), to.getDate(), 23, 59, 0);
            this.getOriginalList().clear();
            ResultSet rs = da.select("Select * from Request where (fromStoreCode=? or toStoreCode=?) and (REQUESTDATE  between ? and ? or STATUS<>?) order by REQUESTDATE desc LIMIT 50", new ParameterValue[]{new ParameterValue("fromStoreCode", JDBCType.VARCHAR, storeCode), new ParameterValue("toStoreCode", JDBCType.VARCHAR, storeCode), new ParameterValue("requestDate", JDBCType.TIMESTAMP, new Timestamp(start.getTime())), new ParameterValue("requestDate", JDBCType.TIMESTAMP, new Timestamp(end.getTime())), new ParameterValue("requestDate", JDBCType.VARCHAR, RequestStatus.COMPLETED.name())});
            if (rs != null) {
                while (rs.next()) {
                    Request request = new Request(rs.getString("transferId"), rs.getInt("docEntry"), rs.getString("code"), rs.getString("reason"), rs.getString("status"), rs.getBoolean("syncFlag"), rs.getString("fromStoreCode"), rs.getString("requestType"), rs.getDate("requestDate"), rs.getDate("dateAccept"), rs.getString("originatedUser"), rs.getBoolean("isNew"), rs.getString("approvingUser"), rs.getString("releasingUser"), rs.getString("acceptingUser"), rs.getString("approvalComment"), rs.getString("releaseComment"), rs.getString("acceptedComment"), rs.getString("toStoreCode"), rs.getDate("lastUpdatedDate"), rs.getDate("approvalDate"), rs.getDate("releaseDate"), rs.getDate("returnDate"), rs.getString("returningUser"), rs.getString("returningComment"), rs.getBoolean("isPrinted"), rs.getString("toStoreName"), rs.getString("fromStoreName"), rs.getBoolean("autoRelease"), rs.getString("declineBy"), rs.getBoolean("isRecall"), rs.getBoolean("isB2B"), da);
                    request.vClone = request.clone();
                    this.getOriginalList().add((Object)request);
                }
                rs.close();
                da.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void selectApprovedByDateWithNotCompleted(Date from, Date to, DataAccess da) {
        try {
            Date start = new Date(from.getYear(), from.getMonth(), from.getDate(), 0, 0, 0);
            Date end = new Date(to.getYear(), to.getMonth(), to.getDate(), 23, 59, 0);
            this.getOriginalList().clear();
            ResultSet rs = da.select("Select * from Request where  REQUESTDATE between ? and ? or STATUS=? or STATUS=? order by REQUESTDATE desc", new ParameterValue[]{new ParameterValue("requestDate", JDBCType.TIMESTAMP, new Timestamp(start.getTime())), new ParameterValue("requestDate", JDBCType.TIMESTAMP, new Timestamp(end.getTime())), new ParameterValue("requestDate", JDBCType.VARCHAR, RequestStatus.APPROVED.name()), new ParameterValue("requestDate", JDBCType.VARCHAR, RequestStatus.RETURNED.name())});
            if (rs != null) {
                while (rs.next()) {
                    Request request = new Request(rs.getString("transferId"), rs.getInt("docEntry"), rs.getString("code"), rs.getString("reason"), rs.getString("status"), rs.getBoolean("syncFlag"), rs.getString("fromStoreCode"), rs.getString("requestType"), rs.getDate("requestDate"), rs.getDate("dateAccept"), rs.getString("originatedUser"), rs.getBoolean("isNew"), rs.getString("approvingUser"), rs.getString("releasingUser"), rs.getString("acceptingUser"), rs.getString("approvalComment"), rs.getString("releaseComment"), rs.getString("acceptedComment"), rs.getString("toStoreCode"), rs.getDate("lastUpdatedDate"), rs.getDate("approvalDate"), rs.getDate("releaseDate"), rs.getDate("returnDate"), rs.getString("returningUser"), rs.getString("returningComment"), rs.getBoolean("isPrinted"), rs.getString("toStoreName"), rs.getString("fromStoreName"), rs.getBoolean("autoRelease"), rs.getString("declineBy"), rs.getBoolean("isRecall"), rs.getBoolean("isB2B"), da);
                    request.vClone = request.clone();
                    this.getOriginalList().add((Object)request);
                }
                rs.close();
                da.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ArrayList<Request> searchRequest(String searchString, DataAccess dt, String storeCode) throws SQLException {
        ParameterValue[] parameterValue;
        ArrayList<Request> result = new ArrayList<Request>();
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("Code", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        Object query = "Select * From Request Where (fromStoreCode=" + storeCode + " or toStoreCode=" + storeCode + ") and ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        ResultSet rs = dt.select((String)(query = (String)query + "order by Code ASC"), parameterValue = searchCondition.ConvertoparameterValuesArray());
        if (rs != null) {
            try {
                while (rs.next()) {
                    Request request = new Request(rs.getString("transferId"), rs.getInt("docEntry"), rs.getString("code"), rs.getString("reason"), rs.getString("status"), rs.getBoolean("syncFlag"), rs.getString("fromStoreCode"), rs.getString("requestType"), rs.getDate("requestDate"), rs.getDate("dateAccept"), rs.getString("originatedUser"), rs.getBoolean("isNew"), rs.getString("approvingUser"), rs.getString("releasingUser"), rs.getString("acceptingUser"), rs.getString("approvalComment"), rs.getString("releaseComment"), rs.getString("acceptedComment"), rs.getString("toStoreCode"), rs.getDate("lastUpdatedDate"), rs.getDate("approvalDate"), rs.getDate("releaseDate"), rs.getDate("returnDate"), rs.getString("returningUser"), rs.getString("returningComment"), rs.getBoolean("isPrinted"), rs.getString("toStoreName"), rs.getString("fromStoreName"), rs.getBoolean("autoRelease"), rs.getString("declineBy"), rs.getBoolean("isRecall"), rs.getBoolean("isB2B"), dt);
                    request.vClone = request.clone();
                    result.add(request);
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.getDataAccess().select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    Request request = new Request(rs.getString("transferId"), rs.getInt("docEntry"), rs.getString("code"), rs.getString("reason"), rs.getString("status"), rs.getBoolean("syncFlag"), rs.getString("fromStoreCode"), rs.getString("requestType"), rs.getDate("requestDate"), rs.getDate("dateAccept"), rs.getString("originatedUser"), rs.getBoolean("isNew"), rs.getString("approvingUser"), rs.getString("releasingUser"), rs.getString("acceptingUser"), rs.getString("approvalComment"), rs.getString("releaseComment"), rs.getString("acceptedComment"), rs.getString("toStoreCode"), rs.getDate("lastUpdatedDate"), rs.getDate("approvalDate"), rs.getDate("releaseDate"), rs.getDate("returnDate"), rs.getString("returningUser"), rs.getString("returningComment"), rs.getBoolean("isPrinted"), rs.getString("toStoreName"), rs.getString("fromStoreName"), rs.getBoolean("autoRelease"), rs.getString("declineBy"), rs.getBoolean("isRecall"), rs.getBoolean("isB2B"), this.getDataAccess());
                    request.vClone = request.clone();
                    this.getOriginalList().add((Object)request);
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(RequestDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static int getCount(DataAccess dac) {
        try {
            ResultSet rslt = dac.select("SELECT COUNT(*) FROM Request", dac.getEmptyParameterValues());
            if (rslt != null) {
                if (rslt.next()) {
                    return rslt.getInt("COUNT");
                }
                rslt.close();
                dac.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SaleList.class.getName()).log(Level.SEVERE, null, ex);
        }
        return 0;
    }

    public void selectAllJoin(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.getDataAccess().select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    Request request = new Request(rs.getString("transferId"), rs.getInt("docEntry"), rs.getString("code"), rs.getString("reason"), rs.getString("status"), rs.getBoolean("syncFlag"), rs.getString("fromStoreCode"), rs.getString("requestType"), rs.getDate("requestDate"), rs.getDate("dateAccept"), rs.getString("originatedUser"), rs.getBoolean("isNew"), rs.getString("approvingUser"), rs.getString("releasingUser"), rs.getString("acceptingUser"), rs.getString("approvalComment"), rs.getString("releaseComment"), rs.getString("acceptedComment"), rs.getString("toStoreCode"), rs.getDate("lastUpdatedDate"), rs.getDate("approvalDate"), rs.getDate("releaseDate"), rs.getDate("returnDate"), rs.getString("returningUser"), rs.getString("returningComment"), rs.getBoolean("isPrinted"), rs.getString("toStoreName"), rs.getString("fromStoreName"), rs.getBoolean("autoRelease"), rs.getString("declineBy"), rs.getBoolean("isRecall"), rs.getBoolean("isB2B"), this.getDataAccess());
                    request.vClone = request.clone();
                    this.getOriginalList().add((Object)request);
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        DataAccess dt = this.getDataAccess();
        if (reset) {
            this.currentPage = 0;
        }
        Object query = "Select * From Request Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        Objects.requireNonNull(this);
        query = (String)query + "order by dateLog ASC Limit " + 50 + " Offset " + this.currentPage;
        ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
        ResultSet rs = dt.select((String)query, parameterValue);
        try {
            if (rs != null) {
                while (rs.next()) {
                    Request request = new Request(rs.getString("transferId"), rs.getInt("docEntry"), rs.getString("code"), rs.getString("reason"), rs.getString("status"), rs.getBoolean("syncFlag"), rs.getString("fromStoreCode"), rs.getString("requestType"), rs.getDate("requestDate"), rs.getDate("dateAccept"), rs.getString("originatedUser"), rs.getBoolean("isNew"), rs.getString("approvingUser"), rs.getString("releasingUser"), rs.getString("acceptingUser"), rs.getString("approvalComment"), rs.getString("releaseComment"), rs.getString("acceptedComment"), rs.getString("toStoreCode"), rs.getDate("lastUpdatedDate"), rs.getDate("approvalDate"), rs.getDate("releaseDate"), rs.getDate("returnDate"), rs.getString("returningUser"), rs.getString("returningComment"), rs.getBoolean("isPrinted"), rs.getString("toStoreName"), rs.getString("fromStoreName"), rs.getBoolean("autoRelease"), rs.getString("declineBy"), rs.getBoolean("isRecall"), rs.getBoolean("isB2B"), this.getDataAccess());
                    request.vClone = request.clone();
                    this.getOriginalList().add((Object)request);
                }
                this.currentPage = forward ? ++this.currentPage : (this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0);
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

