/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.Issue;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.DataList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IssueDataList
extends DataList<Issue> {
    public DataAccess dataAccess;

    public IssueDataList() {
    }

    public IssueDataList(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    @Override
    public void select() {
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.dataAccess.select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    Issue issue = new Issue(rs.getFloat("balance"), rs.getFloat("quantity"), rs.getInt("transactionCount"), rs.getString("comment"), rs.getString("stockItemBarcode"), rs.getInt("saleInvoiceNumber"), this.dataAccess);
                    issue.vClone = issue.clone();
                    this.getOriginalList().add((Object)issue);
                }
                rs.close();
                this.dataAccess.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(IssueDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        if (reset) {
            this.currentPage = 0;
        }
        Object query = "SELECT FIRST 50 SKIP " + 50 * this.currentPage + " Distinct * FROM ISSUE WHERE ";
        for (ParameterValue p : searchCondition.getParametersvalues()) {
            query = (String)query + p.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        query = (String)query + " ORDER BY TRANSACTIONCOUNT ASC";
        ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
        try {
            ResultSet rs = this.dataAccess.select((String)query, parameterValue);
            if (rs != null) {
                while (rs.next()) {
                    Issue issue = new Issue(rs.getFloat("balance"), rs.getFloat("quantity"), rs.getInt("transactionCount"), rs.getString("comment"), rs.getString("stockItemBarcode"), rs.getInt("saleInvoiceNumber"), this.dataAccess);
                    issue.vClone = issue.clone();
                    this.getOriginalList().add((Object)issue);
                }
                this.currentPage = forward ? ++this.currentPage : (this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0);
                rs.close();
                this.dataAccess.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(IssueDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

