/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.StockItemList;
import java.sql.ResultSet;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class DataList<T extends DbEntity> {
    public final int pagesize = 50;
    public int currentPage;
    protected int totalRecord;
    private ObservableList<T> newList = FXCollections.observableArrayList();
    private ObservableList<T> deleteList = FXCollections.observableArrayList();
    private ObservableList<T> updateList = FXCollections.observableArrayList();
    private ObservableList<T> originalList = FXCollections.observableArrayList();
    protected T t;

    public DataAccess getDataAccess() {
        return ((DbEntity)this.t).getDbAccess();
    }

    public void split() {
        this.newList.clear();
        this.updateList.clear();
        for (DbEntity t1 : this.originalList) {
            if (ObjectState.Changed == t1.getState()) {
                this.updateList.add((Object)t1);
                continue;
            }
            if (ObjectState.New == t1.getState()) {
                this.newList.add((Object)t1);
                continue;
            }
            if (ObjectState.Removed != t1.getState()) continue;
            this.deleteList.add((Object)t1);
        }
    }

    public void update() throws Exception {
        this.split();
        for (DbEntity t1 : this.newList) {
            if (t1 == null) continue;
            t1.beforeInsert();
            t1.insert();
            t1.afterInsert();
            t1.setState(ObjectState.Unchanged);
        }
        for (DbEntity t1 : this.updateList) {
            if (t1 == null) continue;
            t1.update();
            t1.afterUpdate();
            t1.setState(ObjectState.Unchanged);
        }
        for (DbEntity t1 : this.deleteList) {
            if (t1 == null) continue;
            t1.delete();
        }
        this.newList.clear();
        this.updateList.clear();
        this.deleteList.clear();
        this.originalList.removeIf(new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return ((DbEntity)t).getState() == ObjectState.Removed;
            }
        });
    }

    public abstract void select();

    public abstract void selectAll(String var1, ParameterValue[] var2);

    public abstract void select(SearchCondition var1, boolean var2, boolean var3);

    public ObservableList<T> getNewList() {
        return this.newList;
    }

    public void setNewList(ObservableList<T> newList) {
        this.newList = newList;
    }

    public ObservableList<T> getDeleteList() {
        return this.deleteList;
    }

    public void setDeleteList(ObservableList<T> deleteList) {
        this.deleteList = deleteList;
    }

    public ObservableList<T> getUpdateList() {
        return this.updateList;
    }

    public void setUpdateList(ObservableList<T> updateList) {
        this.updateList = updateList;
    }

    public ObservableList<T> getOriginalList() {
        return this.originalList;
    }

    public void setOriginalList(ObservableList<T> originalList) {
        this.originalList = originalList;
    }

    public int getTotalRecord(String className) {
        if (this.totalRecord == 0) {
            String query = "Select count(*) From " + className;
            ResultSet rs = this.getDataAccess().select(query, this.getDataAccess().getEmptyParameterValues());
            if (rs != null) {
                try {
                    while (rs.next()) {
                        this.totalRecord = rs.getInt("count(*)");
                    }
                    rs.close();
                    this.getDataAccess().closeConnection();
                }
                catch (Exception ex) {
                    Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return this.totalRecord;
    }
}

