/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.xputertechnologies.santa.FileBodyPart;
import com.xputertechnologies.santa.IWebCallBack;
import com.xputertechnologies.santa.RequestTypeEnum;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class WebRequest {
    static String ACTIVEDIRECTORYTENANT = "https://login.microsoftonline.com/tdafrica.com";
    static String ACTIVEDIRECTORYCLIENTAPPID = "e577e6c4-614e-47b0-a20c-a93b17e2cadf";
    static String ACTIVEDIRECTORYCLIENTAPPSECRET = "kMZIZ94j1_r7n1YDTi4-R_-y2vIBjVQIC~";
    static String ACTIVEDIRECTORYRESOURCE = "https://kongaprod.operations.dynamics.com";
    static String BASE_SERVICE_URL = ACTIVEDIRECTORYRESOURCE + "/api/services/YuvendServiceGroup/YuvendService/";
    public static String CREATE_PROMOVOUCHER = "promoVoucher/createPromoVoucher";
    public static String GET_ALL_PROMOVOUCHER = "promoVoucher/getPromoVouchers";
    public static String GET_PROMOVOUCHER = "promoVoucher/getPromoVoucher";
    public static String VALIDATE_PROMOVOUCHER = "promoVoucher/validateVoucher";
    public static String MARK_PROMOVOUCHER = "promoVoucher/markVoucherUsed";
    public static String LOCATIONS = "getLocation";
    public static String SEARCHCUSTOMER = "customer/searchCustomerAcrossSources";
    public static String EMPLOYEE = "loadSalesResponsible";
    public static String INVENTORYMOVEMENT = "getInventoryMovements";
    public static String PAYMENT_TERMS = "loadPaymentTerms";
    public static String PAYMENT_TERMS_LOCAL = "utility/getPaymentTerms";
    public static String BANKS = "loadBanks";
    public static String SALES_RETURN = "salesorder/returnSalesorder";
    public static String GET_ALL_TRANSFERS = "transferorder/getTransferOrders";
    public static String GET_TRANSFERS = "transferorder/getTransferorder";
    public static String GET_TRANSFERS_WITH_DATE = "transferorder/getTransfersInAPeriod";
    public static String GET_LASTSYNC_TRANSFERS = "transferorder/getDateChange";
    public static String SENDAPPROVAL_TRANSFERS_MAIL = "transferorder/sendEmail";
    public static String DIMENSIONS = "loadDimensions";
    public static String PAYMENT_METHODS = "loadPaymentMode";
    public static final String CREATE_SALEORDER = "salesorder/createSalesorder";
    public static final String UPDATE_SALEORDER = "salesorder/updateSalesorderDetails";
    public static final String RESEND_MAIL_SALEORDER = "salesorder/sendEmail";
    public static final String GET_SALEORDER = "salesorder/getSalesorder";
    public static final String GET_CREDITSALE = "salesorder/getDueSalesorders";
    public static final String CREATE_TRANSFER = "transferorder/createTransferOrder";
    public static String PRODUCTS = "getInventory";
    public static String PRODUCTS_LOOKUP = "inventoryLookup";
    public static String PRODUCTS_ITEM = "getItems";
    public static final String CREATE_CUSTOMER = "customer/createCustomer";
    public static final String GET_CUSTOMER = "customer/getCustomer";
    public static final String GET_CUSTOMERS = "customer/getCustomers";
    public static final String TRANSFER_RELEASE = "transferorder/releaseTransferorder";
    public static final String TRANSFER_ACCEPT = "transferorder/acceptTransferorder";
    public static final String TRANSFER_DELETE = "transferorder/deleteTransferorder";
    public static final String GET_SALES_ADMIN = "salesorder/getDateChange";
    AuthenticationContext context = null;
    AuthenticationResult result = null;
    ExecutorService service = null;
    IWebCallBack callback;
    String url = "";
    RequestTypeEnum requestType;
    String data = "";
    String token = "";
    ArrayList<String> params = new ArrayList();
    private static final Set<String> SCOPE = Collections.singleton("User.Read User.ReadBasic.All");
    ArrayList<FileBodyPart> files = null;

    public WebRequest(String url, RequestTypeEnum requestType, String data, ArrayList<FileBodyPart> files, IWebCallBack callback) {
        this.callback = callback;
        this.data = data;
        this.requestType = requestType;
        this.url = url;
        this.files = files;
    }

    private void getToken() throws MalformedURLException, InterruptedException, ExecutionException {
        try {
            this.service = Executors.newFixedThreadPool(1);
            this.context = new AuthenticationContext(ACTIVEDIRECTORYTENANT, false, this.service);
            Future future = this.context.acquireToken(ACTIVEDIRECTORYRESOURCE, new ClientCredential(ACTIVEDIRECTORYCLIENTAPPID, ACTIVEDIRECTORYCLIENTAPPSECRET), null);
            this.result = (AuthenticationResult)future.get();
        }
        finally {
            this.service.shutdown();
        }
        if (this.result != null) {
            this.token = this.result.getAccessToken();
        }
    }

    public static Boolean isInternetAvailable() {
        try {
            URL u = new URL("http://www.google.com");
            URLConnection connection = u.openConnection();
            connection.connect();
            System.out.println("Internet is connected");
            return true;
        }
        catch (Exception ex) {
            System.out.println("Internet is not connected");
            return false;
        }
    }

    private Boolean isValidJson(String str) {
        try {
            JsonParser parser = new JsonParser();
            parser.parse(str);
            return true;
        }
        catch (JsonSyntaxException jse) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Boolean isD365) {
        block57: {
            try {
                if (isD365.booleanValue()) {
                    this.getToken();
                }
            }
            catch (Exception ex) {
                this.callback.onError(ex.getMessage());
            }
            if (this.token.length() == 0 && isD365.booleanValue()) {
                this.callback.onError("Unable to authenticate, please try again");
            } else {
                if (WebRequest.isInternetAvailable().booleanValue()) {
                    OkHttpClient client = this.getUnsafeOkHttpClient(this.requestType);
                    MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
                    Request request = null;
                    Request.Builder builder = new Request.Builder().addHeader("Accept", "application/json");
                    if (isD365.booleanValue()) {
                        builder.url(BASE_SERVICE_URL + this.url).addHeader("Authorization", "Bearer " + this.token);
                    } else {
                        builder.url("https://yuvend-be.igbimo.com/api/" + this.url);
                    }
                    Response response = null;
                    switch (this.requestType) {
                        case POST: {
                            RequestBody body;
                            if (this.files != null && this.files.size() > 0) {
                                MultipartBody.Builder b = new MultipartBody.Builder().setType(MultipartBody.ALTERNATIVE);
                                if (this.files != null && this.files.size() > 0) {
                                    for (int i = 0; i < this.files.size(); ++i) {
                                        FileBodyPart fbp = this.files.get(i);
                                        b.addFormDataPart(fbp.id, fbp.filename, RequestBody.create((File)fbp.file, (MediaType)MediaType.parse((String)"image/png")));
                                    }
                                }
                                body = b.build();
                            } else {
                                body = this.data == null ? RequestBody.create((byte[])new byte[0]) : RequestBody.create((String)this.data, (MediaType)JSON);
                            }
                            request = builder.post(body).build();
                            try {
                                response = client.newCall(request).execute();
                                if (response.code() >= 200 && response.code() <= 299) {
                                    String respString = response.body().string();
                                    if (this.isValidJson(respString).booleanValue()) {
                                        this.callback.onSuccess(respString);
                                    } else {
                                        this.callback.onError(response.body().string());
                                    }
                                } else {
                                    this.callback.onError(response.body().string());
                                }
                                break block57;
                            }
                            catch (Exception ex) {
                                this.callback.onError(ex.getMessage());
                                break block57;
                            }
                            finally {
                                if (response != null && response.body() != null) {
                                    response.body().close();
                                }
                            }
                        }
                        case PUT: {
                            RequestBody body = this.data == null ? RequestBody.create((byte[])new byte[0]) : RequestBody.create((String)this.data, (MediaType)JSON);
                            request = builder.put(body).build();
                            try {
                                response = client.newCall(request).execute();
                                if (response.code() >= 200 && response.code() <= 299) {
                                    String respString = response.body().string();
                                    if (this.isValidJson(respString).booleanValue()) {
                                        this.callback.onSuccess(respString);
                                    } else {
                                        this.callback.onError(response.body().string());
                                    }
                                } else {
                                    this.callback.onError(response.body().string());
                                }
                                break block57;
                            }
                            catch (Exception ex) {
                                this.callback.onError(ex.getMessage());
                                break block57;
                            }
                            finally {
                                if (response != null && response.body() != null) {
                                    response.body().close();
                                }
                            }
                        }
                        case GET: {
                            request = builder.build();
                            try {
                                response = client.newCall(request).execute();
                                if (response.code() >= 200 && response.code() <= 299) {
                                    String respString = response.body().string();
                                    if (this.isValidJson(respString).booleanValue()) {
                                        this.callback.onSuccess(respString);
                                    } else {
                                        this.callback.onError(response.body().string());
                                    }
                                } else {
                                    this.callback.onError(response.body().string());
                                }
                                break block57;
                            }
                            catch (Exception ex) {
                                this.callback.onError(ex.getMessage());
                                break block57;
                            }
                            finally {
                                if (response != null && response.body() != null) {
                                    response.body().close();
                                }
                            }
                        }
                        default: {
                            request = builder.delete().build();
                            try {
                                response = client.newCall(request).execute();
                                if (response.code() >= 200 && response.code() <= 299) {
                                    String respString = response.body().string();
                                    if (this.isValidJson(respString).booleanValue()) {
                                        this.callback.onSuccess(respString);
                                    } else {
                                        this.callback.onError(response.body().string());
                                    }
                                } else {
                                    this.callback.onError(response.body().string());
                                }
                                break block57;
                            }
                            catch (Exception ex) {
                                this.callback.onError(ex.getMessage());
                                break block57;
                            }
                            finally {
                                if (response != null && response.body() != null) {
                                    response.body().close();
                                }
                            }
                        }
                    }
                }
                this.callback.onError("Internet not available, please connect and try again");
            }
        }
    }

    private OkHttpClient getUnsafeOkHttpClient(RequestTypeEnum requestType) {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            if (requestType == RequestTypeEnum.GET) {
                builder.connectTimeout(60L, TimeUnit.SECONDS);
                builder.readTimeout(60L, TimeUnit.SECONDS);
            } else {
                builder.connectTimeout(180L, TimeUnit.SECONDS);
                builder.readTimeout(180L, TimeUnit.SECONDS);
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class TrustManagerDelegate
    implements X509TrustManager {
        private final X509TrustManager trustManager;

        TrustManagerDelegate(X509TrustManager trustManager) {
            this.trustManager = trustManager;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
            try {
                this.trustManager.checkServerTrusted(chain, authType);
            }
            catch (CertificateException ex) {
                System.out.println(chain[0]);
                ex.printStackTrace(System.out);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }
    }
}

