/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.ITokenCacheAccessContext;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;

public class TokenCacheAspect
implements ITokenCacheAccessAspect {
    private String data;

    public TokenCacheAspect(String fileName) {
        this.data = TokenCacheAspect.readDataFromFile(fileName);
    }

    public void beforeCacheAccess(ITokenCacheAccessContext iTokenCacheAccessContext) {
        iTokenCacheAccessContext.tokenCache().deserialize(this.data);
    }

    public void afterCacheAccess(ITokenCacheAccessContext iTokenCacheAccessContext) {
        this.data = iTokenCacheAccessContext.tokenCache().serialize();
    }

    private static String readDataFromFile(String resource) {
        try {
            URL path = TokenCacheAspect.class.getResource(resource);
            return new String(Files.readAllBytes(Paths.get(path.toURI())));
        }
        catch (Exception ex) {
            System.out.println("Error reading data from file: " + ex.getMessage());
            throw new RuntimeException(ex);
        }
    }
}

