/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Maker;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StockPreload {
    private List<Maker> makers = new ArrayList<Maker>();

    public List<Maker> getMakers() {
        return this.makers;
    }

    public static List<String> LoadColumn(DataAccess da, String query, String searchString) {
        ArrayList<String> makers = new ArrayList<String>();
        ArrayList<ParameterValue> ParamList = new ArrayList<ParameterValue>();
        ParamList.add(new ParameterValue("name", JDBCType.VARCHAR, "%" + searchString + "%"));
        ParamList.add(new ParameterValue("size", JDBCType.VARCHAR, "%" + searchString + "%"));
        ParamList.add(new ParameterValue("maker", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(ParamList);
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        ParameterValue[] paremeterValues = searchCondition.ConvertoparameterValuesArray();
        ResultSet rs = da.select((String)query, paremeterValues);
        try {
            while (rs.next()) {
                makers.add(rs.getString("maker"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockPreload.class.getName()).log(Level.SEVERE, null, ex);
        }
        return makers;
    }

    public static List<String> LoadColumnGen(DataAccess da, String query, String columnString) {
        ArrayList<String> makers = new ArrayList<String>();
        ResultSet rs = da.select("SELECT DISTINCT MAKER FROM ITEMS", da.getEmptyParameterValues());
        try {
            if (rs != null) {
                while (rs.next()) {
                    makers.add(rs.getString(columnString));
                }
                rs.close();
                da.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Maker.class.getName()).log(Level.SEVERE, null, ex);
        }
        return makers;
    }

    public static List<String> LoadColumnGen(DataAccess da, String query, ParameterValue[] param, String columnString) {
        ArrayList<String> makers = new ArrayList<String>();
        ResultSet rs = da.select(query, param);
        try {
            if (rs != null) {
                while (rs.next()) {
                    makers.add(rs.getString(columnString));
                }
                rs.close();
                da.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Maker.class.getName()).log(Level.SEVERE, null, ex);
        }
        return makers;
    }

    public void setMakers(List<Maker> makers) {
        this.makers = makers;
    }
}

