/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.AccountDetail;
import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.Expenses;
import com.xputertechnologies.santa.ManualPendingStatus;
import com.xputertechnologies.santa.SaleAccountDetailResolver;
import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.SaleStatus;
import com.xputertechnologies.santa.SalesMode;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.Unit;
import com.xputertechnologies.santa.User;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.NotEnoughQtyException;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.AccountDetailDataList;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.CustomerDataList;
import com.xputertechnologies.santa.list.ExpensesDataList;
import com.xputertechnologies.santa.list.ReplenishmentList;
import com.xputertechnologies.santa.list.SaleAccountDetailResolverDataList;
import com.xputertechnologies.santa.list.SaleItemList;
import com.xputertechnologies.santa.list.SaleItemSerialDataList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.UserDataList;
import com.xputertechnologies.santa.ui.Santa;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.imageio.ImageIO;

public class Sale
extends DbEntity {
    public String postingUser = "";
    public String approvingUser = "";
    public String salesType;
    public boolean saleCreated = false;
    public String storeName;
    public String tempPromoCode = "";
    public double minAmount = 0.0;
    public double amountCash;
    public double amountNotCash;
    public List<BufferedImage> img = new ArrayList<BufferedImage>();
    private ObjectProperty<String> imageUrl = new SimpleObjectProperty((Object)"");
    private ObjectProperty<String> paymentTermDescription = new SimpleObjectProperty((Object)"");
    private ObjectProperty<String> approvals = new SimpleObjectProperty((Object)"");
    private ObjectProperty<String> paymentTerm = new SimpleObjectProperty((Object)"");
    private ObjectProperty<String> customerEmail = new SimpleObjectProperty((Object)"");
    private ObjectProperty<String> customerPhoneNumber = new SimpleObjectProperty((Object)"");
    private ObjectProperty<String> returnedBy = new SimpleObjectProperty((Object)"");
    private ObjectProperty<String> salesRejectedBy = new SimpleObjectProperty((Object)"");
    private ObjectProperty<String> returnRejectedBy = new SimpleObjectProperty((Object)"");
    private ObjectProperty<String> returnComment = new SimpleObjectProperty((Object)"");
    private ObjectProperty<String> returnApprovals = new SimpleObjectProperty((Object)"");
    private ObjectProperty<String> actionComment = new SimpleObjectProperty((Object)"");
    private ObjectProperty<String> d365CustomerNo = new SimpleObjectProperty((Object)"");
    private ObjectProperty<String> saleStatus = new SimpleObjectProperty((Object)SaleStatus.PENDING.name());
    private StringProperty manualSaleStatus = new SimpleStringProperty(ManualPendingStatus.Created.name());
    private StringProperty approvingComment = new SimpleStringProperty("");
    private StringProperty creditDescription = new SimpleStringProperty("");
    private StringProperty creditToken = new SimpleStringProperty("");
    private StringProperty promoVoucher = new SimpleStringProperty("");
    private DoubleProperty promoVoucherAmt = new SimpleDoubleProperty(0.0);
    public Sale vClone;
    private boolean isCloned;
    public boolean isSold = false;
    private ObjectProperty<String> description = new SimpleObjectProperty((Object)"New Sale");
    public String Reprint;
    private StringProperty costCenter = new SimpleStringProperty();
    private StringProperty locationCode = new SimpleStringProperty("");
    private StringProperty salesChannel = new SimpleStringProperty("");
    private ObjectProperty<Timestamp> transactionDate = new SimpleObjectProperty((Object)new Timestamp(new java.util.Date().getTime()));
    private ObjectProperty<String> saleId = new SimpleObjectProperty((Object)"");
    private ObjectProperty<Timestamp> newDate = new SimpleObjectProperty((Object)new Timestamp(new java.util.Date().getTime()));
    private IntegerProperty invoiceNumber = new SimpleIntegerProperty();
    private Customer customer = new Customer("", "", Date.valueOf(LocalDate.now()), "Unknow", "", "", "", "", this.getDbAccess());
    private Customer parentCustomer;
    private AccountDetail parentAccountDetail;
    private BooleanProperty returnAll = new SimpleBooleanProperty();
    private BooleanProperty isB2B = new SimpleBooleanProperty();
    private BooleanProperty syncFlag = new SimpleBooleanProperty();
    private BooleanProperty isManual = new SimpleBooleanProperty();
    Double amount;
    private DoubleProperty totalAmount = new SimpleDoubleProperty();
    private StringProperty accountDetailNo = new SimpleStringProperty("");
    private DoubleProperty amountPaid = new SimpleDoubleProperty(0.0);
    private DoubleProperty shippingFee = new SimpleDoubleProperty(0.0);
    private DoubleProperty Change = new SimpleDoubleProperty();
    private DoubleProperty discount = new SimpleDoubleProperty(){

        public void set(double value) {
            super.set(value);
        }
    };
    private DoubleProperty balance = new SimpleDoubleProperty();
    private DoubleProperty priceFix = new SimpleDoubleProperty();
    private StringProperty salesMode = new SimpleStringProperty();
    private StringProperty salesRep = new SimpleStringProperty("");
    private StringProperty syncError = new SimpleStringProperty("");
    private StringProperty hdInvoiceNo = new SimpleStringProperty("");
    private StringProperty saleComment = new SimpleStringProperty("");
    private String companyName;
    public Company parentCompany;
    BooleanProperty isFullyPaid = new SimpleBooleanProperty();
    BooleanProperty allowClose = new SimpleBooleanProperty();
    private StringProperty storeCode = new SimpleStringProperty("");
    private String customerName;
    public User Staff;
    private User parentUser;
    private ObservableList<SaleAccountDetailResolver> saleAccountDetailResolvers = FXCollections.observableArrayList();
    private ObservableList<SaleItem> saleItems = FXCollections.observableArrayList();
    private ObservableList<AccountDetail> accountDetailList = FXCollections.observableArrayList();
    private String sellingStaff;
    SaleAccountDetailResolverDataList saleAccountDetailResolverDataList;
    SaleItemList saleItemList;
    SaleList saleList;
    StockItemList stockItemList;
    private SaleAccountDetailResolverDataList payments = new SaleAccountDetailResolverDataList();
    ReplenishmentList replenishmentList = null;
    public float totalSaleitemQtybought;
    public boolean isMigration = false;
    public boolean manualEnt = false;
    public double proRateValue;
    double prorateDiff;
    double proVal;
    int prorateListCount;
    public boolean isMakingSale;
    public boolean alreadyProrate = false;
    public DecimalFormat df = new DecimalFormat("#.##");
    public DecimalFormat dfTot = new DecimalFormat("#,###.##");
    public IntegerProperty tracker = new SimpleIntegerProperty();
    public StringBinding totalAmountBinding = new StringBinding(){

        protected String computeValue() {
            double result = 0.0;
            if (Sale.this.saleItems.size() == 0) {
                Sale.this.balance.set(0.0);
                Sale.this.Change.set(0.0);
                return "0.00";
            }
            if (!Sale.this.isMakingSale) {
                if (Sale.this.saleItems.size() > 0) {
                    if (Sale.this.isB2B.get()) {
                        Sale.this.setIfb2B();
                    }
                    for (SaleItem si : Sale.this.saleItems) {
                        if (si.getTotalQty() <= 0) continue;
                        result += (double)si.getTotalQty() * si.getVariablePrice();
                    }
                    Sale.this.totalAmountProperty().set(result);
                    if (Sale.this.amountPaid.get() > Sale.this.totalAmount.get()) {
                        Sale.this.Change.set(Sale.this.amountPaid.get() - Sale.this.totalAmount.get());
                    }
                } else {
                    Sale.this.totalAmountProperty().set(Sale.this.amountPaid.get());
                    result = Float.valueOf(Sale.this.df.format(Sale.this.amountPaid.get())).floatValue();
                }
            } else {
                result = Sale.this.totalAmount.get();
            }
            return String.valueOf(Sale.this.dfTot.format(result));
        }
    };
    public IntegerProperty trackerAmountDetail = new SimpleIntegerProperty();
    public StringBinding totalAmountDetailBinding = new StringBinding(){

        protected String computeValue() {
            double result = 0.0;
            if (Sale.this.accountDetailList.size() == 0) {
                return "0";
            }
            if (Sale.this.accountDetailList.size() > 0) {
                for (AccountDetail si : Sale.this.accountDetailList) {
                    if (!(si.getAmount() > 0.0)) continue;
                    result += si.getAmount();
                }
            }
            return String.valueOf(Sale.this.dfTot.format(result += Sale.this.promoVoucherAmt.get()));
        }
    };
    public boolean isAnyProrate = false;

    public String getImageUrl() {
        return (String)this.imageUrl.get();
    }

    public void setImageUrl(String val) {
        this.imageUrl.set((Object)val);
    }

    public ObjectProperty<String> imageUrlProperty() {
        return this.imageUrl;
    }

    public String getPaymentTermDescription() {
        return (String)this.paymentTermDescription.get();
    }

    public void setPaymentTermDescription(String val) {
        this.paymentTermDescription.set((Object)val);
    }

    public ObjectProperty<String> paymentTermDescriptionProperty() {
        return this.paymentTermDescription;
    }

    public String getApprovals() {
        return (String)this.approvals.get();
    }

    public void setApprovals(String val) {
        this.approvals.set((Object)val);
    }

    public ObjectProperty<String> approvalsProperty() {
        return this.approvals;
    }

    public String getPaymentTerm() {
        return (String)this.paymentTerm.get();
    }

    public void setPaymentTerm(String val) {
        this.paymentTerm.set((Object)val);
    }

    public ObjectProperty<String> paymentTermProperty() {
        return this.paymentTerm;
    }

    public String getCustomerEmail() {
        return (String)this.customerEmail.get();
    }

    public void setCustomerEmail(String val) {
        this.customerEmail.set((Object)val);
    }

    public ObjectProperty<String> customerEmailProperty() {
        return this.customerEmail;
    }

    public String getCustomerPhoneNumber() {
        return (String)this.customerPhoneNumber.get();
    }

    public void setCustomerPhoneNumber(String val) {
        this.customerPhoneNumber.set((Object)val);
    }

    public ObjectProperty<String> customerPhoneNumberProperty() {
        return this.customerPhoneNumber;
    }

    public String getReturnedBy() {
        return (String)this.returnedBy.get();
    }

    public void setReturnedBy(String val) {
        this.returnedBy.set((Object)val);
    }

    public ObjectProperty<String> returnedByProperty() {
        return this.returnedBy;
    }

    public String getSalesRejectedBy() {
        return (String)this.salesRejectedBy.get();
    }

    public void setSalesRejectedBy(String val) {
        this.salesRejectedBy.set((Object)val);
    }

    public ObjectProperty<String> salesRejectedByProperty() {
        return this.salesRejectedBy;
    }

    public String getReturnRejectedBy() {
        return (String)this.returnRejectedBy.get();
    }

    public void setReturnRejectedBy(String val) {
        this.returnRejectedBy.set((Object)val);
    }

    public ObjectProperty<String> returnRejectedByProperty() {
        return this.returnRejectedBy;
    }

    public String getReturnComment() {
        return (String)this.returnComment.get();
    }

    public void setReturnComment(String val) {
        this.returnComment.set((Object)val);
    }

    public ObjectProperty<String> returnCommentProperty() {
        return this.returnComment;
    }

    public String getReturnApprovals() {
        return (String)this.returnApprovals.get();
    }

    public void setReturnApprovals(String val) {
        this.returnApprovals.set((Object)val);
    }

    public ObjectProperty<String> returnApprovalsProperty() {
        return this.returnApprovals;
    }

    public String getActionComment() {
        return (String)this.actionComment.get();
    }

    public void setActionComment(String val) {
        this.actionComment.set((Object)val);
    }

    public ObjectProperty<String> actionCommentProperty() {
        return this.actionComment;
    }

    public String getd365CustomerNo() {
        return (String)this.d365CustomerNo.get();
    }

    public void setD365CustomerNo(String val) {
        this.d365CustomerNo.set((Object)val);
    }

    public ObjectProperty<String> d365CustomerNoProperty() {
        return this.d365CustomerNo;
    }

    public String getSaleStatus() {
        return (String)this.saleStatus.get();
    }

    public void setSaleStatus(String val) {
        this.saleStatus.set((Object)val);
    }

    public ObjectProperty<String> saleStatusProperty() {
        return this.saleStatus;
    }

    public StringProperty manualSaleStatusProperty() {
        return this.manualSaleStatus;
    }

    public String getManualSaleStatus() {
        return (String)this.manualSaleStatus.get();
    }

    public void setManualSaleStatus(String manualSaleStatus) {
        this.manualSaleStatus.set((Object)manualSaleStatus);
    }

    public StringProperty approvingCommentProperty() {
        return this.approvingComment;
    }

    public String getApprovingComment() {
        return (String)this.approvingComment.get();
    }

    public void setApprovingComment(String approvingComment) {
        this.approvingComment.set((Object)approvingComment);
    }

    public StringProperty creditDescriptionProperty() {
        return this.creditDescription;
    }

    public String getCreditDescription() {
        return (String)this.creditDescription.get();
    }

    public void setCreditDescription(String creditDescription) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.changeObjectState();
        this.creditDescription.set((Object)creditDescription);
    }

    public StringProperty creditTokenProperty() {
        return this.creditToken;
    }

    public String getCreditToken() {
        return (String)this.creditToken.get();
    }

    public void setCreditToken(String creditToken) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.changeObjectState();
        this.creditToken.set((Object)creditToken);
    }

    public StringProperty promoVoucherProperty() {
        return this.promoVoucher;
    }

    public String getPromoVoucher() {
        return (String)this.promoVoucher.get();
    }

    public void setPromoVoucher(String promoVoucher) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.changeObjectState();
        this.promoVoucher.set((Object)promoVoucher);
    }

    public DoubleProperty promoVoucherAmtProperty() {
        return this.promoVoucherAmt;
    }

    public double getPromoVoucherAmt() {
        return this.promoVoucherAmt.get();
    }

    public void setPromoVoucherAmt(double promoVoucherAmt) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.changeObjectState();
        this.promoVoucherAmt.set(promoVoucherAmt);
        this.trackerAmountDetail.set(this.trackerAmountDetail.get() + 1);
    }

    public SaleAccountDetailResolverDataList getPayments() {
        return this.payments;
    }

    public StringProperty costCenterProperty() {
        return this.costCenter;
    }

    public String getCostCenter() {
        return (String)this.costCenter.get();
    }

    public void setCostCenter(String costCenter) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.changeObjectState();
        this.costCenter.set((Object)costCenter);
    }

    public StringProperty locationCodeProperty() {
        return this.locationCode;
    }

    public String getLocationCode() {
        return (String)this.locationCode.get();
    }

    public void setLocationCode(String locationCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.changeObjectState();
        this.locationCode.set((Object)locationCode);
    }

    public StringProperty salesChannelProperty() {
        return this.salesChannel;
    }

    public String getSalesChannel() {
        return (String)this.salesChannel.get();
    }

    public void setSalesChannel(String salesChannel) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.changeObjectState();
        this.salesChannel.set((Object)salesChannel);
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public Timestamp getTransactionDate() {
        return (Timestamp)this.transactionDate.get();
    }

    public void setTransactionDate(Timestamp transactionDate) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.transactionDate.set((Object)transactionDate);
        this.changeObjectState();
    }

    public ObjectProperty<Timestamp> transactionDateProperty() {
        return this.transactionDate;
    }

    public ObjectProperty<String> descriptionProperty() {
        return this.description;
    }

    public String getSaleId() {
        return (String)this.saleId.get();
    }

    public void setSaleId(String sapDockNum) {
        this.saleId.set((Object)sapDockNum);
    }

    public ObjectProperty<String> saleIdProperty() {
        return this.saleId;
    }

    public Timestamp getNewDate() {
        return (Timestamp)this.newDate.get();
    }

    public ObjectProperty<Timestamp> dateProperty() {
        return this.newDate;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public int getInvoiceNumber() {
        return this.invoiceNumber.get();
    }

    public void setInvoiceNumber(int invoiceNumber) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.invoiceNumber.set(invoiceNumber);
    }

    public IntegerProperty invoiceNumberProperty() {
        return this.invoiceNumber;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.customer = customer;
        this.parentCustomer = customer;
        if (customer != null) {
            this.customerName = customer.getName();
            this.setCustomerEmail(customer.getEmail());
            this.setCustomerPhoneNumber(customer.getPhoneNumber());
            this.setD365CustomerNo(customer.getD365Code());
            this.description.set((Object)customer.getName());
        }
        if (!((String)this.description.get()).equals("New Sale")) {
            this.allowClose.set(true);
        }
        this.changeObjectState();
    }

    public Customer getParentCustomer() {
        if (!(this.parentCustomer != null || ((String)this.d365CustomerNo.get()).isEmpty() && ((String)this.customerPhoneNumber.get()).isEmpty())) {
            this.loadParentCustomer();
        }
        return this.parentCustomer;
    }

    public AccountDetail getParentAccountDetail() {
        if (this.parentAccountDetail == null) {
            this.loadParentAccountDetail();
        }
        return this.parentAccountDetail;
    }

    public Boolean getReturnAll() {
        return this.returnAll.get();
    }

    public void setReturnAll(Boolean returnAll) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.returnAll.set(returnAll.booleanValue());
        this.changeObjectState();
    }

    public BooleanProperty modifiedProperty() {
        return this.returnAll;
    }

    public Boolean getB2B() {
        return this.isB2B.get();
    }

    public void setB2B(Boolean isB2B) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.isB2B.set(isB2B.booleanValue());
        this.changeObjectState();
    }

    void setIfb2B() {
        int countGreaterThan5 = 0;
        for (SaleItem saleItem1 : this.saleItems) {
            countGreaterThan5 += Math.round(saleItem1.getTotalQty());
        }
        if (this.saleItems.size() >= 5 || this.saleItems.stream().filter(item -> item.getTotalQty() >= 5).findAny().orElse(null) != null || countGreaterThan5 >= 5) {
            Iterator iterator = this.saleItems.iterator();
            while (iterator.hasNext()) {
                SaleItem saleItem;
                saleItem.setVariablePrice((saleItem = (SaleItem)iterator.next()).getPriceB2B() > 0.0 ? saleItem.getPriceB2B() : saleItem.getSellingPrice());
            }
        } else {
            for (SaleItem saleItem : this.saleItems) {
                saleItem.setVariablePrice(saleItem.getSellingPrice());
            }
        }
    }

    public BooleanProperty isB2BProperty() {
        return this.isB2B;
    }

    public Boolean getSyncFlag() {
        return this.syncFlag.get();
    }

    public void setSyncFlag(Boolean syncFlag) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.syncFlag.set(syncFlag.booleanValue());
        this.changeObjectState();
    }

    public BooleanProperty syncFlagProperty() {
        return this.syncFlag;
    }

    public Boolean getIsManual() {
        return this.isManual.get();
    }

    public void setIsManual(Boolean isManual) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.isManual.set(isManual.booleanValue());
        this.changeObjectState();
    }

    public BooleanProperty isManualProperty() {
        return this.isManual;
    }

    public void setParentAccountDetail(AccountDetail accountDetail) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.parentAccountDetail = accountDetail;
        this.accountDetailNo.set((Object)(accountDetail == null ? "" : accountDetail.getAccNumber()));
        this.changeObjectState();
    }

    public void setParentCustomer(Customer parentCustomer) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.parentCustomer = parentCustomer;
        this.customerName = parentCustomer == null ? "" : parentCustomer.getName();
        this.setCustomerPhoneNumber(parentCustomer == null ? "" : parentCustomer.getPhoneNumber());
        this.setCustomerEmail(parentCustomer == null ? "" : parentCustomer.getEmail());
        this.setD365CustomerNo(parentCustomer == null ? "" : parentCustomer.getD365Code());
        this.description.set((Object)(parentCustomer == null ? "" : parentCustomer.getName()));
        if (!((String)this.description.get()).equals("New Sale")) {
            this.allowClose.set(true);
        }
        this.changeObjectState();
    }

    private void loadParentCustomer() {
        CustomerDataList purList = new CustomerDataList(this.getDbAccess());
        String query = "Select * From Customer Where d365Code=? or phoneNumber=?";
        purList.selectAll(query, new ParameterValue[]{new ParameterValue("d365Code", JDBCType.VARCHAR, this.d365CustomerNo.get()), new ParameterValue("phoneNumber", JDBCType.VARCHAR, this.customerPhoneNumber.get())});
        if (purList.getOriginalList().size() > 0) {
            this.parentCustomer = (Customer)purList.getOriginalList().get(0);
        }
    }

    private void loadParentAccountDetail() {
        AccountDetailDataList purList = new AccountDetailDataList(this.getDbAccess());
        String query = "Select * From AccountDetail Where accNumber=?";
        purList.selectAll(query, new ParameterValue[]{new ParameterValue("accountDetailNo", JDBCType.VARCHAR, this.accountDetailNo.get())});
        if (purList.getOriginalList().size() > 0) {
            this.parentAccountDetail = (AccountDetail)purList.getOriginalList().get(0);
        }
    }

    public double getTotalAmount() {
        return this.totalAmount.get();
    }

    public void setTotalAmount(double totalAmount) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.totalAmount.set(totalAmount);
        this.changeObjectState();
    }

    public DoubleProperty totalAmountProperty() {
        return this.totalAmount;
    }

    public String getAccountDetailNo() {
        return (String)this.accountDetailNo.get();
    }

    public void setAmountCollected(String accountDetailNo) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.accountDetailNo.set((Object)accountDetailNo);
    }

    public StringProperty accountDetailNoProperty() {
        return this.accountDetailNo;
    }

    public double getAmountPaid() {
        return this.amountPaid.get();
    }

    public void setAmountPaid(double amountPaid) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.amountPaid.set(amountPaid);
        this.changeObjectState();
    }

    public DoubleProperty amountPaidProperty() {
        return this.amountPaid;
    }

    public double getShippingFee() {
        return this.shippingFee.get();
    }

    public void setShippingFee(double shippingFee) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.shippingFee.set(shippingFee);
        this.changeObjectState();
    }

    public DoubleProperty shippingFeeProperty() {
        return this.shippingFee;
    }

    public double getChange() {
        return this.Change.get();
    }

    public void setChange(double Change) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.Change.set(Change);
        this.changeObjectState();
    }

    public DoubleProperty changeProperty() {
        return this.Change;
    }

    public double getDiscount() {
        return this.discount.get();
    }

    public void setDiscount(double discount) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.discount.set(discount);
        this.changeObjectState();
    }

    public DoubleProperty discountProperty() {
        return this.discount;
    }

    public double getBalance() {
        return this.balance.get();
    }

    public void setBalance(double balance) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.balance.set(balance);
        this.changeObjectState();
    }

    public DoubleProperty balanceProperty() {
        return this.balance;
    }

    public double getPriceFix() {
        return this.balance.get();
    }

    public void setPriceFix(double priceFix) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.priceFix.set(priceFix);
        this.changeObjectState();
    }

    public DoubleProperty priceFixProperty() {
        return this.priceFix;
    }

    public StringProperty salesModeProperty() {
        return this.salesMode;
    }

    public String getSalesMode() {
        return (String)this.salesMode.get();
    }

    public void setSalesMode(SalesMode salesMode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.salesMode.set((Object)salesMode.toString());
        this.changeObjectState();
    }

    public StringProperty salesRepProperty() {
        return this.salesRep;
    }

    public String getSalesRep() {
        return (String)this.salesRep.get();
    }

    public void setSalesRep(String salesRep) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.salesRep.set((Object)salesRep);
        this.changeObjectState();
    }

    public StringProperty syncErrorProperty() {
        return this.syncError;
    }

    public String getSyncError() {
        return (String)this.syncError.get();
    }

    public void setSyncError(String syncError) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.syncError.set((Object)syncError);
        this.changeObjectState();
    }

    public StringProperty hdInvoiceNoProperty() {
        return this.hdInvoiceNo;
    }

    public String getHdInvoiceNo() {
        return (String)this.hdInvoiceNo.get();
    }

    public void setHdInvoiceNo(String hdInvoiceNo) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.hdInvoiceNo.set((Object)hdInvoiceNo);
        this.changeObjectState();
    }

    public StringProperty saleCommentProperty() {
        return this.saleComment;
    }

    public String getSaleComment() {
        return (String)this.saleComment.get();
    }

    public void setSaleComment(String saleComment) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.saleComment.set((Object)saleComment);
        this.changeObjectState();
    }

    public boolean getIsFullpaid() {
        return this.isFullyPaid.get();
    }

    public void setIsFullpaid(boolean isfullyPaid) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.isFullyPaid.set(isfullyPaid);
    }

    public BooleanProperty IsFullpaidProperty() {
        return this.isFullyPaid;
    }

    public boolean getAllowClose() {
        return this.allowClose.get();
    }

    public void setAllowClose(boolean allowClose) {
        this.allowClose.set(allowClose);
    }

    public BooleanProperty AllowCloseProperty() {
        return this.allowClose;
    }

    public void setParentCompany(Company cp) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.parentCompany = cp;
        this.companyName = cp == null ? "" : cp.getName();
        this.changeObjectState();
    }

    private void loadParentCompany() {
        CompanyDataList compList = new CompanyDataList(this.getDbAccess());
        String query = "Select * From Company";
        compList.selectAll(query, this.getDbAccess().getEmptyParameterValues());
        if (compList.getOriginalList().size() > 0) {
            this.parentCompany = (Company)compList.getOriginalList().get(0);
        }
    }

    public Company getParentCompany() {
        if (this.parentCompany == null) {
            this.loadParentCompany();
        }
        return this.parentCompany;
    }

    public String getStoreCode() {
        return (String)this.storeCode.get();
    }

    public StringProperty storeCodeProperty() {
        return this.storeCode;
    }

    public void setStoreCode(String storeCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.storeCode.set((Object)storeCode);
        this.changeObjectState();
    }

    public void setCustomerName(String cust) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.customerName = cust;
        this.changeObjectState();
    }

    public User getStaff() {
        if (this.Staff == null) {
            UserDataList userDataList = new UserDataList(this.getDbAccess());
            userDataList.selectAll("Select * From User where username=?", new ParameterValue[]{new ParameterValue("username", JDBCType.VARCHAR, this.sellingStaff)});
            this.Staff = userDataList.getOriginalList().size() == 1 ? (User)userDataList.getOriginalList().get(0) : null;
        }
        return this.Staff;
    }

    public void setStaff(User Staff) {
        this.Staff = Staff;
        this.sellingStaff = this.Staff.getUserName();
    }

    public void setParentUser(User use) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.parentUser = use;
        this.sellingStaff = use == null ? "" : use.getUserName();
        this.changeObjectState();
    }

    public ObservableList<SaleAccountDetailResolver> getSaleAccountDetailResolvers() {
        return this.saleAccountDetailResolvers;
    }

    public ObservableList<SaleItem> getSaleItemsList() {
        return this.saleItems;
    }

    public void setSaleItemsList(ObservableList<SaleItem> saleItems) {
        this.saleItems = saleItems;
    }

    public ObservableList<SaleItem> getSaleItems(ObservableList<StockItem> items) {
        ObservableList saleItems = FXCollections.observableArrayList();
        for (StockItem si : items) {
            saleItems.add((Object)new SaleItem(si, this.getDbAccess(), this));
        }
        return saleItems;
    }

    public ObservableList<AccountDetail> getAccountDetailList() {
        return this.accountDetailList;
    }

    public void setAccountDetailList(ObservableList<AccountDetail> accountDetails) {
        this.accountDetailList = accountDetails;
    }

    public void loadParentUser() {
        UserDataList userList = new UserDataList(this.getDbAccess());
        String query = "Select * From User Where userName=?";
        userList.selectAll(query, new ParameterValue[]{new ParameterValue("userName", JDBCType.VARCHAR, this.sellingStaff)});
        if (userList.getOriginalList().size() > 0) {
            this.parentUser = (User)userList.getOriginalList().get(0);
        }
    }

    public User getParentUser() {
        if (this.parentUser == null) {
            this.loadParentUser();
        }
        return this.parentUser;
    }

    public String toString() {
        return String.valueOf(this.invoiceNumber.get());
    }

    public void setSaleStaffResponsible(String sellingStaff) {
        this.sellingStaff = sellingStaff;
    }

    public String getSaleStaffResponsible() {
        return this.sellingStaff;
    }

    public Sale CloneForInvoice() {
        Sale chase = new Sale();
        this.setMustClone(false);
        chase.syncFlag.set(this.syncFlag.get());
        chase.paymentTermDescription.set((Object)((String)this.paymentTermDescription.get()));
        chase.transactionDate.set((Object)((Timestamp)this.transactionDate.get()));
        chase.saleId.set((Object)((String)this.saleId.get()));
        chase.accountDetailNo.set((Object)((String)this.accountDetailNo.get()));
        chase.balance.set(this.balance.get());
        chase.companyName = this.companyName;
        chase.totalAmount.set(this.totalAmount.get());
        chase.sellingStaff = this.sellingStaff;
        chase.amountPaid.set(this.amountPaid.get());
        chase.isManual.set(this.isManual.get());
        chase.storeCode.set((Object)((String)this.storeCode.get()));
        chase.storeName = this.storeName;
        chase.costCenter.set((Object)((String)this.costCenter.get()));
        chase.locationCode.set((Object)((String)this.locationCode.get()));
        chase.salesMode.set((Object)((String)this.salesMode.get()));
        chase.shippingFee.set(this.shippingFee.get());
        chase.customerName = this.customerName;
        chase.invoiceNumber.set(this.getInvoiceNumber());
        chase.priceFix.set(this.getPriceFix());
        chase.discount.set(this.discount.get());
        chase.syncError.set((Object)((String)this.syncError.get()));
        chase.newDate.set((Object)((Timestamp)this.newDate.get()));
        chase.returnAll.set(this.returnAll.get());
        chase.hdInvoiceNo.set((Object)((String)this.hdInvoiceNo.get()));
        chase.isB2B.set(this.isB2B.get());
        chase.accountDetailList = this.accountDetailList;
        chase.salesChannel = this.salesChannel;
        chase.creditDescription = this.creditDescription;
        chase.creditToken = this.creditToken;
        chase.promoVoucher = this.promoVoucher;
        chase.promoVoucherAmt = this.promoVoucherAmt;
        chase.customerEmail = this.customerEmail;
        chase.customerName = this.customerName;
        chase.customerPhoneNumber = this.customerPhoneNumber;
        chase.d365CustomerNo = this.d365CustomerNo;
        chase.paymentTerm = this.paymentTerm;
        this.setMustClone(true);
        this.isCloned = true;
        return chase;
    }

    public Sale Clone() {
        Sale chase = new Sale();
        this.setMustClone(false);
        chase.returnComment.set((Object)((String)this.returnComment.get()));
        chase.paymentTermDescription.set((Object)((String)this.paymentTermDescription.get()));
        chase.returnRejectedBy.set((Object)((String)this.returnRejectedBy.get()));
        chase.paymentTerm.set((Object)((String)this.paymentTerm.get()));
        chase.salesRejectedBy.set((Object)((String)this.salesRejectedBy.get()));
        chase.salesChannel = this.salesChannel;
        chase.syncFlag.set(this.syncFlag.get());
        chase.transactionDate.set((Object)((Timestamp)this.transactionDate.get()));
        chase.saleId.set((Object)((String)this.saleId.get()));
        chase.accountDetailNo.set((Object)((String)this.accountDetailNo.get()));
        chase.balance.set(this.balance.get());
        chase.companyName = this.companyName;
        chase.totalAmount.set(this.totalAmount.get());
        chase.sellingStaff = this.sellingStaff;
        chase.amountPaid.set(this.amountPaid.get());
        chase.isManual.set(this.isManual.get());
        chase.storeCode.set((Object)((String)this.storeCode.get()));
        chase.salesMode.set((Object)((String)this.salesMode.get()));
        chase.shippingFee.set(this.shippingFee.get());
        chase.customerName = this.customerName;
        chase.invoiceNumber.set(this.getInvoiceNumber());
        chase.priceFix.set(this.getPriceFix());
        chase.discount.set(this.discount.get());
        chase.syncError.set((Object)((String)this.syncError.get()));
        chase.newDate.set((Object)((Timestamp)this.newDate.get()));
        chase.returnAll.set(this.returnAll.get());
        chase.isB2B.set(this.isB2B.get());
        chase.costCenter.set((Object)((String)this.costCenter.get()));
        chase.locationCode.set((Object)((String)this.locationCode.get()));
        chase.hdInvoiceNo.set((Object)((String)this.hdInvoiceNo.get()));
        chase.saleComment.set((Object)((String)this.saleComment.get()));
        chase.creditDescription.set((Object)((String)this.creditDescription.get()));
        chase.creditToken.set((Object)((String)this.creditToken.get()));
        chase.promoVoucher = this.promoVoucher;
        chase.promoVoucherAmt = this.promoVoucherAmt;
        chase.imageUrl = this.imageUrl;
        this.setMustClone(true);
        this.isCloned = true;
        return chase;
    }

    public Sale testClone() {
        Sale chase = new Sale();
        this.setMustClone(false);
        chase.paymentTerm.set((Object)((String)this.paymentTerm.get()));
        chase.paymentTermDescription.set((Object)((String)this.paymentTermDescription.get()));
        chase.returnRejectedBy.set((Object)((String)this.returnRejectedBy.get()));
        chase.returnComment.set((Object)((String)this.returnComment.get()));
        chase.imageUrl.set((Object)((String)this.imageUrl.get()));
        chase.syncFlag.set(this.syncFlag.get());
        chase.transactionDate.set((Object)((Timestamp)this.transactionDate.get()));
        chase.saleId.set((Object)((String)this.saleId.get()));
        chase.accountDetailNo.set((Object)((String)this.accountDetailNo.get()));
        chase.balance.set(this.balance.get());
        chase.companyName = this.companyName;
        chase.totalAmount.set(this.totalAmount.get());
        chase.storeCode.set((Object)((String)this.storeCode.get()));
        chase.sellingStaff = this.sellingStaff;
        chase.amountPaid.set(this.amountPaid.get());
        chase.salesMode.set((Object)((String)this.salesMode.get()));
        chase.customerName = this.customerName;
        chase.invoiceNumber.set(this.getInvoiceNumber());
        chase.priceFix.set(this.getPriceFix());
        chase.discount.set(this.discount.get());
        chase.newDate.set((Object)((Timestamp)this.newDate.get()));
        chase.shippingFee.set(this.shippingFee.get());
        chase.returnAll.set(this.returnAll.get());
        chase.isB2B.set(this.isB2B.get());
        chase.salesRejectedBy.set((Object)((String)this.salesRejectedBy.get()));
        this.setMustClone(true);
        return chase;
    }

    public void rollBack() {
        this.setBalance(this.vClone.getBalance());
        this.syncFlag = this.vClone.syncFlag;
        this.paymentTermDescription = this.vClone.paymentTermDescription;
        this.returnComment = this.vClone.returnComment;
        this.returnRejectedBy = this.vClone.returnRejectedBy;
        this.paymentTerm = this.vClone.paymentTerm;
        this.imageUrl = this.vClone.imageUrl;
        this.salesRejectedBy = this.vClone.salesRejectedBy;
        this.transactionDate = this.vClone.transactionDate;
        this.accountDetailNo = this.vClone.accountDetailNo;
        this.saleId = this.vClone.saleId;
        this.companyName = this.vClone.companyName;
        this.storeCode = this.vClone.storeCode;
        this.syncError = this.vClone.syncError;
        this.isManual = this.vClone.isManual;
        this.hdInvoiceNo = this.vClone.hdInvoiceNo;
        this.costCenter.set((Object)((String)this.vClone.costCenter.get()));
        this.locationCode.set((Object)((String)this.vClone.locationCode.get()));
        this.sellingStaff = this.vClone.sellingStaff;
        this.customerName = this.vClone.customerName;
        this.setInvoiceNumber(this.vClone.getInvoiceNumber());
        this.setTotalAmount(this.vClone.getTotalAmount());
        this.setPriceFix(this.vClone.getPriceFix());
        this.setDiscount(this.vClone.getDiscount());
        this.setAmountPaid(this.vClone.getAmountPaid());
        this.shippingFee = this.vClone.shippingFee;
        this.setSalesMode(SalesMode.valueOf((String)this.vClone.salesMode.get()));
        this.returnAll.set(this.vClone.returnAll.get());
        this.isB2B.set(this.vClone.isB2B.get());
        this.saleComment.set((Object)((String)this.vClone.saleComment.get()));
        this.salesChannel.set((Object)((String)this.vClone.salesChannel.get()));
        this.creditDescription.set((Object)((String)this.vClone.creditDescription.get()));
        this.creditToken.set((Object)((String)this.vClone.creditToken.get()));
        this.promoVoucher.set((Object)((String)this.vClone.promoVoucher.get()));
        this.promoVoucherAmt.set(this.vClone.promoVoucherAmt.get());
        this.setMustClone(true);
    }

    public Sale() {
        this.Reprint = "Original";
    }

    public Sale(String salesRep, Timestamp transactionDate, Timestamp date, Integer invoiceNumber, Double totalAmount, Double amountPaid, Double discount, Double balance, Double priceFix, SalesMode salesMode, String companyName, String customerName, String sellingStaff, Boolean returnAll, String accountDetailNo, String sapDockNum, Boolean isB2B, Boolean syncFlag, Double shippingFee, String storeCode, String syncError, Boolean isManual, String saleComment, String salesChannel, String locationCode, String costCenter, String hdInvoiceNo, String creditDescription, String creditToken, String promoVoucher, Double promoVoucherAmt, String manualSaleStatus, String CustomerPhoneNumber, String CustomerEmail, String Approvals, String salesRejectedBy, String ReturnApprovals, String ReturnedBy, String ActionComment, String D365CustomerNo, String SaleStatus2, String paymentTerm, String imageUrl, String returnRejectedBy, String returnComment, String paymentTermDescription, DataAccess de) {
        super(de);
        this.returnRejectedBy.set((Object)returnRejectedBy);
        this.paymentTermDescription.set((Object)paymentTermDescription);
        this.returnComment.set((Object)returnComment);
        this.paymentTerm.set((Object)paymentTerm);
        this.imageUrl.set((Object)imageUrl);
        this.customerPhoneNumber.set((Object)CustomerPhoneNumber);
        this.salesRejectedBy.set((Object)salesRejectedBy);
        this.customerEmail.set((Object)CustomerEmail);
        this.approvals.set((Object)Approvals);
        this.returnApprovals.set((Object)ReturnApprovals);
        this.returnedBy.set((Object)ReturnedBy);
        this.actionComment.set((Object)ActionComment);
        this.d365CustomerNo.set((Object)D365CustomerNo);
        this.saleStatus.set((Object)SaleStatus2);
        this.manualSaleStatus.set((Object)manualSaleStatus);
        this.syncFlag.set(syncFlag.booleanValue());
        this.salesRep.set((Object)salesRep);
        this.hdInvoiceNo.set((Object)(hdInvoiceNo == null ? "" : hdInvoiceNo));
        this.creditDescription.set((Object)(creditDescription == null ? "" : creditDescription));
        this.creditToken.set((Object)(creditToken == null ? "" : creditToken));
        this.costCenter.set((Object)(costCenter == null ? "" : costCenter));
        this.locationCode.set((Object)(locationCode == null ? "" : locationCode));
        this.transactionDate.set((Object)transactionDate);
        this.newDate.set((Object)date);
        this.saleId.set((Object)sapDockNum);
        this.isManual.set(isManual.booleanValue());
        this.accountDetailNo.set((Object)accountDetailNo);
        this.invoiceNumber.set(invoiceNumber.intValue());
        this.totalAmount.set(totalAmount.doubleValue());
        this.amountPaid.set(amountPaid.doubleValue());
        this.syncError.set((Object)syncError);
        this.discount.set(discount.doubleValue());
        this.balance.set(balance.doubleValue());
        this.priceFix.set(priceFix.doubleValue());
        this.storeCode.set((Object)(storeCode == null ? "" : storeCode));
        this.salesMode.set((Object)salesMode.toString());
        this.customerName = customerName;
        this.companyName = companyName;
        this.sellingStaff = sellingStaff;
        this.shippingFee.set(shippingFee.doubleValue());
        this.returnAll.set(returnAll.booleanValue());
        this.saleComment.set((Object)saleComment);
        this.isB2B.set(isB2B.booleanValue());
        this.salesChannel.set((Object)salesChannel);
        this.promoVoucher.set((Object)promoVoucher);
        this.promoVoucherAmt.set(promoVoucherAmt.doubleValue());
        this.Reprint = "Duplicate";
        this.setState(ObjectState.Unchanged);
        this.initializeListener();
    }

    public Sale(DataAccess dbAccess) {
        super(dbAccess);
    }

    void saveToFile() {
        Object filePath = "";
        filePath = Santa.isDevelopment ? "/Users/akintunde/NetBeansProjects/YuvendRetail/Files" : (System.getProperty("os.name").indexOf("Mac OS X") >= 0 ? File.separator + this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replace("Santa.jar", "Files").substring(1) : this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath().replace("Santa.jar", "File").substring(1));
        File outputFile = null;
        for (BufferedImage image : this.img) {
            String path = (String)filePath + File.separator + Santa.getUniqueId("Upload") + ".png";
            outputFile = new File(path);
            try {
                ImageIO.write((RenderedImage)image, "png", outputFile);
                this.setImageUrl(this.getImageUrl().isEmpty() || this.getImageUrl() == null ? path : this.getImageUrl() + "," + path);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    boolean isManualWithoutApproval() {
        return this.getSaleItemsList().stream().filter(sf -> sf.getQuantity() > (float)sf.getParentStockItem().totalQty || sf.getVariablePrice() < sf.getParentStockItem().getSellingPrice()).count() == 0L && this.getIsManual() != false && ((String)this.creditToken.get()).isEmpty();
    }

    private void saveList() throws Exception {
        this.amount = this.Change.get() > 0.0 ? Double.valueOf(this.amountPaid.get() - this.Change.get()) : Double.valueOf(this.amountPaid.get());
        if (!this.getIsManual().booleanValue() || this.getIsManual().booleanValue() && this.getManualSaleStatus().equals(ManualPendingStatus.Completed.toString())) {
            this.setSaleStatus(SaleStatus.COMPLETED.name());
            this.setManualSaleStatus(ManualPendingStatus.Completed.name());
        }
        this.saleList.getOriginalList().add((Object)this);
        try {
            if (this.getImageUrl().isEmpty() && this.img != null) {
                this.saveToFile();
            }
            this.saleList.update();
        }
        catch (Exception e) {
            this.getDbAccess().rollBack();
            this.setState(ObjectState.New);
            Logger.getLogger(Sale.class.getName()).log(Level.SEVERE, null, e);
            throw new Exception(e.getMessage());
        }
        if (this.saleCreated || !this.getIsManual().booleanValue() || this.isManualWithoutApproval()) {
            this.saleAccountDetailResolverDataList = new SaleAccountDetailResolverDataList(this.getDbAccess());
            for (AccountDetail accountDetail : this.accountDetailList) {
                SaleAccountDetailResolver saleAccountDetailResolver = new SaleAccountDetailResolver(this.getDbAccess());
                saleAccountDetailResolver.setAccNumber(accountDetail.getAccNumber());
                saleAccountDetailResolver.setAccType(accountDetail.getAccType());
                saleAccountDetailResolver.setAmountPaid(accountDetail.getAmount());
                saleAccountDetailResolver.setInvoiceNumber(this.getInvoiceNumber());
                saleAccountDetailResolver.setTransactionDate(this.getNewDate());
                saleAccountDetailResolver.setPaymentCode((String)accountDetail.chequeNumber.get());
                saleAccountDetailResolver.setAccountName(accountDetail.getAccName());
                this.saleAccountDetailResolverDataList.getOriginalList().add((Object)saleAccountDetailResolver);
            }
            try {
                this.saleAccountDetailResolverDataList.update();
            }
            catch (Exception ex) {
                this.setState(ObjectState.New);
                this.getDbAccess().rollBack();
                Logger.getLogger(Sale.class.getName()).log(Level.SEVERE, null, ex);
                throw new Exception(ex.getMessage());
            }
        }
        if (this.saleItemList.getOriginalList().size() > 0) {
            try {
                for (SaleItem saleParameterValue : this.saleItemList.getOriginalList()) {
                    saleParameterValue.quantityProperty().set(saleParameterValue.getQuantity() * saleParameterValue.getParentUnit().getQuantity());
                }
                this.saleItemList.update();
            }
            catch (Exception e) {
                this.setState(ObjectState.New);
                this.getDbAccess().rollBack();
                Logger.getLogger(Sale.class.getName()).log(Level.SEVERE, null, e);
                throw new Exception(e.getMessage());
            }
        }
        if (this.saleItemList.getOriginalList().size() > 0) {
            try {
                SaleItemSerialDataList serialList = new SaleItemSerialDataList(this.getDbAccess());
                this.saleItemList.getOriginalList().forEach(val -> serialList.getOriginalList().addAll(val.getSerials().getOriginalList()));
                serialList.update();
            }
            catch (Exception e) {
                this.getDbAccess().rollBack();
                this.setState(ObjectState.New);
                Logger.getLogger(Sale.class.getName()).log(Level.SEVERE, null, e);
                throw new Exception(e.getMessage());
            }
        }
        if (((SaleItem)this.getSaleItemsList().get(0)).getParentStockItem() != null && (this.saleCreated || !this.getIsManual().booleanValue())) {
            this.stockItemList.getOriginalList().clear();
            for (SaleItem saleItem : this.getSaleItemsList()) {
                this.stockItemList.getOriginalList().add((Object)saleItem.getParentStockItem());
            }
            if (this.stockItemList.getOriginalList().size() > 0) {
                try {
                    this.stockItemList.update();
                }
                catch (Exception e) {
                    this.setState(ObjectState.New);
                    this.getDbAccess().rollBack();
                    Logger.getLogger(Sale.class.getName()).log(Level.SEVERE, null, e);
                }
            }
        }
    }

    public void makeSale(User currentUser) throws Exception {
        this.salesMode.set((Object)SalesMode.Bargain.toString());
        this.isMakingSale = true;
        this.stockItemList = new StockItemList(this.getDbAccess());
        this.saleList = new SaleList(this.getDbAccess());
        this.saleItemList = new SaleItemList(this.getDbAccess());
        if (!this.getSaleComment().isEmpty()) {
            this.setIsManual(true);
        }
        if (!this.saleCreated) {
            this.dateProperty().set((Object)Timestamp.valueOf(this.getParentCompany().getCurrentDay().atStartOfDay()));
            this.setStaff(currentUser);
            boolean b2b = false;
            int countGreaterThan5 = 0;
            for (SaleItem saleItem1 : this.getSaleItemsList()) {
                countGreaterThan5 += Math.round(saleItem1.getTotalQty());
            }
            if (this.getSaleItemsList().size() >= 5 || this.getSaleItemsList().stream().filter(item -> item.getTotalQty() >= 5).findAny().orElse(null) != null || countGreaterThan5 >= 5) {
                b2b = true;
            }
            for (SaleItem saleItem : this.getSaleItemsList()) {
                SaleItem s;
                if (saleItem.getTotalQty() <= 0) continue;
                saleItem.setSellingPrice(saleItem.getVariablePrice());
                if (saleItem.getParentStockItem() != null) {
                    saleItem.getParentStockItem().dateLastDateProperty().set((Object)Date.valueOf(this.getParentCompany().getCurrentDay()));
                }
                if (this.getSaleComment() != null && !this.getSaleComment().isEmpty()) {
                    this.setSaleComment("User Comment:" + this.getSaleComment());
                }
                if (saleItem.getParentStockItem() != null && saleItem.getParentStockItem().getTotalQty() < saleItem.getTotalQty()) {
                    this.setSaleComment(this.getSaleComment().isEmpty() ? "System Comment:" + saleItem.getParentStockItem().getItemCode() : this.getSaleComment() + "\n System Comment:" + saleItem.getParentStockItem().getItemCode() + Integer.toString(saleItem.getParentStockItem().getTotalQty()) + " Quantity Available, Quantity altered");
                }
                if (saleItem.getParentStockItem() != null) {
                    if (b2b) {
                        if (saleItem.getParentStockItem().getPriceB2B() != saleItem.getSellingPrice()) {
                            this.setSaleComment(this.getSaleComment().isEmpty() ? "System Comment:" + saleItem.getParentStockItem().getItemCode() + " Selling Price " : this.getSaleComment() + "\n System Comment:" + saleItem.getParentStockItem().getItemCode() + " Selling Price " + Double.toString(saleItem.getParentStockItem().getSellingPrice()) + " During Sale, Selling Price altered");
                        }
                    } else if (saleItem.getParentStockItem().getSellingPrice() != saleItem.getSellingPrice()) {
                        this.setSaleComment(this.getSaleComment().isEmpty() ? "System Comment:" + saleItem.getParentStockItem().getItemCode() + " Selling Price " : this.getSaleComment() + "\n System Comment:" + saleItem.getParentStockItem().getItemCode() + " Selling Price " + Double.toString(saleItem.getParentStockItem().getSellingPrice()) + " During Sale, Selling Price altered");
                    }
                }
                if (saleItem.getQuantity() > 0.0f) {
                    s = saleItem.clone();
                    s.codeProperty().set((Object)UUID.randomUUID().toString());
                    s.setDbAccess(saleItem.getDbAccess());
                    if (saleItem.getParentStockItem() != null) {
                        s.setParentStockItem(saleItem.getParentStockItem());
                    }
                    s.setCostPrice(saleItem.getParentStockItem() != null ? s.getParentStockItem().getCostPrice() : 0.0);
                    s.dspQtyProperty().set(0.0f);
                    s.cnsQtyProperty().set(0.0f);
                    if (saleItem.getParentStockItem() != null) {
                        s.getParentStockItem().quantityProperty().set(s.getParentStockItem().getQuantity() - s.getQuantity() * s.getParentUnit().getQuantity());
                    }
                    s.setParentSale(this);
                    saleItem.getSerials().getOriginalList().forEach(v -> {
                        v.setSaleItemCode(s.getCode());
                        s.getSerials().getOriginalList().add(v);
                    });
                    this.saleItemList.getOriginalList().add((Object)s);
                }
                if (saleItem.getCnsQty() > 0) {
                    s = saleItem.clone();
                    s.codeProperty().set((Object)UUID.randomUUID().toString());
                    s.setDbAccess(saleItem.getDbAccess());
                    if (saleItem.getParentStockItem() != null) {
                        s.setParentStockItem(saleItem.getParentStockItem());
                    }
                    s.setCostPrice(saleItem.getParentStockItem() != null ? s.getParentStockItem().getCostPrice() : 0.0);
                    s.dspQtyProperty().set(0.0f);
                    s.quantityProperty().set(0.0f);
                    if (saleItem.getParentStockItem() != null) {
                        s.getParentStockItem().cnsQtyProperty().set((float)s.getParentStockItem().getCnsQty() - (float)s.getCnsQty() * s.getParentUnit().getQuantity());
                    }
                    s.setParentSale(this);
                    saleItem.getSerials().getOriginalList().forEach(v -> {
                        v.setSaleItemCode(s.getCode());
                        s.getSerials().getOriginalList().add(v);
                    });
                    this.saleItemList.getOriginalList().add((Object)s);
                }
                if (saleItem.getDspQty() <= 0) continue;
                s = saleItem.clone();
                s.codeProperty().set((Object)UUID.randomUUID().toString());
                s.setDbAccess(saleItem.getDbAccess());
                if (saleItem.getParentStockItem() != null) {
                    s.setParentStockItem(saleItem.getParentStockItem());
                }
                s.setCostPrice(saleItem.getParentStockItem() != null ? s.getParentStockItem().getCostPrice() : 0.0);
                s.cnsQtyProperty().set(0.0f);
                s.quantityProperty().set(0.0f);
                if (saleItem.getParentStockItem() != null) {
                    s.getParentStockItem().dspQtyProperty().set((float)s.getParentStockItem().getDspQty() - (float)s.getDspQty() * s.getParentUnit().getQuantity());
                }
                s.setParentSale(this);
                saleItem.getSerials().getOriginalList().forEach(v -> {
                    v.setSaleItemCode(s.getCode());
                    s.getSerials().getOriginalList().add(v);
                });
                this.saleItemList.getOriginalList().add((Object)s);
            }
        }
        try {
            this.getDbAccess().start();
            this.saveList();
            this.getDbAccess().end();
            this.isSold = true;
        }
        catch (Exception ex) {
            this.getDbAccess().rollBack();
            throw ex;
        }
    }

    private void DirectSale(SaleItem saleItem) throws NotEnoughQtyException {
        this.isMakingSale = true;
        Calendar CurrentDate = Calendar.getInstance();
        Calendar lastSaleSold = Calendar.getInstance();
        CurrentDate.setTime(Date.valueOf(this.getParentCompany().getCurrentDay()));
        if (saleItem.getParentStockItem().getDateLastSold() == null) {
            lastSaleSold.setTime(Date.valueOf(this.getParentCompany().getCurrentDay()));
        } else {
            lastSaleSold.setTime(saleItem.getParentStockItem().getDateLastSold());
        }
        long l = this.getParentCompany().getDirectPurchaseDuration();
        this.getParentCompany();
        if (l < Company.daysBetween(lastSaleSold, CurrentDate) && saleItem.getParentStockItem().getDirectPurchaseQty() != 0.0) {
            throw new NotEnoughQtyException("Direct Purchase Not possible for Item " + saleItem.getParentStockItem().getName() + " code " + saleItem.getParentStockItem().getItemCode());
        }
        double directSaleQuantity = saleItem.getQuantity() * saleItem.getParentUnit().getQuantity() - saleItem.getParentStockItem().getQuantity();
        saleItem.getParentStockItem().directPurchaseQtyProperty().set(directSaleQuantity + saleItem.getParentStockItem().getDirectPurchaseQty());
        saleItem.getParentStockItem().quantityProperty().set(0.0f);
    }

    public static SaleList search(String qry, ParameterValue[] param, DataAccess dt) {
        SaleList saleList = new SaleList(dt);
        saleList.selectAll(qry, param);
        return saleList;
    }

    public void setPayments(SaleAccountDetailResolverDataList payments) {
        this.payments.getOriginalList().addAll(payments.getOriginalList());
    }

    public static SaleList SearchSaleItemForSaleReturn(String searcString, Date FromDate, Date ToDate, DataAccess dt, User user) {
        LocalDateTime now;
        SaleList saleLst = new SaleList(dt);
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        SaleItemList saleItemList = new SaleItemList(dt);
        tempParamValue.clear();
        Object query = user != null && user.getRoleDescription().equals(UserType.SalesPerson.name()) ? "Select * From Sale Where SaleStatus <> \"CANCELLED\" and SellingStaff='" + user.getUserName() + "' and " : "Select * From Sale Where SaleStatus<> \"CANCELLED\" and ";
        if (searcString != null && !searcString.isEmpty()) {
            FromDate = null;
            ToDate = null;
        }
        if (searcString != null && !searcString.isEmpty() && FromDate != null && ToDate != null) {
            now = new Timestamp(FromDate.getTime()).toLocalDateTime();
            LocalDateTime start = now.with(LocalTime.MIN);
            Timestamp startTime = Timestamp.valueOf(start);
            LocalDateTime end = new Timestamp(ToDate.getTime()).toLocalDateTime().with(LocalTime.MAX);
            Timestamp endTime = Timestamp.valueOf(end);
            query = (String)query + "(saleId like ? or customerName like ? or invoiceNumber like ? or SellingStaff like ? or hdInvoiceNo like ? ) and transactionDate >= ? And transactionDate <= ? ORDER by invoiceNumber DESC ";
            saleLst.selectAll((String)query, new ParameterValue[]{new ParameterValue("saleId", JDBCType.VARCHAR, searcString), new ParameterValue("customerName", JDBCType.VARCHAR, searcString), new ParameterValue("invoiceNumber", JDBCType.VARCHAR, searcString), new ParameterValue("hdInvoiceNo", JDBCType.VARCHAR, searcString), new ParameterValue("SellingStaff", JDBCType.VARCHAR, searcString), new ParameterValue("ParamFromDate", JDBCType.TIMESTAMP, startTime), new ParameterValue("ParamToDate", JDBCType.TIMESTAMP, endTime)});
        } else if ((searcString == null || searcString.isEmpty()) && FromDate != null && ToDate != null) {
            now = FromDate.toLocalDate().atTime(0, 0, 0);
            Timestamp startTime = Timestamp.valueOf(now);
            LocalDateTime end = new Timestamp(ToDate.getTime()).toLocalDateTime().with(LocalTime.MAX);
            Timestamp endTime = Timestamp.valueOf(end);
            query = (String)query + " transactionDate >= " + startTime.getTime() + " And transactionDate <= " + endTime.getTime() + "  ORDER by invoiceNumber DESC";
            saleLst.selectAll((String)query, dt.getEmptyParameterValues());
        } else if (!(searcString == null || searcString.isEmpty() || FromDate != null && ToDate != null)) {
            query = (String)query + "(saleId like ? or customerName like ? or invoiceNumber like ? or SellingStaff like ? or hdInvoiceNo like ? ) ORDER by invoiceNumber DESC ";
            saleLst.selectAll((String)query, new ParameterValue[]{new ParameterValue("saleId", JDBCType.VARCHAR, searcString), new ParameterValue("customerName", JDBCType.VARCHAR, searcString), new ParameterValue("invoiceNumber", JDBCType.VARCHAR, searcString), new ParameterValue("SellingStaff", JDBCType.VARCHAR, searcString), new ParameterValue("hdInvoiceNo", JDBCType.VARCHAR, searcString)});
        }
        if (saleLst.getOriginalList().size() > 0) {
            for (Sale sale : saleLst.getOriginalList()) {
                tempParamValue.clear();
                tempParamValue.add(new ParameterValue("saleinvoicenumber", JDBCType.INTEGER, sale.getInvoiceNumber()));
                saleItemList.selectAll("Select * from SaleItem where saleinvoicenumber=?", new ParameterValue[]{new ParameterValue("saleinvoicenumber", JDBCType.INTEGER, sale.getInvoiceNumber())});
                if (saleItemList.getOriginalList().size() > 0) {
                    sale.getSaleItemsList().addAll(saleItemList.getOriginalList());
                    for (SaleItem sitem : saleItemList.getOriginalList()) {
                        sitem.loadedUnit = sitem.getParentUnit().clone();
                        sale.totalSaleitemQtybought += sitem.getQuantity();
                        sitem.setHasQty(sitem.getQuantity() > 0.0f);
                        sitem.getParentStockItem();
                    }
                }
                sale.payments = new SaleAccountDetailResolverDataList(dt);
                sale.payments.selectAll("Select * from SaleAccountDetailResolver where invoiceNumber=?", new ParameterValue[]{new ParameterValue("invoiceNumber", JDBCType.INTEGER, sale.getInvoiceNumber())});
            }
        }
        return saleLst;
    }

    public static SaleList SearchSaleForSaleReturnNotSync(DataAccess dt) {
        SaleList saleLst = new SaleList(dt);
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        SaleItemList saleItemList = new SaleItemList(dt);
        tempParamValue.clear();
        String query = "Select * From Sale Where SaleStatus <> \"CANCELLED\" and SyncFlag=?";
        saleLst.selectAll(query, new ParameterValue[]{new ParameterValue("SyncFlag", JDBCType.CHAR, Boolean.FALSE)});
        if (saleLst.getOriginalList().size() > 0) {
            for (Sale sale : saleLst.getOriginalList()) {
                tempParamValue.clear();
                tempParamValue.add(new ParameterValue("saleinvoicenumber", JDBCType.INTEGER, sale.getInvoiceNumber()));
                saleItemList.selectAll("Select * from SaleItem where saleinvoicenumber=?", new ParameterValue[]{new ParameterValue("saleinvoicenumber", JDBCType.INTEGER, sale.getInvoiceNumber())});
                if (saleItemList.getOriginalList().size() > 0) {
                    sale.getSaleItemsList().addAll(saleItemList.getOriginalList());
                    for (SaleItem sitem : saleItemList.getOriginalList()) {
                        sitem.loadedUnit = sitem.getParentUnit().clone();
                        sale.totalSaleitemQtybought += sitem.getQuantity();
                        sitem.setHasQty(sitem.getQuantity() > 0.0f);
                        sitem.getParentStockItem();
                    }
                }
                sale.payments = new SaleAccountDetailResolverDataList(dt);
                sale.payments.selectAll("Select * from SaleAccountDetailResolver where invoiceNumber=?", new ParameterValue[]{new ParameterValue("invoiceNumber", JDBCType.INTEGER, sale.getInvoiceNumber())});
            }
        }
        return saleLst;
    }

    public static boolean iSaleOccurInDate(Date FromDate, Date ToDate, DataAccess dt) {
        SaleList saleLst = new SaleList(dt);
        ArrayList tempParamValue = new ArrayList();
        SaleItemList saleItemList = new SaleItemList(dt);
        tempParamValue.clear();
        String query = "Select Distinct * From Sale Where SaleStatus <> \"CANCELLED\" and transactionDate between ? And ? ";
        java.util.Date start = new java.util.Date(FromDate.getYear(), FromDate.getMonth(), FromDate.getDate(), 0, 0, 0);
        java.util.Date end = new java.util.Date(FromDate.getYear(), ToDate.getMonth(), ToDate.getDate(), 23, 59, 0);
        saleLst.selectAll(query, new ParameterValue[]{new ParameterValue("ParamFromDate", JDBCType.TIMESTAMP, new Timestamp(start.getTime())), new ParameterValue("ParamToDate", JDBCType.TIMESTAMP, new Timestamp(end.getTime()))});
        return !saleLst.getOriginalList().isEmpty();
    }

    public static SaleList SearchSaleItemByAcct(String searcString, Date FromDate, Date ToDate, DataAccess dt, User user) {
        java.util.Date end;
        java.util.Date start;
        SaleList saleLst = new SaleList(dt);
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        SaleItemList saleItemList = new SaleItemList(dt);
        tempParamValue.clear();
        Object query = user.getRoleDescription().equals(UserType.SalesPerson.name()) ? "Select Distinct * From Sale Where SaleStatus <> \"CANCELLED\" and SellingStaff='" + user.getUserName() + "' and " : "Select Distinct * From Sale Where SaleStatus <> \"CANCELLED\" and";
        if (searcString != null && !searcString.isEmpty() && FromDate != null && ToDate != null) {
            query = (String)query + "(saleId like ? or customerName like ? or invoiceNumber like ? or SellingStaff like ? ) and transactionDate between ? And ? ORDER by invoiceNumber ASC ";
            start = new java.util.Date(FromDate.getYear(), FromDate.getMonth(), FromDate.getDate(), 0, 0, 0);
            end = new java.util.Date(FromDate.getYear(), ToDate.getMonth(), ToDate.getDate(), 23, 59, 0);
            saleLst.selectAll((String)query, new ParameterValue[]{new ParameterValue("saleId", JDBCType.VARCHAR, searcString), new ParameterValue("customerName", JDBCType.VARCHAR, searcString), new ParameterValue("invoiceNumber", JDBCType.VARCHAR, searcString), new ParameterValue("SellingStaff", JDBCType.VARCHAR, searcString), new ParameterValue("ParamFromDate", JDBCType.TIMESTAMP, new Timestamp(start.getTime())), new ParameterValue("ParamToDate", JDBCType.TIMESTAMP, new Timestamp(end.getTime()))});
        } else if ((searcString == null || searcString.isEmpty()) && FromDate != null && ToDate != null) {
            query = (String)query + " transactionDate between '" + FromDate.toString() + " 0:0' And '" + ToDate.toString() + " 23:59' ORDER by invoiceNumber ASC";
            start = new java.util.Date(FromDate.getYear(), FromDate.getMonth(), FromDate.getDate(), 0, 0, 0);
            end = new java.util.Date(FromDate.getYear(), ToDate.getMonth(), ToDate.getDate(), 23, 59, 0);
            saleLst.selectAll((String)query, dt.getEmptyParameterValues());
        } else if (!(searcString == null || searcString.isEmpty() || FromDate != null && ToDate != null)) {
            query = (String)query + "(saleId like ? or customerName like ? or invoiceNumber like ? or SellingStaff like ? ) ORDER by invoiceNumber ASC ";
            saleLst.selectAll((String)query, new ParameterValue[]{new ParameterValue("saleId", JDBCType.VARCHAR, searcString), new ParameterValue("customerName", JDBCType.VARCHAR, searcString), new ParameterValue("invoiceNumber", JDBCType.VARCHAR, searcString), new ParameterValue("SellingStaff", JDBCType.VARCHAR, searcString)});
        }
        if (saleLst.getOriginalList().size() > 0) {
            for (Sale sale : saleLst.getOriginalList()) {
                tempParamValue.clear();
                tempParamValue.add(new ParameterValue("saleinvoicenumber", JDBCType.INTEGER, sale.getInvoiceNumber()));
                saleItemList.selectAll("Select * from SaleItem where saleinvoicenumber=?", new ParameterValue[]{new ParameterValue("saleinvoicenumber", JDBCType.INTEGER, sale.getInvoiceNumber())});
                if (saleItemList.getOriginalList().size() <= 0) continue;
                sale.getSaleItemsList().addAll(saleItemList.getOriginalList());
                for (SaleItem sitem : saleItemList.getOriginalList()) {
                    sitem.loadedUnit = sitem.getParentUnit().clone();
                    sale.totalSaleitemQtybought += sitem.getQuantity();
                    sitem.setHasQty(sitem.getQuantity() > 0.0f);
                }
            }
        }
        return saleLst;
    }

    public static SaleList SearchSaleItemForSaleReturn(String searchString, DataAccess dt) {
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        SaleList saleList = new SaleList(dt);
        SaleItemList saleItemList = new SaleItemList(dt);
        tempParamValue.clear();
        SearchCondition searchCondition = new SearchCondition();
        tempParamValue.add(new ParameterValue("Customername", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("SellingStaff", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("invoiceNumber", JDBCType.VARCHAR, "%" + searchString + "%"));
        searchCondition.setParametersvalues(tempParamValue);
        saleList.select(searchCondition, true, true);
        saleList.getOriginalList().removeIf((Predicate)new Predicate<Sale>(){

            @Override
            public boolean test(Sale t) {
                return t.returnAll.get();
            }
        });
        if (saleList.getOriginalList().size() > 0) {
            for (Sale sale : saleList.getOriginalList()) {
                tempParamValue.clear();
                tempParamValue.add(new ParameterValue("saleinvoicenumber", JDBCType.INTEGER, sale.getInvoiceNumber()));
                saleItemList.selectAll("Select * from SaleItem where saleinvoicenumber=?", new ParameterValue[]{new ParameterValue("saleinvoicenumber", JDBCType.INTEGER, sale.getInvoiceNumber())});
                if (saleItemList.getOriginalList().size() <= 0) continue;
                saleItemList.getOriginalList().removeIf((Predicate)new Predicate<SaleItem>(){

                    @Override
                    public boolean test(SaleItem t) {
                        return t.getQuantity() == 0.0f;
                    }
                });
                sale.getSaleItemsList().addAll(saleItemList.getOriginalList());
                for (SaleItem sitem : saleItemList.getOriginalList()) {
                    sitem.loadedUnit = sitem.getParentUnit().clone();
                    sale.totalSaleitemQtybought += sitem.getQuantity();
                }
            }
        }
        return saleList;
    }

    public Expenses generateExpense() {
        Expenses expense = new Expenses(this.getDbAccess());
        expense.setParentCompany(this.getParentCompany());
        expense.setCode(UUID.randomUUID().toString());
        expense.setUserName(this.getStaff().getUserName());
        expense.setDate(Date.valueOf(this.getParentCompany().getCurrentDay()));
        float amtpaid = 0.0f;
        for (SaleItem saleItem : this.saleItemList.getOriginalList()) {
            if (saleItem.loadedUnit.getName().equals(saleItem.getParentUnit().getName())) {
                amtpaid = (float)((double)amtpaid + (double)saleItem.getQtyToreturnQty() * saleItem.getSellingPrice());
                continue;
            }
            amtpaid = (float)((double)amtpaid + (double)saleItem.getQtyToreturnQty() * (saleItem.getSellingPrice() / (double)saleItem.loadedUnit.getQuantity()));
        }
        expense.setAmount(amtpaid);
        expense.setDescription("Expense for Sale return " + this.getInvoiceNumber());
        return expense;
    }

    public void returnSales() {
        this.getDbAccess().start();
        float tempTotalQtyReturning = 0.0f;
        this.replenishmentList = new ReplenishmentList(this.getDbAccess());
        this.saleItemList = new SaleItemList(this.getDbAccess());
        this.stockItemList = new StockItemList(this.getDbAccess());
        for (SaleItem saleItem : this.getSaleItemsList()) {
            if (!(saleItem.getQtyToreturnQty() <= saleItem.getQuantity())) continue;
            saleItem.getParentStockItem().setPrevBalaceBfQty(saleItem.getParentStockItem().getQuantity());
            float retQty = saleItem.getQtyToreturnQty() * saleItem.getParentUnit().getQuantity();
            tempTotalQtyReturning += retQty;
            saleItem.setReturnQty(saleItem.getReturnQty() * saleItem.getParentUnit().getQuantity() + retQty);
            saleItem.getParentStockItem().setQuantity(saleItem.getParentStockItem().getQuantity() + retQty);
            saleItem.setQuantity(saleItem.getQuantity() - retQty);
            this.replenishmentList.getOriginalList().add((Object)saleItem.generateReplenishment("Replenishment for return of item with Barcode " + saleItem.getParentStockItem().getItemCode(), retQty));
            this.saleItemList.getOriginalList().add((Object)saleItem);
            this.stockItemList.getOriginalList().add((Object)saleItem.getParentStockItem());
        }
        if (this.totalSaleitemQtybought - tempTotalQtyReturning == 0.0f) {
            SaleList saleLst = new SaleList(this.getDbAccess());
            this.vClone = this.Clone();
            this.setState(ObjectState.Changed);
            this.returnAll.set(true);
            saleLst.getOriginalList().add((Object)this);
            try {
                saleLst.update();
            }
            catch (Exception ex) {
                Logger.getLogger(Sale.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.saleItemList.getOriginalList().size() > 0) {
            try {
                this.saleItemList.update();
            }
            catch (Exception e) {
                Logger.getLogger(Sale.class.getName()).log(Level.SEVERE, null, e);
            }
            try {
                this.replenishmentList.update();
            }
            catch (Exception ex) {
                Logger.getLogger(Sale.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                this.stockItemList.update();
            }
            catch (Exception ex) {
                Logger.getLogger(Sale.class.getName()).log(Level.SEVERE, null, ex);
            }
            ExpensesDataList expensesDataList = new ExpensesDataList(this.getDbAccess());
            expensesDataList.getOriginalList().add((Object)this.generateExpense());
            try {
                expensesDataList.update();
            }
            catch (Exception ex) {
                Logger.getLogger(Sale.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.getDbAccess().end();
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO Sale (salesRep,transactionDate,\"date\",invoiceNumber,totalAmount,amountPaid,discount,balance,priceFix,modeType,companyName,customerName,sellingStaff,returnAll,accountDetailNo,saleId,isB2B,syncFlag,lastSyncDate,shippingFee,storeCode,syncError,isManual,saleComment,salesChannel,costCenter,locationCode,hdInvoiceNo, creditDescription,creditToken,promoVoucher,promoVoucherAmt,manualSaleStatus, customerPhoneNumber,customerEmail,approvals,salesRejectedBy,returnApprovals,returnedBy,actionComment,d365CustomerNo,saleStatus,paymentTerm,imageUrl,returnRejectedBy,returnComment,paymentTermDescription) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            ParameterValue[] parameterValue = new ParameterValue[]{new ParameterValue("salesRep", JDBCType.VARCHAR, this.salesRep.get()), new ParameterValue("transactionDate", JDBCType.TIMESTAMP, new Timestamp(((Timestamp)this.transactionDate.get()).getTime())), new ParameterValue("\"date\"", JDBCType.TIMESTAMP, this.isMigration ? new Timestamp(((Timestamp)this.dateProperty().get()).getTime()) : Timestamp.valueOf(this.getParentCompany().getCurrentDay().atStartOfDay())), new ParameterValue("invoiceNumber", JDBCType.INTEGER, this.invoiceNumber.get()), new ParameterValue("totalAmount", JDBCType.DOUBLE, this.totalAmount.get()), new ParameterValue("amountPaid", JDBCType.DOUBLE, this.amount == null ? this.totalAmount.get() : this.amount.doubleValue()), new ParameterValue("discount", JDBCType.DOUBLE, this.discount.get()), new ParameterValue("balance", JDBCType.DOUBLE, this.balance.get()), new ParameterValue("priceFix", JDBCType.DOUBLE, this.priceFix.get()), new ParameterValue("modeType", JDBCType.VARCHAR, SalesMode.Bargain.name()), new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName), new ParameterValue("customerName", JDBCType.VARCHAR, this.customerName), new ParameterValue("sellingStaff", JDBCType.VARCHAR, this.sellingStaff), new ParameterValue("returnAll", JDBCType.CHAR, this.returnAll.get()), new ParameterValue("accountDetailNo", JDBCType.VARCHAR, this.accountDetailNo.get()), new ParameterValue("saleId", JDBCType.VARCHAR, this.saleId.get()), new ParameterValue("isB2B", JDBCType.CHAR, this.isB2B.get()), new ParameterValue("syncFlag", JDBCType.CHAR, this.syncFlag.get()), new ParameterValue("lastSyncDate", JDBCType.TIMESTAMP, new Timestamp(this.lastSyncDate.getTime())), new ParameterValue("shippingFee", JDBCType.DOUBLE, this.shippingFee.get()), new ParameterValue("storeCode", JDBCType.VARCHAR, this.storeCode.get()), new ParameterValue("syncError", JDBCType.VARCHAR, this.syncError.get()), new ParameterValue("isManual", JDBCType.CHAR, this.isManual.get()), new ParameterValue("saleComment", JDBCType.VARCHAR, this.saleComment.get()), new ParameterValue("salesChannel", JDBCType.VARCHAR, this.salesChannel.get()), new ParameterValue("costCenter", JDBCType.VARCHAR, this.costCenter.get()), new ParameterValue("locationCode", JDBCType.VARCHAR, this.locationCode.get()), new ParameterValue("hdInvoiceNo", JDBCType.VARCHAR, ((String)this.hdInvoiceNo.get()).isEmpty() ? String.valueOf(this.invoiceNumber.get()) : this.hdInvoiceNo.get()), new ParameterValue("creditDescription", JDBCType.VARCHAR, this.creditDescription.get()), new ParameterValue("creditToken", JDBCType.VARCHAR, this.creditToken.get()), new ParameterValue("promoVoucher", JDBCType.VARCHAR, this.promoVoucher.get()), new ParameterValue("promoVoucherAmt", JDBCType.DOUBLE, this.promoVoucherAmt.get()), new ParameterValue("manualSaleStatus", JDBCType.VARCHAR, this.manualSaleStatus.get()), new ParameterValue("customerPhoneNumber", JDBCType.VARCHAR, this.customerPhoneNumber.get()), new ParameterValue("customerEmail", JDBCType.VARCHAR, this.customerEmail.get()), new ParameterValue("approvals", JDBCType.VARCHAR, this.approvals.get()), new ParameterValue("salesRejectedBy", JDBCType.VARCHAR, this.salesRejectedBy.get()), new ParameterValue("returnApprovals", JDBCType.VARCHAR, this.returnApprovals.get()), new ParameterValue("returnedBy", JDBCType.VARCHAR, this.returnedBy.get()), new ParameterValue("actionComment", JDBCType.VARCHAR, this.actionComment.get()), new ParameterValue("d365CustomerNo", JDBCType.VARCHAR, this.d365CustomerNo.get()), new ParameterValue("saleStatus", JDBCType.VARCHAR, this.saleStatus.get()), new ParameterValue("paymentTerm", JDBCType.VARCHAR, this.paymentTerm.get()), new ParameterValue("imageUrl", JDBCType.VARCHAR, this.imageUrl.get()), new ParameterValue("returnRejectedBy", JDBCType.VARCHAR, this.returnRejectedBy.get()), new ParameterValue("returnComment", JDBCType.VARCHAR, this.returnComment.get()), new ParameterValue("paymentTermDescription", JDBCType.VARCHAR, this.paymentTermDescription.get())};
            this.getDbAccess().performDbOperation(query, parameterValue);
            this.vClone = this.testClone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isCloned = false;
            throw ex;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE Sale set salesRep=?, transactionDate=?, \"date\"=?,invoiceNumber=?,totalAmount=?,amountPaid=?,discount=?,balance=?,priceFix=?,modeType=?,companyName=?,customerName=?,sellingStaff=?,returnAll=?,accountDetailNo=?,saleId=?,isB2B=?,syncFlag=?,lastSyncDate=?,shippingFee=?,storeCode=?,syncError=?,isManual=?, saleComment=?, salesChannel=?,costCenter=?,locationCode=?,hdInvoiceNo=?,  creditDescription=?,creditToken=?,promoVoucher=?,promoVoucherAmt=? , manualSaleStatus=?,customerPhoneNumber=?,customerEmail=?,approvals=?,  salesRejectedBy=?, returnApprovals=?, returnedBy=?, actionComment=?, d365CustomerNo=?, saleStatus=?, paymentTerm=?, imageUrl=?, returnRejectedBy=?,returnComment=?, paymentTermDescription=?  where invoiceNumber=?";
            this.getDbAccess().performDbOperation(query, new ParameterValue[]{new ParameterValue("salesRep", JDBCType.VARCHAR, this.salesRep.get()), new ParameterValue("transactionDate", JDBCType.TIMESTAMP, new Timestamp(((Timestamp)this.transactionDate.get()).getTime())), new ParameterValue("\"date\"", JDBCType.TIMESTAMP, new Timestamp(((Timestamp)this.newDate.get()).getTime())), new ParameterValue("invoiceNumber", JDBCType.INTEGER, this.invoiceNumber.get()), new ParameterValue("totalAmount", JDBCType.DOUBLE, this.totalAmount.get()), new ParameterValue("amountPaid", JDBCType.DOUBLE, this.amount == null ? this.totalAmount.get() : this.amount.doubleValue()), new ParameterValue("discount", JDBCType.DOUBLE, this.discount.get()), new ParameterValue("balance", JDBCType.DOUBLE, this.balance.get()), new ParameterValue("priceFix", JDBCType.DOUBLE, this.priceFix.get()), new ParameterValue("modeType", JDBCType.VARCHAR, SalesMode.Bargain.name()), new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName), new ParameterValue("customerName", JDBCType.VARCHAR, this.customerName), new ParameterValue("sellingStaff", JDBCType.VARCHAR, this.sellingStaff), new ParameterValue("returnAll", JDBCType.CHAR, this.returnAll.get()), new ParameterValue("accountDetailNo", JDBCType.VARCHAR, this.accountDetailNo.get()), new ParameterValue("sapDockNum", JDBCType.VARCHAR, this.saleId.get()), new ParameterValue("isB2B", JDBCType.CHAR, this.isB2B.get()), new ParameterValue("syncFlag", JDBCType.CHAR, this.syncFlag.get()), new ParameterValue("lastSyncDate", JDBCType.TIMESTAMP, new Timestamp(this.lastSyncDate.getTime())), new ParameterValue("shippingFee", JDBCType.DOUBLE, this.shippingFee.get()), new ParameterValue("storeCode", JDBCType.VARCHAR, this.storeCode.get()), new ParameterValue("syncError", JDBCType.VARCHAR, this.syncError.get()), new ParameterValue("isManual", JDBCType.CHAR, this.isManual.get()), new ParameterValue("saleComment", JDBCType.VARCHAR, this.saleComment.get()), new ParameterValue("salesChannel", JDBCType.VARCHAR, this.salesChannel.get()), new ParameterValue("costCenter", JDBCType.VARCHAR, this.costCenter.get()), new ParameterValue("locationCode", JDBCType.VARCHAR, this.locationCode.get()), new ParameterValue("hdInvoiceNo", JDBCType.VARCHAR, this.hdInvoiceNo.get()), new ParameterValue("creditDescription", JDBCType.VARCHAR, this.creditDescription.get()), new ParameterValue("creditToken", JDBCType.VARCHAR, this.creditToken.get()), new ParameterValue("promoVoucher", JDBCType.VARCHAR, this.promoVoucher.get()), new ParameterValue("promoVoucherAmt", JDBCType.DOUBLE, this.promoVoucherAmt.get()), new ParameterValue("manualSaleStatus", JDBCType.VARCHAR, this.manualSaleStatus.get()), new ParameterValue("customerPhoneNumber", JDBCType.VARCHAR, this.customerPhoneNumber.get()), new ParameterValue("customerEmail", JDBCType.VARCHAR, this.customerEmail.get()), new ParameterValue("approvals", JDBCType.VARCHAR, this.approvals.get()), new ParameterValue("salesRejectedBy", JDBCType.VARCHAR, this.salesRejectedBy.get()), new ParameterValue("returnApprovals", JDBCType.VARCHAR, this.returnApprovals.get()), new ParameterValue("returnedBy", JDBCType.VARCHAR, this.returnedBy.get()), new ParameterValue("actionComment", JDBCType.VARCHAR, this.actionComment.get()), new ParameterValue("d365CustomerNo", JDBCType.VARCHAR, this.d365CustomerNo.get()), new ParameterValue("saleStatus", JDBCType.VARCHAR, this.saleStatus.get()), new ParameterValue("paymentTerm", JDBCType.VARCHAR, this.paymentTerm.get()), new ParameterValue("imageUrl", JDBCType.VARCHAR, this.imageUrl.get()), new ParameterValue("returnRejectedBy", JDBCType.VARCHAR, this.returnRejectedBy.get()), new ParameterValue("returnComment", JDBCType.VARCHAR, this.returnComment.get()), new ParameterValue("paymentTermDescription", JDBCType.VARCHAR, this.paymentTermDescription.get()), new ParameterValue("cloneInvoiceNumber", JDBCType.INTEGER, this.vClone.invoiceNumber.get())}, true);
            this.vClone = this.testClone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isCloned = false;
            if (ex instanceof BaseConcurrencyException) {
                throw new BaseConcurrencyException("This object has been modified by another user, please reload your data", null);
            }
            throw ex;
        }
    }

    @Override
    public void delete() throws Exception {
        String query = "Delete FROM Sale where invoiceNumber=?";
        this.getDbAccess().performDbOperation(query, new ParameterValue[]{new ParameterValue("invoiceNumber", JDBCType.INTEGER, this.invoiceNumber.get())});
    }

    @Override
    public void beforeInsert() {
        block5: {
            try {
                if (this.getSaleComment().length() > 1000) {
                    this.setSaleComment(this.getSaleComment().substring(0, 999));
                }
                if (this.invoiceNumber.get() != 0) break block5;
                this.getParentCompany().setLastInvoiceNumber(this.getParentCompany().getLastInvoiceNumber() + 1);
                this.getParentCompany().update();
                this.invoiceNumber.set(this.getParentCompany().getLastInvoiceNumber());
            }
            catch (Exception ex) {
                Logger.getLogger(Sale.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
    }

    @Override
    public Searchable getSearchable() {
        Searchable sb = new Searchable();
        sb.setTableName("Sale");
        String[] parameter = new String[]{"date", "invoiceNumber", "totalAmount", "amountPaid", "discount", "balance", "priceFix", "saleMode", "companyName", "customerName", "sellingStaff"};
        parameter[11] = "salesRep";
        sb.setParameters(parameter);
        return sb;
    }

    public double getDiscountValue() {
        ArrayList<SaleItem> discountList = new ArrayList<SaleItem>();
        double amount = 0.0;
        double discountVal = 0.0;
        for (SaleItem proSaleItem : this.getSaleItemsList()) {
            if (!(proSaleItem.getQuantity() > 0.0f)) continue;
            discountList.add(proSaleItem);
            amount += (double)(proSaleItem.getQuantity() * Float.valueOf(this.df.format(Unit.convertUnitFromOneToAnother(proSaleItem.getParentStockItem(), proSaleItem.getParentUnit()))).floatValue());
        }
        double disc = amount * (double)((float)this.getDiscount() / 100.0f);
        if (disc > 0.0) {
            discountVal = disc / (double)discountList.size();
        }
        return discountVal;
    }

    public void setproRateValue(double proRateValue) {
        this.proRateValue = proRateValue;
    }

    public double proRateValueProperty() {
        return this.proRateValue;
    }

    public void performDiscount() {
        double amt = 0.0;
        double disc = this.getTotalAmount() * (this.discount.get() / 100.0);
        for (SaleItem sa : this.getSaleItemsList()) {
            if (!(sa.getQuantity() > 0.0f) || sa.getParentUnit() == null) continue;
            float k = (float)this.getDiscountValue() / sa.getQuantity();
            sa.sellingPriceProperty().set((double)Float.valueOf(this.df.format(Unit.convertUnitFromOneToAnother(sa.getParentStockItem(), sa.getParentUnit()))).floatValue());
            sa.sellingPriceProperty().set((double)Float.valueOf(this.df.format(sa.sellingPriceProperty().get() - (double)Float.valueOf(this.df.format(k)).floatValue())).floatValue());
            amt += sa.getSellingPrice() * (double)sa.getQuantity();
        }
        this.totalAmount.set(amt);
        this.amountPaid.set(amt);
    }

    private double Prorate() {
        ArrayList<SaleItem> prorateList = new ArrayList<SaleItem>();
        double prorateDiff = this.getTotalAmount() - this.getAmountPaid();
        double prorateValue = 0.0;
        for (SaleItem proSaleItem : this.getSaleItemsList()) {
            if (!proSaleItem.getIsProrate()) continue;
            prorateList.add(proSaleItem);
        }
        if (prorateList.size() > 0) {
            prorateValue = prorateDiff / (double)prorateList.size();
        }
        return prorateValue;
    }

    public void setIsCloned(boolean isCloned) {
        this.isCloned = isCloned;
    }

    @Override
    public void initializeListener() {
        this.amountPaid.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Sale.this.setAmountPaid((Double)newValue);
            }
        });
        this.totalAmount.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Sale.this.setTotalAmount((Double)newValue);
            }
        });
        this.balance.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Sale.this.setBalance((Double)newValue);
            }
        });
        this.Change.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Sale.this.setChange((Double)newValue);
            }
        });
        this.discount.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Sale.this.setDiscount((Double)newValue);
            }
        });
        this.invoiceNumber.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Sale.this.setInvoiceNumber((Integer)newValue);
            }
        });
        this.priceFix.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Sale.this.setPriceFix((Double)newValue);
            }
        });
        this.salesMode.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Sale.this.setSalesMode(SalesMode.valueOf(newValue));
            }
        });
        this.salesRep.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Sale.this.setSalesRep(newValue);
            }
        });
        this.saleComment.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Sale.this.setSaleComment(newValue);
            }
        });
        this.approvingComment.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Sale.this.setApprovingComment(newValue);
            }
        });
        this.promoVoucherAmt.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Sale.this.setPromoVoucherAmt((Double)newValue);
            }
        });
        this.isFullyPaid.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                Sale.this.tracker.set(Sale.this.tracker.get() + 1);
            }
        });
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Sale) {
            Sale s = (Sale)object;
            return this.getInvoiceNumber() == s.getInvoiceNumber();
        }
        return false;
    }

    public String getTooltipData() {
        return "Name:" + this.getParentCustomer().getName() + "\nEmail:" + this.getParentCustomer().getEmail() + "\nDate of Purchase:" + ((Timestamp)this.dateProperty().get()).toString() + "\nAmount Paid:\u20a6" + String.valueOf(this.amountPaid.get()) + "\nTotal number of item(s):" + String.valueOf(this.getSaleItemsList().size());
    }

    public static ArrayList<SearchClass> selectAutoCompleteSaleRep(String searchString, DataAccess dt) throws SQLException {
        ParameterValue[] parameterValue;
        ArrayList<SearchClass> result = new ArrayList<SearchClass>();
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("salesRep", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        Object query = "Select Distinct * From Sale Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        ResultSet rs = dt.select((String)(query = (String)query + "order by salesRep ASC"), parameterValue = searchCondition.ConvertoparameterValuesArray());
        if (rs != null) {
            try {
                while (rs.next()) {
                    result.add(new SearchClass(rs.getString("salesRep"), rs.getString("salesRep")));
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }
}

