/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.RequestItemBin;
import com.xputertechnologies.santa.RequestitemSerial;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.RequestitemSerialDataList;
import java.sql.JDBCType;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class RequestItem
extends DbEntity {
    public RequestItem vClone;
    private boolean isCloned;
    public boolean hasAccepted = false;
    private IntegerProperty tempQty = new SimpleIntegerProperty(0);
    DataAccess dt = this.getDbAccess();
    private StringProperty sn = new SimpleStringProperty();
    private StringProperty requestCode = new SimpleStringProperty("");
    private StringProperty lineNumber = new SimpleStringProperty("");
    private IntegerProperty quantity = new SimpleIntegerProperty(this, "quantity", 0){

        public void set(int value) {
            super.set(value);
        }
    };
    private IntegerProperty availableQty = new SimpleIntegerProperty(-1);
    private IntegerProperty editableAccptQty = new SimpleIntegerProperty(0);
    private IntegerProperty editableReleaseQty = new SimpleIntegerProperty(0);
    private IntegerProperty releasedQuantity = new SimpleIntegerProperty(this, "releasedQuantity", 0){

        public void set(int value) {
            super.set(value);
        }
    };
    private StringProperty reason = new SimpleStringProperty("");
    private StringProperty storeName = new SimpleStringProperty("");
    private StringProperty itemCode = new SimpleStringProperty("");
    private FloatProperty netWeight = new SimpleFloatProperty(0.0f);
    private StringProperty itemName = new SimpleStringProperty("");
    private StringProperty originatedStore = new SimpleStringProperty("");
    private IntegerProperty toStoreInitQty = new SimpleIntegerProperty(0);
    private IntegerProperty acceptedQty = new SimpleIntegerProperty(0);
    private IntegerProperty returnedQty = new SimpleIntegerProperty(0);
    private IntegerProperty approvedQty = new SimpleIntegerProperty(0);
    private StringProperty code = new SimpleStringProperty(UUID.randomUUID().toString());
    ObservableList<RequestitemSerial> serials = FXCollections.observableArrayList();
    ObservableList<RequestItemBin> requestItemBins = FXCollections.observableArrayList();
    public IntegerProperty trackerQty = new SimpleIntegerProperty();
    public StringBinding totalQtyBinding = new StringBinding(){
        Integer qty;

        protected String computeValue() {
            this.qty = 0;
            if (RequestItem.this.requestItemBins.isEmpty()) {
                return "0";
            }
            if (RequestItem.this.requestItemBins.size() > 0) {
                RequestItem.this.requestItemBins.forEach(s -> {
                    this.qty = this.qty + s.getQuantity();
                });
            }
            RequestItem.this.setReleasedQuantity(this.qty);
            return String.valueOf(this.qty);
        }
    };

    public boolean getHasAccepted() {
        return this.hasAccepted;
    }

    public void setHasAccepted(boolean hasAccepted) {
        this.hasAccepted = hasAccepted;
    }

    public Integer getTempQty() {
        return this.tempQty.get();
    }

    public IntegerProperty tempQtyProperty() {
        return this.tempQty;
    }

    public void setTempQty(Integer tempQty) {
        this.tempQty.set(tempQty.intValue());
    }

    public RequestItem(DataAccess dt) {
        super(dt);
    }

    public String getSerialString() {
        Object rslt = this.serials.size() > 0 ? "(" : "";
        for (RequestitemSerial requestserial : this.serials) {
            rslt = (String)rslt + requestserial.getSerial() + ", ";
        }
        return ((String)rslt).length() > 0 ? ((String)rslt).substring(0, ((String)rslt).length() - 2) + ")" : rslt;
    }

    public StringProperty snProperty() {
        return this.sn;
    }

    public String getSn() {
        return (String)this.sn.get();
    }

    public void setSn(String sn) {
        this.sn.set((Object)sn);
    }

    public StringProperty requestCodeProperty() {
        return this.requestCode;
    }

    public String getRequestCode() {
        return (String)this.requestCode.get();
    }

    public void setRequestCode(String requestCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.requestCode.set((Object)requestCode);
    }

    public StringProperty lineNumberProperty() {
        return this.lineNumber;
    }

    public String getLineNumber() {
        return (String)this.lineNumber.get();
    }

    public void setLineNumber(String requestCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.lineNumber.set((Object)requestCode);
    }

    public int getQuantity() {
        return this.quantity.get();
    }

    public void setQuantity(int quantity) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.quantity.set(quantity);
        this.changeObjectState();
    }

    public IntegerProperty availableQtyProperty() {
        return this.availableQty;
    }

    public IntegerProperty editableAccptQtyProperty() {
        return this.editableAccptQty;
    }

    public IntegerProperty editableReleaseQtyProperty() {
        return this.editableReleaseQty;
    }

    public int getReleasedQuantity() {
        return this.releasedQuantity.get();
    }

    public void setReleasedQuantity(int releasedQuantity) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.releasedQuantity.set(releasedQuantity);
        this.changeObjectState();
    }

    public IntegerProperty releasedQuantityProperty() {
        return this.releasedQuantity;
    }

    public IntegerProperty quantityProperty() {
        return this.quantity;
    }

    public StringProperty reasonProperty() {
        return this.reason;
    }

    public String getReason() {
        return (String)this.reason.get();
    }

    public void setReason(String reason) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.reason.set((Object)reason);
    }

    public StringProperty storeNameProperty() {
        return this.storeName;
    }

    public String getStoreName() {
        return (String)this.storeName.get();
    }

    public void setStoreName(String storeName) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.storeName.set((Object)storeName);
    }

    public StringProperty itemCodeProperty() {
        return this.itemCode;
    }

    public String getItemCode() {
        return (String)this.itemCode.get();
    }

    public void setItemCode(String barCode) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.itemCode.set((Object)barCode);
    }

    public float getNetWeight() {
        return this.netWeight.get();
    }

    public void setNetWeight(float netWeight) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.netWeight.set(netWeight);
        this.changeObjectState();
    }

    public FloatProperty netWeightProperty() {
        return this.netWeight;
    }

    public String getItemName() {
        return (String)this.itemName.get();
    }

    public StringProperty itemNameProperty() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.itemName.set((Object)itemName);
        this.changeObjectState();
    }

    public String getOriginatedStore() {
        return (String)this.originatedStore.get();
    }

    public StringProperty originatedStoreProperty() {
        return this.originatedStore;
    }

    public void setOriginatedStore(String originatedStore) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.originatedStore.set((Object)originatedStore);
        this.changeObjectState();
    }

    public Integer getToStoreInitQty() {
        return this.toStoreInitQty.get();
    }

    public IntegerProperty ToStoreInitQtyProperty() {
        return this.toStoreInitQty;
    }

    public void setToStoreInitQty(Integer destinationStoreQty) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.toStoreInitQty.set(destinationStoreQty.intValue());
        this.changeObjectState();
    }

    public Integer getAcceptedQty() {
        return this.acceptedQty.get();
    }

    public IntegerProperty acceptedQtyProperty() {
        return this.acceptedQty;
    }

    public void setAcceptedQty(Integer acceptedQty) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.acceptedQty.set(acceptedQty.intValue());
        this.changeObjectState();
    }

    public Integer getReturnedQty() {
        return this.returnedQty.get();
    }

    public IntegerProperty releaseQtyProperty() {
        return this.returnedQty;
    }

    public void setReturnedQty(Integer returnedQty) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.returnedQty.set(returnedQty.intValue());
        this.changeObjectState();
    }

    public Integer getApprovedQty() {
        return this.approvedQty.get();
    }

    public IntegerProperty approvedQtyProperty() {
        return this.approvedQty;
    }

    public void setApprovedQty(Integer approvedQty) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.approvedQty.set(approvedQty.intValue());
        this.changeObjectState();
    }

    public StringProperty codeProperty() {
        return this.code;
    }

    public String getCode() {
        return (String)this.code.get();
    }

    public void setCode(String code) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.code.set((Object)code);
    }

    public ObservableList<RequestitemSerial> getSerials() {
        return this.serials;
    }

    public ObservableList<RequestItemBin> getRequestItemBins() {
        return this.requestItemBins;
    }

    public void loadSerials() {
        RequestitemSerialDataList requestItemDataList = new RequestitemSerialDataList(this.getDbAccess());
        requestItemDataList.selectAll("Select * From RequestitemSerial  where REQUESTITEMCODE=?", new ParameterValue[]{new ParameterValue("requestCode", JDBCType.VARCHAR, this.code.get())});
        this.serials.addAll(requestItemDataList.getOriginalList());
    }

    public RequestItem clone() {
        RequestItem requestItem = new RequestItem(this.dt);
        requestItem.setMustClone(false);
        requestItem.requestCode.set((Object)((String)this.requestCode.get()));
        requestItem.netWeight.set(this.netWeight.get());
        requestItem.quantity.set(this.quantity.get());
        requestItem.releasedQuantity.set(this.releasedQuantity.get());
        requestItem.lineNumber.set((Object)((String)this.lineNumber.get()));
        requestItem.reason.set((Object)((String)this.reason.get()));
        requestItem.itemCode.set((Object)((String)this.itemCode.get()));
        requestItem.itemName.set((Object)((String)this.itemName.get()));
        requestItem.originatedStore.set((Object)((String)this.originatedStore.get()));
        requestItem.returnedQty.set(this.returnedQty.get());
        requestItem.toStoreInitQty.set(this.toStoreInitQty.get());
        requestItem.acceptedQty.set(this.acceptedQty.get());
        requestItem.approvedQty.set(this.approvedQty.get());
        requestItem.code.set((Object)((String)this.code.get()));
        this.setMustClone(true);
        this.isCloned = true;
        return requestItem;
    }

    protected void rollBack() {
        this.requestCode.set((Object)((String)this.vClone.requestCode.get()));
        this.quantity.set(this.vClone.quantity.get());
        this.netWeight.set(this.vClone.netWeight.get());
        this.releasedQuantity.set(this.vClone.releasedQuantity.get());
        this.lineNumber.set((Object)((String)this.vClone.lineNumber.get()));
        this.reason.set((Object)((String)this.vClone.reason.get()));
        this.itemCode.set((Object)((String)this.vClone.itemCode.get()));
        this.itemName.set((Object)((String)this.vClone.itemName.get()));
        this.originatedStore.set((Object)((String)this.vClone.originatedStore.get()));
        this.returnedQty.set(this.vClone.returnedQty.get());
        this.toStoreInitQty.set(this.vClone.toStoreInitQty.get());
        this.acceptedQty.set(this.vClone.acceptedQty.get());
        this.approvedQty.set(this.vClone.approvedQty.get());
        this.code.set((Object)((String)this.vClone.code.get()));
        this.setMustClone(true);
    }

    public RequestItem(String requestCode, Integer quantity, Integer releasedQuantity, String reason, String barCode, String itemName, Integer fromStoreInitQty, Integer acceptedQty, Integer approvedQty, String code, String lineNumber, Float netWeight, DataAccess dbAccess) {
        super(dbAccess);
        this.itemName.set((Object)itemName);
        this.netWeight.set(netWeight.floatValue());
        this.toStoreInitQty.set(fromStoreInitQty.intValue());
        this.acceptedQty.set(acceptedQty.intValue());
        this.releasedQuantity.set(releasedQuantity.intValue());
        this.approvedQty.set(approvedQty.intValue());
        this.code.set((Object)code);
        this.requestCodeProperty().set((Object)requestCode);
        this.quantityProperty().set(quantity.intValue());
        this.lineNumberProperty().set((Object)lineNumber);
        this.reasonProperty().set((Object)reason);
        this.itemCodeProperty().set((Object)barCode);
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO RequestItem(requestCode,quantity,releasedQuantity,reason,itemCode,itemName,toStoreInitQty,acceptedQty,approvedQty,code,returnedQty,lineNumber,netWeight) Values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("requestCode", JDBCType.VARCHAR, this.requestCode.get()), new ParameterValue("quantity", JDBCType.INTEGER, this.quantity.get()), new ParameterValue("releasedQuantity", JDBCType.INTEGER, this.releasedQuantity.get()), new ParameterValue("reason", JDBCType.VARCHAR, this.reason.get()), new ParameterValue("itemCode", JDBCType.VARCHAR, this.itemCode.get()), new ParameterValue("itemName", JDBCType.VARCHAR, this.itemName.get()), new ParameterValue("toStoreInitQty", JDBCType.INTEGER, this.toStoreInitQty.get()), new ParameterValue("acceptedQty", JDBCType.INTEGER, this.acceptedQty.get()), new ParameterValue("approvedQty", JDBCType.INTEGER, this.approvedQty.get()), new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("returnedQty", JDBCType.INTEGER, this.returnedQty.get()), new ParameterValue("lineNumber", JDBCType.VARCHAR, this.lineNumber.get()), new ParameterValue("lineNumber", JDBCType.FLOAT, Float.valueOf(this.netWeight.get()))};
            this.getDbAccess().performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            throw e;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE RequestItem SET requestCode=?, quantity=?,releasedQuantity=?,reason=?,itemCode=?,itemName=?,toStoreInitQty=?,acceptedQty=?,approvedQty=?,code=?,returnedQty=?,lineNumber=?,netWeight=? WHERE requestCode=? and itemCode=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("requestCode", JDBCType.VARCHAR, this.requestCode.get()), new ParameterValue("quantity", JDBCType.INTEGER, this.quantity.get()), new ParameterValue("releasedQuantity", JDBCType.INTEGER, this.releasedQuantity.get()), new ParameterValue("reason", JDBCType.VARCHAR, this.reason.get()), new ParameterValue("itemCode", JDBCType.VARCHAR, this.itemCode.get()), new ParameterValue("itemName", JDBCType.VARCHAR, this.itemName.get()), new ParameterValue("toStoreInitQty", JDBCType.INTEGER, this.toStoreInitQty.get()), new ParameterValue("acceptedQty", JDBCType.INTEGER, this.acceptedQty.get()), new ParameterValue("approvedQty", JDBCType.INTEGER, this.approvedQty.get()), new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("returnedQty", JDBCType.INTEGER, this.returnedQty.get()), new ParameterValue("lineNumber", JDBCType.VARCHAR, this.lineNumber.get()), new ParameterValue("netWeight", JDBCType.FLOAT, Float.valueOf(this.netWeight.get())), new ParameterValue("requestCode", JDBCType.VARCHAR, this.vClone.requestCode.get()), new ParameterValue("itemCode", JDBCType.VARCHAR, this.vClone.itemCode.get())};
            this.getDbAccess().performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() throws Exception {
        String query = "DELETE FROM RequestItem WHERE requestCode=? and itemCode=?";
        ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("requestCode", JDBCType.VARCHAR, this.vClone.requestCode.get()), new ParameterValue("itemCode", JDBCType.VARCHAR, this.vClone.itemCode.get())};
        try {
            this.getDbAccess().performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
    }

    @Override
    public Searchable getSearchable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void initializeListener() {
    }
}

