/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.ReportSync;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Security;
import com.xputertechnologies.santa.list.ReportSyncDataList;
import com.xputertechnologies.santa.list.ReportUserDataList;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.Santa;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.JDBCType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;

public class ReportMail {
    final String host = "smtp.office365.com";
    final String port = "587";
    final String userName = "orders@yudala.com";
    String passwordEncoded = "UmhlbWExMDAw";
    Date currentDate = new Date(new java.util.Date().getTime());
    Santa app;
    boolean isAutomatic = true;
    boolean createNew;

    public ReportMail(Santa app) {
        this.app = app;
    }

    public ReportMail(Santa app, boolean createNew) {
        this.app = app;
        this.createNew = createNew;
    }

    public void sendAllOutstandingReport() {
        try {
            ReportSyncDataList reportSyncDataList = new ReportSyncDataList(this.app.da);
            reportSyncDataList.selectAll("Select * From  ReportSync where isSent=?", new ParameterValue[]{new ParameterValue("", JDBCType.CHAR, Boolean.FALSE)}, this.app.da);
            if ((reportSyncDataList.getOriginalList().size() == 0 || reportSyncDataList.getOriginalList().stream().filter(p -> new SimpleDateFormat("yyyy/MM/dd").format(p.getCurrentDay()).equals(new SimpleDateFormat("yyyy/MM/dd").format(new Date(new java.util.Date().getTime())))).findAny().orElse(null) == null) && this.createNew) {
                ReportSync reportSync = new ReportSync(this.app.da);
                reportSync.setCurrentDay(new Date(new java.util.Date().getTime()));
                reportSync.setIsSent(false);
                reportSyncDataList.getOriginalList().add((Object)reportSync);
                reportSyncDataList.update();
            }
            for (ReportSync reportSync : reportSyncDataList.getOriginalList()) {
                this.currentDate = reportSync.getCurrentDay();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(ReportMail.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean sendMailReport(JasperPrint rJasperPrint, List<String> recipients, String subject) {
        try {
            File fileFormat = File.createTempFile("Report.", ".pdf");
            String message = "";
            final String password = Security.decodeString(this.passwordEncoded);
            Properties properties = new Properties();
            properties.put("mail.smtp.host", "smtp.office365.com");
            properties.put("mail.smtp.port", "587");
            properties.put("mail.smtp.auth", "true");
            properties.put("mail.smtp.starttls.enable", "true");
            properties.put("mail.user", "orders@yudala.com");
            properties.put("mail.password", password);
            Authenticator auth = new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication("orders@yudala.com", password);
                }
            };
            Session session = Session.getInstance((Properties)properties, (Authenticator)auth);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress("orders@yudala.com"));
            InternetAddress[] toAddresses = new InternetAddress[recipients.size()];
            recipients.forEach(rpt -> {
                try {
                    toAddresses[recipients.indexOf((Object)rpt)] = new InternetAddress(rpt);
                }
                catch (AddressException ex) {
                    Logger.getLogger(ReportMail.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            msg.setSubject(subject);
            msg.setSentDate(new java.util.Date());
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)message, "text/html");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            JasperExportManager.exportReportToPdfStream((JasperPrint)rJasperPrint, (OutputStream)new FileOutputStream(fileFormat));
            MimeBodyPart attachPart = new MimeBodyPart();
            try {
                attachPart.attachFile(fileFormat);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            multipart.addBodyPart((BodyPart)attachPart);
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
            fileFormat.delete();
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(ReportMail.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public boolean sendMailReport(File file, List<String> recipients, String subject) {
        try {
            String message = "";
            final String password = Security.decodeString(this.passwordEncoded);
            Properties properties = new Properties();
            properties.put("mail.smtp.host", "smtp.office365.com");
            properties.put("mail.smtp.port", "587");
            properties.put("mail.smtp.auth", "true");
            properties.put("mail.smtp.starttls.enable", "true");
            properties.put("mail.user", "orders@yudala.com");
            properties.put("mail.password", password);
            Authenticator auth = new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication("orders@yudala.com", password);
                }
            };
            Session session = Session.getInstance((Properties)properties, (Authenticator)auth);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress("orders@yudala.com"));
            InternetAddress[] toAddresses = new InternetAddress[recipients.size()];
            recipients.forEach(rpt -> {
                try {
                    toAddresses[recipients.indexOf((Object)rpt)] = new InternetAddress(rpt);
                }
                catch (AddressException ex) {
                    Logger.getLogger(ReportMail.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            msg.setSubject(subject);
            msg.setSentDate(new java.util.Date());
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)message, "text/html");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            MimeBodyPart attachPart = new MimeBodyPart();
            try {
                attachPart.attachFile(file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            multipart.addBodyPart((BodyPart)attachPart);
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
            file.delete();
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(ReportMail.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    private boolean sendReportMail(String subject) {
        try {
            ReportUserDataList reportUserDataList = new ReportUserDataList(this.app.da);
            reportUserDataList.selectAll("Select * From ReportUser", this.app.da.getEmptyParameterValues());
            File pdf = File.createTempFile(this.app.currentUser.getParentCompany().getStoreName() + " " + new SimpleDateFormat("d-MMM-yyyy").format(this.currentDate), ".pdf");
            String message = "";
            final String password = Security.decodeString(this.passwordEncoded);
            Properties properties = new Properties();
            properties.put("mail.smtp.host", "smtp.office365.com");
            properties.put("mail.smtp.port", "587");
            properties.put("mail.smtp.auth", "true");
            properties.put("mail.smtp.starttls.enable", "true");
            properties.put("mail.user", "orders@yudala.com");
            properties.put("mail.password", password);
            Authenticator auth = new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication("orders@yudala.com", password);
                }
            };
            Session session = Session.getInstance((Properties)properties, (Authenticator)auth);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress("orders@yudala.com"));
            InternetAddress[] toAddresses = new InternetAddress[reportUserDataList.getOriginalList().size()];
            reportUserDataList.getOriginalList().forEach(rpt -> {
                try {
                    toAddresses[reportUserDataList.getOriginalList().indexOf((Object)rpt)] = new InternetAddress(rpt.getEmail());
                }
                catch (AddressException ex) {
                    Logger.getLogger(ReportMail.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            msg.setSubject(subject);
            msg.setSentDate(new java.util.Date());
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)message, "text/html");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            JasperExportManager.exportReportToPdfStream((JasperPrint)this.generateReport(), (OutputStream)new FileOutputStream(pdf));
            MimeBodyPart attachPart = new MimeBodyPart();
            try {
                attachPart.attachFile(pdf);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            multipart.addBodyPart((BodyPart)attachPart);
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
            pdf.delete();
            return true;
        }
        catch (MessagingException ex) {
            Logger.getLogger(ReportMail.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(ReportMail.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ReportMail.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (JRException ex) {
            Logger.getLogger(ReportMail.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public boolean sendReportMail(String subject, String Content, String Recipients) {
        try {
            String message = Content;
            final String password = Security.decodeString(this.passwordEncoded);
            Properties properties = new Properties();
            properties.put("mail.smtp.host", "smtp.office365.com");
            properties.put("mail.smtp.port", "587");
            properties.put("mail.smtp.auth", "true");
            properties.put("mail.smtp.starttls.enable", "true");
            properties.put("mail.user", "orders@yudala.com");
            properties.put("mail.password", password);
            Authenticator auth = new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication("orders@yudala.com", password);
                }
            };
            Session session = Session.getInstance((Properties)properties, (Authenticator)auth);
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress("orders@yudala.com"));
            String[] values = Recipients.split(",");
            ArrayList<String> addresses = new ArrayList<String>();
            for (int i = 0; i < values.length; ++i) {
                addresses.add(values[i]);
            }
            InternetAddress[] toAddresses = new InternetAddress[addresses.size()];
            addresses.forEach(x -> {
                try {
                    toAddresses[addresses.indexOf((Object)x)] = new InternetAddress(x);
                }
                catch (Exception ex) {
                    Logger.getLogger(ReportMail.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            msg.setSubject(subject);
            msg.setSentDate(new java.util.Date());
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)message, "text/html");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(ReportMail.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public JasperPrint generateReport() {
        General general = new General();
        return null;
    }
}

