/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.Purchase;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.PurchaseList;
import com.xputertechnologies.santa.list.StockItemList;
import java.sql.Date;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class Replenishment
extends DbEntity {
    public Replenishment vClone;
    private boolean isCloned;
    DataAccess dt = this.getDbAccess();
    private StockItem parentStockItem;
    private Purchase parentPurchase;
    private ObjectProperty<Date> newDate = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));
    private FloatProperty balanceBf = new SimpleFloatProperty();
    private StringProperty comment = new SimpleStringProperty();
    private FloatProperty quantity = new SimpleFloatProperty();
    private String stockItemBarcode;
    private String purchaseCode;
    private IntegerProperty transactionCount = new SimpleIntegerProperty();

    public StockItem getParentStockItem() {
        if (this.parentStockItem == null) {
            this.loadParentStockItem();
        }
        return this.parentStockItem;
    }

    public void setParentStockItem(StockItem parentStockItem) {
        this.parentStockItem = parentStockItem;
        this.stockItemBarcode = parentStockItem == null ? "" : parentStockItem.getItemCode();
        this.changeObjectState();
    }

    private void loadParentStockItem() {
        StockItemList compList = new StockItemList();
        String query = "Select * From StockItem Where name=?";
        compList.selectAll(query, new ParameterValue[]{new ParameterValue("barcode", JDBCType.VARCHAR, this.stockItemBarcode)});
        if (compList.getOriginalList().size() > 0) {
            this.parentStockItem = (StockItem)compList.getOriginalList().get(0);
        }
    }

    public Purchase getParentPurchase() {
        if (this.parentPurchase == null) {
            this.loadParentPurchase();
        }
        return this.parentPurchase;
    }

    public void setParentPurchase(Purchase parentPurchase) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.parentPurchase = parentPurchase;
        this.purchaseCode = parentPurchase == null ? "" : parentPurchase.getPurchaseCode();
        this.changeObjectState();
    }

    private void loadParentPurchase() {
        PurchaseList purList = new PurchaseList(this.dt);
        String query = "Select * From Purchase Where purchaseCode=?";
        purList.selectAll(query, new ParameterValue[]{new ParameterValue("purchaseCode", JDBCType.VARCHAR, this.purchaseCode)});
        if (purList.getOriginalList().size() > 0) {
            this.parentPurchase = (Purchase)purList.getOriginalList().get(0);
        }
    }

    public Date getNewDate() {
        return (Date)this.newDate.get();
    }

    public void setNewDate(Date date) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.newDate.set((Object)date);
        this.changeObjectState();
    }

    public ObjectProperty<Date> dateProperty() {
        return this.newDate;
    }

    public float getBalanceBf() {
        return this.balanceBf.get();
    }

    public void setBalanceBf(float balanceBf) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.balanceBf.set(balanceBf);
        this.changeObjectState();
    }

    public FloatProperty balanceBfProperty() {
        return this.balanceBf;
    }

    public String getComment() {
        return (String)this.comment.get();
    }

    public void setComment(String comment) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.comment.set((Object)comment);
        this.changeObjectState();
    }

    public StringProperty commentProperty() {
        return this.comment;
    }

    public float getQuantity() {
        return this.quantity.get();
    }

    public void setQuantity(float quantity) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.quantity.set(quantity);
        this.changeObjectState();
    }

    public FloatProperty quantityProperty() {
        return this.quantity;
    }

    public int getTransactionCount() {
        return this.transactionCount.get();
    }

    public void setTransactionCount(int transactionCount) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.Clone();
        }
        this.transactionCount.set(transactionCount);
        this.changeObjectState();
    }

    public IntegerProperty transactionCountProperty() {
        return this.transactionCount;
    }

    public Replenishment Clone() {
        Replenishment rep = new Replenishment();
        this.setMustClone(false);
        rep.balanceBf.set(this.balanceBf.get());
        rep.comment.set((Object)((String)this.comment.get()));
        rep.newDate.set((Object)((Date)this.newDate.get()));
        rep.purchaseCode = this.purchaseCode;
        rep.quantity.set(this.quantity.get());
        rep.stockItemBarcode = this.stockItemBarcode;
        rep.transactionCount.set(this.transactionCount.get());
        this.setMustClone(true);
        this.isCloned = true;
        return rep;
    }

    public Replenishment testClone() {
        Replenishment rep = new Replenishment();
        this.setMustClone(false);
        rep.balanceBf.set(this.balanceBf.get());
        rep.comment.set((Object)((String)this.comment.get()));
        rep.newDate.set((Object)((Date)this.newDate.get()));
        rep.purchaseCode = this.purchaseCode;
        rep.quantity.set(this.quantity.get());
        rep.stockItemBarcode = this.stockItemBarcode;
        rep.transactionCount.set(this.transactionCount.get());
        this.setMustClone(true);
        this.isCloned = true;
        return rep;
    }

    public void rollBack() {
        this.balanceBf.set(this.vClone.balanceBf.get());
        this.comment.set((Object)((String)this.vClone.comment.get()));
        this.newDate.set((Object)((Date)this.vClone.newDate.get()));
        this.purchaseCode = this.vClone.purchaseCode;
        this.quantity.set(this.vClone.quantity.get());
        this.stockItemBarcode = this.vClone.stockItemBarcode;
        this.setTransactionCount(this.vClone.getTransactionCount());
    }

    public Replenishment() {
    }

    public Replenishment(Float balanceBf, String comment, String purchaseCode, Float quantity, String stockItemBarcode, Integer transactionCount, Date date, DataAccess de) {
        super(de);
        this.newDate.set((Object)date);
        this.balanceBf.set(balanceBf.floatValue());
        this.comment.set((Object)comment);
        this.quantity.set(quantity.floatValue());
        this.stockItemBarcode = stockItemBarcode;
        this.purchaseCode = purchaseCode;
        this.transactionCount.set(transactionCount.intValue());
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    public Replenishment(DataAccess dbAccess) {
        super(dbAccess);
    }

    @Override
    public void insert() throws Exception {
        try {
            String query = "INSERT INTO Replenishment (balanceBf,comment,purchaseCode,quantity,stockItemBarcode,transactionCount,\"Date\") VALUES(?,?,?,?,?,?,?)";
            this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("balanceBf", JDBCType.FLOAT, Float.valueOf(this.balanceBf.get())), new ParameterValue("comment", JDBCType.VARCHAR, this.comment.get()), new ParameterValue("purchaseCode", JDBCType.VARCHAR, this.purchaseCode), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(this.quantity.get())), new ParameterValue("stockItemBarcode", JDBCType.VARCHAR, this.stockItemBarcode), new ParameterValue("transactionCount", JDBCType.INTEGER, this.transactionCount.get()), new ParameterValue("Date", JDBCType.DATE, this.newDate.get())});
            this.vClone = this.testClone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isCloned = false;
            throw ex;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            String query = "UPDATE Replenishment set balanceBf=?,comment=?, purchaseCode=?,quantity=?,stockItemBarcode=?,transactionCount=?,\"Date\"=? where transactionCount=?";
            this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("balanceBf", JDBCType.FLOAT, Float.valueOf(this.balanceBf.get())), new ParameterValue("comment", JDBCType.VARCHAR, this.comment.get()), new ParameterValue("purchaseCode", JDBCType.VARCHAR, this.purchaseCode), new ParameterValue("quantity", JDBCType.FLOAT, Float.valueOf(this.quantity.get())), new ParameterValue("stockItemBarcode", JDBCType.VARCHAR, this.stockItemBarcode), new ParameterValue("transactionCount", JDBCType.INTEGER, this.transactionCount.get()), new ParameterValue("Date", JDBCType.DATE, this.newDate.get()), new ParameterValue("cloneTransactionCount", JDBCType.INTEGER, this.vClone.transactionCount.get())}, true);
            this.vClone = this.testClone();
        }
        catch (Exception ex) {
            this.rollBack();
            this.isCloned = false;
            if (ex instanceof BaseConcurrencyException) {
                throw new BaseConcurrencyException("This object has been modified by another user, please reload your data", null);
            }
            throw ex;
        }
    }

    @Override
    public void delete() throws Exception {
        String query = "Delete FROM Replenishment where transactionCount=?";
        this.dt.performDbOperation(query, new ParameterValue[]{new ParameterValue("transactionCount", JDBCType.INTEGER, this.transactionCount.get())});
    }

    @Override
    public void beforeInsert() {
        block9: {
            try {
                if (this.getParentPurchase() != null) {
                    this.parentPurchase.getParentCompanyName().setLastTransactionCount(this.parentPurchase.getParentCompanyName().getLastTransactionCount() + 1);
                    this.setTransactionCount(this.parentPurchase.getParentCompanyName().getLastTransactionCount());
                    this.parentPurchase.getParentCompanyName().update();
                    break block9;
                }
                this.getParentStockItem().getParentCompany().setLastTransactionCount(this.getParentStockItem().getParentCompany().getLastTransactionCount() + 1);
                this.setTransactionCount(this.getParentStockItem().getParentCompany().getLastTransactionCount());
                this.getParentStockItem().getParentCompany().update();
            }
            catch (Exception ex) {
                try {
                    throw ex;
                }
                catch (Exception ex1) {
                    Logger.getLogger(Replenishment.class.getName()).log(Level.SEVERE, null, ex1);
                }
            }
        }
    }

    @Override
    public void afterInsert() {
    }

    @Override
    public void beforeUpdate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void afterUpdate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Searchable getSearchable() {
        Searchable sb = new Searchable();
        sb.setTableName("Replenishment");
        String[] parameter = new String[]{"balanceBf", "comment", "purchaseCode", "quantity", "stockItemBarcode", "transactionCount", "\"Date\""};
        sb.setParameters(parameter);
        return sb;
    }

    @Override
    public void initializeListener() {
        this.balanceBf.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Replenishment.this.setBalanceBf(((Float)newValue).floatValue());
            }
        });
        this.comment.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Replenishment.this.setComment(newValue);
            }
        });
        this.quantity.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Replenishment.this.setQuantity(((Float)newValue).floatValue());
            }
        });
        this.transactionCount.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Replenishment.this.setTransactionCount((Integer)newValue);
            }
        });
    }
}

