/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.UserDataList;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class NameValueObject {
    DataAccess dt = null;
    private String key;
    private String data;
    private String type;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public NameValueObject(DataAccess dt) {
        this.dt = dt;
    }

    public String toString() {
        return this.data;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        NameValueObject obj = (NameValueObject)object;
        if (obj.key == null || this.key == null) {
            return false;
        }
        return this.key.equals(obj.key);
    }

    public NameValueObject(String key, String data, String type, DataAccess dt) {
        this.dt = dt;
        this.key = key;
        this.data = data;
        this.type = type;
    }

    public NameValueObject(String key, String data, DataAccess dt) {
        this.dt = dt;
        this.key = key;
        this.data = data;
    }

    public NameValueObject(String key) {
        this.key = key;
    }

    public void insert() throws Exception {
        String query = "INSERT INTO NameValueObject(\"KEY\",\"DATA\",\"TYPE\") Values(?,?,?)";
        ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("key", JDBCType.VARCHAR, this.key), new ParameterValue("data", JDBCType.VARCHAR, this.data), new ParameterValue("type", JDBCType.VARCHAR, this.type)};
        this.dt.performDbOperation(query, parameterValues);
    }

    public static void insertBatch(List<NameValueObject> list, DataAccess dt) throws Exception {
        String query = "INSERT INTO NameValueObject(\"KEY\",\"DATA\",\"TYPE\") Values(?,?,?)";
        ArrayList<ParameterValue[]> parameters = new ArrayList<ParameterValue[]>();
        list.forEach(val -> {
            ParameterValue[] paramValue = new ParameterValue[]{new ParameterValue("key", JDBCType.VARCHAR, val.getKey()), new ParameterValue("data", JDBCType.VARCHAR, val.getData()), new ParameterValue("type", JDBCType.VARCHAR, val.getType())};
            parameters.add(paramValue);
        });
        dt.performDbOperationBatch(query, parameters);
    }

    public void update() throws Exception {
        try {
            String query = "UPDATE  NameValueObject SET \"KEY\"=?, \"DATA\"=?,\"TYPE\"=?  WHERE \"Key\"=? and \"TYPE\"=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("key", JDBCType.VARCHAR, this.key), new ParameterValue("data", JDBCType.VARCHAR, this.data), new ParameterValue("type", JDBCType.VARCHAR, this.type), new ParameterValue("key", JDBCType.VARCHAR, this.key), new ParameterValue("key", JDBCType.VARCHAR, this.type)};
            this.dt.performDbOperation(query, parameterValues, true);
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    public void delete() {
    }

    public static ObservableList<NameValueObject> select(String qry, ParameterValue[] parameterValues, DataAccess dt) {
        ObservableList result = FXCollections.observableArrayList();
        try {
            ResultSet rs = dt.select(qry, parameterValues);
            if (rs != null) {
                while (rs.next()) {
                    NameValueObject request = new NameValueObject(rs.getString("\"KEY\""), rs.getString("\"DATA\""), rs.getString("\"TYPE\""), dt);
                    result.add((Object)request);
                }
                rs.close();
                dt.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public static ObservableList<NameValueObject> select(String type, DataAccess dt) {
        ObservableList result = FXCollections.observableArrayList();
        try {
            ResultSet rs = dt.select("Select * From NameValueObject where \"TYPE\"=? order by \"DATA\" ", new ParameterValue[]{new ParameterValue("TYPE", JDBCType.VARCHAR, type)});
            if (rs != null) {
                while (rs.next()) {
                    NameValueObject request = new NameValueObject(rs.getString("\"KEY\""), rs.getString("\"DATA\""), rs.getString("\"TYPE\""), dt);
                    result.add((Object)request);
                }
                rs.close();
                dt.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public static boolean Delete(String qry, ParameterValue[] parameterValues, DataAccess dt) {
        try {
            dt.performDbOperation(qry, parameterValues);
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }
}

