/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa;

import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.CustomerPayment;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.Income;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.User;
import com.xputertechnologies.santa.core.BaseConcurrencyException;
import com.xputertechnologies.santa.core.ConsequentialConcurrencyException;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.core.Searchable;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.CustomerDataList;
import com.xputertechnologies.santa.list.CustomerPaymentDataList;
import com.xputertechnologies.santa.list.IncomeDataList;
import com.xputertechnologies.santa.list.SaleList;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class Customer
extends DbEntity {
    public Customer vClone;
    private boolean isCloned;
    DataAccess dt = this.getDbAccess();
    public boolean isLoadDebt;
    private String storeCode;
    private ObjectProperty<java.util.Date> dateCreated = new SimpleObjectProperty((Object)Date.valueOf(LocalDate.now()));
    private int sn;
    public boolean isEdit = false;
    private String companyName;
    public Company parentCompanyName;
    private StringProperty name = new SimpleStringProperty();
    private StringProperty d365Code = new SimpleStringProperty();
    private StringProperty code = new SimpleStringProperty(UUID.randomUUID().toString());
    private StringProperty phoneNumber = new SimpleStringProperty();
    private StringProperty email = new SimpleStringProperty();
    private StringProperty address = new SimpleStringProperty("");
    private static int returnIndex = -1;

    public String getStoreCode() {
        return this.storeCode;
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public int getSn() {
        return this.sn;
    }

    public void setSn(int sn) {
        this.sn = sn;
    }

    public Customer(String code, String d365Code, java.util.Date dateCreated, String email, String name, String phoneNumber, String address, String companyName, DataAccess dbAccess) {
        super(dbAccess);
        this.d365CodeProperty().set((Object)d365Code);
        this.codeProperty().set((Object)code);
        this.dateCreated.set((Object)dateCreated);
        this.emailProperty().set((Object)email);
        this.nameProperty().set((Object)name);
        this.phoneNumberProperty().set((Object)phoneNumber);
        this.addressProperty().set((Object)(address == null ? "" : address));
        this.companyName = companyName;
        this.setState(ObjectState.Unchanged);
        this.setMustClone(true);
        this.initializeListener();
    }

    public java.util.Date getDateCreated() {
        return (java.util.Date)this.dateCreated.get();
    }

    public void setDateCreated(java.util.Date date) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.dateCreated.set((Object)date);
    }

    public ObjectProperty<java.util.Date> dateCreatedProperty() {
        return this.dateCreated;
    }

    public Customer(DataAccess dbAccess) {
        super(dbAccess);
        this.initializeListener();
    }

    public void setParentCompanyName(Company cp) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.parentCompanyName = cp;
        this.companyName = cp == null ? "" : cp.getName();
        this.changeObjectState();
    }

    private void loadParentCompanyName() {
        CompanyDataList compList = new CompanyDataList(this.dt);
        String query = "Select * From Company where name=? ";
        compList.selectAll(query, new ParameterValue[]{new ParameterValue("name", JDBCType.VARCHAR, this.companyName)});
        if (compList.getOriginalList().size() > 0) {
            this.parentCompanyName = (Company)compList.getOriginalList().get(0);
        }
    }

    public Company getParentCompanyName() {
        if (this.parentCompanyName == null) {
            this.loadParentCompanyName();
        }
        return this.parentCompanyName;
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.name.set((Object)name);
    }

    public StringProperty d365CodeProperty() {
        return this.d365Code;
    }

    public String getD365Code() {
        return this.d365Code.get() == null || ((String)this.d365Code.get()).isEmpty() ? UUID.randomUUID().toString() : (String)this.d365Code.get();
    }

    public void setD365Code(String d365) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.d365Code.set((Object)d365);
    }

    public StringProperty codeProperty() {
        return this.code;
    }

    public String getCode() {
        return (String)this.code.get();
    }

    public void setCode(String code) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.code.set((Object)code);
    }

    public StringProperty phoneNumberProperty() {
        return this.phoneNumber;
    }

    public String getPhoneNumber() {
        return (String)this.phoneNumber.get();
    }

    public void setPhoneNumber(String phoneNumber) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.phoneNumber.set((Object)phoneNumber);
    }

    public StringProperty emailProperty() {
        return this.email;
    }

    public String getEmail() {
        return (String)this.email.get();
    }

    public void setEmail(String email) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.email.set((Object)email);
    }

    public StringProperty addressProperty() {
        return this.address;
    }

    public String getAddress() {
        return (String)this.address.get();
    }

    public void setAddress(String address) {
        if (!this.isCloned && this.isMustClone()) {
            this.vClone = this.clone();
        }
        this.changeObjectState();
        this.address.set((Object)address);
    }

    public Customer clone() {
        Customer customer = new Customer(this.dt);
        customer.setMustClone(false);
        customer.email.set((Object)((String)this.email.get()));
        customer.code.set((Object)((String)this.code.get()));
        customer.d365Code.set((Object)((String)this.d365Code.get()));
        customer.dateCreated.set((Object)((java.util.Date)this.dateCreated.get()));
        customer.name.set((Object)((String)this.name.get()));
        customer.phoneNumber.set((Object)((String)this.phoneNumber.get()));
        customer.address.set((Object)((String)this.address.get()));
        customer.companyName = this.companyName;
        this.setMustClone(true);
        this.isCloned = true;
        return customer;
    }

    protected void rollBack() {
        this.email.set((Object)((String)this.vClone.email.get()));
        this.code.set((Object)((String)this.vClone.code.get()));
        this.d365Code.set((Object)((String)this.vClone.d365Code.get()));
        this.dateCreated.set((Object)((java.util.Date)this.vClone.dateCreated.get()));
        this.name.set((Object)((String)this.vClone.name.get()));
        this.address.set((Object)((String)this.vClone.address.get()));
        this.phoneNumber.set((Object)((String)this.vClone.phoneNumber.get()));
        this.setMustClone(true);
    }

    public double collectBalance(SaleList saleList, User currentUser, double amountPaid) {
        double rembalance = 0.0;
        IncomeDataList incomeList = new IncomeDataList(currentUser.getDbAccess());
        Object incomeCode = "Income from Customer Payment:Invoice No ";
        CustomerPaymentDataList custPytList = new CustomerPaymentDataList(currentUser.getDbAccess());
        CustomerPayment cp = new CustomerPayment(currentUser.getDbAccess());
        Income income = new Income(currentUser.getDbAccess());
        income.setAmount(amountPaid);
        cp.amountPaidProperty().set(amountPaid);
        cp.setCustomerName(this.getName());
        cp.commentProperty().set((Object)"Payment for sale ");
        cp.codeProperty().set((Object)UUID.randomUUID().toString());
        cp.dateProperty().set((Object)Date.valueOf(currentUser.getParentCompany().getCurrentDay()));
        double balance = 0.0;
        block6: while (amountPaid > 0.0) {
            for (Sale s : saleList.getOriginalList()) {
                balance = s.getBalance();
                if (amountPaid == 0.0) continue block6;
                if (amountPaid >= balance) {
                    if (s.getBalance() > 0.0) {
                        incomeCode = (String)incomeCode + s.getInvoiceNumber() + ",";
                    }
                    cp.commentProperty().set((Object)((String)cp.commentProperty().get() + String.valueOf(s.getInvoiceNumber()) + ","));
                    cp.setSaleInvoiceNumber(s.getInvoiceNumber());
                    s.amountPaidProperty().set(s.amountPaidProperty().get() + amountPaid);
                    amountPaid -= balance;
                    s.setBalance(0.0);
                    continue;
                }
                if (s.getBalance() > 0.0) {
                    incomeCode = (String)incomeCode + s.getInvoiceNumber() + ",";
                }
                cp.commentProperty().set((Object)((String)cp.commentProperty().get() + String.valueOf(s.getInvoiceNumber()) + "(" + amountPaid + " out of " + String.valueOf(balance) + "),"));
                cp.setSaleInvoiceNumber(s.getInvoiceNumber());
                s.amountPaidProperty().set(s.amountPaidProperty().get() + amountPaid);
                amountPaid = 0.0;
                s.setBalance(balance -= amountPaid);
            }
        }
        for (Sale sale : saleList.getOriginalList()) {
            rembalance += sale.getBalance();
        }
        try {
            saleList.update();
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
        income.setDescription(((String)incomeCode).substring(0, ((String)incomeCode).length() - 1));
        if (income.getAmount() > 0.0) {
            income.setParentCompany(currentUser.getParentCompany());
            income.setUserName(currentUser.getUserName());
            incomeList.getOriginalList().add((Object)income);
        }
        try {
            incomeList.update();
        }
        catch (Exception ex) {
            Logger.getLogger(CustomerPayment.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (cp.getAmountPaid() > 0.0) {
            cp.commentProperty().set((Object)((String)cp.commentProperty().get()).substring(0, ((String)cp.commentProperty().get()).length() - 1));
            cp.setParentUser(currentUser);
            custPytList.getOriginalList().add((Object)cp);
            try {
                custPytList.update();
            }
            catch (Exception ex) {
                Logger.getLogger(CustomerPayment.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return rembalance;
    }

    public static CustomerDataList SearchCustomers(String searchString, DataAccess da) {
        if (!searchString.isEmpty() && searchString.charAt(0) == '0') {
            searchString = searchString.substring(1);
        }
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("email", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("name", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("address", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("phoneNumber", JDBCType.VARCHAR, "%" + searchString + "%"));
        CustomerDataList customerList = new CustomerDataList(da);
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        if (!searchString.isEmpty()) {
            customerList.select(searchCondition, true, false);
        } else {
            customerList.SelectAll();
        }
        return customerList;
    }

    public static int getAnonymousIndex(CustomerDataList customerDataList) {
        for (int i = 0; i < customerDataList.getOriginalList().size(); ++i) {
            if (!((Customer)customerDataList.getOriginalList().get(i)).getName().equals("Anonymous")) continue;
            returnIndex = i;
            break;
        }
        return returnIndex;
    }

    public static CustomerDataList LoadDebtors(DataAccess da) {
        CustomerDataList customerDataList = new CustomerDataList(da);
        customerDataList.selectAll("Select Distinct CUSTOMER.name,CUSTOMER.phoneNumber,CUSTOMER.address,CUSTOMER.companyName from CUSTOMER  JOIN  SALE On  CUSTOMER.NAME= SALE.CUSTOMERNAME   where  SALE.BALANCE>0 and SALE.RETURNALL<>1", da.getEmptyParameterValues());
        return customerDataList;
    }

    @Override
    public void insert() throws Exception {
        this.d365Code.set((Object)(this.d365Code.get() == null || ((String)this.d365Code.get()).isEmpty() ? UUID.randomUUID().toString() : (String)this.d365Code.get()));
        try {
            String query = "INSERT INTO CUSTOMER(d365Code,code,dateCreated,email,name,phoneNumber,address,companyName,lastSyncDate) Values(?,?,?,?,?,?,?,?,?)";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("d365Code", JDBCType.VARCHAR, this.d365Code.get()), new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("dateCreated", JDBCType.DATE, this.dateCreated.get()), new ParameterValue("email", JDBCType.VARCHAR, this.email.get()), new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("phoneNumber", JDBCType.VARCHAR, this.phoneNumber.get()), new ParameterValue("address", JDBCType.VARCHAR, this.address.get()), new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName), new ParameterValue("lastSyncDate", JDBCType.TIMESTAMP, new Timestamp(this.lastSyncDate.getTime()))};
            this.getDbAccess().performDbOperation(query, parameterValues);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            this.rollBack();
            this.isCloned = false;
            throw e;
        }
    }

    @Override
    public void update() throws Exception {
        try {
            if (this.getD365Code().equals("CUS-19786963")) {
                System.out.println("Name:" + this.getName() + " Phone Number" + this.getPhoneNumber() + " Temp Code" + this.getCode() + " Store" + this.getStoreCode());
            }
            String query = "UPDATE CUSTOMER SET code=?, d365Code=?,phoneNumber=?,dateCreated=?, name=?,email=?,address=?,companyName=?,lastSyncDate=? WHERE d365Code=? and phoneNumber=?";
            ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("code", JDBCType.VARCHAR, this.code.get()), new ParameterValue("d365Code", JDBCType.VARCHAR, this.d365Code.get()), new ParameterValue("phoneNumber", JDBCType.VARCHAR, this.phoneNumber.get()), new ParameterValue("dateCreated", JDBCType.DATE, this.dateCreated.get()), new ParameterValue("name", JDBCType.VARCHAR, this.name.get()), new ParameterValue("email", JDBCType.VARCHAR, this.email.get()), new ParameterValue("address", JDBCType.VARCHAR, this.address.get()), new ParameterValue("companyName", JDBCType.VARCHAR, this.companyName), new ParameterValue("lastSyncDate", JDBCType.TIMESTAMP, new Timestamp(this.lastSyncDate.getTime())), new ParameterValue("d365Code", JDBCType.VARCHAR, this.vClone.d365Code.get()), new ParameterValue("phoneNumber", JDBCType.VARCHAR, this.vClone.phoneNumber.get())};
            this.getDbAccess().performDbOperation(query, parameterValues, true);
            this.vClone = this.clone();
        }
        catch (Exception e) {
            if (e instanceof BaseConcurrencyException) {
                String message = e.getMessage();
                throw new ConsequentialConcurrencyException(message, (Object)null);
            }
            throw e;
        }
    }

    @Override
    public void delete() {
        String query = "DELETE FROM CUSTOMER WHERE phoneNumber=?";
        ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("d365Code", JDBCType.VARCHAR, this.phoneNumber.get())};
        try {
            this.getDbAccess().performDbOperation(query, parameterValues);
        }
        catch (Exception ex) {
            Logger.getLogger(Customer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Searchable getSearchable() {
        Searchable searchable = new Searchable();
        searchable.setTableName("Customer");
        String[] parameters = new String[]{"email,name", "phoneNumber", "address", "companyName"};
        searchable.setParameters(parameters);
        return searchable;
    }

    @Override
    public void beforeInsert() {
    }

    @Override
    public void afterInsert() {
        this.setState(ObjectState.Unchanged);
    }

    @Override
    public void beforeUpdate() {
    }

    @Override
    public void afterUpdate() {
        this.setState(ObjectState.Unchanged);
    }

    public String toString() {
        return (String)this.name.get();
    }

    @Override
    public void initializeListener() {
        this.name.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Customer.this.setName(newValue);
            }
        });
        this.email.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Customer.this.setEmail(newValue);
            }
        });
        this.phoneNumber.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Customer.this.setPhoneNumber(newValue);
            }
        });
        this.address.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                Customer.this.setAddress(newValue);
            }
        });
    }
}

