/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.ui.General;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.FloatStringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;

public class UIControlBase
extends VBox {
    GlyphFont fontAwesome = GlyphFontRegistry.font((String)"FontAwesome");
    protected StringConverter<? extends Number> intConverter = new IntegerStringConverter(){

        public String toString(Integer object) {
            if (object != null) {
                return General.formatDecimalToMoneyString(object.doubleValue());
            }
            return null;
        }

        public Integer fromString(String string) {
            Integer d = 0;
            if (!string.isEmpty()) {
                string = string.replace(",", "");
                d = Integer.parseInt(string);
            }
            return d;
        }
    };
    protected StringConverter<? extends Number> fConverter = new FloatStringConverter(){

        public String toString(Float object) {
            if (object != null) {
                return General.formatDecimalToMoneyString(object.doubleValue());
            }
            return null;
        }

        public Float fromString(String string) {
            Float d = Float.valueOf(0.0f);
            if (!string.isEmpty()) {
                string = string.replace(",", "");
                d = Float.valueOf(Float.parseFloat(string));
            }
            return d;
        }
    };
    protected StringConverter<? extends Number> dConverter = new DoubleStringConverter(){

        public String toString(Double object) {
            if (object != null) {
                return General.formatDecimalToMoneyString(object);
            }
            return null;
        }

        public Double fromString(String string) {
            Double d = 0.0;
            if (!string.isEmpty()) {
                string = string.replace(",", "");
                d = Double.parseDouble(string);
            }
            return d;
        }
    };
    private DbEntity dbEntity;

    public UIControlBase() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + ".fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public DbEntity getBoundObject() {
        return this.dbEntity;
    }

    public UIControlBase(DbEntity dbEntity) {
        this.dbEntity = dbEntity;
    }
}

