/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.AccountDetail;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class TableEdit
extends TableCell<AccountDetail, String> {
    private TextField textField;

    public void startEdit() {
        super.startEdit();
        if (this.textField == null) {
            this.createTextField();
        }
        this.setGraphic((Node)this.textField);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TableEdit.this.textField.requestFocus();
                TableEdit.this.textField.selectAll();
            }
        });
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText((String)this.getItem());
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getString());
            }
            this.setGraphic((Node)this.textField);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        } else {
            this.setText(this.getString());
            this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    TableEdit.this.commitEdit(TableEdit.this.textField.getText());
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    TableEdit.this.cancelEdit();
                } else if (t.getCode() == KeyCode.TAB) {
                    TableEdit.this.commitEdit(TableEdit.this.textField.getText());
                    TableColumn nextColumn = TableEdit.this.getNextColumn(!t.isShiftDown());
                    if (nextColumn != null) {
                        TableEdit.this.getTableView().edit(TableEdit.this.getTableRow().getIndex(), nextColumn);
                    }
                }
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue() && TableEdit.this.textField != null) {
                    TableEdit.this.commitEdit(TableEdit.this.textField.getText());
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
    }

    private TableColumn<AccountDetail, ?> getNextColumn(boolean forward) {
        int currentIndex;
        ArrayList columns = new ArrayList();
        for (TableColumn column : this.getTableView().getColumns()) {
            columns.addAll(this.getLeaves(column));
        }
        if (columns.size() < 2) {
            return null;
        }
        int nextIndex = currentIndex = columns.indexOf(this.getTableColumn());
        if (forward) {
            if (++nextIndex > columns.size() - 1) {
                nextIndex = 0;
            }
        } else if (--nextIndex < 0) {
            nextIndex = columns.size() - 1;
        }
        return (TableColumn)columns.get(nextIndex);
    }

    private List<TableColumn<AccountDetail, ?>> getLeaves(TableColumn<AccountDetail, ?> root) {
        ArrayList columns = new ArrayList();
        if (root.getColumns().isEmpty()) {
            if (root.isEditable()) {
                columns.add(root);
            }
            return columns;
        }
        for (TableColumn column : root.getColumns()) {
            columns.addAll(this.getLeaves(column));
        }
        return columns;
    }
}

