/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.AccountDetail;
import com.xputertechnologies.santa.AccountPaymentType;
import com.xputertechnologies.santa.Employee;
import com.xputertechnologies.santa.IDBEntity;
import com.xputertechnologies.santa.Log;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.NameValueObjectType;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.StreamEnum;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.list.AccountDetailDataList;
import com.xputertechnologies.santa.list.LogDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.SyncSettingDataList;
import com.xputertechnologies.santa.ui.AccountDetailItem;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.TableEdit;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.controlsfx.glyphfont.FontAwesome;

public class SyncSettingPane
extends UIParent {
    Santa app;
    @FXML
    private TextField endPointUrl;
    @FXML
    private TextField endPointUrlOMS;
    @FXML
    private TextField tbSyncInterval;
    @FXML
    private HBox hbToSap;
    @FXML
    private TableView<Log> logTb;
    @FXML
    public VBox RepeatingVB;
    @FXML
    private Button btnSync;
    @FXML
    private Button logRefresh;
    @FXML
    private Button btnSaveAccDetail;
    @FXML
    private Button btnSaveEndPoints;
    @FXML
    private ImageView btnAdd;
    @FXML
    private StackPane stackPane;
    @FXML
    private TableColumn<Log, String> colLogStatus;
    @FXML
    private TableColumn<Log, String> colLogMsg;
    @FXML
    private JFXButton btnSR;
    @FXML
    private JFXButton btnBank;
    @FXML
    private JFXButton btnPT;
    @FXML
    private JFXButton btnPM;
    @FXML
    private JFXButton btnDim;
    @FXML
    private JFXButton btnStore;
    @FXML
    private TableColumn<Log, Timestamp> colDateLog;
    @FXML
    private Tab tabLog;
    @FXML
    private Tab tabSetting;
    @FXML
    private CheckBox chkCustToSap;
    @FXML
    private CheckBox chkCustFromSap;
    @FXML
    private CheckBox chkStockFromSap;
    @FXML
    private CheckBox chkSaleToSap;
    @FXML
    private TabPane tabPane;
    AccountDetailDataList deleteAccountDetailDataList;
    @FXML
    private JFXComboBox<NameValueObject> cmbCC_Ret;
    @FXML
    private JFXComboBox<NameValueObject> cmbCC_B2B;
    @FXML
    private JFXComboBox<NameValueObject> cmbBU_Ret;
    @FXML
    private JFXComboBox<NameValueObject> cmbBU_B2B;
    @FXML
    private JFXComboBox<NameValueObject> cmbBS_Ret;
    @FXML
    private JFXComboBox<NameValueObject> cmbBS_B2B;
    @FXML
    private JFXButton btnSaveDim;

    public SyncSettingPane(Santa app) {
        super("SyncSettingPane.fxml", app);
        this.deleteAccountDetailDataList = new AccountDetailDataList(this.da);
        this.app = app;
        this.title = "Sync Setting";
        this.colLogStatus.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.colDateLog.setCellValueFactory((Callback)new PropertyValueFactory("dateLog"));
        this.colLogMsg.setCellValueFactory((Callback)new PropertyValueFactory("msg"));
        this.btnSaveAccDetail.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK).color(Color.WHITE).size(12.0));
        this.btnSaveEndPoints.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK).color(Color.WHITE).size(12.0));
        this.logRefresh.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.TRASH).color(Color.WHITE).size(12.0));
        this.btnAdd.setImage(new Image("/com/xputertechnologies/santa/ui/Images/increase.png"));
        this.loadDimensions();
        this.btnSaveDim.setOnAction(eh -> {
            try {
                StockItemList.insertSalesDimension(this.mainPage.dimensions, this.da);
                this.mainPage.showNotification(NotificationType.Success, "Operation successfull", this);
            }
            catch (Exception ex) {
                Logger.getLogger(SyncSettingPane.class.getName()).log(Level.SEVERE, null, ex);
                this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            }
        });
        this.cmbBU_Ret.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (newValue != null) {
                    NameValueObject currDim = SyncSettingPane.this.mainPage.dimensions.stream().filter(prdct -> prdct.getData().equals(StreamEnum.Retail.name()) && prdct.getType().equals(NameValueObjectType.BusinessUnit.name())).findAny().orElse(null);
                    if (currDim != null) {
                        currDim.setKey(newValue.getKey());
                    } else {
                        NameValueObject dim = new NameValueObject(newValue.getKey(), StreamEnum.Retail.name(), NameValueObjectType.BusinessUnit.name(), SyncSettingPane.this.da);
                        dim.setType(NameValueObjectType.BusinessUnit.name());
                        SyncSettingPane.this.mainPage.dimensions.add(dim);
                    }
                }
            }
        });
        this.cmbBU_B2B.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (newValue != null) {
                    NameValueObject currDim = SyncSettingPane.this.mainPage.dimensions.stream().filter(prdct -> prdct.getData().equals(StreamEnum.B2B.name()) && prdct.getType().equals(NameValueObjectType.BusinessUnit.name())).findAny().orElse(null);
                    if (currDim != null) {
                        currDim.setKey(newValue.getKey());
                    } else {
                        NameValueObject dim = new NameValueObject(newValue.getKey(), StreamEnum.B2B.name(), NameValueObjectType.BusinessUnit.name(), SyncSettingPane.this.da);
                        dim.setType(NameValueObjectType.BusinessUnit.name());
                        SyncSettingPane.this.mainPage.dimensions.add(dim);
                    }
                }
            }
        });
        this.cmbBS_Ret.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (newValue != null) {
                    NameValueObject currDim = SyncSettingPane.this.mainPage.dimensions.stream().filter(prdct -> prdct.getData().equals(StreamEnum.Retail.name()) && prdct.getType().equals(NameValueObjectType.BusinessStream.name())).findAny().orElse(null);
                    if (currDim != null) {
                        currDim.setKey(newValue.getKey());
                    } else {
                        NameValueObject dim = new NameValueObject(newValue.getKey(), StreamEnum.Retail.name(), NameValueObjectType.BusinessStream.name(), SyncSettingPane.this.da);
                        dim.setType(NameValueObjectType.BusinessStream.name());
                        SyncSettingPane.this.mainPage.dimensions.add(dim);
                    }
                }
            }
        });
        this.cmbBS_B2B.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (newValue != null) {
                    NameValueObject currDim = SyncSettingPane.this.mainPage.dimensions.stream().filter(prdct -> prdct.getData().equals(StreamEnum.B2B.name()) && prdct.getType().equals(NameValueObjectType.BusinessStream.name())).findAny().orElse(null);
                    if (currDim != null) {
                        currDim.setKey(newValue.getKey());
                    } else {
                        NameValueObject dim = new NameValueObject(newValue.getKey(), StreamEnum.B2B.name(), NameValueObjectType.BusinessStream.name(), SyncSettingPane.this.da);
                        dim.setType(NameValueObjectType.BusinessStream.name());
                        SyncSettingPane.this.mainPage.dimensions.add(dim);
                    }
                }
            }
        });
        this.cmbCC_Ret.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (newValue != null) {
                    NameValueObject currDim = SyncSettingPane.this.mainPage.dimensions.stream().filter(prdct -> prdct.getData().equals(StreamEnum.Retail.name()) && prdct.getType().equals(NameValueObjectType.CostCentre.name())).findAny().orElse(null);
                    if (currDim != null) {
                        currDim.setKey(newValue.getKey());
                    } else {
                        NameValueObject dim = new NameValueObject(newValue.getKey(), StreamEnum.Retail.name(), NameValueObjectType.CostCentre.name(), SyncSettingPane.this.da);
                        dim.setType(NameValueObjectType.CostCentre.name());
                        SyncSettingPane.this.mainPage.dimensions.add(dim);
                    }
                }
            }
        });
        this.cmbCC_B2B.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (newValue != null) {
                    NameValueObject currDim = SyncSettingPane.this.mainPage.dimensions.stream().filter(prdct -> prdct.getData().equals(StreamEnum.B2B.name()) && prdct.getType().equals(NameValueObjectType.CostCentre.name())).findAny().orElse(null);
                    if (currDim != null) {
                        currDim.setKey(newValue.getKey());
                    } else {
                        NameValueObject dim = new NameValueObject(newValue.getKey(), StreamEnum.B2B.name(), NameValueObjectType.CostCentre.name(), SyncSettingPane.this.da);
                        dim.setType(NameValueObjectType.CostCentre.name());
                        SyncSettingPane.this.mainPage.dimensions.add(dim);
                    }
                }
            }
        });
        this.btnSR.setOnAction(eh -> {
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            try {
                box.setAlignment(Pos.CENTER);
                this.stackPane.getChildren().add((Object)box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                SyncData syncData = new SyncData(SyncSettingPane.this.santa, SyncSettingPane.this.da, SyncSettingPane.this.santa.currentUser.getParentCompany());
                                syncData.getEmployee(SyncSettingPane.this.da, new IDBEntity<Employee>(){

                                    @Override
                                    public void onError(String data) {
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Error, data, SyncSettingPane.this);
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                    }

                                    @Override
                                    public void onTimeOut(String data) {
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Error, "Timeout", SyncSettingPane.this);
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                    }

                                    @Override
                                    public void onSuccess(ObservableList<Employee> data) {
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Success, data.size() + " Employee loaded successfully", SyncSettingPane.this);
                                    }
                                });
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            }
            catch (Exception ex) {
                this.stackPane.getChildren().remove((Object)box);
                Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.btnBank.setOnAction(eh -> {
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            try {
                box.setAlignment(Pos.CENTER);
                this.stackPane.getChildren().add((Object)box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                SyncData syncData = new SyncData(SyncSettingPane.this.santa, SyncSettingPane.this.da, SyncSettingPane.this.santa.currentUser.getParentCompany());
                                syncData.getBank(SyncSettingPane.this.da, SyncSettingPane.this.santa.currentUser.getParentCompany().getStoreCode(), new IDBEntity<AccountDetail>(){

                                    @Override
                                    public void onError(String data) {
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Error, data, SyncSettingPane.this);
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                    }

                                    @Override
                                    public void onTimeOut(String data) {
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Error, "Timeout", SyncSettingPane.this);
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                    }

                                    @Override
                                    public void onSuccess(ObservableList<AccountDetail> data) {
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Success, data.size() + " Banks loaded successfully", SyncSettingPane.this);
                                    }
                                });
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            }
            catch (Exception ex) {
                this.stackPane.getChildren().remove((Object)box);
                Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.btnPT.setOnAction(eh -> {
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            try {
                box.setAlignment(Pos.CENTER);
                this.stackPane.getChildren().add((Object)box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                SyncData syncData = new SyncData(SyncSettingPane.this.santa, SyncSettingPane.this.da, SyncSettingPane.this.santa.currentUser.getParentCompany());
                                syncData.getPaymentTerms(SyncSettingPane.this.da, new IDBEntity<NameValueObject>(){

                                    @Override
                                    public void onError(String data) {
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Error, data, SyncSettingPane.this);
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                    }

                                    @Override
                                    public void onTimeOut(String data) {
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Error, "Timeout", SyncSettingPane.this);
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                    }

                                    @Override
                                    public void onSuccess(ObservableList<NameValueObject> data) {
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Success, data.size() + " Payment Terms loaded successfully", SyncSettingPane.this);
                                    }
                                });
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            }
            catch (Exception ex) {
                this.stackPane.getChildren().remove((Object)box);
                Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.btnPM.setOnAction(eh -> {
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            try {
                box.setAlignment(Pos.CENTER);
                this.stackPane.getChildren().add((Object)box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                SyncData syncData = new SyncData(SyncSettingPane.this.santa, SyncSettingPane.this.da, SyncSettingPane.this.santa.currentUser.getParentCompany());
                                syncData.getPaymentModes(SyncSettingPane.this.da, new IDBEntity<NameValueObject>(){

                                    @Override
                                    public void onError(String data) {
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Error, data, SyncSettingPane.this);
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                    }

                                    @Override
                                    public void onTimeOut(String data) {
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Error, "Timeout", SyncSettingPane.this);
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                    }

                                    @Override
                                    public void onSuccess(ObservableList<NameValueObject> data) {
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Success, data.size() + " Payment Mode(s) loaded successfully", SyncSettingPane.this);
                                    }
                                });
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            }
            catch (Exception ex) {
                this.stackPane.getChildren().remove((Object)box);
                Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.btnDim.setOnAction(eh -> {
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            try {
                box.setAlignment(Pos.CENTER);
                this.stackPane.getChildren().add((Object)box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                SyncData syncData = new SyncData(SyncSettingPane.this.santa, SyncSettingPane.this.da, SyncSettingPane.this.santa.currentUser.getParentCompany());
                                syncData.getDimenssions(SyncSettingPane.this.da, new IDBEntity<NameValueObject>(){

                                    @Override
                                    public void onError(String data) {
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Error, data, SyncSettingPane.this);
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                    }

                                    @Override
                                    public void onTimeOut(String data) {
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Error, "Timeout", SyncSettingPane.this);
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                    }

                                    @Override
                                    public void onSuccess(ObservableList<NameValueObject> data) {
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Success, "Dimesion loaded successfully", SyncSettingPane.this);
                                        try {
                                            StockItemList.deleteAll("SalesDimension", SyncSettingPane.this.da);
                                            SyncSettingPane.this.loadDimensions();
                                        }
                                        catch (Exception ex) {
                                            Logger.getLogger(SyncSettingPane.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }
                                });
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            }
            catch (Exception ex) {
                this.stackPane.getChildren().remove((Object)box);
                Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.btnStore.setOnAction(eh -> {
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            try {
                box.setAlignment(Pos.CENTER);
                this.stackPane.getChildren().add((Object)box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                SyncData syncData = new SyncData(SyncSettingPane.this.santa, SyncSettingPane.this.da, SyncSettingPane.this.santa.currentUser.getParentCompany());
                                syncData.getLocations(SyncSettingPane.this.da, new IDBEntity<Store>(){

                                    @Override
                                    public void onError(String data) {
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Error, data, SyncSettingPane.this);
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                    }

                                    @Override
                                    public void onTimeOut(String data) {
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Error, "Timeout", SyncSettingPane.this);
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                    }

                                    @Override
                                    public void onSuccess(ObservableList<Store> data) {
                                        SyncSettingPane.this.stackPane.getChildren().remove((Object)box);
                                        SyncSettingPane.this.mainPage.showNotification(NotificationType.Success, data.size() + " Store(s) loaded successfully", SyncSettingPane.this);
                                    }
                                });
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            }
            catch (Exception ex) {
                this.stackPane.getChildren().remove((Object)box);
                Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.btnAdd.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                event.consume();
                if (SyncSettingPane.this.RepeatingVB.getChildren().stream().filter(p -> ((AccountDetailItem)p).accountDetail.getAccNumber() == null || ((AccountDetailItem)p).accountDetail.getAccNumber().isEmpty() || ((AccountDetailItem)p).accountDetail.getAccName() == null || ((AccountDetailItem)p).accountDetail.getAccName().isEmpty()).findAny().orElse(null) == null || SyncSettingPane.this.RepeatingVB.getChildren().size() == 0) {
                    SyncSettingPane.this.RepeatingVB.getChildren().add((Object)new AccountDetailItem(new AccountDetail(SyncSettingPane.this.da), SyncSettingPane.this, SyncSettingPane.this.RepeatingVB.getChildren().size() + 1));
                }
            }
        });
        this.btnSaveEndPoints.setOnAction(ev -> {
            if (this.endPointUrl.getText() != null && !this.endPointUrl.getText().isEmpty() && this.endPointUrlOMS.getText() != null && !this.endPointUrlOMS.getText().isEmpty()) {
                SyncSettingDataList syncSettingDataList = new SyncSettingDataList(this.da);
                if (app.syncSetting != null) {
                    try {
                        app.syncSetting.setD365URL(this.endPointUrlOMS.getText());
                        app.syncSetting.setBEURL(this.endPointUrl.getText());
                        boolean restartTimer = app.syncSetting.getSyncInterval() != Integer.valueOf(this.tbSyncInterval.getText()).intValue();
                        app.syncSetting.setSyncInterval(Integer.valueOf(this.tbSyncInterval.getText()));
                        syncSettingDataList.getOriginalList().add((Object)app.syncSetting);
                        syncSettingDataList.update();
                        if (restartTimer) {
                            app.startSyncTimer();
                        }
                        app.mainpage.showNotification(NotificationType.Success, "Operation Successful", this);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(SyncSettingPane.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            } else {
                app.mainpage.showNotification(NotificationType.Error, "SAP url or OMS url cannot be empty", this);
            }
        });
        this.btnSaveAccDetail.setOnAction(ev -> {
            if (this.RepeatingVB.getChildren().stream().filter(p -> ((AccountDetailItem)p).accountDetail.getAccNumber().isEmpty() || ((AccountDetailItem)p).accountDetail.getAccName().isEmpty()).findAny().orElse(null) == null) {
                try {
                    AccountDetailDataList accountDetailDataList = new AccountDetailDataList(this.da);
                    for (Node object : this.RepeatingVB.getChildren()) {
                        accountDetailDataList.getOriginalList().add((Object)((AccountDetailItem)object).accountDetail);
                    }
                    accountDetailDataList.update();
                    app.mainpage.showNotification(NotificationType.Success, "Operation Successful", this);
                    this.loadSyncSetting();
                }
                catch (Exception ex) {
                    Logger.getLogger(SyncSettingPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                app.mainpage.showNotification(NotificationType.Error, "you must fill all field ", this);
            }
        });
        Callback<TableColumn, TableCell> cellFactory = new Callback<TableColumn, TableCell>(){

            public TableCell call(TableColumn p) {
                return new TableEdit();
            }
        };
        this.colLogStatus.setCellFactory((Callback)new Callback<TableColumn<Log, String>, TableCell<Log, String>>(){

            public TableCell<Log, String> call(TableColumn<Log, String> param) {
                TableCell<Log, String> cell = new TableCell<Log, String>(){

                    public void updateItem(String status, boolean empty) {
                        if (status != null) {
                            Log log = (Log)this.getTableView().getItems().get(this.getIndex());
                            HBox hb = new HBox();
                            hb.setAlignment(Pos.CENTER);
                            ImageView imageView = new ImageView();
                            if (status.equalsIgnoreCase("Failure")) {
                                imageView.setImage(new Image("/com/xputertechnologies/santa/ui/Images/delete.png"));
                            } else if (status.equalsIgnoreCase("Success")) {
                                imageView.setImage(new Image("/com/xputertechnologies/santa/ui/Images/tick_32.png"));
                            } else {
                                imageView.setImage(new Image("/com/xputertechnologies/santa/ui/Images/warning_32.png"));
                            }
                            imageView.setFitHeight(25.0);
                            imageView.setFitWidth(25.0);
                            hb.getChildren().add((Object)imageView);
                            this.setTooltip(new Tooltip(log.getmsg().length() > 500 ? log.getmsg().substring(0, 499) : log.getmsg()));
                            this.setGraphic((Node)hb);
                        }
                    }
                };
                return cell;
            }
        });
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

            public void changed(ObservableValue<? extends Tab> observable, Tab oldValue, Tab newValue) {
                if (SyncSettingPane.this.tabLog.equals(newValue)) {
                    SyncSettingPane.this.loadLog();
                } else {
                    SyncSettingPane.this.loadSyncSetting();
                }
            }
        });
        this.logRefresh.setOnAction(ev -> {
            try {
                LogDataList logDataList = new LogDataList(app.da);
                Log log = new Log(this.da);
                log.setState(ObjectState.Removed);
                logDataList.getOriginalList().add((Object)log);
                logDataList.update();
                this.logTb.getItems().clear();
            }
            catch (Exception ex) {
                Logger.getLogger(SyncSettingPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.loadLog();
    }

    public void loadDimensions() {
        try {
            this.mainPage.dimensions = StockItemList.selectAllNameValue(this.da, "SalesDimension", "Code", "Stream", "Name");
            List<NameValueObject> Bus = StockItemList.selectAllNameValue(this.da, "BusinessUnit", "BusinessUnit", "Name");
            ObservableList bus = FXCollections.observableArrayList(Bus);
            this.cmbBU_B2B.getSelectionModel().clearSelection();
            this.cmbBU_Ret.getSelectionModel().clearSelection();
            this.cmbBS_B2B.getSelectionModel().clearSelection();
            this.cmbBS_Ret.getSelectionModel().clearSelection();
            this.cmbCC_B2B.getSelectionModel().clearSelection();
            this.cmbCC_Ret.getSelectionModel().clearSelection();
            this.cmbBU_B2B.setItems(bus);
            this.cmbBU_Ret.setItems(bus);
            for (int i = 0; i < bus.size(); ++i) {
                NameValueObject dimRetail;
                NameValueObject dimB2B = this.mainPage.dimensions.stream().filter(p -> p.getData().equals(StreamEnum.B2B.name()) && p.getType().equals(NameValueObjectType.BusinessUnit.name())).findAny().orElse(null);
                if (dimB2B != null) {
                    this.cmbBU_B2B.getSelectionModel().select((Object)this.cmbBU_B2B.getItems().stream().filter(p -> p.getKey().equals(dimB2B.getKey())).findAny().orElse(null));
                }
                if ((dimRetail = (NameValueObject)this.mainPage.dimensions.stream().filter(p -> p.getData().equals(StreamEnum.Retail.name()) && p.getType().equals(NameValueObjectType.BusinessUnit.name())).findAny().orElse(null)) == null) continue;
                this.cmbBU_Ret.getSelectionModel().select((Object)this.cmbBU_Ret.getItems().stream().filter(p -> p.getKey().equals(dimRetail.getKey())).findAny().orElse(null));
            }
            List<NameValueObject> BSs = StockItemList.selectAllNameValue(this.da, "BusinessStream", "BusinessStream", "Name");
            ObservableList bss = FXCollections.observableArrayList(BSs);
            this.cmbBS_B2B.setItems(bss);
            this.cmbBS_Ret.setItems(bss);
            for (int i = 0; i < bss.size(); ++i) {
                NameValueObject dimRetail;
                NameValueObject dimB2B = this.mainPage.dimensions.stream().filter(p -> p.getData().equals(StreamEnum.B2B.name()) && p.getType().equals(NameValueObjectType.BusinessStream.name())).findAny().orElse(null);
                if (dimB2B != null) {
                    this.cmbBS_B2B.getSelectionModel().select((Object)this.cmbBS_B2B.getItems().stream().filter(p -> p.getKey().equals(dimB2B.getKey())).findAny().orElse(null));
                }
                if ((dimRetail = (NameValueObject)this.mainPage.dimensions.stream().filter(p -> p.getData().equals(StreamEnum.Retail.name()) && p.getType().equals(NameValueObjectType.BusinessStream.name())).findAny().orElse(null)) == null) continue;
                this.cmbBS_Ret.getSelectionModel().select((Object)this.cmbBS_Ret.getItems().stream().filter(p -> p.getKey().equals(dimRetail.getKey())).findAny().orElse(null));
            }
            List<NameValueObject> Ccs = StockItemList.selectAllNameValue(this.da, "CostCenter", "CostCenter", "Name");
            ObservableList css = FXCollections.observableArrayList(Ccs);
            this.cmbCC_B2B.setItems(FXCollections.observableArrayList((Collection)css));
            this.cmbCC_Ret.setItems(FXCollections.observableArrayList((Collection)css));
            for (int i = 0; i < css.size(); ++i) {
                NameValueObject dimRetail;
                NameValueObject dimB2B = this.mainPage.dimensions.stream().filter(p -> p.getData().equals(StreamEnum.B2B.name()) && p.getType().equals(NameValueObjectType.CostCentre.name())).findAny().orElse(null);
                if (dimB2B != null) {
                    this.cmbCC_B2B.getSelectionModel().select((Object)this.cmbCC_B2B.getItems().stream().filter(p -> p.getKey().equals(dimB2B.getKey())).findAny().orElse(null));
                }
                if ((dimRetail = (NameValueObject)this.mainPage.dimensions.stream().filter(p -> p.getData().equals(StreamEnum.Retail.name()) && p.getType().equals(NameValueObjectType.CostCentre.name())).findAny().orElse(null)) == null) continue;
                this.cmbCC_Ret.getSelectionModel().select((Object)this.cmbCC_Ret.getItems().stream().filter(p -> p.getKey().equals(dimRetail.getKey())).findAny().orElse(null));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SyncSettingPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean validateAccType(String value) {
        for (AccountPaymentType accType : AccountPaymentType.values()) {
            if (!accType.name().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    private void loadLog() {
        LogDataList logDataList = new LogDataList(this.da);
        logDataList.selectAll();
        this.logTb.setItems(logDataList.getOriginalList());
    }

    private void loadSyncSetting() {
        this.RepeatingVB.getChildren().clear();
        this.endPointUrl.setText(this.app.syncSetting.getBEURL());
        this.endPointUrlOMS.setText(this.app.syncSetting.getD365URL());
        this.tbSyncInterval.setText(Integer.toString(this.app.syncSetting.getSyncInterval()));
        AccountDetailDataList accountDetailDataList = new AccountDetailDataList(this.da);
        accountDetailDataList.selectAllNotDeleted();
        ObservableList nodes = FXCollections.observableArrayList();
        for (AccountDetail object : accountDetailDataList.getOriginalList()) {
            AccountDetailItem accountDetailItem = new AccountDetailItem(object, this, accountDetailDataList.getOriginalList().size());
            nodes.add((Object)accountDetailItem);
        }
        this.RepeatingVB.getChildren().addAll((Collection)nodes);
    }

    public void validateForNewAcct() {
        if (this.RepeatingVB.getChildren().stream().filter(p -> ((AccountDetailItem)p).accountDetail.getAccNumber().isEmpty() || ((AccountDetailItem)p).accountDetail.getAccName().isEmpty() || ((AccountDetailItem)p).accountDetail.getAccType().isEmpty()).findAny().orElse(null) == null) {
            this.RepeatingVB.getChildren().add((Object)new AccountDetailItem(new AccountDetail(this.da), this, this.RepeatingVB.getChildren().size() + 1));
        }
    }
}

