/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.StockItemPriceCostSettingPane;
import com.xputertechnologies.santa.ui.UIControlBase;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.FloatStringConverter;

public class StockItemPriceCostSetting
extends UIControlBase {
    StringConverter<? extends Number> fConverter = new FloatStringConverter();
    StringConverter<? extends Number> dConverter = new DoubleStringConverter();
    @FXML
    private TextField txtSp;
    @FXML
    private Label lblDesc;
    @FXML
    private TextField txtCostp;
    @FXML
    private Label lblUnit;

    public StockItemPriceCostSetting(StockItem stockItem, StockItemPriceCostSettingPane parentContainer) {
        this.lblDesc.setText(stockItem.getName() + " (" + stockItem.getSize() + " ," + stockItem.getType() + ")");
        this.txtSp.textProperty().bindBidirectional((Property)stockItem.sellingPriceProperty(), this.fConverter);
        this.txtCostp.textProperty().bindBidirectional((Property)stockItem.costPriceProperty(), this.fConverter);
        this.lblUnit.setText(stockItem.getParentUnit().getName());
        this.txtCostp.addEventFilter(KeyEvent.KEY_TYPED, General.vaalidateTextBoxInput());
        this.txtCostp.addEventFilter(KeyEvent.KEY_TYPED, General.numeric_Validation(10));
        this.txtSp.addEventFilter(KeyEvent.KEY_TYPED, General.vaalidateTextBoxInput());
        this.txtSp.addEventFilter(KeyEvent.KEY_TYPED, General.numeric_Validation(10));
    }
}

