/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.SaleItemSerial;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import javafx.util.Duration;
import org.controlsfx.glyphfont.FontAwesome;

public class SerialTablePane
extends UIParent {
    @FXML
    private Label lblName;
    @FXML
    private Button btnAdd;
    @FXML
    private TextField search;
    @FXML
    private TableView<SaleItemSerial> table;
    @FXML
    private TableColumn<SaleItemSerial, Integer> colSn;
    @FXML
    private TableColumn<SaleItemSerial, String> colSerial;
    @FXML
    private TableColumn colAct;
    @FXML
    private TableColumn colCns;
    @FXML
    private TableColumn colDsp;
    @FXML
    private TableColumn colDel;
    StoreDataList storeDataList;
    int sn = 0;
    @FXML
    Label lblError;
    Timeline timeline;

    public SerialTablePane(Santa app, final boolean readOnly, final SaleItem saleItem) {
        super("SerialTablePane.fxml", app);
        this.santa = app;
        this.storeDataList = new StoreDataList(this.da);
        this.storeDataList.selectAll("Select *from store", this.da.getEmptyParameterValues());
        this.table.setItems(saleItem.getSerials().getOriginalList());
        this.lblName.setText(saleItem.getItemName());
        saleItem.getSerials().getOriginalList().forEach(val -> {
            ++this.sn;
            val.setSn(this.sn);
        });
        this.lblError.setVisible(false);
        this.btnAdd.setVisible(false);
        this.search.requestFocus();
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colSerial.setCellValueFactory((Callback)new PropertyValueFactory("serial"));
        Callback<TableColumn<SaleItemSerial, String>, TableCell<SaleItemSerial, String>> cellFactoryViewAct = new Callback<TableColumn<SaleItemSerial, String>, TableCell<SaleItemSerial, String>>(){

            public TableCell call(TableColumn<SaleItemSerial, String> param) {
                TableCell<SaleItemSerial, String> cell = new TableCell<SaleItemSerial, String>(){
                    final CheckBox chk = new CheckBox();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            if (readOnly) {
                                this.chk.setDisable(true);
                            }
                            SaleItemSerial serial = (SaleItemSerial)this.getTableView().getItems().get(this.getIndex());
                            this.chk.selectedProperty().bindBidirectional((Property)serial.actProperty());
                            this.setGraphic((Node)this.chk);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colAct.setCellFactory((Callback)cellFactoryViewAct);
        Callback<TableColumn<SaleItemSerial, String>, TableCell<SaleItemSerial, String>> cellFactoryViewDsp = new Callback<TableColumn<SaleItemSerial, String>, TableCell<SaleItemSerial, String>>(){

            public TableCell call(TableColumn<SaleItemSerial, String> param) {
                TableCell<SaleItemSerial, String> cell = new TableCell<SaleItemSerial, String>(){
                    final CheckBox chk = new CheckBox();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            if (readOnly) {
                                this.chk.setDisable(true);
                            }
                            SaleItemSerial serial = (SaleItemSerial)this.getTableView().getItems().get(this.getIndex());
                            this.chk.selectedProperty().bindBidirectional((Property)serial.dspProperty());
                            this.setGraphic((Node)this.chk);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colDsp.setCellFactory((Callback)cellFactoryViewDsp);
        Callback<TableColumn<SaleItemSerial, String>, TableCell<SaleItemSerial, String>> cellFactoryViewCns = new Callback<TableColumn<SaleItemSerial, String>, TableCell<SaleItemSerial, String>>(){

            public TableCell call(TableColumn<SaleItemSerial, String> param) {
                TableCell<SaleItemSerial, String> cell = new TableCell<SaleItemSerial, String>(){
                    final CheckBox chk = new CheckBox();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            if (readOnly) {
                                this.chk.setDisable(true);
                            }
                            SaleItemSerial serial = (SaleItemSerial)this.getTableView().getItems().get(this.getIndex());
                            this.chk.selectedProperty().bindBidirectional((Property)serial.cnsProperty());
                            this.setGraphic((Node)this.chk);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colCns.setCellFactory((Callback)cellFactoryViewCns);
        Callback<TableColumn<SaleItemSerial, String>, TableCell<SaleItemSerial, String>> cellFactoryViewDel = new Callback<TableColumn<SaleItemSerial, String>, TableCell<SaleItemSerial, String>>(){

            public TableCell call(TableColumn<SaleItemSerial, String> param) {
                TableCell<SaleItemSerial, String> cell = new TableCell<SaleItemSerial, String>(){
                    final Button btn = new Button();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            if (readOnly) {
                                this.btn.setDisable(true);
                            }
                            SaleItemSerial serial = (SaleItemSerial)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setPrefWidth(25.0);
                            this.btn.setPrefHeight(25.0);
                            this.btn.setGraphic((Node)SerialTablePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.MINUS_CIRCLE).color(Color.RED).size(15.0));
                            this.btn.setOnAction(v -> {
                                saleItem.getSerials().getOriginalList().remove((Object)serial);
                                saleItem.setQuantity(saleItem.getQuantity() - 1.0f);
                                SerialTablePane.this.resetSerial();
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colDel.setCellFactory((Callback)cellFactoryViewDel);
        this.search.setOnAction(v -> {
            if (!readOnly) {
                String saleMode = this.currentUser.getParentCompany().getSalesMode();
                StockItemList stockItemList = new StockItemList(this.da);
                stockItemList.selectWithSerial(this.search.getText());
                if (stockItemList.getOriginalList().size() > 0) {
                    if (saleItem.getSerials().getOriginalList().stream().filter(p -> p.getSerial().equals(((StockItem)stockItemList.getOriginalList().get((int)0)).serial)).findAny().orElse(null) == null) {
                        SaleItemSerial serial = new SaleItemSerial(this.da);
                        serial.setItemCode(saleItem.getItemCode());
                        serial.setQuantity(1);
                        serial.setSaleItemCode(saleItem.getCode());
                        serial.setStatus(((StockItem)stockItemList.getOriginalList().get((int)0)).status);
                        serial.setSysSerial(((StockItem)stockItemList.getOriginalList().get((int)0)).sysSerial);
                        serial.setWhscode(((StockItem)stockItemList.getOriginalList().get((int)0)).whsCode);
                        serial.setSerial(((StockItem)stockItemList.getOriginalList().get((int)0)).serial);
                        saleItem.getSerials().getOriginalList().add((Object)serial);
                        if (saleItem.getTotalQty() < saleItem.getSerials().getOriginalList().size()) {
                            saleItem.setQuantity(saleItem.getQuantity() + 1.0f);
                        }
                        if (serial.getWhscode().equals("02")) {
                            serial.cnsProperty().set(true);
                        } else if (serial.getWhscode().equals("07")) {
                            serial.dspProperty().set(true);
                        } else {
                            serial.actProperty().set(true);
                        }
                        this.resetSerial();
                    } else {
                        this.showNotif(false, "Item with the same serial " + this.search.getText() + " already exist");
                        this.table.getSelectionModel().select((Object)saleItem.getSerials().getOriginalList().stream().filter(p -> p.getSerial().equals(((StockItem)stockItemList.getOriginalList().get((int)0)).serial)).findAny().get());
                    }
                    this.search.clear();
                    this.search.requestFocus();
                } else if (saleItem.getIsManual().booleanValue()) {
                    this.showNotif(true, "No item found for " + this.search.getText() + " click Add to register the serial");
                } else {
                    this.showNotif(false, "No item found for " + this.search.getText());
                    this.search.clear();
                    this.search.requestFocus();
                }
            }
        });
        this.btnAdd.setOnAction(val -> {
            if (!readOnly) {
                if (!this.search.getText().isEmpty()) {
                    if (saleItem.getSerials().getOriginalList().stream().filter(p -> p.getSerial().equals(this.search.getText())).findAny().orElse(null) == null) {
                        SaleItemSerial serial = new SaleItemSerial(this.da);
                        serial.setItemCode(saleItem.getItemCode());
                        serial.setQuantity(1);
                        serial.setSaleItemCode(saleItem.getCode());
                        serial.setWhscode(app.currentUser.getParentCompany().getStoreCode());
                        serial.actProperty().set(true);
                        serial.setSerial(this.search.getText());
                        saleItem.getSerials().getOriginalList().add((Object)serial);
                        if (saleItem.getTotalQty() < saleItem.getSerials().getOriginalList().size()) {
                            saleItem.setQuantity(saleItem.getQuantity() + 1.0f);
                        }
                        this.resetSerial();
                    } else {
                        this.showNotif(false, "Item with the same serial " + this.search.getText() + " already exist");
                        this.table.getSelectionModel().select((Object)saleItem.getSerials().getOriginalList().stream().filter(p -> p.getSerial().equals(this.search)).findAny().get());
                    }
                } else {
                    this.showNotif(false, "Please supply serial in the search box and try again ");
                }
                this.search.clear();
                this.search.requestFocus();
                this.btnAdd.setVisible(false);
                this.lblError.setVisible(false);
            }
        });
    }

    void showNotif(boolean iswarning, String msg) {
        int notificationTimeInSecond = 10;
        if (iswarning) {
            this.btnAdd.setVisible(true);
        }
        this.lblError.setText(msg);
        this.lblError.setVisible(true);
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)notificationTimeInSecond), ae -> {
            this.btnAdd.setVisible(false);
            this.lblError.setVisible(false);
        }, new KeyValue[0])});
        this.timeline.play();
    }

    @Override
    public void yes() {
    }

    void resetSerial() {
        this.sn = 0;
        this.table.getItems().forEach(val -> {
            ++this.sn;
            val.setSn(this.sn);
        });
    }
}

