/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.ObjectDb;
import com.xputertechnologies.santa.StockItemData;
import com.xputertechnologies.santa.StockItemDataPrint;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.report.JRStockItemBarCodeDataSource;
import com.xputertechnologies.santa.ui.IPurchasePane;
import com.xputertechnologies.santa.ui.NewRequestPane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PurchaseOrderPaneViewerPane;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SerialRepeatingItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.print.Printer;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrinterName;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class SerialGeneratorPane
extends IPurchasePane {
    @FXML
    private StackPane stackPane;
    @FXML
    private TextField txItemCode;
    @FXML
    private TextField txQty;
    @FXML
    private JFXButton btnLoadDetail;
    @FXML
    private JFXButton btnPrintSerial;
    @FXML
    private JFXButton btnPrintItem;
    @FXML
    private JFXButton btnReloadYuProduct;
    @FXML
    private Label lblItemName;
    @FXML
    public VBox vbox;
    int i = 0;
    ObjectDb objectDb;
    ObservableList<StockItemDataPrint> stockItemDataPrints;

    public SerialGeneratorPane(Santa app) {
        super("SerialGeneratorPane.fxml", app);
        this.title = "Serial Generator";
        this.objectDb = ObjectDb.loadLocalDb() == null ? new ObjectDb() : ObjectDb.loadLocalDb();
        this.stockItemDataPrints = FXCollections.observableArrayList();
        this.txItemCode.setTextFormatter(new TextFormatter(change -> {
            change.setText(change.getText().toUpperCase());
            return change;
        }));
        this.btnLoadDetail.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.BINOCULARS).color(javafx.scene.paint.Color.WHITE).size(15.0));
        this.btnReloadYuProduct.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.EXTERNAL_LINK).color(javafx.scene.paint.Color.WHITE).size(15.0));
        this.btnPrintItem.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PRINT).color(javafx.scene.paint.Color.WHITE).size(15.0));
        this.btnPrintSerial.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PRINT).color(javafx.scene.paint.Color.WHITE).size(15.0));
        if (this.santa.Products.isEmpty()) {
            try {
                this.santa.Products.addAll(StockItemList.selectAllYuProducts(this.da));
            }
            catch (SQLException ex) {
                Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.btnLoadDetail.setOnAction(x -> {
            this.vbox.getChildren().clear();
            this.lblItemName.setText("");
            if (this.txItemCode.getText().isEmpty() || this.txQty.getText().isEmpty()) {
                this.mainPage.showNotification(NotificationType.Error, "Please supply Item Code and Quantity", this);
            } else {
                StockItemData stk = this.santa.Products.stream().filter(c -> c.getItemCode().compareToIgnoreCase(this.txItemCode.getText()) == 0).findAny().orElse(null);
                if (stk != null) {
                    try {
                        this.lblItemName.setText(stk.getDescription());
                        String str = "";
                        for (int i = 0; i < Integer.valueOf(this.txQty.getText()); ++i) {
                            StockItemDataPrint stockItemDataPrint = new StockItemDataPrint();
                            stockItemDataPrint.setSn(i + 1);
                            stockItemDataPrint.setItemCode(stk.getItemCode());
                            stockItemDataPrint.setItemName(stk.getDescription());
                            this.vbox.getChildren().add((Object)new SerialRepeatingItem(stockItemDataPrint, this));
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    this.mainPage.showNotification(NotificationType.Information, "Item Code not Found", this);
                }
            }
        });
        this.btnReloadYuProduct.setOnAction(x -> {
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            box.setAlignment(Pos.CENTER);
            VBox progressContainer = box;
            this.stackPane.getChildren().add((Object)box);
            Service service = new Service(){

                protected Task createTask() {
                    return new Task(){

                        protected Object call() throws Exception {
                            try {
                                HttpGet httpGet = new HttpGet(SerialGeneratorPane.this.santa.syncSetting.getBEURL() + "rProduct/GetSAPItems");
                                RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                                httpGet.setHeader("Content-type", "application/json");
                                CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                                if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                    String output;
                                    BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                    StringBuilder stringBuilder = new StringBuilder();
                                    System.out.println("Output from Server .... \n");
                                    while ((output = br.readLine()) != null) {
                                        System.out.println(output);
                                        stringBuilder.append(output + "\n");
                                    }
                                    br.close();
                                    httpClient.getConnectionManager().shutdown();
                                    String result = stringBuilder.toString();
                                    JSONArray jar = new JSONArray(result);
                                    if (jar.length() > 0) {
                                        ArrayList<StockItemData> list = new ArrayList<StockItemData>();
                                        for (int i = 0; i < jar.length(); ++i) {
                                            JSONObject jo = jar.getJSONObject(i);
                                            StockItemData stkData = new StockItemData();
                                            stkData.setDescription(jo.isNull("ItemName") ? "" : jo.getString("ItemName"));
                                            stkData.setItemCode(jo.isNull("ItemCode") ? "" : jo.getString("ItemCode"));
                                            list.add(stkData);
                                        }
                                        StockItemList.insertAllYudalaProduct(list, SerialGeneratorPane.this.da);
                                        if (list.size() > 0) {
                                            SerialGeneratorPane.this.santa.Products.clear();
                                            SerialGeneratorPane.this.santa.Products.addAll(list);
                                        }
                                        SerialGeneratorPane.this.objectDb.setLastUpdateYuProduct(new Date());
                                        Platform.runLater(() -> {
                                            SerialGeneratorPane.this.stackPane.getChildren().remove((Object)box);
                                            SerialGeneratorPane.this.mainPage.showNotification(NotificationType.Success, "Operation successful", SerialGeneratorPane.this);
                                        });
                                    } else {
                                        Platform.runLater(() -> {
                                            SerialGeneratorPane.this.stackPane.getChildren().remove((Object)box);
                                            SerialGeneratorPane.this.mainPage.showNotification(NotificationType.Information, "Unable to load products", SerialGeneratorPane.this);
                                        });
                                    }
                                } else {
                                    String output;
                                    BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                    StringBuilder stringBuilder = new StringBuilder();
                                    while ((output = br.readLine()) != null) {
                                        System.out.println(output);
                                        stringBuilder.append(output + "\n");
                                    }
                                    br.close();
                                    String fullError = stringBuilder.toString();
                                    Platform.runLater(() -> {
                                        SerialGeneratorPane.this.stackPane.getChildren().remove((Object)box);
                                        SerialGeneratorPane.this.mainPage.showNotification(NotificationType.Error, fullError, SerialGeneratorPane.this);
                                    });
                                }
                            }
                            catch (Exception ex) {
                                Platform.runLater(() -> {
                                    SerialGeneratorPane.this.stackPane.getChildren().remove((Object)box);
                                    SerialGeneratorPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), SerialGeneratorPane.this);
                                });
                            }
                            return null;
                        }
                    };
                }
            };
            progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
            service.start();
        });
        this.btnPrintItem.setOnAction(x -> {
            try {
                this.stockItemDataPrints.clear();
                this.vbox.getChildren().forEach(xx -> this.stockItemDataPrints.add((Object)((SerialRepeatingItem)xx).item));
                this.print(false);
            }
            catch (Exception ex) {
                Logger.getLogger(PurchaseOrderPaneViewerPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.btnPrintSerial.setOnAction(x -> {
            this.stockItemDataPrints.clear();
            this.vbox.getChildren().forEach(xx -> this.stockItemDataPrints.add((Object)((SerialRepeatingItem)xx).item));
            this.stockItemDataPrints.forEach(c -> {
                try {
                    c.setBarCode(this.generateBarCode(c.getImei().isEmpty() ? c.getInternalNo() : c.getInternalNo(), 350, 100, 12));
                }
                catch (Exception ex) {
                    Logger.getLogger(SerialGeneratorPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            try {
                this.print(true);
            }
            catch (Exception ex) {
                Logger.getLogger(PurchaseOrderPaneViewerPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
    }

    public void print(boolean isBarCode) {
        try {
            JasperPrint rpt = null;
            HashMap params = new HashMap();
            rpt = JasperFillManager.fillReport((JasperReport)(isBarCode ? this.santa.getCompiledJasperReportStockItemBarCode() : this.santa.getCompiledJasperReportStockItemBarCodeItem()), params, (JRDataSource)this.createStockBarCodePrint(this.stockItemDataPrints));
            try {
                long start = System.currentTimeMillis();
                HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
                printRequestAttributeSet.add(MediaSizeName.ISO_A4);
                HashPrintServiceAttributeSet printServiceAttributeSet = new HashPrintServiceAttributeSet();
                PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
                System.out.println("Number of print services: " + printServices.length);
                for (PrintService printer : printServices) {
                    System.out.println("Printer: " + printer.getName());
                }
                printServiceAttributeSet.add(new PrinterName(Printer.getDefaultPrinter().getName(), null));
                JRPrintServiceExporter exporter = new JRPrintServiceExporter();
                exporter.setExporterInput((ExporterInput)new SimpleExporterInput(rpt));
                SimplePrintServiceExporterConfiguration configuration = new SimplePrintServiceExporterConfiguration();
                configuration.setPrintRequestAttributeSet((PrintRequestAttributeSet)printRequestAttributeSet);
                configuration.setPrintServiceAttributeSet((PrintServiceAttributeSet)printServiceAttributeSet);
                configuration.setDisplayPageDialog(Boolean.valueOf(false));
                configuration.setDisplayPrintDialog(Boolean.valueOf(true));
                exporter.setConfiguration((ExporterConfiguration)configuration);
                exporter.exportReport();
                System.err.println("Printing time : " + (System.currentTimeMillis() - start));
                this.vbox.getChildren().clear();
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
        catch (JRException ex) {
            Logger.getLogger(SerialGeneratorPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private JRDataSource createStockBarCodePrint(ObservableList<StockItemDataPrint> pos) {
        JRStockItemBarCodeDataSource dataSource = new JRStockItemBarCodeDataSource();
        pos.forEach(v -> dataSource.add(v.getItemCode(), v.getBarCode(), v.getItemName(), v.getImei().isEmpty() ? v.getInternalNo() : v.getImei()));
        return dataSource;
    }

    public BufferedImage generateBarCode(String codeS, int width, int height, int fontSize) throws Exception {
        try {
            BitMatrix matrix;
            Code128Writer writer = new Code128Writer();
            try {
                matrix = writer.encode(codeS, BarcodeFormat.CODE_128, width, height);
            }
            catch (WriterException e) {
                throw new Exception("Error generando el QR");
            }
            BufferedImage image = new BufferedImage(width, height, 1);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int grayValue = (matrix.get(x, y) ? 0 : 1) & 0xFF;
                    image.setRGB(x, y, grayValue == 0 ? 0 : 0xFFFFFF);
                }
            }
            Graphics graphics = image.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            Font f = new Font("Calibri", 0, fontSize);
            FontRenderContext frc = image.getGraphics().getFontMetrics().getFontRenderContext();
            Rectangle2D rect = f.getStringBounds(codeS, frc);
            graphics.setColor(Color.WHITE);
            graphics.fillRect((int)Math.ceil((double)(image.getWidth() / 2) - (rect.getWidth() + 10.0) / 2.0), (int)Math.ceil((double)image.getHeight() - (rect.getHeight() + 6.0)), (int)Math.ceil(rect.getWidth() + 10.0), (int)Math.ceil(rect.getHeight() + 6.0));
            graphics.setFont(f);
            graphics.setColor(Color.BLACK);
            graphics.drawString(codeS, (int)Math.ceil((double)(image.getWidth() / 2) - rect.getWidth() / 2.0), (int)Math.ceil(image.getHeight() - 6));
            graphics.dispose();
            return image;
        }
        catch (Exception ex) {
            throw new Exception("Error generando el QR");
        }
    }
}

