/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextArea;
import com.xputertechnologies.santa.Account;
import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SaleAccountDetailResolver;
import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.SaleItemSerial;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.SyncSetting;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.AccountDataList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.list.SyncSettingDataList;
import com.xputertechnologies.santa.list.UnitDataList;
import com.xputertechnologies.santa.report.ReportType;
import com.xputertechnologies.santa.ui.CustomEditableTableColumnNumberDouble;
import com.xputertechnologies.santa.ui.CustomEditableTableColumnNumberFloat;
import com.xputertechnologies.santa.ui.CustomEditableTableColumnsAutocomplete;
import com.xputertechnologies.santa.ui.CustomEditableTableColumnsSaleItemItemCodeAutocomplete;
import com.xputertechnologies.santa.ui.CustomEditableTableColumnsSaleItemStorenameAutocomplete;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.ReportPane;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SerialView;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRException;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SalesReturnPaneAudit
extends UIParent {
    @FXML
    private JFXComboBox<String> cmbFilter;
    @FXML
    private JFXButton SearchButton;
    @FXML
    private JFXButton resyncSale;
    @FXML
    private JFXButton btnApprove;
    @FXML
    private JFXDatePicker fromDate;
    @FXML
    private JFXDatePicker toDate;
    @FXML
    private StackPane stackPane;
    @FXML
    private SplitMenuButton rpt;
    @FXML
    private Label lblTotal;
    @FXML
    private Label naira;
    @FXML
    private Label lblUsername;
    @FXML
    private Label lblPnum;
    @FXML
    private Label lblDate;
    @FXML
    private Label lblSap;
    @FXML
    private Label totCaption;
    @FXML
    private Label lblcount;
    @FXML
    private Label lblFilter;
    @FXML
    private Label lblCusPno;
    @FXML
    private Label lblcusName;
    @FXML
    private Label lblVoucherCode;
    @FXML
    private Label lblVoucherAmt;
    @FXML
    private MenuItem summaryRpt;
    @FXML
    private MenuItem detailRpt;
    @FXML
    private JFXTextArea lblSaleComment;
    @FXML
    private JFXTextArea lblAuditComent;
    @FXML
    private JFXTextArea textAreaInvoice;
    @FXML
    private GridPane grid;
    @FXML
    private TableView<SaleAccountDetailResolver> tbPayment;
    @FXML
    private TableView<SaleItem> tbItem;
    @FXML
    private TableColumn<SaleItem, String> colItemCode;
    @FXML
    private TableColumn<SaleItem, String> colDescription;
    @FXML
    private TableColumn<SaleItem, String> colStore;
    @FXML
    private TableColumn<SaleItem, String> colRet;
    @FXML
    private TableColumn<SaleItem, Float> colQty;
    @FXML
    private TableColumn<SaleItem, Double> colPrice;
    @FXML
    private TableColumn<SaleAccountDetailResolver, Double> colAmount;
    @FXML
    private TableColumn<SaleAccountDetailResolver, String> colAccNo;
    @FXML
    private TableColumn<SaleAccountDetailResolver, String> colAccType;
    @FXML
    private TableColumn<SaleAccountDetailResolver, String> colpaycode;
    @FXML
    private TableColumn<SaleAccountDetailResolver, String> colAccName;
    @FXML
    private TableColumn colSerial;
    @FXML
    private TableColumn colLineStatus;
    VBox progressContainer;
    @FXML
    private ListView<Sale> listview;
    @FXML
    private JFXComboBox<Store> cmbStore;
    private Sale sale = null;
    private ArrayList<ParameterValue> tempParamValue = new ArrayList();
    private SaleList saleList;
    UnitDataList unitDataList;
    Customer currentCustomer;
    Double Total = 0.0;
    SyncSettingDataList syncSettingDataList = null;
    StoreDataList storeDataList = null;
    AccountDataList accontDataList = null;
    String errormsg;
    Sale oldselectedSale;
    int i = 0;

    public SalesReturnPaneAudit(Santa app) {
        super("SalesReturnPaneAudit.fxml", app);
        this.title = "Sale Information Page";
        this.unitDataList = new UnitDataList(this.da);
        this.unitDataList.SelectAll();
        this.saleList = new SaleList(this.da);
        this.fromDate.setValue((Object)LocalDate.now());
        this.toDate.setValue((Object)LocalDate.now());
        this.grid.setVisible(false);
        this.syncSettingDataList = new SyncSettingDataList(this.da);
        this.syncSettingDataList.selectAll("Select * From SyncSetting", this.da);
        this.storeDataList = new StoreDataList(this.da);
        this.storeDataList.selectAll(this.da);
        this.listview.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ObservableList reportFilter = FXCollections.observableArrayList();
        for (int i = 0; i < ReportFilterEnum.values().length; ++i) {
            reportFilter.add((Object)ReportFilterEnum.values()[i].name());
        }
        this.cmbFilter.setItems(reportFilter);
        this.cmbFilter.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                String value;
                SaleList sales = new SaleList(SalesReturnPaneAudit.this.da);
                String string = value = newValue == null ? oldValue : newValue;
                if (SalesReturnPaneAudit.this.saleList.getOriginalList().size() > 0) {
                    if (value.equals(ReportFilterEnum.None.name())) {
                        sales.getOriginalList().addAll(SalesReturnPaneAudit.this.saleList.getOriginalList());
                    } else if (value.equals(ReportFilterEnum.AuditApproved.name())) {
                        sales.getOriginalList().addAll((Collection)SalesReturnPaneAudit.this.saleList.getOriginalList().stream().filter(p -> p.getSyncError().isEmpty() && p.postingUser.isEmpty() && !p.approvingUser.isEmpty() && p.getIsManual() != false).collect(Collectors.toList()));
                    } else if (value.equals(ReportFilterEnum.Pending.name())) {
                        sales.getOriginalList().addAll((Collection)SalesReturnPaneAudit.this.saleList.getOriginalList().stream().filter(p -> p.getSyncError().isEmpty() && p.getIsManual() != false && p.postingUser.isEmpty() && p.approvingUser.isEmpty()).collect(Collectors.toList()));
                    } else if (value.equals(ReportFilterEnum.SuccessfullyPosted.name())) {
                        sales.getOriginalList().addAll((Collection)SalesReturnPaneAudit.this.saleList.getOriginalList().stream().filter(p -> p.getSyncError().isEmpty() && p.getIsManual() == false).collect(Collectors.toList()));
                    } else {
                        sales.getOriginalList().addAll((Collection)SalesReturnPaneAudit.this.saleList.getOriginalList().stream().filter(p -> !p.getSyncError().isEmpty()).collect(Collectors.toList()));
                    }
                    SalesReturnPaneAudit.this.listview.getItems().clear();
                    SalesReturnPaneAudit.this.listview.getItems().addAll(sales.getOriginalList());
                    SalesReturnPaneAudit.this.tbItem.getItems().clear();
                    SalesReturnPaneAudit.this.tbPayment.getItems().clear();
                    SalesReturnPaneAudit.this.grid.setVisible(false);
                    if (sales.getOriginalList().size() == 1) {
                        SalesReturnPaneAudit.this.listview.getSelectionModel().select(0);
                        SalesReturnPaneAudit.this.tbItem.setItems(((Sale)sales.getOriginalList().get(0)).getSaleItemsList());
                        SalesReturnPaneAudit.this.tbItem.refresh();
                        SalesReturnPaneAudit.this.tbPayment.setItems(((Sale)sales.getOriginalList().get(0)).getPayments().getOriginalList());
                        SalesReturnPaneAudit.this.tbPayment.refresh();
                        SalesReturnPaneAudit.this.setCustomerInfo((Sale)sales.getOriginalList().get(0));
                    } else {
                        SalesReturnPaneAudit.this.tbItem.setItems(SalesReturnPaneAudit.this.sale.getSaleItemsList());
                        SalesReturnPaneAudit.this.tbItem.refresh();
                        SalesReturnPaneAudit.this.tbPayment.setItems(SalesReturnPaneAudit.this.sale.getPayments().getOriginalList());
                        SalesReturnPaneAudit.this.tbPayment.refresh();
                    }
                }
            }
        });
        Callback<TableColumn<SaleItem, String>, TableCell<SaleItem, String>> cellFactoryVieSerial = new Callback<TableColumn<SaleItem, String>, TableCell<SaleItem, String>>(){

            public TableCell call(TableColumn<SaleItem, String> param) {
                TableCell<SaleItem, String> cell = new TableCell<SaleItem, String>(){
                    final JFXButton lbl = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            SaleItem req = (SaleItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getSerials().getOriginalList().isEmpty()) {
                                this.lbl.setPrefHeight(30.0);
                                this.lbl.setPrefWidth(30.0);
                                this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                                this.lbl.setGraphic((Node)SalesReturnPaneAudit.this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.GREEN).size(15.0));
                                this.lbl.setOnAction(c -> {
                                    ObservableList observableList = FXCollections.observableArrayList();
                                    SalesReturnPaneAudit.this.i = 0;
                                    req.getSerials().getOriginalList().forEach(x -> {
                                        ++SalesReturnPaneAudit.this.i;
                                        NameValueObject valuePair = new NameValueObject(SalesReturnPaneAudit.this.da);
                                        valuePair.setKey(Integer.toString(SalesReturnPaneAudit.this.i));
                                        valuePair.setData(x.getSerial());
                                        observableList.add((Object)valuePair);
                                    });
                                    JFXDialog dialog = new JFXDialog();
                                    dialog.setDialogContainer(SalesReturnPaneAudit.this.stackPane);
                                    dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
                                    dialog.setContent((Region)new SerialView(SalesReturnPaneAudit.this.santa, dialog, req.getItemName(), (ObservableList<NameValueObject>)observableList));
                                    dialog.setOverlayClose(false);
                                    dialog.show();
                                });
                                this.setGraphic((Node)this.lbl);
                            } else {
                                this.setGraphic(null);
                            }
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colSerial.setCellFactory((Callback)cellFactoryVieSerial);
        this.btnApprove.setVisible(false);
        Comparator<Store> comparatorMyObject_Name = new Comparator<Store>(){

            @Override
            public int compare(Store o1, Store o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        Collections.sort(this.storeDataList.getOriginalList(), comparatorMyObject_Name);
        this.resyncSale.setVisible(false);
        Store store = new Store(this.da);
        store.setCode("-1");
        store.setName("All");
        this.storeDataList.getOriginalList().add(0, (Object)store);
        this.accontDataList = new AccountDataList(this.da);
        this.accontDataList.selectAll("Select *from Account", this.da.getEmptyParameterValues());
        Comparator<Account> comparatorMyObject_Name_Account = new Comparator<Account>(){

            @Override
            public int compare(Account o1, Account o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        };
        Collections.sort(this.accontDataList.getOriginalList(), comparatorMyObject_Name_Account);
        this.cmbStore.setItems(this.storeDataList.getOriginalList());
        this.cmbStore.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            }
        });
        this.cmbStore.setItems(this.storeDataList.getOriginalList());
        this.cmbStore.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            }
        });
        this.lblSap.setText("");
        this.lblCusPno.setText("");
        this.lblcusName.setText("");
        Circle circle = new Circle(15.0, 15.0, 42.0);
        Tooltip tp = new Tooltip("Search by the following\nName\nPhone Number\nInvoice Number\nStaff");
        Tooltip.install((Node)circle, (Tooltip)tp);
        if (this.santa.Products.isEmpty()) {
            try {
                this.santa.Products.addAll(StockItemList.selectAllYuProducts(this.da));
            }
            catch (SQLException ex) {
                Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.colRet.setCellValueFactory((Callback)new PropertyValueFactory("returnQty"));
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        Callback itemCodeFactory = param -> new CustomEditableTableColumnsSaleItemItemCodeAutocomplete(this.santa.Products);
        this.colItemCode.setCellFactory(itemCodeFactory);
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colDescription.setCellFactory(param -> {
            TableCell<SaleItem, String> cell = new TableCell<SaleItem, String>(){

                public void updateItem(String value, boolean empty) {
                    if (value != null) {
                        Label lbl = new Label(value);
                        SaleItem item = (SaleItem)this.getTableRow().getItem();
                        if (item != null) {
                            Tooltip tooltip = new Tooltip(item.serialToolTipProperty());
                            lbl.setTooltip(tooltip);
                        }
                        this.setGraphic((Node)lbl);
                    }
                }
            };
            return cell;
        });
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("sellingPrice"));
        this.colAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountPaid"));
        this.colStore.setCellValueFactory((Callback)new PropertyValueFactory("storeName"));
        Callback<TableColumn<SaleItem, String>, TableCell<SaleItem, String>> cellFactorycolLineStatus = new Callback<TableColumn<SaleItem, String>, TableCell<SaleItem, String>>(){

            public TableCell call(TableColumn<SaleItem, String> param) {
                TableCell<SaleItem, String> cell = new TableCell<SaleItem, String>(){
                    final Label lbl = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            SaleItem req = (SaleItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getLineStatus().isEmpty()) {
                                if (req.getLineStatus().equals("Invoiced")) {
                                    this.lbl.setStyle("-fx-background-color:#CCFFFF;-fx-font-size: 12.0px;");
                                } else {
                                    this.lbl.setStyle("-fx-background-color:#FC02DD;-fx-font-size: 12.0px;");
                                }
                                this.lbl.setText(req.getLineStatus());
                                this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                                this.setGraphic((Node)this.lbl);
                                this.setAlignment(Pos.CENTER);
                                this.setGraphic((Node)this.lbl);
                            } else {
                                this.setGraphic(null);
                            }
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colLineStatus.setCellFactory((Callback)cellFactorycolLineStatus);
        Callback storeNameFactory = param -> new CustomEditableTableColumnsSaleItemStorenameAutocomplete((List<Store>)this.storeDataList.getOriginalList(), this.listview.getSelectionModel().getSelectedItem() != null ? ((Sale)this.listview.getSelectionModel().getSelectedItem()).getStoreCode() : "");
        this.colStore.setCellFactory(storeNameFactory);
        this.colAccName.setCellValueFactory((Callback)new PropertyValueFactory("accountName"));
        Callback accNameFactory = param -> new CustomEditableTableColumnsAutocomplete((List<Account>)this.accontDataList.getOriginalList());
        this.colAccName.setCellFactory(accNameFactory);
        this.colAccNo.setCellValueFactory((Callback)new PropertyValueFactory("accNumber"));
        this.colAccType.setCellValueFactory((Callback)new PropertyValueFactory("accType"));
        this.colpaycode.setCellValueFactory((Callback)new PropertyValueFactory("paymentCode"));
        this.listview.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Sale>(){

            public void changed(ObservableValue<? extends Sale> observable, Sale oldValue, Sale newValue) {
                if (newValue != null) {
                    SalesReturnPaneAudit.this.oldselectedSale = oldValue;
                    SalesReturnPaneAudit.this.Total = 0.0;
                    newValue.getPayments().getOriginalList().forEach(val -> {
                        SalesReturnPaneAudit.this.Total = SalesReturnPaneAudit.this.Total + val.getAmountPaid();
                    });
                    SalesReturnPaneAudit.this.totCaption.setText("Total:" + General.toNaira());
                    SalesReturnPaneAudit.this.lblTotal.setText(General.formatDecimalToMoneyString(newValue.getAmountPaid()));
                    SalesReturnPaneAudit.this.lblVoucherCode.setText(newValue.getPromoVoucher());
                    SalesReturnPaneAudit.this.lblVoucherAmt.setText(General.toNaira() + General.formatDecimalToMoneyString(newValue.getPromoVoucherAmt()));
                    if (!newValue.getIsManual().booleanValue() && newValue.getSyncError().isEmpty()) {
                        SalesReturnPaneAudit.this.resyncSale.setVisible(false);
                        SalesReturnPaneAudit.this.btnApprove.setVisible(false);
                    } else if (newValue.approvingUser.isEmpty()) {
                        SalesReturnPaneAudit.this.btnApprove.setVisible(true);
                        SalesReturnPaneAudit.this.resyncSale.setVisible(false);
                    } else {
                        SalesReturnPaneAudit.this.resyncSale.setVisible(true);
                        SalesReturnPaneAudit.this.btnApprove.setVisible(false);
                    }
                }
                SalesReturnPaneAudit.this.loadSaleItems();
            }
        });
        this.listview.setCellFactory((Callback)new Callback<ListView<Sale>, ListCell<Sale>>(){

            public ListCell<Sale> call(ListView<Sale> param) {
                Label leadLbl = new Label();
                final Tooltip tooltip = new Tooltip();
                ListCell<Sale> cell = new ListCell<Sale>(){

                    public void updateItem(Sale sale, boolean empty) {
                        super.updateItem((Object)sale, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            GridPane grid = new GridPane();
                            grid.setHgap(10.0);
                            grid.setVgap(4.0);
                            grid.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
                            Label icon = new Label();
                            if (sale.getSyncError().isEmpty()) {
                                if (sale.getIsManual().booleanValue() && sale.postingUser.isEmpty() && sale.approvingUser.isEmpty()) {
                                    icon.setGraphic((Node)SalesReturnPaneAudit.this.fontAwesome.create((Enum)FontAwesome.Glyph.PAUSE).color(Color.BLUE).size(20.0));
                                } else if (sale.postingUser.isEmpty() && sale.approvingUser.isEmpty() && !sale.getIsManual().booleanValue()) {
                                    icon.setGraphic((Node)SalesReturnPaneAudit.this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK_CIRCLE).color(Color.GREEN).size(20.0));
                                } else if (sale.postingUser.isEmpty() && !sale.approvingUser.isEmpty() && sale.getIsManual().booleanValue()) {
                                    icon.setGraphic((Node)SalesReturnPaneAudit.this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK_CIRCLE).color(Color.PURPLE).size(20.0));
                                } else if (!sale.postingUser.isEmpty()) {
                                    icon.setGraphic((Node)SalesReturnPaneAudit.this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK_CIRCLE).color(Color.GREENYELLOW).size(20.0));
                                }
                            } else {
                                icon.setGraphic((Node)SalesReturnPaneAudit.this.fontAwesome.create((Enum)FontAwesome.Glyph.TIMES_CIRCLE).color(Color.RED).size(20.0));
                            }
                            String cachelisticon = " -fx-text-fill: #444444;-fx-font: bold; -fx-effect: dropshadow( three-pass-box, rgba(0,0,0,0.4), 3, 0.0, 1, 1);";
                            icon.getStyleClass().add((Object)cachelisticon);
                            grid.add((Node)icon, 0, 0, 1, 4);
                            Label name = new Label("Invoice Number:" + sale.getHdInvoiceNo());
                            name.setStyle("-fx-background-color:#4FC4F6;-fx-text-fill:white;");
                            name.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                            name.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)11.0));
                            grid.add((Node)name, 1, 0);
                            Label dockNum = new Label("SAP Number:" + sale.getSaleId());
                            grid.add((Node)dockNum, 1, 1);
                            Label dateLabel = new Label("Transaction Date:" + new SimpleDateFormat("dd-MM-yyyy").format(sale.getNewDate()));
                            dateLabel.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.NORMAL, (double)11.0));
                            grid.add((Node)dateLabel, 1, 2);
                            Label creditDescription = new Label((String)(sale.getCreditDescription().isEmpty() ? "Credit/Voucher Desc.: No Credit" : "Credit/Voucher Desc.: " + sale.getCreditDescription()));
                            creditDescription.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.NORMAL, (double)11.0));
                            grid.add((Node)creditDescription, 1, 3);
                            Label creditToken = new Label((String)(sale.getCreditToken().isEmpty() ? "Credit/Voucher Token: No Token" : "Credit Token: " + sale.getCreditToken()));
                            grid.add((Node)creditToken, 1, 4);
                            if (!sale.getCreditToken().isEmpty()) {
                                creditToken.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)11.0));
                            } else {
                                creditToken.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.NORMAL, (double)11.0));
                            }
                            Label dt = new Label(sale.getSyncError().isEmpty() ? (sale.postingUser.isEmpty() ? (sale.getIsManual().booleanValue() ? (sale.approvingUser.isEmpty() ? "Pending audit approval" : "Pending  posting") : "Successfuly posted") : "Successfuly posted") : "Failed");
                            grid.add((Node)dt, 1, 5);
                            if (sale.getSyncError().isEmpty()) {
                                if (sale.getIsManual().booleanValue() && sale.postingUser.isEmpty() && sale.approvingUser.isEmpty()) {
                                    tooltip.setText("Pending as a result of manual sale");
                                } else if (sale.postingUser.isEmpty() && sale.approvingUser.isEmpty() && !sale.getIsManual().booleanValue()) {
                                    tooltip.setText("Successfuly posted to SAP");
                                } else if (sale.postingUser.isEmpty() && !sale.approvingUser.isEmpty() && sale.getIsManual().booleanValue()) {
                                    tooltip.setText("Pending  account approval");
                                } else if (!sale.postingUser.isEmpty()) {
                                    tooltip.setText("Posted By " + sale.postingUser + "\nReviewed By " + sale.approvingUser);
                                }
                            } else {
                                tooltip.setText(sale.getSyncError());
                            }
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)grid);
                        }
                    }
                };
                return cell;
            }
        });
        Callback qtyFactory = param -> new CustomEditableTableColumnNumberFloat(this);
        Callback priceFactory = param -> new CustomEditableTableColumnNumberDouble(this);
        this.summaryRpt.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (SalesReturnPaneAudit.this.listview.getItems().size() > 0) {
                    Dialog dialog = new Dialog();
                    dialog.initStyle(StageStyle.DECORATED);
                    dialog.initOwner((Window)SalesReturnPaneAudit.this.santa.stage);
                    dialog.setTitle("Sales Report");
                    dialog.setResizable(true);
                    try {
                        ReportPane.FromDt = java.sql.Date.valueOf((LocalDate)SalesReturnPaneAudit.this.fromDate.getValue());
                        ReportPane.ToDt = java.sql.Date.valueOf((LocalDate)SalesReturnPaneAudit.this.toDate.getValue());
                        dialog.getDialogPane().setContent((Node)new ReportPane(SalesReturnPaneAudit.this.santa, ReportType.AuditDailySalesByAccount, null, (ObservableList<Sale>)SalesReturnPaneAudit.this.listview.getItems(), ((Store)SalesReturnPaneAudit.this.cmbStore.getSelectionModel().getSelectedItem()).getName()));
                    }
                    catch (JRException ex) {
                        Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                    dialog.show();
                }
            }
        });
        this.detailRpt.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (SalesReturnPaneAudit.this.listview.getItems().size() > 0) {
                    Dialog dialog = new Dialog();
                    dialog.initStyle(StageStyle.DECORATED);
                    dialog.initOwner((Window)SalesReturnPaneAudit.this.santa.stage);
                    dialog.setTitle("Sales Report");
                    dialog.setResizable(true);
                    try {
                        ReportPane.FromDt = java.sql.Date.valueOf((LocalDate)SalesReturnPaneAudit.this.fromDate.getValue());
                        ReportPane.ToDt = java.sql.Date.valueOf((LocalDate)SalesReturnPaneAudit.this.toDate.getValue());
                        dialog.getDialogPane().setContent((Node)new ReportPane(SalesReturnPaneAudit.this.santa, ReportType.DailySalesSummary, null, (ObservableList<Sale>)SalesReturnPaneAudit.this.listview.getItems(), ((Store)SalesReturnPaneAudit.this.cmbStore.getSelectionModel().getSelectedItem()).getName()));
                    }
                    catch (JRException ex) {
                        Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                    dialog.show();
                }
            }
        });
        this.btnApprove.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (SalesReturnPaneAudit.this.cmbStore.getSelectionModel().getSelectedItem() != null && !((Store)SalesReturnPaneAudit.this.cmbStore.getSelectionModel().getSelectedItem()).getCode().equals("-1")) {
                    if (SalesReturnPaneAudit.this.listview.getSelectionModel().getSelectedItem() != null) {
                        MaskerPane maskerPane = new MaskerPane();
                        JFXProgressBar progressIndicator = new JFXProgressBar();
                        progressIndicator.setProgress(-1.0);
                        final VBox box = new VBox(new Node[]{progressIndicator});
                        box.setAlignment(Pos.CENTER);
                        SalesReturnPaneAudit.this.progressContainer = box;
                        SalesReturnPaneAudit.this.stackPane.getChildren().add((Object)box);
                        Service service = new Service(){

                            protected Task createTask() {
                                return new Task(){

                                    protected Object call() throws Exception {
                                        SalesReturnPaneAudit.this.approve();
                                        Platform.runLater(() -> SalesReturnPaneAudit.this.stackPane.getChildren().remove((Object)box));
                                        return null;
                                    }
                                };
                            }
                        };
                        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                        service.start();
                    } else {
                        SalesReturnPaneAudit.this.mainPage.showNotification(NotificationType.Error, "Please select sale to approve", SalesReturnPaneAudit.this);
                    }
                } else {
                    SalesReturnPaneAudit.this.mainPage.showNotification(NotificationType.Error, "Please Valid Store", SalesReturnPaneAudit.this);
                }
            }
        });
        this.resyncSale.setOnAction(v -> {
            try {
                if (this.cmbStore.getSelectionModel().getSelectedItem() != null && !((Store)this.cmbStore.getSelectionModel().getSelectedItem()).getCode().equals("-1")) {
                    this.errormsg = "";
                    this.listview.getSelectionModel().getSelectedItems().forEach(sa -> {
                        if (sa.getAmountPaid() == 0.0) {
                            this.errormsg = this.errormsg + "Sale ( " + sa.getHdInvoiceNo() + " ) total amount not equal to payment total,";
                        }
                    });
                    if (this.errormsg.isEmpty()) {
                        MaskerPane maskerPane = new MaskerPane();
                        JFXProgressBar progressIndicator = new JFXProgressBar();
                        progressIndicator.setProgress(-1.0);
                        final VBox box = new VBox(new Node[]{progressIndicator});
                        box.setAlignment(Pos.CENTER);
                        this.progressContainer = box;
                        this.stackPane.getChildren().add((Object)box);
                        Service service = new Service(){

                            protected Task createTask() {
                                return new Task(){

                                    protected Object call() throws Exception {
                                        SalesReturnPaneAudit.this.resync();
                                        Platform.runLater(() -> SalesReturnPaneAudit.this.stackPane.getChildren().remove((Object)box));
                                        return null;
                                    }
                                };
                            }
                        };
                        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                        service.start();
                    } else {
                        Platform.runLater(() -> this.mainPage.showNotification(NotificationType.Error, this.errormsg, this));
                    }
                } else {
                    Platform.runLater(() -> this.mainPage.showNotification(NotificationType.Error, "Please Valid Store", this));
                }
            }
            catch (Exception ex) {
                Platform.runLater(() -> {
                    System.out.println(ex.getMessage());
                    this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
                });
            }
        });
        this.SearchButton.setOnAction(v -> {
            if (this.cmbStore.getSelectionModel().getSelectedItem() != null) {
                MaskerPane maskerPane = new MaskerPane();
                JFXProgressBar progressIndicator = new JFXProgressBar();
                progressIndicator.setProgress(-1.0);
                final VBox box = new VBox(new Node[]{progressIndicator});
                box.setAlignment(Pos.CENTER);
                this.progressContainer = box;
                this.stackPane.getChildren().add((Object)box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                if (SalesReturnPaneAudit.this.textAreaInvoice.getText().isEmpty()) {
                                    SalesReturnPaneAudit.this.Search(false);
                                } else {
                                    SalesReturnPaneAudit.this.SearchWithInvoice();
                                }
                                Platform.runLater(() -> SalesReturnPaneAudit.this.stackPane.getChildren().remove((Object)box));
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            } else {
                this.mainPage.showNotification(NotificationType.Error, "Please Select Store", this);
            }
        });
        this.btnApprove.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(15.0));
        this.resyncSale.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(15.0));
    }

    void approve() {
        try {
            Sale sa = (Sale)this.listview.getSelectionModel().getSelectedItem();
            Object url = ((SyncSetting)this.syncSettingDataList.getOriginalList().get(0)).getBEURL();
            url = (String)url + "RSaleOrder/ApproveSales";
            JSONArray jSONArray = new JSONArray();
            List sales = this.listview.getSelectionModel().getSelectedItems().stream().filter(p -> p.getIsManual() != false || !p.getSyncError().isEmpty()).collect(Collectors.toList());
            for (Sale sale1 : sales) {
                JSONObject param = new JSONObject();
                param.put("StoreCode", (Object)((Store)this.cmbStore.getSelectionModel().getSelectedItem()).getCode());
                param.put("InvoiceNumber", (Object)sale1.getHdInvoiceNo());
                param.put("ApprovingUser", (Object)this.mainPage.currentUser.getUserName());
                param.put("Comment", (Object)sale1.getApprovingComment());
                jSONArray.put((Object)param);
            }
            HttpPost httpPost = new HttpPost((String)url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            StringEntity stringEntity = new StringEntity(jSONArray.toString());
            httpPost.setEntity((HttpEntity)stringEntity);
            httpPost.setHeader("Content-type", "application/json");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                this.Search(true);
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                Platform.runLater(() -> this.mainPage.showNotification(NotificationType.Error, stringBuilder.toString(), this));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void resync() {
        try {
            String output;
            StringBuilder stringBuilder;
            BufferedReader br;
            Object url = ((SyncSetting)this.syncSettingDataList.getOriginalList().get(0)).getBEURL();
            url = (String)url + "RSaleOrder/SyncManualSales";
            JSONArray jSONArray = new JSONArray();
            List sales = this.listview.getSelectionModel().getSelectedItems().stream().filter(p -> p.approvingUser != null && !p.approvingUser.isEmpty()).collect(Collectors.toList());
            for (Sale sa : sales) {
                Object item2;
                JSONObject param = new JSONObject();
                param.put("InvoiceNumber", (Object)sa.getHdInvoiceNo());
                param.put("SAPDocNum", (Object)sa.getSaleId());
                JSONObject jsCustomer = new JSONObject();
                jsCustomer.put("Name", (Object)sa.getParentCustomer().getName());
                jsCustomer.put("Email", (Object)"");
                jsCustomer.put("SAPCode", (Object)sa.getParentCustomer().getD365Code());
                jsCustomer.put("PhoneNo", (Object)sa.getParentCustomer().getPhoneNumber());
                jsCustomer.put("Code", (Object)"");
                jsCustomer.put("StoreCode", (Object)((Store)this.cmbStore.getSelectionModel().getSelectedItem()).getCode());
                param.put("Customer", (Object)jsCustomer);
                param.put("StoreCode", (Object)((Store)this.cmbStore.getSelectionModel().getSelectedItem()).getCode());
                param.put("Discount", sa.getPromoVoucherAmt());
                param.put("StoreUser", (Object)sa.getSaleStaffResponsible());
                param.put("SalesResponsible", sa.isB2BProperty().get() ? Integer.valueOf(Integer.parseInt(sa.getSalesRep())) : null);
                param.put("PostingUser", (Object)this.mainPage.currentUser.getUserName());
                param.put("IsManual", (Object)sa.getIsManual());
                param.put("CreditDescription", (Object)sa.getCreditDescription());
                param.put("CreditToken", (Object)sa.getCreditToken());
                param.put("Comment", (Object)sa.getSaleComment());
                param.put("SaleDate", (Object)sa.getNewDate());
                param.put("Location", (Object)sa.getLocationCode());
                param.put("Channel", (Object)sa.getSalesChannel());
                param.put("Amount", sa.getAmountPaid());
                param.put("PromoVoucher", (Object)sa.getPromoVoucher());
                JSONArray jsObjectArray = new JSONArray();
                for (Object item2 : sa.getSaleItemsList()) {
                    JSONObject jsItem = new JSONObject();
                    jsItem.put("ItemCode", (Object)((SaleItem)item2).getItemCode());
                    jsItem.put("Qty", ((SaleItem)item2).getTotalQty());
                    jsItem.put("UnitPrice", ((SaleItem)item2).getSellingPrice());
                    jsItem.put("Discount", 0);
                    jsItem.put("ItemName", (Object)((SaleItem)item2).getItemName());
                    jsItem.put("CostCentre", (Object)((SaleItem)item2).costCentre);
                    jsItem.put("Code", (Object)((SaleItem)item2).getCode());
                    jsItem.put("CostPrice", ((SaleItem)item2).getCostPrice());
                    jsItem.put("StoreCode", ((SaleItem)item2).getStoreCode() == null || ((SaleItem)item2).getStoreCode().equals("NULL") ? null : ((SaleItem)item2).getStoreCode());
                    jsItem.put("Channel", (Object)((SaleItem)item2).channel);
                    JSONArray jaArraySerial = new JSONArray();
                    ((SaleItem)item2).getSerials().getOriginalList().forEach(v -> {
                        try {
                            JSONObject jSONObject = new JSONObject();
                            jSONObject.put("ItemCode", (Object)v.getItemCode());
                            jSONObject.put("Serial", (Object)v.getSerial());
                            jSONObject.put("Quantity", (Object)"1");
                            jSONObject.put("SysSerial", (double)v.getSysSerial());
                            jSONObject.put("Status", (Object)v.getStatus());
                            jSONObject.put("WhsCode", (Object)v.getWhscode());
                            jaArraySerial.put((Object)jSONObject);
                        }
                        catch (JSONException ex) {
                            Logger.getLogger(SyncData.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    });
                    jsItem.put("Serials", (Object)jaArraySerial);
                    jsObjectArray.put((Object)jsItem);
                }
                param.put("LineItems", (Object)jsObjectArray);
                JSONArray payementArray = new JSONArray();
                item2 = sa.getPayments().getOriginalList().iterator();
                while (item2.hasNext()) {
                    SaleAccountDetailResolver sadr = (SaleAccountDetailResolver)item2.next();
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("AccountNumber", (Object)sadr.getAccNumber());
                    jSONObject.put("AmountPaid", sadr.getAmountPaid());
                    jSONObject.put("AccountType", (Object)sadr.getAccType());
                    payementArray.put((Object)jSONObject);
                }
                param.put("PaymentDetails", (Object)payementArray);
                jSONArray.put((Object)param);
            }
            HttpPost httpPost = new HttpPost((String)url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            File f = Santa.writePayLoadToFileAll(jSONArray.toString());
            HttpEntity reqEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("payload", f, ContentType.DEFAULT_BINARY, f.getName()).build();
            httpPost.setEntity(reqEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 200) {
                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONObject ra = new JSONObject(result);
                this.Search(true);
            } else {
                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                Platform.runLater(() -> this.mainPage.showNotification(NotificationType.Error, stringBuilder.toString(), this));
            }
        }
        catch (Exception ex) {
            Platform.runLater(() -> this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this));
        }
    }

    void Search(boolean isReload) {
        this.saleList.getOriginalList().clear();
        this.oldselectedSale = null;
        String url = ((SyncSetting)this.syncSettingDataList.getOriginalList().get(0)).getBEURL();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LocalDateTime Strtdatetime = LocalDate.of(((LocalDate)this.fromDate.getValue()).getYear(), ((LocalDate)this.fromDate.getValue()).getMonth().getValue(), ((LocalDate)this.fromDate.getValue()).getDayOfMonth()).atTime(0, 0, 0);
        LocalDateTime Enddatetime = LocalDate.of(((LocalDate)this.toDate.getValue()).getYear(), ((LocalDate)this.toDate.getValue()).getMonth().getValue(), ((LocalDate)this.toDate.getValue()).getDayOfMonth()).atTime(23, 59, 0);
        String fromDt = format.format(java.sql.Date.from(Strtdatetime.atZone(ZoneId.systemDefault()).toInstant()));
        String toDt = format.format(java.sql.Date.from(Enddatetime.atZone(ZoneId.systemDefault()).toInstant()));
        HttpGet httpget = null;
        try {
            httpget = new HttpGet(url + "RSaleOrder/GetStoreSales");
            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
            BasicNameValuePair param1 = new BasicNameValuePair("storeCode", ((Store)this.cmbStore.getSelectionModel().getSelectedItem()).getCode() == "-1" ? null : ((Store)this.cmbStore.getSelectionModel().getSelectedItem()).getCode());
            listParam.add(param1);
            BasicNameValuePair param2 = new BasicNameValuePair("start", fromDt);
            listParam.add(param2);
            BasicNameValuePair param3 = new BasicNameValuePair("end", toDt);
            listParam.add(param3);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            URI uri = new URIBuilder(httpget.getURI()).addParameters(listParam).build();
            httpget.setURI(uri);
            httpget.setHeader("Content-type", "application/json");
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpget);
            if (response.getStatusLine().getStatusCode() == 200) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                client.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray ra = new JSONArray(result);
                for (int i = 0; i < ra.length(); ++i) {
                    JSONObject jo = ra.getJSONObject(i);
                    Sale sa = new Sale(this.da);
                    sa.setHdInvoiceNo(jo.isNull("InvoiceNumber") ? "" : jo.getString("InvoiceNumber"));
                    sa.setStoreCode(jo.isNull("StoreCode") ? "" : jo.getString("StoreCode").toUpperCase());
                    Store str = this.storeDataList.getOriginalList().stream().filter(p -> p.getCode().equalsIgnoreCase(sa.getStoreCode())).findAny().orElse(null);
                    if (str != null) {
                        sa.storeName = str.getName();
                    }
                    sa.setSaleStaffResponsible(jo.isNull("StoreUser") ? "" : jo.getString("StoreUser"));
                    sa.setDiscount(jo.isNull("Discount") ? 0.0 : jo.getDouble("Discount"));
                    sa.setSaleStaffResponsible(jo.isNull("StoreUser") ? "" : jo.getString("StoreUser"));
                    sa.setSalesRep(jo.has("SalesResponsible") ? (jo.isNull("SalesResponsible") ? "" : jo.getString("SalesResponsible")) : "");
                    sa.setIsManual(jo.isNull("IsManual") ? false : jo.getBoolean("IsManual"));
                    String string = jo.has("PostingUser") ? (jo.isNull("PostingUser") ? "" : jo.getString("PostingUser")) : (sa.postingUser = "");
                    sa.setSyncError(jo.has("ErrMessage") ? (jo.isNull("ErrMessage") ? "" : jo.getString("ErrMessage")) : "");
                    sa.setSaleComment(jo.has("Comment") ? (jo.isNull("Comment") ? "" : jo.getString("Comment")) : "");
                    sa.setApprovingComment(jo.has("ApprovalComment") ? (jo.isNull("ApprovalComment") ? "" : jo.getString("ApprovalComment")) : "");
                    sa.approvingUser = jo.has("ApprovingUser") ? (jo.isNull("ApprovingUser") ? "" : jo.getString("ApprovingUser")) : "";
                    Customer cust = new Customer(this.da);
                    sa.setSaleId(jo.has("SAPDocNum") ? (jo.isNull("SAPDocNum") ? "" : jo.getString("SAPDocNum")) : "");
                    sa.setLocationCode(jo.has("Location") ? (jo.isNull("Location") ? "" : jo.getString("Location")) : "");
                    sa.setSalesChannel(jo.has("Channel") ? (jo.isNull("Channel") ? "" : jo.getString("Channel")) : "");
                    sa.setAmountPaid(jo.isNull("Amount") ? 0.0 : jo.getDouble("Amount"));
                    sa.setPromoVoucherAmt(jo.isNull("Discount") ? 0.0 : jo.getDouble("Discount"));
                    sa.setPromoVoucher(jo.isNull("PromoVoucher") ? "" : jo.getString("PromoVoucher"));
                    if (jo.has("SaleDate") && !jo.isNull("SaleDate")) {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                        Date dt = df.parse(jo.getString("SaleDate"));
                        sa.dateProperty().set((Object)new Timestamp(new Date().getTime()));
                    }
                    sa.setCreditDescription(jo.isNull("CreditDescription") ? "" : jo.getString("CreditDescription"));
                    sa.setCreditToken(jo.isNull("CreditToken") ? "" : jo.getString("CreditToken"));
                    JSONObject jCust = jo.getJSONObject("Customer");
                    cust.setName(jCust.isNull("Name") ? "" : jCust.getString("Name"));
                    cust.setEmail(jCust.isNull("Email") ? "" : jCust.getString("Email"));
                    cust.setD365Code(jCust.isNull("SAPCode") ? "" : jCust.getString("SAPCode"));
                    cust.setPhoneNumber(jCust.isNull("PhoneNo") ? "" : jCust.getString("PhoneNo"));
                    cust.setCode(jCust.isNull("Code") ? "" : jCust.getString("Code"));
                    cust.setStoreCode(jCust.isNull("StoreCode") ? "" : jCust.getString("StoreCode"));
                    sa.setCustomer(cust);
                    JSONArray jsonArray = jo.getJSONArray("LineItems");
                    for (int j = 0; j < jsonArray.length(); ++j) {
                        SaleItem saleItem = new SaleItem(this.da);
                        saleItem.setParentSale(sa);
                        saleItem.setItemCode(jsonArray.getJSONObject(j).isNull("ItemCode") ? "" : jsonArray.getJSONObject(j).getString("ItemCode"));
                        saleItem.setQuantity(jsonArray.getJSONObject(j).isNull("Qty") ? 0.0f : (float)jsonArray.getJSONObject(j).getDouble("Qty"));
                        saleItem.setSellingPrice(jsonArray.getJSONObject(j).isNull("UnitPrice") ? 0.0 : jsonArray.getJSONObject(j).getDouble("UnitPrice"));
                        saleItem.setCostPrice((float)(jsonArray.getJSONObject(j).isNull("CostPrice") ? 0.0 : jsonArray.getJSONObject(j).getDouble("CostPrice")));
                        saleItem.setCode(jsonArray.getJSONObject(j).isNull("Code") ? "" : jsonArray.getJSONObject(j).getString("Code"));
                        saleItem.setStoreCode(jsonArray.getJSONObject(j).isNull("StoreCode") ? "" : jsonArray.getJSONObject(j).getString("StoreCode").toUpperCase());
                        saleItem.channel = jsonArray.getJSONObject(j).isNull("Channel") ? "" : jsonArray.getJSONObject(j).getString("Channel");
                        saleItem.costCentre = jsonArray.getJSONObject(j).isNull("CostCentre") ? "" : jsonArray.getJSONObject(j).getString("CostCentre");
                        Store store = this.storeDataList.getOriginalList().stream().filter(f -> f.getCode().equalsIgnoreCase(saleItem.getStoreCode())).findAny().orElse(null);
                        if (store != null) {
                            saleItem.storeNameProperty().set((Object)(saleItem.getStoreCode().isEmpty() ? "" : store.getName()));
                        }
                        saleItem.setItemName(jsonArray.getJSONObject(j).isNull("ItemName") ? "" : jsonArray.getJSONObject(j).getString("ItemName"));
                        JSONArray jSONArray = jsonArray.getJSONObject(j).getJSONArray("Serials");
                        for (int k = 0; k < jSONArray.length(); ++k) {
                            JSONObject joS = jSONArray.getJSONObject(k);
                            SaleItemSerial serialItemData = new SaleItemSerial(this.da);
                            serialItemData.setItemCode(joS.isNull("ItemCode") ? "" : joS.getString("ItemCode"));
                            serialItemData.setQuantity(joS.isNull("Quantity") ? 0 : joS.getInt("Quantity"));
                            serialItemData.setSerial(joS.isNull("Serial") ? "" : joS.getString("Serial"));
                            serialItemData.setStatus(joS.isNull("Status") ? "" : joS.getString("Status"));
                            serialItemData.setSysSerial(joS.isNull("SysSerial") ? 0 : joS.getInt("SysSerial"));
                            serialItemData.setWhscode(joS.isNull("WhsCode") ? "" : joS.getString("WhsCode"));
                            saleItem.getSerials().getOriginalList().add((Object)serialItemData);
                        }
                        sa.getSaleItemsList().add((Object)saleItem);
                    }
                    JSONArray jsonArrayPayment = jo.getJSONArray("PaymentDetails");
                    for (int j = 0; j < jsonArrayPayment.length(); ++j) {
                        SaleAccountDetailResolver AccResolver = new SaleAccountDetailResolver(this.da);
                        AccResolver.setAccNumber(jsonArrayPayment.getJSONObject(j).isNull("AccountNumber") ? "" : jsonArrayPayment.getJSONObject(j).getString("AccountNumber"));
                        AccResolver.setAmountPaid(jsonArrayPayment.getJSONObject(j).isNull("AmountPaid") ? 0.0 : jsonArrayPayment.getJSONObject(j).getDouble("AmountPaid"));
                        AccResolver.setAccountName(jsonArrayPayment.getJSONObject(j).isNull("AccountName") ? "" : jsonArrayPayment.getJSONObject(j).getString("AccountName"));
                        AccResolver.setAccType(jsonArrayPayment.getJSONObject(j).has("AccountType") ? (jsonArrayPayment.getJSONObject(j).isNull("AccountType") ? "" : jsonArrayPayment.getJSONObject(j).getString("AccountType")) : "");
                        AccResolver.setPaymentCode(jsonArrayPayment.getJSONObject(j).has("PaymentCode") ? (jsonArrayPayment.getJSONObject(j).isNull("PaymentCode") ? "" : jsonArrayPayment.getJSONObject(j).getString("PaymentCode")) : "");
                        sa.getPayments().getOriginalList().add((Object)AccResolver);
                    }
                    sa.initializeListener();
                    this.saleList.getOriginalList().add((Object)sa);
                }
                Platform.runLater(() -> this.searchChanged(isReload));
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                Platform.runLater(() -> this.mainPage.showNotification(NotificationType.Error, fullError, this));
            }
        }
        catch (Exception e) {
            Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    void SearchWithInvoice() {
        this.saleList.getOriginalList().clear();
        this.oldselectedSale = null;
        String url = ((SyncSetting)this.syncSettingDataList.getOriginalList().get(0)).getBEURL();
        HttpGet httpget = null;
        try {
            httpget = new HttpGet(url + "RSaleOrder/SearchStoreSales");
            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
            BasicNameValuePair param1 = new BasicNameValuePair("storeCode", ((Store)this.cmbStore.getSelectionModel().getSelectedItem()).getCode() == "-1" ? null : ((Store)this.cmbStore.getSelectionModel().getSelectedItem()).getCode());
            listParam.add(param1);
            BasicNameValuePair param2 = new BasicNameValuePair("invoices", this.textAreaInvoice.getText());
            listParam.add(param2);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            URI uri = new URIBuilder(httpget.getURI()).addParameters(listParam).build();
            httpget.setURI(uri);
            httpget.setHeader("Content-type", "application/json");
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpget);
            if (response.getStatusLine().getStatusCode() == 200) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                client.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray ra = new JSONArray(result);
                for (int i = 0; i < ra.length(); ++i) {
                    JSONObject jo = ra.getJSONObject(i);
                    Sale sa = new Sale(this.da);
                    sa.setHdInvoiceNo(jo.isNull("InvoiceNumber") ? "" : jo.getString("InvoiceNumber"));
                    sa.setStoreCode(jo.isNull("StoreCode") ? "" : jo.getString("StoreCode"));
                    Store str = this.storeDataList.getOriginalList().stream().filter(p -> p.getCode().equalsIgnoreCase(sa.getStoreCode())).findAny().orElse(null);
                    if (str != null) {
                        sa.storeName = str.getName();
                    }
                    sa.setSaleStaffResponsible(jo.isNull("StoreUser") ? "" : jo.getString("StoreUser"));
                    sa.setDiscount(jo.isNull("Discount") ? 0.0 : jo.getDouble("Discount"));
                    sa.setSaleStaffResponsible(jo.isNull("StoreUser") ? "" : jo.getString("StoreUser"));
                    sa.setSalesRep(jo.has("SalesResponsible") ? (jo.isNull("SalesResponsible") ? "" : jo.getString("SalesResponsible")) : "");
                    sa.setIsManual(jo.isNull("IsManual") ? false : jo.getBoolean("IsManual"));
                    String string = jo.has("PostingUser") ? (jo.isNull("PostingUser") ? "" : jo.getString("PostingUser")) : (sa.postingUser = "");
                    sa.setSyncError(jo.has("ErrMessage") ? (jo.isNull("ErrMessage") ? "" : jo.getString("ErrMessage")) : "");
                    sa.setSaleComment(jo.has("Comment") ? (jo.isNull("Comment") ? "" : jo.getString("Comment")) : "");
                    sa.setApprovingComment(jo.has("ApprovalComment") ? (jo.isNull("ApprovalComment") ? "" : jo.getString("ApprovalComment")) : "");
                    sa.approvingUser = jo.has("ApprovingUser") ? (jo.isNull("ApprovingUser") ? "" : jo.getString("ApprovingUser")) : "";
                    Customer cust = new Customer(this.da);
                    sa.setSaleId(jo.has("SAPDocNum") ? (jo.isNull("SAPDocNum") ? "" : jo.getString("SAPDocNum")) : "");
                    sa.setLocationCode(jo.has("Location") ? (jo.isNull("Location") ? "" : jo.getString("Location")) : "");
                    sa.setSalesChannel(jo.has("Channel") ? (jo.isNull("Channel") ? "" : jo.getString("Channel")) : "");
                    sa.setPromoVoucherAmt(jo.isNull("Discount") ? 0.0 : jo.getDouble("Discount"));
                    sa.setPromoVoucher(jo.isNull("PromoVoucher") ? "" : jo.getString("PromoVoucher"));
                    sa.setAmountPaid(jo.isNull("Amount") ? 0.0 : jo.getDouble("Amount"));
                    if (jo.has("SaleDate") && !jo.isNull("SaleDate")) {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                        Date date = df.parse(jo.getString("SaleDate"));
                    }
                    sa.setCreditDescription(jo.isNull("CreditDescription") ? "" : jo.getString("CreditDescription"));
                    sa.setCreditToken(jo.isNull("CreditToken") ? "" : jo.getString("CreditToken"));
                    JSONObject jCust = jo.getJSONObject("Customer");
                    cust.setName(jCust.isNull("Name") ? "" : jCust.getString("Name"));
                    cust.setEmail(jCust.isNull("Email") ? "" : jCust.getString("Email"));
                    cust.setD365Code(jCust.isNull("SAPCode") ? "" : jCust.getString("SAPCode"));
                    cust.setPhoneNumber(jCust.isNull("PhoneNo") ? "" : jCust.getString("PhoneNo"));
                    cust.setCode(jCust.isNull("Code") ? "" : jCust.getString("Code"));
                    cust.setStoreCode(jCust.isNull("StoreCode") ? "" : jCust.getString("StoreCode"));
                    sa.setCustomer(cust);
                    JSONArray jsonArray = jo.getJSONArray("LineItems");
                    for (int j = 0; j < jsonArray.length(); ++j) {
                        SaleItem saleItem = new SaleItem(this.da);
                        saleItem.setParentSale(sa);
                        saleItem.setItemCode(jsonArray.getJSONObject(j).isNull("ItemCode") ? "" : jsonArray.getJSONObject(j).getString("ItemCode"));
                        saleItem.setQuantity(jsonArray.getJSONObject(j).isNull("Qty") ? 0.0f : (float)jsonArray.getJSONObject(j).getDouble("Qty"));
                        saleItem.setSellingPrice(jsonArray.getJSONObject(j).isNull("UnitPrice") ? 0.0 : jsonArray.getJSONObject(j).getDouble("UnitPrice"));
                        saleItem.setCostPrice((float)(jsonArray.getJSONObject(j).isNull("CostPrice") ? 0.0 : jsonArray.getJSONObject(j).getDouble("CostPrice")));
                        saleItem.setCode(jsonArray.getJSONObject(j).isNull("Code") ? "" : jsonArray.getJSONObject(j).getString("Code"));
                        saleItem.setStoreCode(jsonArray.getJSONObject(j).isNull("StoreCode") ? "" : jsonArray.getJSONObject(j).getString("StoreCode"));
                        saleItem.channel = jsonArray.getJSONObject(j).isNull("Channel") ? "" : jsonArray.getJSONObject(j).getString("Channel");
                        saleItem.costCentre = jsonArray.getJSONObject(j).isNull("CostCentre") ? "" : jsonArray.getJSONObject(j).getString("CostCentre");
                        Store store = this.storeDataList.getOriginalList().stream().filter(f -> f.getCode().equalsIgnoreCase(saleItem.getStoreCode())).findAny().orElse(null);
                        if (store != null) {
                            saleItem.storeNameProperty().set((Object)(saleItem.getStoreCode().isEmpty() ? "" : store.getName()));
                        }
                        saleItem.setItemName(jsonArray.getJSONObject(j).isNull("ItemName") ? "" : jsonArray.getJSONObject(j).getString("ItemName"));
                        JSONArray jSONArray = jsonArray.getJSONObject(j).getJSONArray("Serials");
                        for (int k = 0; k < jSONArray.length(); ++k) {
                            JSONObject joS = jSONArray.getJSONObject(k);
                            SaleItemSerial serialItemData = new SaleItemSerial(this.da);
                            serialItemData.setItemCode(joS.isNull("ItemCode") ? "" : joS.getString("ItemCode"));
                            serialItemData.setQuantity(joS.isNull("Quantity") ? 0 : joS.getInt("Quantity"));
                            serialItemData.setSerial(joS.isNull("Serial") ? "" : joS.getString("Serial"));
                            serialItemData.setStatus(joS.isNull("Status") ? "" : joS.getString("Status"));
                            serialItemData.setSysSerial(joS.isNull("SysSerial") ? 0 : joS.getInt("SysSerial"));
                            serialItemData.setWhscode(joS.isNull("WhsCode") ? "" : joS.getString("WhsCode"));
                            saleItem.getSerials().getOriginalList().add((Object)serialItemData);
                        }
                        sa.getSaleItemsList().add((Object)saleItem);
                    }
                    JSONArray jsonArrayPayment = jo.getJSONArray("PaymentDetails");
                    for (int j = 0; j < jsonArrayPayment.length(); ++j) {
                        SaleAccountDetailResolver AccResolver = new SaleAccountDetailResolver(this.da);
                        AccResolver.setAccNumber(jsonArrayPayment.getJSONObject(j).isNull("AccountNumber") ? "" : jsonArrayPayment.getJSONObject(j).getString("AccountNumber"));
                        AccResolver.setAmountPaid(jsonArrayPayment.getJSONObject(j).isNull("AmountPaid") ? 0.0 : jsonArrayPayment.getJSONObject(j).getDouble("AmountPaid"));
                        AccResolver.setAccountName(jsonArrayPayment.getJSONObject(j).isNull("AccountName") ? "" : jsonArrayPayment.getJSONObject(j).getString("AccountName"));
                        AccResolver.setAccType(jsonArrayPayment.getJSONObject(j).has("AccountType") ? (jsonArrayPayment.getJSONObject(j).isNull("AccountType") ? "" : jsonArrayPayment.getJSONObject(j).getString("AccountType")) : "");
                        AccResolver.setPaymentCode(jsonArrayPayment.getJSONObject(j).has("PaymentCode") ? (jsonArrayPayment.getJSONObject(j).isNull("PaymentCode") ? "" : jsonArrayPayment.getJSONObject(j).getString("PaymentCode")) : "");
                        sa.getPayments().getOriginalList().add((Object)AccResolver);
                    }
                    sa.initializeListener();
                    this.saleList.getOriginalList().add((Object)sa);
                }
                Platform.runLater(() -> this.searchChanged(false));
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                Platform.runLater(() -> this.mainPage.showNotification(NotificationType.Error, fullError, this));
            }
        }
        catch (Exception e) {
            Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    void forceUpdate() {
        Platform.runLater(() -> {
            this.listview.getItems().clear();
            this.listview.getItems().addAll(this.saleList.getOriginalList());
            this.listview.refresh();
        });
    }

    void searchChanged(boolean isreload) {
        this.forceUpdate();
        this.tbItem.getItems().clear();
        this.tbPayment.getItems().clear();
        this.grid.setVisible(false);
        if (this.saleList.getOriginalList().size() == 1) {
            this.listview.getSelectionModel().select(0);
            this.tbItem.setItems(((Sale)this.saleList.getOriginalList().get(0)).getSaleItemsList());
            this.tbItem.refresh();
            this.tbPayment.setItems(((Sale)this.saleList.getOriginalList().get(0)).getPayments().getOriginalList());
            this.tbPayment.refresh();
            this.setCustomerInfo((Sale)this.saleList.getOriginalList().get(0));
        }
        if (this.saleList.getOriginalList().isEmpty() && !isreload) {
            this.mainPage.showNotification(NotificationType.Information, (String)(this.textAreaInvoice.getText().isEmpty() ? "No Sale Found for the selected store" : "No Sale found for these invoice(s) " + this.textAreaInvoice.getText()), this);
        }
        this.cmbFilter.getSelectionModel().clearSelection();
        this.textAreaInvoice.clear();
        this.lblcount.setText(Integer.toString(this.saleList.getOriginalList().size()) + " Sales loaded");
    }

    void setCustomerInfo(Sale sale) {
        if (sale.getParentCustomer() != null) {
            this.grid.setVisible(true);
            this.lblSaleComment.setText(sale.getSaleComment());
            if (this.oldselectedSale != null) {
                this.lblAuditComent.textProperty().unbindBidirectional((Property)this.oldselectedSale.approvingCommentProperty());
                this.lblAuditComent.clear();
            }
            this.lblAuditComent.textProperty().bindBidirectional((Property)sale.approvingCommentProperty());
            this.lblSap.setText(sale.getParentCustomer().getD365Code());
            this.lblCusPno.setText(sale.getParentCustomer().getPhoneNumber());
            this.lblcusName.setText(sale.getParentCustomer().getName());
        } else {
            this.grid.setVisible(false);
        }
    }

    @Override
    public void populateSearch(String SearchValue) {
        this.tempParamValue.clear();
        this.sale = new Sale(this.da);
        this.lblTotal.setText("0.0");
        this.lblVoucherAmt.setText("");
        this.lblVoucherCode.setText("");
        this.tbItem.getItems().clear();
        this.tbPayment.getItems().clear();
        this.saleList = Sale.SearchSaleItemForSaleReturn(SearchValue, this.fromDate.getValue() != null ? java.sql.Date.valueOf((LocalDate)this.fromDate.getValue()) : null, this.toDate.getValue() != null ? java.sql.Date.valueOf((LocalDate)this.toDate.getValue()) : null, this.da, this.currentUser);
        this.listview.getItems().clear();
        this.listview.getItems().addAll(this.saleList.getOriginalList());
        if (this.saleList.getOriginalList().size() == 1) {
            this.listview.getSelectionModel().select(0);
            this.tbItem.setItems(((Sale)this.saleList.getOriginalList().get(0)).getSaleItemsList());
            this.tbItem.refresh();
            this.tbPayment.setItems(((Sale)this.saleList.getOriginalList().get(0)).getPayments().getOriginalList());
            this.tbPayment.refresh();
            this.setCustomerInfo((Sale)this.saleList.getOriginalList().get(0));
        }
        this.listview.refresh();
    }

    @Override
    public List<SearchClass> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<SearchClass>();
        }
        try {
            return SaleList.selectAutoComplete(searchString, this.da);
        }
        catch (SQLException ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<SearchClass>();
        }
    }

    @Override
    public void propertyChange() {
        this.Total = 0.0;
        ((Sale)this.listview.getSelectionModel().getSelectedItem()).getSaleItemsList().forEach(val -> {
            this.Total = this.Total + val.getSellingPrice() * (double)val.getQuantity();
        });
        ((Sale)this.listview.getSelectionModel().getSelectedItem()).setAmountPaid(this.Total);
        this.lblTotal.setText(General.formatDecimalToMoneyString(((Sale)this.listview.getSelectionModel().getSelectedItem()).getAmountPaid()));
    }

    @FXML
    private void SearchButtonOnAction(ActionEvent event) {
    }

    @FXML
    private void RefreshButtonOnAction(ActionEvent event) {
    }

    @FXML
    private void ReturnItemButtonOnAction(ActionEvent event) {
    }

    private void loadSaleItems() {
        this.tempParamValue.clear();
        this.sale = (Sale)this.listview.getSelectionModel().getSelectedItem();
        if (this.sale != null) {
            this.tbItem.setItems(this.sale.getSaleItemsList());
            this.tbItem.refresh();
            this.tbPayment.setItems(this.sale.getPayments().getOriginalList());
            this.tbPayment.refresh();
            this.setCustomerInfo(this.sale);
        }
    }

    @Override
    void no() {
        this.mainPage.isToMenu = true;
        this.closeNotification();
        this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
        this.mainPage.hbBottom.setVisible(false);
    }

    @Override
    void closeNotification() {
        this.mainPage.closeNotification();
    }

    @Override
    void completeControl() {
        this.mainPage.isToMenu = true;
    }

    static enum ReportFilterEnum {
        None,
        Pending,
        AuditApproved,
        SuccessfullyPosted,
        Failed;

    }
}

