/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.AccountDetail;
import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.CustomerPayment;
import com.xputertechnologies.santa.Employee;
import com.xputertechnologies.santa.IDBEntity;
import com.xputertechnologies.santa.ISaleCallBack;
import com.xputertechnologies.santa.IWebCallBack;
import com.xputertechnologies.santa.ManualPendingStatus;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.PendingSales;
import com.xputertechnologies.santa.RequestTypeEnum;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SaleStatus;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.WebRequest;
import com.xputertechnologies.santa.core.NotEnoughQtyException;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.AccountDetailDataList;
import com.xputertechnologies.santa.list.CustomerDataList;
import com.xputertechnologies.santa.list.CustomerPaymentDataList;
import com.xputertechnologies.santa.list.EmployeeDataList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.report.ReportType;
import com.xputertechnologies.santa.ui.AccountDetailItemPane;
import com.xputertechnologies.santa.ui.AnimationEnum;
import com.xputertechnologies.santa.ui.DlgInterface;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.ISalePane;
import com.xputertechnologies.santa.ui.MainPage;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PaymentOptionPane;
import com.xputertechnologies.santa.ui.PendingManualSaleItem;
import com.xputertechnologies.santa.ui.PromoVoucher;
import com.xputertechnologies.santa.ui.PromptDialog;
import com.xputertechnologies.santa.ui.ReportPane;
import com.xputertechnologies.santa.ui.SaleItem;
import com.xputertechnologies.santa.ui.SaleItemCart;
import com.xputertechnologies.santa.ui.SaleListItem;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.SalesReturnPaneAudit;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SearchCustomerPane;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.UIParent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.FloatStringConverter;
import javax.imageio.ImageIO;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SalesPaneB2B
extends UIParent
implements ISalePane {
    @FXML
    public StackPane stackPane;
    @FXML
    public VBox RepeatingVB;
    @FXML
    public VBox RepeatingVBAdded;
    @FXML
    private JFXComboBox<Employee> tbSalesRep;
    @FXML
    private JFXButton btnUpload;
    @FXML
    private JFXButton brnRemoveUpload;
    @FXML
    private JFXButton btnViewUplaod;
    @FXML
    private JFXTextField tbCreditToken;
    @FXML
    private JFXComboBox<String> cbCreditSale;
    @FXML
    private TextField SearchTextField;
    @FXML
    JFXComboBox<NameValueObject> cbPaymentTerm;
    @FXML
    private Button SearchButton;
    @FXML
    private ProgressIndicator pi;
    @FXML
    private Label TotalAmtTF;
    @FXML
    private ImageView sellimg;
    @FXML
    private ImageView imgCartCount;
    @FXML
    private Label nairaTotal;
    @FXML
    public FlowPane flowPane;
    @FXML
    public HBox hbSales;
    @FXML
    public HBox searchHbdivider;
    @FXML
    public HBox hbUpload;
    @FXML
    public HBox hbPayTerm;
    @FXML
    private Button MakeSaleButton;
    @FXML
    private JFXButton btnSMS;
    @FXML
    private BorderPane repeaingContainer;
    @FXML
    private ScrollPane container;
    private SaleItem saleItemUI;
    public Sale sale;
    private Customer customer;
    public StockItemList stockItemList;
    public StockItemList cartStockItemList;
    private CustomerDataList customerDataList;
    private CustomerPayment customerPayment;
    private CustomerPaymentDataList cpdl;
    private ArrayList<ParameterValue> tempParamValue = new ArrayList();
    VBox progressContainer;
    @FXML
    private VBox saleAccNameContainer;
    @FXML
    private CheckBox chkFullyPaid;
    @FXML
    private TextArea txtComment;
    StringConverter<? extends Number> fConverter = new FloatStringConverter();
    StringConverter<? extends Number> dConverter = new DoubleStringConverter();
    public PendingSales pendingSales;
    AccountDetailDataList lst;
    public Dialog<Customer> dialog;
    ObservableList<NameValueObject> channnels = FXCollections.observableArrayList();
    ObservableList<NameValueObject> paymentTerms = FXCollections.observableArrayList();
    @FXML
    public JFXListView<Sale> listManualSales;
    final String CHEQUE_TEXT = "Upload Cheque";
    boolean isResetSale = false;
    Double keepAmnthPaid = 0.0;

    public SalesPaneB2B(Santa app) throws Exception {
        super("SalesPaneB2B.fxml", app);
        this.title = "B2B Sale Page";
        this.sale = new Sale(this.da);
        this.sale.isB2BProperty().set(true);
        this.btnViewUplaod.setVisible(false);
        this.brnRemoveUpload.setVisible(false);
        this.btnUpload.setOnAction(eh -> this.uploadImage());
        List<NameValueObject> paymentModes = StockItemList.selectAllNameValue(this.da, "PaymentTerm", "PaymentTerm", "Description");
        ObservableList obPT = FXCollections.observableArrayList(paymentModes);
        this.cbPaymentTerm.setItems(obPT);
        this.btnUpload.setText("Upload Cheque");
        this.btnViewUplaod.setOnAction(eh -> {
            FlowPane bp = new FlowPane();
            bp.setOrientation(Orientation.VERTICAL);
            this.sale.img.forEach(im -> {
                ImageView imgView = new ImageView();
                imgView.setFitWidth(300.0);
                imgView.setFitHeight(300.0);
                imgView.setPreserveRatio(true);
                imgView.setImage((Image)SwingFXUtils.toFXImage((BufferedImage)im, null));
                bp.getChildren().add((Object)imgView);
            });
            this.dialog = new Dialog();
            this.dialog.initStyle(StageStyle.DECORATED);
            this.dialog.initOwner((Window)this.santa.stage);
            this.dialog.setTitle("Upload Cheque");
            this.dialog.setResizable(true);
            this.dialog.getDialogPane().setContent((Node)bp);
            this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
            this.dialog.show();
        });
        this.brnRemoveUpload.setOnAction(eh -> {
            this.sale.img = null;
            this.brnRemoveUpload.setVisible(false);
            this.btnViewUplaod.setVisible(false);
            this.btnUpload.setText("Upload Cheque");
        });
        this.cbCreditSale.setItems(General.getCredits());
        this.cbCreditSale.getSelectionModel().select(0);
        this.tbCreditToken.setVisible(this.cbCreditSale.getSelectionModel().getSelectedIndex() != 0);
        this.cbCreditSale.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.equals("No Credit")) {
                    SalesPaneB2B.this.tbCreditToken.setVisible(true);
                } else {
                    SalesPaneB2B.this.tbCreditToken.setVisible(false);
                }
            }
        });
        this.stockItemList = new StockItemList(this.da);
        this.customerDataList = new CustomerDataList(this.da);
        this.cpdl = new CustomerPaymentDataList(this.da);
        this.customerPayment = new CustomerPayment(this.da);
        this.nairaTotal.setText(General.toNaira());
        this.hbPayTerm.setVisible(false);
        this.SearchTextField.requestFocus();
        EmployeeDataList employeeDataList = new EmployeeDataList(this.da);
        employeeDataList.selectAll("Select * from Employee order by empId asc", this.da.getEmptyParameterValues());
        this.tbSalesRep.setItems(employeeDataList.getOriginalList());
        this.sale.setSalesRep("");
        this.pendingSales = new PendingSales();
        this.pendingSales.getSales().add((Object)this.sale);
        this.hbSales.getChildren().add((Object)new SaleListItem(this.sale, this, false));
        this.txtComment.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.isEmpty()) {
                    SalesPaneB2B.this.sale.setSaleComment(newValue);
                }
            }
        });
        this.TotalAmtTF.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.isEmpty()) {
                    SalesPaneB2B.this.sale.amountPaidProperty().set(Double.valueOf(newValue.replace(",", "")).doubleValue());
                }
            }
        });
        this.customerDataList.SelectAll();
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.SearchTextField, t -> {
            List<SearchClass> result = this.searchData(t.getUserText());
            return result.size() > 25 ? result.subList(0, 25) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<SearchClass>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<SearchClass> event) {
                SalesPaneB2B.this.populateSearch(((SearchClass)event.getCompletion()).getUniqueString());
            }
        });
        autoCompletionBinding.setPrefWidth(550.0);
        this.MakeSaleButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    SalesPaneB2B.this.makeSale();
                }
                catch (Exception ex) {
                    Logger.getLogger(SalesPaneB2B.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.TotalAmtTF.textProperty().bind((ObservableValue)this.sale.totalAmountBinding);
        this.tbSalesRep.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                SalesPaneB2B.this.sale.setSalesRep(((Employee)newValue).getEmpId());
            }
        });
        this.TotalAmtTF.addEventFilter(KeyEvent.KEY_TYPED, General.numeric_Validation(20));
        General.selectAll(this.SearchTextField);
        this.SearchTextField.setOnAction(v -> {
            this.sale.manualEnt = false;
            String saleMode = this.currentUser.getParentCompany().getSalesMode();
            this.stockItemList.searPrecise(this.SearchTextField.getText());
            if (this.stockItemList.getOriginalList().size() > 0) {
                if (this.getCartStockItemList() == null) {
                    this.setCartStockItemList(new StockItemList(this.da));
                }
                com.xputertechnologies.santa.SaleItem saleItem1 = this.sale.getSaleItemsList().stream().filter(si -> si.getParentStockItem().getItemCode().equals(((StockItem)this.stockItemList.getOriginalList().get(0)).getItemCode())).findAny().orElse(null);
                if (((StockItem)this.stockItemList.getOriginalList().get(0)).getQuantity() > 0.0f) {
                    if (saleItem1 == null) {
                        com.xputertechnologies.santa.SaleItem saleItem2 = ((com.xputertechnologies.santa.SaleItem)this.sale.getSaleItems(this.stockItemList.getOriginalList()).get(0)).duplicate();
                        this.sale.getSaleItemsList().add(this.sale.getSaleItemsList().size(), (Object)saleItem2);
                        this.getRepeatingVBAdded().getChildren().add((Object)new SaleItemCart(saleItem2, this));
                    } else {
                        SaleItemCart cart = this.getRepeatingVBAdded().getChildren().stream().filter(cat -> ((SaleItemCart)cat).saleItem.getParentStockItem().getItemCode().equals(saleItem1.getParentStockItem().getItemCode())).findAny().orElse(null);
                        if (cart.saleItem.getQuantity() + 1.0f <= ((StockItem)this.stockItemList.getOriginalList().get(0)).getQuantity()) {
                            cart.saleItem.setQuantity(cart.saleItem.getQuantity() + 1.0f);
                        } else {
                            this.mainPage.showNotification(NotificationType.Information, "Not enough quantity to add for item " + this.SearchTextField.getText(), this);
                        }
                    }
                } else {
                    this.mainPage.showNotification(NotificationType.Information, "Not enough quantity to add for item " + this.SearchTextField.getText(), this);
                }
            } else {
                this.mainPage.showNotification(NotificationType.Information, "No item found for " + this.SearchTextField.getText(), this);
            }
            this.SearchTextField.clear();
            this.SearchTextField.requestFocus();
        });
        this.listManualSales.setItems(this.mainPage.manualSaleList.getOriginalList());
        this.listManualSales.setCellFactory((Callback)new Callback<ListView<Sale>, ListCell<Sale>>(){

            public ListCell<Sale> call(ListView<Sale> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<Sale> cell = new ListCell<Sale>(){

                    public void updateItem(Sale s, boolean empty) {
                        super.updateItem((Object)s, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            PendingManualSaleItem node = new PendingManualSaleItem(SalesPaneB2B.this.santa, s, SalesPaneB2B.this);
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)node);
                        }
                    }
                };
                return cell;
            }
        });
        final SalesPaneB2B sp = this;
        this.listManualSales.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Sale>(){

            public void changed(ObservableValue<? extends Sale> observable, Sale oldValue, Sale newValue) {
                if (newValue != null && SalesPaneB2B.this.hbSales.getChildren().stream().filter(s -> s.getClass() == SaleListItem.class && ((SaleListItem)s).sale.getInvoiceNumber() == newValue.getInvoiceNumber()).count() == 0L) {
                    SalesPaneB2B.this.sale = newValue;
                    SalesPaneB2B.this.hbSales.getChildren().add((Object)new SaleListItem(SalesPaneB2B.this.sale, sp, true));
                    SalesPaneB2B.this.saleSelectionChanged();
                }
            }
        });
    }

    void uploadImage() {
        FileChooser fc = new FileChooser();
        FileChooser.ExtensionFilter ext1 = new FileChooser.ExtensionFilter("JPG files(*.jpg)", new String[]{"*.JPG"});
        FileChooser.ExtensionFilter ext2 = new FileChooser.ExtensionFilter("PNG files(*.png)", new String[]{"*.PNG"});
        fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{ext1, ext2});
        List files = fc.showOpenMultipleDialog((Window)this.santa.stage);
        try {
            this.sale.img.clear();
            for (File file : files) {
                BufferedImage bf = ImageIO.read(file);
                int type = bf.getType() == 0 ? 2 : bf.getType();
                bf = SalesPane.resizeImage(bf, type);
                this.sale.img.add(bf);
                this.btnViewUplaod.setVisible(true);
                this.brnRemoveUpload.setVisible(true);
                this.btnUpload.setText("Edit Cheque");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resendManualSaleMail(final Sale s) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        SyncData syncData = new SyncData(SalesPaneB2B.this.santa, SalesPaneB2B.this.da, SalesPaneB2B.this.santa.currentUser.getParentCompany());
                        syncData.resendManualSaleMail(SalesPaneB2B.this.currentUser.getParentCompany().getStoreCode(), s.getHdInvoiceNo(), new IDBEntity<String>(){

                            @Override
                            public void onError(String data) {
                                SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, data, SalesPaneB2B.this);
                                SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                            }

                            @Override
                            public void onTimeOut(String data) {
                                SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Timeout", SalesPaneB2B.this);
                                SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                            }

                            @Override
                            public void onSuccess(ObservableList<String> data) {
                                SalesPaneB2B.this.mainPage.showNotification(NotificationType.Success, "Sale with invoice number " + s.getHdInvoiceNo() + " resent for approval", SalesPaneB2B.this);
                            }
                        });
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    private void sendSMS() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        SyncData syncData = new SyncData(SalesPaneB2B.this.santa, SalesPaneB2B.this.da, SalesPaneB2B.this.santa.currentUser.getParentCompany());
                        syncData.sendSMS("", new IDBEntity<String>(){

                            @Override
                            public void onError(String data) {
                                SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, data, SalesPaneB2B.this);
                                SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                            }

                            @Override
                            public void onTimeOut(String data) {
                                SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Timeout", SalesPaneB2B.this);
                                SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                            }

                            @Override
                            public void onSuccess(ObservableList<String> data) {
                                SalesPaneB2B.this.mainPage.showNotification(NotificationType.Success, "Message Sent", SalesPaneB2B.this);
                            }
                        });
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    public void removeSale(final PendingManualSaleItem pm) {
        new PromptDialog(this.santa, "Remove Sale", "Are you sure you want to delete this sale? ", this.stackPane, new DlgInterface(){

            @Override
            public void ok() {
                try {
                    pm.sale.setSaleComment(SalesPaneB2B.this.currentUser.getUserName() + " removed sale");
                    pm.sale.setSaleStatus(SaleStatus.CANCELLED.name());
                    pm.sale.setManualSaleStatus(ManualPendingStatus.Declined.name());
                    pm.sale.setSyncFlag(true);
                    SalesPaneB2B.this.saveAndRemove(pm);
                }
                catch (Exception ex) {
                    SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), SalesPaneB2B.this);
                }
            }

            @Override
            public void cancel() {
            }
        });
    }

    public void searchAll() {
        this.populateSearch("");
    }

    @Override
    public void ValidateVoucher(final String code) {
        this.dialog.close();
        this.sale.setPromoVoucherAmt(0.0);
        this.sale.setPromoVoucher("");
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            new WebRequest(WebRequest.VALIDATE_PROMOVOUCHER + "/" + code, RequestTypeEnum.GET, null, null, new IWebCallBack(){

                                @Override
                                public void onSuccess(String data) {
                                    try {
                                        JSONArray ra = new JSONArray(data);
                                        if (ra.length() > 0) {
                                            System.out.println("JSon " + ra.toString());
                                            SalesPaneB2B.this.sale.setPromoVoucherAmt(ra.getJSONObject(0).getDouble("promoVoucherAmt"));
                                            SalesPaneB2B.this.sale.setPromoVoucher(ra.getJSONObject(0).getString("code"));
                                            SalesPaneB2B.this.sale.minAmount = ra.getJSONObject(0).getDouble("minAmt");
                                            Platform.runLater(() -> {
                                                SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                                if (SalesPaneB2B.this.sale.getAmountPaid() >= SalesPaneB2B.this.sale.minAmount) {
                                                    SalesPaneB2B.this.showPayment(true);
                                                } else {
                                                    SalesPaneB2B.this.sale.setPromoVoucherAmt(0.0);
                                                    SalesPaneB2B.this.sale.setPromoVoucher("");
                                                    SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Sorry,voucher applicable to sale of " + General.toNaira() + General.formatDecimalToMoneyString(SalesPaneB2B.this.sale.minAmount) + " and above", SalesPaneB2B.this);
                                                    SalesPaneB2B.this.showPayment(false);
                                                }
                                            });
                                        } else {
                                            Platform.runLater(() -> {
                                                SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                                SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Invalid Voucher", SalesPaneB2B.this);
                                                SalesPaneB2B.this.showPayment(false);
                                            });
                                        }
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(PromoVoucher.class.getName()).log(Level.SEVERE, null, ex);
                                        Platform.runLater(() -> {
                                            SalesPaneB2B.this.showPayment(false);
                                            SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                            SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), SalesPaneB2B.this);
                                        });
                                    }
                                }

                                @Override
                                public void onError(String data) {
                                    Platform.runLater(() -> {
                                        SalesPaneB2B.this.showPayment(false);
                                        SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, SalesPaneB2B.this);
                                    });
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    Platform.runLater(() -> {
                                        SalesPaneB2B.this.showPayment(false);
                                        SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", SalesPaneB2B.this);
                                    });
                                }
                            }).execute(false);
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                SalesPaneB2B.this.showPayment(false);
                                SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), SalesPaneB2B.this);
                                Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, e);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    @Override
    public void MarkVoucherUsed() {
        try {
            int val = SaleList.selectLastInvoiceNumber(this.da);
            val = val > 0 ? ++val : this.currentUser.getParentCompany().getLastInvoiceNumber() + 1;
            JSONObject json = new JSONObject().put("invoiceNumber", val).put("dateUsed", (Object)new Timestamp(new Date().getTime())).put("isUsed", true).put("code", (Object)this.sale.getPromoVoucher()).put("storeName", (Object)this.currentUser.getParentCompany().getStoreName()).put("customerName", (Object)this.sale.getParentCustomer().getName()).put("customerCode", (Object)this.sale.getParentCustomer().getPhoneNumber()).put("storeUser", (Object)this.currentUser.getUserName());
            new WebRequest(WebRequest.MARK_PROMOVOUCHER, RequestTypeEnum.PUT, json.toString(), null, new IWebCallBack(){

                @Override
                public void onSuccess(String data) {
                    Platform.runLater(() -> SalesPaneB2B.this.done(1));
                }

                @Override
                public void onError(String data) {
                    Platform.runLater(() -> SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, SalesPaneB2B.this));
                }

                @Override
                public void onTimeOut(String data) {
                    Platform.runLater(() -> SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", SalesPaneB2B.this));
                }
            }).execute(false);
        }
        catch (Exception ex) {
            Platform.runLater(() -> {
                Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
                this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            });
        }
    }

    @Override
    public void populateSearch(String SearchValue) {
        this.sale.manualEnt = false;
        String saleMode = this.currentUser.getParentCompany().getSalesMode();
        if (SearchValue.isEmpty()) {
            this.stockItemList.selectAll("Select * From StockItem", this.da.getEmptyParameterValues());
        } else {
            this.stockItemList = StockItem.searchStock(SearchValue, this.da);
        }
        this.RepeatingVB.getChildren().clear();
        ArrayList<SaleItem> children = new ArrayList<SaleItem>();
        if (this.stockItemList.getOriginalList().size() > 0) {
            this.RepeatingVB.getChildren().clear();
            ObservableList<com.xputertechnologies.santa.SaleItem> saleItemsss = this.sale.getSaleItems(this.stockItemList.getOriginalList());
            for (com.xputertechnologies.santa.SaleItem saleItem : saleItemsss) {
                saleItem.hasQtyProperty().set(saleItem.getParentStockItem().getQuantity() > 0.0f);
                int serial = this.sale.getSaleItems(this.stockItemList.getOriginalList()).indexOf((Object)saleItem) + 1;
                this.saleItemUI = new SaleItem(saleItem, this, saleMode, serial);
                Santa.setAnimation((Region)this.saleItemUI, (Region)this.RepeatingVB, AnimationEnum.BOTOM);
                children.add(this.saleItemUI);
            }
            this.RepeatingVB.getChildren().addAll(children);
        } else {
            this.mainPage.showNotification(NotificationType.Information, "No item found", this);
        }
    }

    @Override
    public List<SearchClass> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<SearchClass>();
        }
        try {
            if (this.tbSalesRep.isFocused()) {
                return Sale.selectAutoCompleteSaleRep(searchString, this.da);
            }
            return StockItemList.selectAutoComplete(searchString, this.da, false);
        }
        catch (SQLException ex) {
            Logger.getLogger(SalesPaneB2B.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<SearchClass>();
        }
    }

    @Override
    public void saleSelectionChanged() {
        if (this.hbSales.getChildren().size() > 2 || this.sale.saleCreated) {
            this.TotalAmtTF.textProperty().unbind();
            this.RepeatingVB.getChildren().clear();
            this.RepeatingVBAdded.getChildren().clear();
            this.txtComment.setText(this.sale.getSaleComment());
            this.sale.isMakingSale = false;
            this.hbPayTerm.setVisible(false);
            this.tbCreditToken.setVisible(false);
            for (com.xputertechnologies.santa.SaleItem saleItem : this.sale.getSaleItemsList()) {
                this.RepeatingVBAdded.getChildren().add((Object)new SaleItemCart(saleItem, this));
            }
            if (!this.sale.getPaymentTerm().isEmpty()) {
                this.hbPayTerm.setVisible(true);
                this.cbPaymentTerm.getSelectionModel().select((Object)this.cbPaymentTerm.getItems().stream().filter(prdct -> prdct.getKey().equals(this.sale.getPaymentTerm())).findAny().orElse(null));
            }
            if (!this.sale.getCreditToken().isEmpty()) {
                this.tbCreditToken.setVisible(true);
                this.tbCreditToken.setText(this.sale.getCreditToken());
            }
            this.TotalAmtTF.textProperty().bind((ObservableValue)this.sale.totalAmountBinding);
            if (this.sale.saleCreated) {
                this.txtComment.setEditable(false);
            } else {
                this.txtComment.setEditable(true);
            }
        }
    }

    public void saveAndRemove(PendingManualSaleItem pm) {
        try {
            pm.sale.setState(ObjectState.Changed);
            SaleList sl = new SaleList(this.da);
            sl.getOriginalList().add((Object)pm.sale);
            sl.update();
            this.mainPage.manualSaleList.getOriginalList().remove((Object)pm.sale);
            this.listManualSales.refresh();
            this.resetSale();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @FXML
    private void SearchButtonOnAction(ActionEvent event) {
        if (!this.SearchTextField.getText().toString().isEmpty()) {
            this.populateSearch(this.SearchTextField.getText().toString());
        }
    }

    @Override
    public void resetSale() {
        this.hbSales.getChildren().removeIf((Predicate)new Predicate<Node>(){

            @Override
            public boolean test(Node t) {
                if (t instanceof SaleListItem) {
                    return ((SaleListItem)t).sale.isSold;
                }
                return false;
            }
        });
        this.pendingSales.getSales().removeIf((Predicate)new Predicate<Sale>(){

            @Override
            public boolean test(Sale t) {
                return t.isSold;
            }
        });
        this.TotalAmtTF.textProperty().unbind();
        this.RepeatingVB.getChildren().clear();
        this.cbCreditSale.getSelectionModel().select(0);
        this.tbCreditToken.setVisible(this.cbCreditSale.getSelectionModel().getSelectedIndex() != 0);
        this.tbCreditToken.setText("");
        this.cbPaymentTerm.getSelectionModel().select(0);
        this.hbPayTerm.setVisible(false);
        this.brnRemoveUpload.setVisible(false);
        this.btnViewUplaod.setVisible(false);
        this.btnUpload.setText("Upload Cheque");
        this.RepeatingVBAdded.getChildren().clear();
        if (this.pendingSales.getSales().stream().filter(x -> x.getDescription().equals("New Sale")).findAny().orElse(null) == null) {
            this.sale = new Sale(this.da);
            this.sale.isB2BProperty().set(true);
            this.pendingSales.getSales().add((Object)this.sale);
            this.hbSales.getChildren().add((Object)new SaleListItem(this.sale, this, true));
        } else {
            this.sale = this.pendingSales.getSales().stream().filter(x -> x.getDescription().equals("New Sale")).findAny().orElse(null);
            this.sale.setB2B(true);
            if (!this.sale.getCreditToken().isEmpty()) {
                this.tbCreditToken.setVisible(true);
                this.tbCreditToken.setText(this.sale.getCreditToken());
                this.cbCreditSale.getSelectionModel().select((Object)this.sale.getCreditDescription());
            }
            if (!this.sale.getPaymentTerm().isEmpty()) {
                this.cbPaymentTerm.getSelectionModel().select((Object)new NameValueObject(this.sale.getPaymentTerm(), this.sale.getPaymentTermDescription(), this.da));
                this.hbPayTerm.setVisible(true);
            }
            if (!this.sale.img.isEmpty()) {
                this.brnRemoveUpload.setVisible(true);
                this.btnViewUplaod.setVisible(true);
                this.btnUpload.setText("Upload Cheque");
            }
        }
        this.txtComment.setText(this.sale.getSaleComment());
        this.sale.isMakingSale = false;
        this.TotalAmtTF.textProperty().unbind();
        this.TotalAmtTF.textProperty().bind((ObservableValue)this.sale.totalAmountBinding);
        this.stockItemList = new StockItemList(this.da);
        this.RepeatingVB.getChildren().clear();
        this.SearchTextField.setText("");
    }

    public void showPayment(boolean iscallback) {
        this.dialog = new Dialog();
        this.dialog.initStyle(StageStyle.UTILITY);
        this.dialog.initOwner((Window)this.santa.stage);
        this.dialog.setTitle("Payment Option");
        this.dialog.setResizable(true);
        this.dialog.getDialogPane().setContent((Node)new PaymentOptionPane(this, iscallback));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        this.dialog.show();
    }

    public void pushSale(final Sale s) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        SyncData syncData = new SyncData(SalesPaneB2B.this.santa, SalesPaneB2B.this.da, SalesPaneB2B.this.santa.currentUser.getParentCompany());
                        syncData.pushSales(null, s, "salesorder/createSalesorder", new IWebCallBack(){

                            @Override
                            public void onSuccess(String data) {
                                try {
                                    s.setManualSaleStatus(ManualPendingStatus.Pending.name());
                                    s.setState(ObjectState.Changed);
                                    SaleList saleList = new SaleList(SalesPaneB2B.this.da);
                                    saleList.getOriginalList().add((Object)s);
                                    saleList.update();
                                    SalesPaneB2B.this.listManualSales.refresh();
                                    SalesPaneB2B.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", SalesPaneB2B.this);
                                    SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                }
                                catch (Exception ex) {
                                    Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
                                }
                            }

                            @Override
                            public void onError(String data) {
                                SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, SalesPaneB2B.this);
                                SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                            }

                            @Override
                            public void onTimeOut(String data) {
                                SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", SalesPaneB2B.this);
                                SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                            }
                        });
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    public void loadSale(final Sale s) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        try {
            box.setAlignment(Pos.CENTER);
            this.progressContainer = box;
            this.stackPane.getChildren().add((Object)box);
            Service service = new Service(){

                protected Task createTask() {
                    return new Task(){

                        protected Object call() throws Exception {
                            SyncData syncData = new SyncData(SalesPaneB2B.this.santa, SalesPaneB2B.this.da, SalesPaneB2B.this.santa.currentUser.getParentCompany());
                            JSONObject jSONObject = new JSONObject().put("storeId", (Object)s.getStoreCode()).put("invoiceNumber", (Object)String.valueOf(s.getInvoiceNumber()));
                            String url = "salesorder/getSalesorder?condition=" + jSONObject.toString();
                            syncData.getSale(url, SalesPaneB2B.this.da, new ISaleCallBack(){

                                @Override
                                public void onSuccess(SaleList data) {
                                    SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                    if (data.getOriginalList().size() > 0) {
                                        SalesPaneB2B.this.replaceManualSaleAndUpdate(s, (Sale)data.getOriginalList().get(0));
                                    } else {
                                        SalesPaneB2B.this.mainPage.showNotification(NotificationType.Information, String.valueOf(s.getInvoiceNumber()) + " not found", SalesPaneB2B.this);
                                    }
                                }

                                @Override
                                public void onError(String data) {
                                    SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, SalesPaneB2B.this);
                                    SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", SalesPaneB2B.this);
                                    SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                }
                            });
                            return null;
                        }
                    };
                }
            };
            progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
            service.start();
        }
        catch (Exception ex) {
            this.stackPane.getChildren().remove((Object)box);
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void replaceManualSaleAndUpdate(Sale OldSale, Sale newSale) {
        try {
            OldSale.setApprovals(newSale.getApprovals());
            OldSale.setSalesRejectedBy(newSale.getSalesRejectedBy());
            OldSale.setSaleId(newSale.getSaleId());
            OldSale.setManualSaleStatus(newSale.getManualSaleStatus());
            OldSale.setSaleStatus(newSale.getSaleStatus());
            OldSale.setSyncFlag(newSale.getSyncFlag());
            OldSale.setState(ObjectState.Changed);
            SaleList saleList = new SaleList(this.da);
            saleList.getOriginalList().add((Object)OldSale);
            saleList.update();
            ArrayList<Sale> arr = new ArrayList<Sale>();
            arr.add(OldSale);
            this.mainPage.updateSalesList(arr);
            this.listManualSales.refresh();
        }
        catch (Exception ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void makeSale() throws Exception {
        this.mainPage.isToMenu = false;
        if (this.validateControl()) {
            if (!this.sale.getIsManual().booleanValue() && this.sale.getPaymentTerm().isEmpty() && (this.tbCreditToken.getText().isEmpty() || ((String)this.cbCreditSale.getSelectionModel().getSelectedItem()).equals("Voucher"))) {
                this.showPayment(false);
            } else {
                this.done(1);
            }
        }
    }

    @Override
    void closeNotification() {
        this.mainPage.closeNotification();
    }

    @Override
    public void showDialog(String text) {
        this.dialog = new Dialog();
        this.dialog.initStyle(StageStyle.UTILITY);
        this.dialog.initOwner((Window)this.santa.stage);
        this.dialog.setTitle("Search Customer");
        this.dialog.setResizable(true);
        this.dialog.getDialogPane().setContent((Node)new SearchCustomerPane(this, text));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        this.dialog.show();
    }

    @Override
    public void searchCustomer(final String text) {
        this.dialog.close();
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String serachText = text.charAt(0) == '0' ? text.substring(1) : text;
                            new SyncData(SalesPaneB2B.this.santa, SalesPaneB2B.this.da, SalesPaneB2B.this.currentUser.getParentCompany()).getCustomer(serachText, new IDBEntity<Customer>(){

                                @Override
                                public void onSuccess(ObservableList<Customer> data) {
                                    Platform.runLater(() -> {
                                        if (data.isEmpty()) {
                                            SalesPaneB2B.this.showDialog(null);
                                            SalesPaneB2B.this.mainPage.showNotification(NotificationType.Information, "No cutomer found", SalesPaneB2B.this);
                                        } else {
                                            SalesPaneB2B.this.showDialog(text);
                                        }
                                        SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                    });
                                }

                                @Override
                                public void onError(String data) {
                                    Platform.runLater(() -> {
                                        SalesPaneB2B.this.showDialog(null);
                                        SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, data, SalesPaneB2B.this);
                                    });
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    Platform.runLater(() -> {
                                        SalesPaneB2B.this.showDialog(null);
                                        SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                        SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, data, SalesPaneB2B.this);
                                    });
                                }
                            });
                        }
                        catch (JSONException ex) {
                            Platform.runLater(() -> {
                                SalesPaneB2B.this.showDialog(null);
                                SalesPaneB2B.this.stackPane.getChildren().remove((Object)box);
                                SalesPaneB2B.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), SalesPaneB2B.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    @Override
    public void done(int flag) {
        if (flag == 1) {
            if (this.dialog != null && this.dialog.isShowing()) {
                this.dialog.close();
            }
            this.container.setDisable(true);
            try {
                this.sale.tempPromoCode = "";
                this.sale.setSalesChannel("B2B");
                this.sale.setStoreCode(this.santa.currentUser.getParentCompany().getStoreCode());
                this.sale.storeName = this.santa.currentUser.getParentCompany().getStoreName();
                this.sale.setTransactionDate(Timestamp.valueOf(this.santa.currentUser.getParentCompany().getCurrentDay().atStartOfDay()));
                this.sale.setCostCenter(this.santa.currentUser.getParentCompany().getCostCenter());
                this.sale.setParentCompany(this.currentUser.getParentCompany());
                this.sale.setLocationCode(this.santa.currentUser.getParentCompany().getLocationCode());
                if (!((String)this.cbCreditSale.getSelectionModel().getSelectedItem()).equals("No Credit")) {
                    this.sale.setCreditDescription((String)this.cbCreditSale.getSelectionModel().getSelectedItem());
                    this.sale.setCreditToken(this.tbCreditToken.getText());
                    this.sale.setIsManual(true);
                }
                this.sale.makeSale(this.currentUser);
                if (this.sale.getHdInvoiceNo().isEmpty()) {
                    this.sale.setHdInvoiceNo(String.valueOf(this.sale.getInvoiceNumber()));
                }
                Sale saleForRpt = this.sale.CloneForInvoice();
                saleForRpt.setDbAccess(this.da);
                saleForRpt.setSaleItemsList(this.sale.getSaleItemsList());
                if (this.sale.getIsManual().booleanValue() && !this.sale.saleCreated) {
                    saleForRpt.saleCreated = true;
                    this.mainPage.manualSaleList.getOriginalList().add(0, (Object)this.sale);
                    this.listManualSales.refresh();
                    this.resetSale();
                } else {
                    if (this.sale.getIsManual().booleanValue() && this.sale.saleCreated) {
                        this.mainPage.manualSaleList.getOriginalList().remove((Object)this.sale);
                        this.listManualSales.refresh();
                    }
                    this.resetSale();
                    this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
                    this.dialog = new Dialog();
                    this.dialog.initStyle(StageStyle.DECORATED);
                    this.dialog.initOwner((Window)this.santa.stage);
                    this.dialog.setTitle("Invoice");
                    this.dialog.setResizable(true);
                    this.dialog.getDialogPane().setPrefHeight((double)Santa.dialogHeight.floatValue());
                    this.dialog.getDialogPane().setPrefWidth((double)Santa.dialogWidth.floatValue());
                    this.dialog.getDialogPane().setContent((Node)new ReportPane(this.santa, ReportType.Invoice, saleForRpt, null, null, null));
                    this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                    this.dialog.show();
                }
            }
            catch (Exception e) {
                if (NotEnoughQtyException.class == e.getClass()) {
                    this.mainPage.showNotification(NotificationType.Error, "Maximum days set for direct purchase Exceeded", this);
                }
                this.mainPage.showNotification(NotificationType.Error, e.getMessage(), this);
            }
            this.container.setDisable(false);
        }
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        this.needToSave = false;
        if (this.mainPage.isToMenu) {
            return true;
        }
        if (this.sale.getSaleItemsList().isEmpty()) {
            this.errorMessage = this.errorMessage + "No item selected to sell \n";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (this.sale.getSaleItemsList().stream().filter(p -> p.getSerials().getOriginalList().size() > 0 && p.getSerials().getOriginalList().size() != p.getTotalQty()).findAny().orElse(null) != null) {
            this.errorMessage = this.errorMessage + "One or more item(s) has serial(s) less than the quantity";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (this.sale.getSaleItemsList().stream().anyMatch(s -> s.getIsManual() == Boolean.TRUE) && (this.sale.getSaleComment() == null || this.sale.getSaleComment().isEmpty())) {
            this.errorMessage = this.errorMessage + "Please enter reason(s) for manual sale \n";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (this.sale.getParentCustomer() == null) {
            this.errorMessage = this.errorMessage + "Please select customer \n";
        }
        if (this.cbCreditSale.getSelectionModel().getSelectedIndex() > 0 && !((String)this.cbCreditSale.getSelectionModel().getSelectedItem()).equals("Others") && this.tbCreditToken.getText().isEmpty()) {
            this.errorMessage = this.errorMessage + "Please supply token for credit/voucher sale \n";
        }
        if (((String)this.cbCreditSale.getSelectionModel().getSelectedItem()).equals("Others") && this.sale.getPaymentTerm().isEmpty()) {
            this.errorMessage = this.errorMessage + "Please select payment term for the sale \n";
        }
        if (Double.valueOf(this.TotalAmtTF.getText().replace(",", "")) == 0.0 || Double.valueOf(this.TotalAmtTF.getText().replace(",", "")) < 0.0) {
            this.errorMessage = this.errorMessage + "Please specify amount recieved from the customer";
        }
        if (!this.errorMessage.equals("")) {
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        return true;
    }

    @Override
    void yes() {
        try {
            this.makeSale();
            this.mainPage.isToMenu = true;
            this.closeNotification();
            this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
            this.mainPage.hbBottom.setVisible(false);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
    }

    @Override
    void no() {
        this.mainPage.isToMenu = true;
        this.closeNotification();
        this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
        this.mainPage.hbBottom.setVisible(false);
    }

    @Override
    void completeControl() {
        this.mainPage.isToMenu = false;
        this.mainPage.showNotification(NotificationType.Warning, "Do you want to make sale for the selected item(s)", this);
    }

    private void loadAccountDetails() {
        this.lst = new AccountDetailDataList(this.da);
        this.lst.selectAll("Select * From AccountDetail ", this.da.getEmptyParameterValues());
        ArrayList<AccountDetailItemPane> children = new ArrayList<AccountDetailItemPane>();
        for (AccountDetail accountDetail : this.lst.getOriginalList()) {
            children.add(new AccountDetailItemPane(accountDetail));
        }
    }

    @Override
    public Santa getSanta() {
        return this.santa;
    }

    @Override
    public Sale getSale() {
        return this.sale;
    }

    @Override
    public HBox getHbSales() {
        return this.hbSales;
    }

    @Override
    public void setSale(Sale s) {
        this.sale = s;
        Employee selectedEmployee = this.tbSalesRep.getItems().stream().filter(val -> val.getEmpId().equals(s.getSalesRep())).findAny().orElse(null);
        if (selectedEmployee == null) {
            this.tbSalesRep.getSelectionModel().select(0);
        } else {
            this.tbSalesRep.getSelectionModel().select((Object)selectedEmployee);
        }
    }

    @Override
    public Dialog getDialog() {
        return this.dialog;
    }

    @Override
    public MainPage getMainPage() {
        return this.mainPage;
    }

    @Override
    public PendingSales getPendingSale() {
        return this.pendingSales;
    }

    @Override
    public StockItemList getCartStockItemList() {
        return this.cartStockItemList;
    }

    @Override
    public void setCartStockItemList(StockItemList stckLst) {
        this.cartStockItemList = stckLst;
    }

    @Override
    public VBox getRepeatingVBAdded() {
        return this.RepeatingVBAdded;
    }

    @Override
    public StackPane getStackPane() {
        return this.stackPane;
    }
}

