/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.AccountDetail;
import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.Employee;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.PendingSales;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.StockItemData;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.core.NotEnoughQtyException;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.AccountDetailDataList;
import com.xputertechnologies.santa.list.CustomerDataList;
import com.xputertechnologies.santa.list.CustomerPaymentDataList;
import com.xputertechnologies.santa.list.EmployeeDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.report.ReportType;
import com.xputertechnologies.santa.ui.AccountDetailItemPane;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.ISalePane;
import com.xputertechnologies.santa.ui.MainPage;
import com.xputertechnologies.santa.ui.NewRequestPane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PaymentOptionPane;
import com.xputertechnologies.santa.ui.ReportPane;
import com.xputertechnologies.santa.ui.SaleListItem;
import com.xputertechnologies.santa.ui.SalesItemAdminCard;
import com.xputertechnologies.santa.ui.SalesReturnPaneAudit;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SearchCustomerPane;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.FloatStringConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SalesPaneAdmin
extends UIParent
implements ISalePane {
    @FXML
    public StackPane stackPane;
    @FXML
    public FlowPane container;
    @FXML
    private JFXDatePicker datePick;
    @FXML
    private TextField SearchTextField;
    @FXML
    private JFXComboBox<NameValueObject> cbChannel;
    @FXML
    private JFXTextField tbCreditToken;
    @FXML
    private JFXComboBox<String> cbCreditSale;
    @FXML
    private JFXComboBox<Store> cbStore;
    @FXML
    private JFXComboBox<Employee> cbSalesResponsible;
    @FXML
    private Button SearchButton;
    @FXML
    private Button btnSetPriceQty;
    @FXML
    private Label TotalAmtTF;
    @FXML
    private Label nairaTotal;
    @FXML
    public FlowPane flowPane;
    @FXML
    public HBox hbSales;
    @FXML
    public HBox searchHbdivider;
    @FXML
    private Button MakeSaleButton;
    @FXML
    private TextArea txtComment;
    private SalesItemAdminCard saleItemUI;
    public Sale sale;
    public StockItemList stockItemList;
    public StockItemList cartStockItemList;
    private CustomerDataList customerDataList;
    private ArrayList<ParameterValue> tempParamValue = new ArrayList();
    StringConverter<? extends Number> fConverter = new FloatStringConverter();
    StringConverter<? extends Number> dConverter = new DoubleStringConverter();
    public PendingSales pendingSales;
    AccountDetailDataList lst;
    public Dialog<Customer> dialog;
    ObservableList<NameValueObject> channnels = FXCollections.observableArrayList();
    Customer customer;
    CustomerPaymentDataList cpdl;
    StoreDataList storeDataList;
    public AccountDetailDataList accountDetailDataList;
    boolean isResetSale = false;
    Double keepAmnthPaid = 0.0;

    public SalesPaneAdmin(Santa app) throws Exception {
        super("SalesPaneAdmin.fxml", app);
        int index;
        this.title = "Sale Page";
        this.sale = new Sale(this.da);
        this.customer = new Customer(this.da);
        this.stockItemList = new StockItemList(this.da);
        this.customerDataList = new CustomerDataList(this.da);
        this.cpdl = new CustomerPaymentDataList(this.da);
        this.nairaTotal.setText(General.toNaira());
        this.channnels.addAll(StockItemList.selectAllChannels(this.da));
        this.cbChannel.setItems(this.channnels);
        if (this.channnels.size() > 0 && (index = this.channnels.indexOf((Object)new NameValueObject("14000"))) >= 0) {
            this.cbChannel.getSelectionModel().select(index);
        }
        this.cbCreditSale.setItems(General.getCredits());
        this.cbCreditSale.getSelectionModel().select(0);
        this.tbCreditToken.setVisible(this.cbCreditSale.getSelectionModel().getSelectedIndex() != 0);
        this.cbCreditSale.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.equals("No Credit")) {
                    SalesPaneAdmin.this.tbCreditToken.setVisible(true);
                } else {
                    SalesPaneAdmin.this.tbCreditToken.setVisible(false);
                }
            }
        });
        this.accountDetailDataList = new AccountDetailDataList(this.da);
        this.datePick.setValue((Object)LocalDate.now());
        this.SearchTextField.requestFocus();
        EmployeeDataList employeeDataList = new EmployeeDataList(this.da);
        employeeDataList.selectAll("Select * from Employee order by empId asc", this.da.getEmptyParameterValues());
        this.cbSalesResponsible.setItems(employeeDataList.getOriginalList());
        this.cbSalesResponsible.getSelectionModel().select(0);
        this.sale.setSalesRep(((Employee)this.cbSalesResponsible.getSelectionModel().getSelectedItem()).getEmpId());
        this.storeDataList = new StoreDataList(this.da);
        this.storeDataList.selectAll(this.da);
        this.cbStore.setItems(this.storeDataList.getOriginalList());
        this.pendingSales = new PendingSales();
        this.pendingSales.getSales().add((Object)this.sale);
        this.hbSales.getChildren().add((Object)new SaleListItem(this.sale, this, false));
        this.txtComment.textProperty().bindBidirectional((Property)this.sale.saleCommentProperty());
        this.TotalAmtTF.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.isEmpty()) {
                    SalesPaneAdmin.this.sale.amountPaidProperty().set(Double.valueOf(newValue.replace(",", "")).doubleValue());
                }
            }
        });
        this.cbSalesResponsible.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                SalesPaneAdmin.this.sale.setSalesRep(((Employee)newValue).getEmpId());
            }
        });
        this.customerDataList.SelectAll();
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.SearchTextField, t -> {
            List<StockItemData> result = this.searchDataHere(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<StockItemData>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<StockItemData> event) {
                SalesPaneAdmin.this.populateSearch((StockItemData)event.getCompletion());
            }
        });
        autoCompletionBinding.setPrefWidth(550.0);
        this.MakeSaleButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    SalesPaneAdmin.this.makeSale();
                }
                catch (Exception ex) {
                    Logger.getLogger(SalesPaneAdmin.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.TotalAmtTF.textProperty().bind((ObservableValue)this.sale.totalAmountBinding);
        this.TotalAmtTF.addEventFilter(KeyEvent.KEY_TYPED, General.numeric_Validation(20));
        General.selectAll(this.SearchTextField);
        if (this.santa.Products.isEmpty()) {
            try {
                this.santa.Products.addAll(StockItemList.selectAllYuProducts(this.da));
            }
            catch (SQLException ex) {
                Logger.getLogger(NewRequestPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.btnSetPriceQty.setOnAction(x -> {
            if (this.cbStore.getSelectionModel().getSelectedItem() != null) {
                this.getPriceWithQty();
            } else {
                this.mainPage.showNotification(NotificationType.Error, "Please select store and try again", this);
            }
        });
        this.SearchButton.setOnAction(c -> {
            if (!this.SearchTextField.getText().isEmpty()) {
                JFXProgressBar progressIndicator = new JFXProgressBar();
                progressIndicator.setProgress(-1.0);
                final VBox box = new VBox(new Node[]{progressIndicator});
                box.setAlignment(Pos.CENTER);
                this.stackPane.getChildren().add((Object)box);
                Service service = new Service(){

                    protected Task createTask() {
                        return new Task(){

                            protected Object call() throws Exception {
                                HttpGet httpget = null;
                                try {
                                    String url = SalesPaneAdmin.this.santa.syncSetting.getBEURL();
                                    httpget = new HttpGet(url + "RProduct/GetSAPItemsByItemCode?itemCode=" + SalesPaneAdmin.this.SearchTextField.getText());
                                    CloseableHttpClient client = HttpClientBuilder.create().build();
                                    httpget.setHeader("Content-type", "application/json");
                                    HttpResponse response = client.execute((HttpUriRequest)httpget);
                                    if (response.getStatusLine().getStatusCode() == 200) {
                                        String output;
                                        BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                        StringBuilder stringBuilder = new StringBuilder();
                                        while ((output = br.readLine()) != null) {
                                            stringBuilder.append(output + "\n");
                                        }
                                        br.close();
                                        client.getConnectionManager().shutdown();
                                        String result = stringBuilder.toString();
                                        System.out.println("String " + result);
                                        JSONArray ra = new JSONArray(result);
                                        System.out.println("JSon " + ra.toString());
                                        if (ra.length() > 0) {
                                            ArrayList<StockItemData> list = new ArrayList<StockItemData>();
                                            for (int i = 0; i < ra.length(); ++i) {
                                                JSONObject jo = ra.getJSONObject(i);
                                                StockItemData stkData = new StockItemData();
                                                stkData.setDescription(jo.isNull("ItemName") ? "" : jo.getString("ItemName"));
                                                stkData.setItemCode(jo.isNull("ItemCode") ? "" : jo.getString("ItemCode"));
                                                list.add(stkData);
                                            }
                                            StockItemList.insertYudalaProduct(list, SalesPaneAdmin.this.da);
                                            list.forEach(x -> SalesPaneAdmin.this.santa.Products.removeIf(xy -> xy.getItemCode().equals(x.getItemCode())));
                                            SalesPaneAdmin.this.santa.Products.addAll(list);
                                            Platform.runLater(() -> {
                                                SalesPaneAdmin.this.populateSearch((StockItemData)list.get(0));
                                                SalesPaneAdmin.this.stackPane.getChildren().remove((Object)box);
                                            });
                                        } else {
                                            Platform.runLater(() -> {
                                                SalesPaneAdmin.this.stackPane.getChildren().remove((Object)box);
                                                SalesPaneAdmin.this.mainPage.showNotification(NotificationType.Information, "no result found", SalesPaneAdmin.this);
                                            });
                                        }
                                    } else {
                                        String output;
                                        BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                        StringBuilder stringBuilder = new StringBuilder();
                                        while ((output = br.readLine()) != null) {
                                            System.out.println(output);
                                            stringBuilder.append(output + "\n");
                                        }
                                        br.close();
                                        String fullError = stringBuilder.toString();
                                        Platform.runLater(() -> {
                                            SalesPaneAdmin.this.mainPage.showNotification(NotificationType.Error, fullError, SalesPaneAdmin.this);
                                            SalesPaneAdmin.this.stackPane.getChildren().remove((Object)box);
                                        });
                                    }
                                }
                                catch (Exception e) {
                                    Platform.runLater(() -> {
                                        SalesPaneAdmin.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), SalesPaneAdmin.this);
                                        SalesPaneAdmin.this.stackPane.getChildren().remove((Object)box);
                                        Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, e);
                                    });
                                }
                                return null;
                            }
                        };
                    }
                };
                progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
                service.start();
            } else {
                this.mainPage.showNotification(NotificationType.Information, "Please supply item code", this);
            }
        });
    }

    @Override
    public void searchCustomer(String text) {
    }

    public void populateSearch(StockItemData stockItemData) {
        Node node = this.container.getChildren().stream().filter(x -> ((SalesItemAdminCard)x).saleItem.getItemCode().equals(stockItemData.getItemCode())).findAny().orElse(null);
        if (node == null) {
            this.sale.manualEnt = false;
            ArrayList<SalesItemAdminCard> children = new ArrayList<SalesItemAdminCard>();
            if (stockItemData != null) {
                SaleItem saleItem = new SaleItem(this.da);
                saleItem.setParentSale(this.sale);
                saleItem.setSellingPrice(0.0);
                saleItem.setQuantity(1.0f);
                saleItem.setPriceB2B(0.0);
                saleItem.setCostPrice(0.0);
                saleItem.setItemCode(stockItemData.getItemCode());
                saleItem.setItemName(stockItemData.getDescription());
                saleItem.setMustClone(true);
                saleItem.initializeListener();
                saleItem.vclone = saleItem.clone();
                this.saleItemUI = new SalesItemAdminCard(saleItem, this);
                children.add(this.saleItemUI);
                this.container.getChildren().addAll(children);
                this.sale.getSaleItemsList().add((Object)saleItem);
            } else {
                this.mainPage.showNotification(NotificationType.Information, "No item found", this);
            }
        } else {
            ((SalesItemAdminCard)node).saleItem.setQuantity(((SalesItemAdminCard)node).saleItem.getQuantity() + 1.0f);
        }
    }

    public List<StockItemData> searchDataHere(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<StockItemData>();
        }
        List result = this.santa.Products.stream().filter(e -> e.getItemCode().toLowerCase().contains(searchString.toLowerCase()) || e.getDescription().toLowerCase().contains(searchString.toLowerCase())).collect(Collectors.toList());
        LinkedList searchResult = new LinkedList();
        searchResult.addAll(result.isEmpty() && result.size() > 0 ? this.santa.Products : result);
        return searchResult.subList(0, searchResult.size());
    }

    @Override
    public void saleSelectionChanged() {
        if (this.hbSales.getChildren().size() > 2) {
            this.TotalAmtTF.textProperty().unbind();
            this.container.getChildren().clear();
            this.txtComment.textProperty().unbind();
            this.txtComment.textProperty().bindBidirectional((Property)this.sale.saleCommentProperty());
            this.sale.isMakingSale = false;
            for (SaleItem saleItem : this.sale.getSaleItemsList()) {
                this.container.getChildren().add((Object)new SalesItemAdminCard(saleItem, this));
            }
            this.TotalAmtTF.textProperty().bind((ObservableValue)this.sale.totalAmountBinding);
        }
    }

    @Override
    public void resetSale() {
        this.hbSales.getChildren().removeIf((Predicate)new Predicate<Node>(){

            @Override
            public boolean test(Node t) {
                if (t instanceof SaleListItem) {
                    return ((SaleListItem)t).sale.isSold;
                }
                return false;
            }
        });
        this.pendingSales.getSales().removeIf((Predicate)new Predicate<Sale>(){

            @Override
            public boolean test(Sale t) {
                return t.isSold;
            }
        });
        this.TotalAmtTF.textProperty().unbind();
        this.container.getChildren().clear();
        if (this.pendingSales.getSales().stream().filter(x -> x.getDescription().equals("New Sale")).findAny().orElse(null) == null) {
            int index;
            this.sale = new Sale(this.da);
            if (this.channnels.size() > 0 && (index = this.channnels.indexOf((Object)new NameValueObject("14000"))) >= 0) {
                this.cbChannel.getSelectionModel().select(index);
            }
            this.pendingSales.getSales().add((Object)this.sale);
            this.hbSales.getChildren().add((Object)new SaleListItem(this.sale, this, true));
            this.cbStore.getSelectionModel().clearSelection();
            this.datePick.setValue((Object)LocalDate.now());
            this.cbSalesResponsible.getSelectionModel().select(0);
            this.sale.setSalesRep(((Employee)this.cbSalesResponsible.getSelectionModel().getSelectedItem()).getEmpId());
            this.cbCreditSale.getSelectionModel().select(0);
            this.tbCreditToken.setVisible(this.cbCreditSale.getSelectionModel().getSelectedIndex() != 0);
            this.tbCreditToken.setText("");
        } else {
            this.sale = this.pendingSales.getSales().stream().filter(x -> x.getDescription().equals("New Sale")).findAny().orElse(null);
            this.cbSalesResponsible.getSelectionModel().select(0);
            this.sale.setSalesRep(((Employee)this.cbSalesResponsible.getSelectionModel().getSelectedItem()).getEmpId());
            this.cbCreditSale.getSelectionModel().select(0);
            this.tbCreditToken.setVisible(this.cbCreditSale.getSelectionModel().getSelectedIndex() != 0);
            this.tbCreditToken.setText("");
        }
        this.txtComment.textProperty().unbind();
        this.txtComment.textProperty().bindBidirectional((Property)this.sale.saleCommentProperty());
        this.sale.isMakingSale = false;
        this.TotalAmtTF.textProperty().unbind();
        this.TotalAmtTF.textProperty().bind((ObservableValue)this.sale.totalAmountBinding);
        this.stockItemList = new StockItemList(this.da);
        this.container.getChildren().clear();
        this.SearchTextField.setText("");
    }

    public void getPriceWithQty() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String url = SalesPaneAdmin.this.santa.syncSetting.getBEURL() + "RProduct/GetSaleDetails?storeInvoiceNo=" + SalesPaneAdmin.this.sale.getHdInvoiceNo();
                            JSONArray jSONArray = new JSONArray();
                            for (SaleItem saleItem : SalesPaneAdmin.this.sale.getSaleItemsList()) {
                                JSONObject joItem = new JSONObject();
                                joItem.put("ItemCode", (Object)saleItem.getItemCode());
                                joItem.put("WhsCode", (Object)((Store)SalesPaneAdmin.this.cbStore.getSelectionModel().getSelectedItem()).getCode());
                                jSONArray.put((Object)joItem);
                            }
                            HttpPost httpPost = new HttpPost(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            StringEntity stringEntity = new StringEntity(jSONArray.toString());
                            httpPost.setEntity((HttpEntity)stringEntity);
                            httpPost.setHeader("Content-type", "application/json");
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONObject ra = new JSONObject(result);
                                if (ra != null) {
                                    if (SalesPaneAdmin.this.sale.getHdInvoiceNo().isEmpty()) {
                                        SalesPaneAdmin.this.sale.setHdInvoiceNo(ra.isNull("HQInvoiceNo") ? "" : ra.getString("HQInvoiceNo"));
                                    }
                                    JSONObject jar = ra.getJSONObject("StoreConfig");
                                    SalesPaneAdmin.this.sale.setLocationCode(jar.isNull("Location") ? "" : jar.getString("Location"));
                                    SalesPaneAdmin.this.sale.setCostCenter(jar.isNull("CostCentre") ? "" : jar.getString("CostCentre"));
                                    JSONArray accounts = jar.isNull("StoreAccounts") ? new JSONArray() : jar.getJSONArray("StoreAccounts");
                                    SalesPaneAdmin.this.accountDetailDataList.getOriginalList().clear();
                                    if (accounts.length() > 0) {
                                        for (int i = 0; i < accounts.length(); ++i) {
                                            JSONObject js = accounts.getJSONObject(i);
                                            AccountDetail accountDetail = new AccountDetail(SalesPaneAdmin.this.da);
                                            accountDetail.setAccName(js.isNull("AccountName") ? "" : js.getString("AccountName").trim());
                                            accountDetail.setAccNumber(js.isNull("AccountNo") ? "" : js.getString("AccountNo").trim());
                                            accountDetail.setAccType(js.isNull("AccountType") ? "" : js.getString("AccountType").trim());
                                            accountDetail.setIsDefault(js.isNull("IsDefault") ? false : js.getBoolean("IsDefault"));
                                            SalesPaneAdmin.this.accountDetailDataList.getOriginalList().add((Object)accountDetail);
                                        }
                                    }
                                    JSONArray items = ra.getJSONArray("Items");
                                    Platform.runLater(() -> {
                                        for (int i = 0; i < items.length(); ++i) {
                                            try {
                                                JSONObject jSONObject = items.getJSONObject(i);
                                                StockItemData data = new StockItemData();
                                                data.setItemCode(jSONObject.isNull("ItemCode") ? "" : jSONObject.getString("ItemCode"));
                                                data.setStoreQuantity(jSONObject.isNull("Quantity") ? 0 : (int)Math.round(jSONObject.getDouble("Quantity")));
                                                data.setSellingPrice(jSONObject.isNull("SellingPrice") ? 0.0 : jSONObject.getDouble("SellingPrice"));
                                                data.setDescription(jSONObject.isNull("Name") ? "" : jSONObject.getString("Name"));
                                                data.setB2bprice(jSONObject.isNull("B2BPrice") ? 0.0 : jSONObject.getDouble("B2BPrice"));
                                                SalesItemAdminCard adminCard = (SalesItemAdminCard)SalesPaneAdmin.this.container.getChildren().stream().filter(zx -> ((SalesItemAdminCard)zx).saleItem.getItemCode().equals(data.getItemCode())).findAny().get();
                                                SaleItem slItem = adminCard.saleItem;
                                                slItem.availableQty.set(data.getStoreQuantity());
                                                if (slItem.availableQty.get() > 0) {
                                                    adminCard.setMaxQty();
                                                }
                                                slItem.setVariablePrice(data.getSellingPrice());
                                                slItem.setSellingPrice(data.getSellingPrice());
                                                slItem.setItemName(data.getDescription());
                                            }
                                            catch (JSONException ex) {
                                                SalesPaneAdmin.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), SalesPaneAdmin.this);
                                            }
                                            SalesPaneAdmin.this.stackPane.getChildren().remove((Object)box);
                                        }
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        SalesPaneAdmin.this.stackPane.getChildren().remove((Object)box);
                                        SalesPaneAdmin.this.mainPage.showNotification(NotificationType.Information, "No Items Found", SalesPaneAdmin.this);
                                    });
                                }
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    SalesPaneAdmin.this.stackPane.getChildren().remove((Object)box);
                                    SalesPaneAdmin.this.mainPage.showNotification(NotificationType.Error, fullError, SalesPaneAdmin.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                SalesPaneAdmin.this.stackPane.getChildren().remove((Object)box);
                                SalesPaneAdmin.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), SalesPaneAdmin.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    public void showPayment() {
        this.dialog = new Dialog();
        this.dialog.initStyle(StageStyle.DECORATED);
        this.dialog.initOwner((Window)this.santa.stage);
        this.dialog.setTitle("Payment Option");
        this.dialog.setResizable(true);
        this.dialog.getDialogPane().setContent((Node)new PaymentOptionPane(this, false));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        this.dialog.show();
    }

    private void makeSale() throws Exception {
        this.mainPage.isToMenu = false;
        if (this.validateControl()) {
            if (this.tbCreditToken.getText().isEmpty()) {
                this.showPayment();
            } else {
                this.done(1);
            }
        }
    }

    @Override
    void closeNotification() {
        this.mainPage.closeNotification();
    }

    @Override
    public void showDialog(String str) {
        this.dialog = new Dialog();
        this.dialog.initStyle(StageStyle.UTILITY);
        this.dialog.initOwner((Window)this.santa.stage);
        this.dialog.setTitle("Search Customer");
        this.dialog.setResizable(true);
        this.dialog.getDialogPane().setContent((Node)new SearchCustomerPane(this, str));
        this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
        this.dialog.show();
    }

    @Override
    public void done(int flag) {
        if (flag == 1) {
            if (this.dialog != null && this.dialog.isShowing()) {
                this.dialog.close();
            }
            this.container.setDisable(true);
            try {
                this.sale.setSalesChannel(((NameValueObject)this.cbChannel.getSelectionModel().getSelectedItem()).getKey());
                this.sale.setStoreCode(((Store)this.cbStore.getSelectionModel().getSelectedItem()).getCode());
                this.sale.storeName = ((Store)this.cbStore.getSelectionModel().getSelectedItem()).getName();
                if (!((String)this.cbCreditSale.getSelectionModel().getSelectedItem()).equals("No Credit")) {
                    this.sale.setCreditDescription((String)this.cbCreditSale.getSelectionModel().getSelectedItem());
                    this.sale.setCreditToken(this.tbCreditToken.getText());
                    this.sale.setIsManual(true);
                }
                this.sale.makeSale(this.currentUser);
                Sale saleForRpt = this.sale.CloneForInvoice();
                saleForRpt.setDbAccess(this.da);
                saleForRpt.setSaleItemsList(this.sale.getSaleItemsList());
                this.resetSale();
                this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
                this.dialog = new Dialog();
                this.dialog.initStyle(StageStyle.DECORATED);
                this.dialog.initOwner((Window)this.santa.stage);
                this.dialog.setTitle("Invoice");
                this.dialog.setResizable(true);
                this.dialog.getDialogPane().setContent((Node)new ReportPane(this.santa, ReportType.Invoice, saleForRpt, null, null, null));
                this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                this.dialog.show();
            }
            catch (Exception e) {
                if (NotEnoughQtyException.class == e.getClass()) {
                    this.mainPage.showNotification(NotificationType.Error, "Maximum days set for direct purchase Exceeded", this);
                }
                this.mainPage.showNotification(NotificationType.Error, e.getMessage(), this);
            }
            this.container.setDisable(false);
        }
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        this.needToSave = false;
        if (this.mainPage.isToMenu) {
            return true;
        }
        if (this.sale.getSaleItemsList().isEmpty()) {
            this.errorMessage = this.errorMessage + "No item selected to sell \n";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (this.sale.getSaleItemsList().stream().filter(p -> p.getSerials().getOriginalList().size() > 0 && p.getSerials().getOriginalList().size() != p.getTotalQty()).findAny().orElse(null) != null) {
            this.errorMessage = this.errorMessage + "One or more item(s) has serial(s) less than the quantity";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (this.sale.getSaleItemsList().stream().anyMatch(s -> s.getIsManual() == Boolean.TRUE) && (this.sale.getSaleComment() == null || this.sale.getSaleComment().isEmpty())) {
            this.errorMessage = this.errorMessage + "Please enter reason(s) for manual sale \n";
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        if (this.sale.getParentCustomer() == null) {
            this.errorMessage = this.errorMessage + "Please add customer \n";
        }
        if (this.sale.getHdInvoiceNo().isEmpty()) {
            this.errorMessage = this.errorMessage + "Invoice number is not set,click Add Price button to generate invoice number and try again";
        }
        if (this.cbStore.getSelectionModel().getSelectedItem() == null) {
            this.errorMessage = this.errorMessage + "Please select store \n";
        }
        if (this.cbCreditSale.getSelectionModel().getSelectedIndex() > 0 && this.tbCreditToken.getText().isEmpty()) {
            this.errorMessage = this.errorMessage + "Please supply token for credit sale \n";
        }
        if (Double.valueOf(this.TotalAmtTF.getText().replace(",", "")) == 0.0 || Double.valueOf(this.TotalAmtTF.getText().replace(",", "")) < 0.0) {
            this.errorMessage = this.errorMessage + "Please specify amount recieved from the customer";
        }
        if (!this.errorMessage.equals("")) {
            this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
            return false;
        }
        return true;
    }

    @Override
    void yes() {
        try {
            this.makeSale();
            this.mainPage.isToMenu = true;
            this.closeNotification();
            this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
            this.mainPage.hbBottom.setVisible(false);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
    }

    @Override
    void no() {
        this.mainPage.isToMenu = true;
        this.closeNotification();
        this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
        this.mainPage.hbBottom.setVisible(false);
    }

    @Override
    void completeControl() {
        this.mainPage.isToMenu = false;
        this.mainPage.showNotification(NotificationType.Warning, "Do you want to make sale for the selected item(s)", this);
    }

    private void loadAccountDetails() {
        this.lst = new AccountDetailDataList(this.da);
        this.lst.selectAll("Select * From AccountDetail ", this.da.getEmptyParameterValues());
        ArrayList<AccountDetailItemPane> children = new ArrayList<AccountDetailItemPane>();
        for (AccountDetail accountDetail : this.lst.getOriginalList()) {
            children.add(new AccountDetailItemPane(accountDetail));
        }
    }

    @Override
    public Santa getSanta() {
        return this.santa;
    }

    @Override
    public Sale getSale() {
        return this.sale;
    }

    @Override
    public HBox getHbSales() {
        return this.hbSales;
    }

    @Override
    public void setSale(Sale s) {
        this.sale = s;
        Employee selectedEmployee = this.cbSalesResponsible.getItems().stream().filter(val -> val.getEmpId().equals(s.getSalesRep())).findAny().orElse(null);
        if (selectedEmployee == null) {
            this.cbSalesResponsible.getSelectionModel().select(0);
        } else {
            this.cbSalesResponsible.getSelectionModel().select((Object)selectedEmployee);
        }
    }

    @Override
    public Dialog getDialog() {
        return this.dialog;
    }

    @Override
    public MainPage getMainPage() {
        return this.mainPage;
    }

    @Override
    public PendingSales getPendingSale() {
        return this.pendingSales;
    }

    @Override
    public StockItemList getCartStockItemList() {
        return this.cartStockItemList;
    }

    @Override
    public void setCartStockItemList(StockItemList stckLst) {
        this.cartStockItemList = stckLst;
    }

    public FlowPane getContainer() {
        return this.container;
    }

    @Override
    public VBox getRepeatingVBAdded() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void ValidateVoucher(String code) {
    }

    @Override
    public void MarkVoucherUsed() {
    }

    @Override
    public StackPane getStackPane() {
        return this.stackPane;
    }
}

