/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.xputertechnologies.santa.RequestItem;
import com.xputertechnologies.santa.RequestType;
import com.xputertechnologies.santa.ui.DecimalNumberTextBox;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.NewRequestPaneB2B;
import com.xputertechnologies.santa.ui.UIControlBase;
import java.util.function.Predicate;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.FloatStringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.controlsfx.glyphfont.FontAwesome;

public class RequestItemRepeatingCartB2B
extends UIControlBase {
    @FXML
    ImageView imgReduce;
    @FXML
    ImageView btnIncrease;
    @FXML
    ImageView imgRemove;
    @FXML
    JFXButton imgSerial;
    @FXML
    DecimalNumberTextBox QtyTF;
    @FXML
    private Label lblName;
    @FXML
    private Label lblItemCode;
    @FXML
    private Label sn;
    @FXML
    private Label lblAvaiQty;
    @FXML
    HBox hbQty;
    @FXML
    HBox hbRemove;
    NewRequestPaneB2B np;
    RequestItem product;
    StringConverter<? extends Number> fConverter = new FloatStringConverter(){

        public String toString(Float object) {
            if (object != null) {
                return Integer.toString(Math.round(object.floatValue()));
            }
            return null;
        }

        public Float fromString(String string) {
            string = string.replace(",", "");
            Float d = Float.valueOf(Float.parseFloat(string));
            return d;
        }
    };
    StringConverter<? extends Number> IntConverter = new IntegerStringConverter(){

        public String toString(Integer object) {
            if (object != null) {
                return Integer.toString(object);
            }
            return null;
        }

        public Integer fromString(String string) {
            string = string.replace(",", "");
            Integer d = 0;
            if (!string.isEmpty()) {
                d = Integer.parseInt(string);
            }
            return d;
        }
    };
    StringConverter<? extends Number> dConverter = new DoubleStringConverter(){

        public String toString(Double object) {
            if (object != null) {
                return General.formatDecimalToMoneyString(object);
            }
            return null;
        }

        public Double fromString(String string) {
            string = string.replace(",", "");
            Double d = Double.parseDouble(string);
            return d;
        }
    };

    public RequestItemRepeatingCartB2B(final RequestItem product, final NewRequestPaneB2B np) {
        this.product = product;
        this.np = np;
        if (np.request.getRequestType().equals(RequestType.Inbound.name()) ? np.vbRepeatingRequested.getChildren().size() % 2 == 0 : np.vbRepeatingRequested1.getChildren().size() % 2 == 0) {
            this.setStyle("-fx-background-color:#F3F3F3");
        }
        if (product.getQuantity() == 0) {
            product.setQuantity(1);
        }
        this.sn.textProperty().bind((ObservableValue)product.snProperty());
        this.btnIncrease.setImage(new Image("/com/xputertechnologies/santa/ui/Images/increase.png"));
        this.imgReduce.setImage(new Image("/com/xputertechnologies/santa/ui/Images/decrease.png"));
        this.imgRemove.setImage(new Image("/com/xputertechnologies/santa/ui/Images/cart-remove.png"));
        this.imgSerial.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.GREEN).size(15.0));
        this.QtyTF.textProperty().bindBidirectional((Property)product.quantityProperty(), this.IntConverter);
        this.lblAvaiQty.textProperty().bindBidirectional((Property)product.availableQtyProperty(), this.IntConverter);
        this.lblAvaiQty.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                int newv = Integer.valueOf(newValue);
                if (newv < product.getQuantity()) {
                    RequestItemRepeatingCartB2B.this.lblAvaiQty.setTextFill((Paint)Color.web((String)"#FF0000"));
                } else {
                    RequestItemRepeatingCartB2B.this.lblAvaiQty.setTextFill((Paint)Color.web((String)"#00A86B"));
                }
            }
        });
        this.QtyTF.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                int newv = Integer.valueOf(newValue);
                if (newv > product.availableQtyProperty().get()) {
                    RequestItemRepeatingCartB2B.this.lblAvaiQty.setTextFill((Paint)Color.web((String)"#FF0000"));
                } else {
                    RequestItemRepeatingCartB2B.this.lblAvaiQty.setTextFill((Paint)Color.web((String)"#00A86B"));
                }
            }
        });
        this.QtyTF.setMax(1000000.0);
        this.imgSerial.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                event.consume();
                np.showDialog(product);
            }
        });
        this.lblItemCode.textProperty().bind((ObservableValue)product.itemCodeProperty());
        this.imgRemove.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                event.consume();
                RequestItemRepeatingCartB2B.this.remove();
            }
        });
        this.btnIncrease.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                event.consume();
                product.quantityProperty().set(product.getQuantity() + 1);
                RequestItem req = np.request.getItems().stream().filter(p -> p.getItemCode().equals(product.getItemCode())).findAny().orElse(null);
                if (req != null) {
                    req.setQuantity(Math.round(product.getQuantity()));
                }
            }
        });
        this.imgReduce.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                event.consume();
                if (product.quantityProperty().get() == 1) {
                    RequestItemRepeatingCartB2B.this.remove();
                } else {
                    product.quantityProperty().set(product.getQuantity() - 1);
                    RequestItem req = np.request.getItems().stream().filter(p -> p.getItemCode().equals(product.getItemCode())).findAny().orElse(null);
                    if (req != null) {
                        req.setQuantity(Math.round(product.getQuantity()));
                    }
                }
            }
        });
        this.lblName.textProperty().bind((ObservableValue)product.itemNameProperty());
    }

    public void remove() {
        if (this.np.request.getRequestType().equals(RequestType.Inbound.name())) {
            this.np.vbRepeatingRequested.getChildren().removeIf((Predicate)new Predicate<Node>(){

                @Override
                public boolean test(Node t) {
                    return ((RequestItemRepeatingCartB2B)t).product.getItemCode().equals(RequestItemRepeatingCartB2B.this.product.getItemCode());
                }
            });
        } else {
            this.np.vbRepeatingRequested1.getChildren().removeIf((Predicate)new Predicate<Node>(){

                @Override
                public boolean test(Node t) {
                    return ((RequestItemRepeatingCartB2B)t).product.getItemCode().equals(RequestItemRepeatingCartB2B.this.product.getItemCode());
                }
            });
        }
        this.np.request.getItems().removeIf((Predicate)new Predicate<RequestItem>(){

            @Override
            public boolean test(RequestItem t) {
                return t.getItemCode().equals(RequestItemRepeatingCartB2B.this.product.getItemCode());
            }
        });
    }
}

