/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.SalesReturnPane;
import com.xputertechnologies.santa.ui.SearchParams;
import com.xputertechnologies.santa.ui.UIParent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitMenuButton;
import org.json.JSONException;
import org.json.JSONObject;

public class ReprintInvoiceSearchDialog
extends UIParent {
    @FXML
    private JFXComboBox<Store> cmbStore;
    @FXML
    private JFXTextField tbSearch;
    @FXML
    private SplitMenuButton split;
    @FXML
    private MenuItem menuInvoice;
    @FXML
    private MenuItem menuName;
    @FXML
    private MenuItem menuPhone;
    @FXML
    private MenuItem menuEmail;
    SalesReturnPane parent;

    public ReprintInvoiceSearchDialog(SalesReturnPane parent) {
        super("ReprintInvoiceSearchDialog.fxml", parent.santa);
        this.santa = parent.santa;
        this.parent = parent;
        this.title = "Re-print Sale Invoice";
        StoreDataList stores = new StoreDataList(this.da);
        stores.selectAll(this.da);
        this.cmbStore.setItems(stores.getOriginalList());
        this.cmbStore.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue ov, Object t, Object t1) {
            }
        });
        this.menuInvoice.setOnAction(it -> this.onAction(SearchParams.INVOICE));
        this.menuName.setOnAction(it -> this.onAction(SearchParams.NAME));
        this.menuPhone.setOnAction(it -> this.onAction(SearchParams.PHONE));
        this.menuEmail.setOnAction(it -> this.onAction(SearchParams.EMAIL));
    }

    private void onAction(SearchParams searchParams) {
        if (this.tbSearch.getText().isEmpty() || this.cmbStore.getSelectionModel().getSelectedItem() == null) {
            this.parent.mainPage.showNotification(NotificationType.Information, "Please select store and fill the search box", this);
        } else {
            try {
                JSONObject json = new JSONObject();
                switch (searchParams) {
                    case INVOICE: {
                        json.put("storeId", (Object)((Store)this.cmbStore.getSelectionModel().getSelectedItem()).getCode()).put("invoiceNumber", (Object)this.tbSearch.getText().trim());
                        break;
                    }
                    case NAME: {
                        json.put("storeId", (Object)((Store)this.cmbStore.getSelectionModel().getSelectedItem()).getCode()).put("customerName", (Object)this.tbSearch.getText().trim());
                        break;
                    }
                    case PHONE: {
                        json.put("storeId", (Object)((Store)this.cmbStore.getSelectionModel().getSelectedItem()).getCode()).put("customerPhone", (Object)this.tbSearch.getText().trim());
                        break;
                    }
                    case EMAIL: {
                        json.put("storeId", (Object)((Store)this.cmbStore.getSelectionModel().getSelectedItem()).getCode()).put("customerEmail", (Object)this.tbSearch.getText().trim());
                    }
                }
                this.parent.loadSale(json, null);
            }
            catch (JSONException ex) {
                Logger.getLogger(ReprintInvoiceSearchDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

