/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextArea;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.NameValueObjectType;
import com.xputertechnologies.santa.POApprovalHistory;
import com.xputertechnologies.santa.PurchaseLineItem;
import com.xputertechnologies.santa.PurchaseOrder;
import com.xputertechnologies.santa.PurchaseType;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.list.PurchaseOrderDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.IPurchasePane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PurchaseOrderApprovalEditDialog;
import com.xputertechnologies.santa.ui.PurchaseOrderDialog;
import com.xputertechnologies.santa.ui.PurchaseOrderHistory;
import com.xputertechnologies.santa.ui.PurchaseOrderPane;
import com.xputertechnologies.santa.ui.Santa;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class PurchaseRequestApprovalPane
extends IPurchasePane {
    @FXML
    Label lblCurrStage;
    @FXML
    Label lblStatus;
    @FXML
    Label lblCurrency;
    @FXML
    Label lblTotal;
    @FXML
    JFXListView<PurchaseOrder> list;
    @FXML
    JFXTextArea approvalComment;
    @FXML
    JFXTextArea txtAreaPoComment;
    @FXML
    private VBox vbHistory;
    @FXML
    private TableView<PurchaseLineItem> table;
    @FXML
    private JFXButton btnPost;
    @FXML
    private JFXButton btnReload;
    @FXML
    private StackPane stackPane;
    @FXML
    private TableColumn colLastPrice;
    @FXML
    private TableColumn colLastSoldMnth;
    @FXML
    private TableColumn colLastDatePurch;
    @FXML
    private TableColumn colCurrQty;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colPrice;
    @FXML
    private TableColumn colEditPrice;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colEdit;
    @FXML
    private TableColumn colCostCenter;
    @FXML
    private TableColumn colTaxCode;
    @FXML
    private TableColumn colQty;
    @FXML
    private TableColumn colEditQty;
    @FXML
    private TableColumn colTotal;
    @FXML
    private TableColumn colDel;
    PurchaseOrderDataList purchaseOrderDataList = null;
    VBox progressContainer;
    ObservableList<NameValueObject> costcenters;
    ObservableList<NameValueObject> taxCodes;
    double dockTotal = 0.0;

    public PurchaseRequestApprovalPane(Santa app) {
        super("PurchaseRequestApprovalPane.fxml", app);
        this.title = "Purchase Order Approval";
        if (this.santa.Products.isEmpty()) {
            try {
                this.santa.Products.addAll(StockItemList.selectAllYuProducts(this.da));
            }
            catch (SQLException ex) {
                Logger.getLogger(PurchaseOrderPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.costcenters = NameValueObject.select(NameValueObjectType.CostCentre.name(), this.da);
        this.taxCodes = NameValueObject.select(NameValueObjectType.TaxCodes.name(), this.da);
        this.btnReload.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.REFRESH).color(Color.WHITE).size(15.0));
        this.btnPost.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.EXTERNAL_LINK).color(Color.WHITE).size(15.0));
        this.purchaseOrderDataList = new PurchaseOrderDataList(this.da);
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.colCostCenter.setCellValueFactory((Callback)new PropertyValueFactory("costCenter"));
        this.colTaxCode.setCellValueFactory((Callback)new PropertyValueFactory("taxCode"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("lineTotal"));
        this.colEdit.setCellValueFactory((Callback)new PropertyValueFactory(""));
        this.colEditQty.setCellValueFactory((Callback)new PropertyValueFactory("editQty"));
        this.colEditPrice.setCellValueFactory((Callback)new PropertyValueFactory("editPrice"));
        this.colLastDatePurch.setCellValueFactory((Callback)new PropertyValueFactory("lastPurchaseDate"));
        this.colLastPrice.setCellValueFactory((Callback)new PropertyValueFactory("lastPurchasePrice"));
        this.colLastSoldMnth.setCellValueFactory((Callback)new PropertyValueFactory("soldOutMonth"));
        this.colCurrQty.setCellValueFactory((Callback)new PropertyValueFactory("currentQty"));
        this.colPrice.setCellFactory(col -> new TableCell<PurchaseLineItem, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.colTotal.setCellFactory(col -> new TableCell<PurchaseLineItem, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.colLastPrice.setCellFactory(col -> new TableCell<PurchaseLineItem, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.colEditPrice.setCellFactory(col -> new TableCell<PurchaseLineItem, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.lblTotal.setText("");
        this.lblCurrency.setText("");
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryCostCenter = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final Label label = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getCostCenter().isEmpty()) {
                                this.label.setText(PurchaseRequestApprovalPane.this.costcenters.stream().filter(x -> x.getKey().equals(req.getCostCenter())).findAny().get().getData());
                            }
                            this.setGraphic((Node)this.label);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colCostCenter.setCellFactory((Callback)cellFactoryCostCenter);
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryViewDelete = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setButtonType(JFXButton.ButtonType.RAISED);
                            this.btn.setGraphic((Node)PurchaseRequestApprovalPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.TIMES).color(Color.RED).size(15.0));
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            if (((PurchaseOrder)PurchaseRequestApprovalPane.this.list.getSelectionModel().getSelectedItem()).canEditProperty().get()) {
                                this.btn.setOnAction(event -> {
                                    req.setState(ObjectState.Removed);
                                    ((PurchaseOrder)PurchaseRequestApprovalPane.this.list.getSelectionModel().getSelectedItem()).recalculateTotal();
                                    PurchaseRequestApprovalPane.this.table.refresh();
                                });
                            }
                            if (req.getIsDeleted().booleanValue()) {
                                req.setState(ObjectState.Removed);
                            }
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colDel.setCellFactory((Callback)cellFactoryViewDelete);
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryViewEdit = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                            this.btn.setGraphic((Node)PurchaseRequestApprovalPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(20.0));
                            this.btn.setStyle("-fx-background-color: #4FC4F6;");
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            if (((PurchaseOrder)PurchaseRequestApprovalPane.this.list.getSelectionModel().getSelectedItem()).canEditProperty().get() && ((PurchaseOrder)PurchaseRequestApprovalPane.this.list.getSelectionModel().getSelectedItem()).canEditProperty().get()) {
                                this.btn.setOnAction(event -> {
                                    PurchaseRequestApprovalPane.this.purchaseOrder = (PurchaseOrder)PurchaseRequestApprovalPane.this.list.getSelectionModel().getSelectedItem();
                                    PurchaseRequestApprovalPane.this.selectedStock = req;
                                    PurchaseRequestApprovalPane.this.showDialog();
                                });
                            }
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colEdit.setCellFactory((Callback)cellFactoryViewEdit);
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryTax = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final Label label = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getCostCenter().isEmpty()) {
                                this.label.setText(PurchaseRequestApprovalPane.this.taxCodes.stream().filter(x -> x.getKey().equals(req.getTaxCode())).findAny().get().getData());
                            }
                            this.setGraphic((Node)this.label);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colTaxCode.setCellFactory((Callback)cellFactoryTax);
        this.list.setItems(this.purchaseOrderDataList.getOriginalList());
        this.list.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PurchaseOrder>(){

            public void changed(ObservableValue<? extends PurchaseOrder> observable, PurchaseOrder oldValue, PurchaseOrder newValue) {
                if (newValue != null) {
                    if (newValue.getSapCode().isEmpty()) {
                        PurchaseRequestApprovalPane.this.colEditPrice.setVisible(false);
                        PurchaseRequestApprovalPane.this.colEditQty.setVisible(false);
                    } else {
                        PurchaseRequestApprovalPane.this.colEditPrice.setVisible(true);
                        PurchaseRequestApprovalPane.this.colEditQty.setVisible(true);
                    }
                    PurchaseRequestApprovalPane.this.table.setItems(newValue.getItems());
                    PurchaseRequestApprovalPane.this.vbHistory.getChildren().clear();
                    newValue.getHistories().forEach(v -> PurchaseRequestApprovalPane.this.vbHistory.getChildren().add((Object)new PurchaseOrderHistory(PurchaseRequestApprovalPane.this.santa, (POApprovalHistory)v)));
                    if (newValue.CurrentCloseStage.isEmpty() && newValue.CurrentEditStage.isEmpty()) {
                        PurchaseRequestApprovalPane.this.lblCurrStage.setText(newValue.getCurrentStage());
                        PurchaseRequestApprovalPane.this.lblStatus.setText(newValue.getStatus());
                    } else if (!newValue.CurrentCloseStage.isEmpty()) {
                        PurchaseRequestApprovalPane.this.lblCurrStage.setText(newValue.CurrentCloseStage);
                        PurchaseRequestApprovalPane.this.lblStatus.setText(newValue.CurrentCloseStatus);
                    } else if (!newValue.CurrentEditStage.isEmpty()) {
                        PurchaseRequestApprovalPane.this.lblCurrStage.setText(newValue.CurrentEditStage);
                        PurchaseRequestApprovalPane.this.lblStatus.setText(newValue.CurrentEditStatus);
                    }
                    PurchaseRequestApprovalPane.this.txtAreaPoComment.setText(newValue.getCreateComment());
                    PurchaseRequestApprovalPane.this.lblCurrency.setText(newValue.getCurrency());
                    newValue.recalculateTotal();
                    PurchaseRequestApprovalPane.this.lblTotal.textProperty().bindBidirectional((Property)newValue.totalProperty(), PurchaseRequestApprovalPane.this.dConverter);
                }
            }
        });
        this.list.setCellFactory((Callback)new Callback<ListView<PurchaseOrder>, ListCell<PurchaseOrder>>(){

            public ListCell<PurchaseOrder> call(ListView<PurchaseOrder> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<PurchaseOrder> cell = new ListCell<PurchaseOrder>(){

                    public void updateItem(PurchaseOrder po, boolean empty) {
                        super.updateItem((Object)po, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            Label code = new Label();
                            if (((String)po.syncErrorProperty().get()).isEmpty() && po.getSyncFlag().booleanValue()) {
                                code.setTextFill((Paint)Color.web((String)"#00A86B"));
                            } else if (!((String)po.syncErrorProperty().get()).isEmpty()) {
                                code.setTextFill((Paint)Color.web((String)"#FF0000"));
                            }
                            code.setText(po.getCode());
                            HBox bLabel = new HBox(new Node[]{code});
                            bLabel.setAlignment(Pos.BOTTOM_LEFT);
                            JFXButton appRelea = new JFXButton();
                            if (po.CurrentEditStage.isEmpty()) {
                                appRelea.setGraphic((Node)new ImageView(new Image("/com/xputertechnologies/santa/ui/Images/likependind.png")));
                            } else {
                                appRelea.setGraphic((Node)new ImageView(new Image("/com/xputertechnologies/santa/ui/Images/likependindEdit.png")));
                            }
                            appRelea.setOnAction(v -> {
                                if (po.approvedStatus == 0) {
                                    appRelea.setGraphic((Node)new ImageView(new Image("/com/xputertechnologies/santa/ui/Images/appr.png")));
                                    po.approvedStatus = 1;
                                } else if (po.approvedStatus == 1) {
                                    appRelea.setGraphic((Node)new ImageView(new Image("/com/xputertechnologies/santa/ui/Images/decl.png")));
                                    po.approvedStatus = 2;
                                } else {
                                    appRelea.setGraphic((Node)new ImageView(new Image("/com/xputertechnologies/santa/ui/Images/likependind.png")));
                                    po.approvedStatus = 0;
                                }
                            });
                            code.setDisable(po.getSyncFlag().booleanValue());
                            appRelea.setDisable(po.getSyncFlag().booleanValue());
                            appRelea.setPrefSize(35.0, 35.0);
                            HBox root = new HBox();
                            root.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
                            code.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
                            Pane spacer = new Pane();
                            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                            spacer.setMinSize(10.0, 1.0);
                            root.getChildren().addAll((Object[])new Node[]{bLabel, spacer, appRelea});
                            tooltip.setText((String)po.syncErrorProperty().get());
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)root);
                        }
                    }
                };
                return cell;
            }
        });
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2 && event.getTarget() instanceof Label && ((PurchaseOrder)PurchaseRequestApprovalPane.this.list.getSelectionModel().getSelectedItem()).canEditProperty().get()) {
                    PurchaseRequestApprovalPane.this.purchaseOrder = (PurchaseOrder)PurchaseRequestApprovalPane.this.list.getSelectionModel().getSelectedItem();
                    PurchaseRequestApprovalPane.this.dialog = new JFXDialog(PurchaseRequestApprovalPane.this.stackPane, (Region)new PurchaseOrderApprovalEditDialog(PurchaseRequestApprovalPane.this), JFXDialog.DialogTransition.CENTER);
                    PurchaseRequestApprovalPane.this.dialog.setOverlayClose(false);
                    PurchaseRequestApprovalPane.this.dialog.show();
                }
            }
        });
        this.btnReload.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PurchaseRequestApprovalPane.this.loadMine(false);
            }
        });
        this.btnPost.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (PurchaseRequestApprovalPane.this.purchaseOrderDataList.getOriginalList().size() > 0) {
                    if (PurchaseRequestApprovalPane.this.purchaseOrderDataList.getOriginalList().stream().filter(v -> v.approvedStatus == 1).count() == 0L && PurchaseRequestApprovalPane.this.purchaseOrderDataList.getOriginalList().stream().filter(v -> v.approvedStatus == 2).count() > 0L || PurchaseRequestApprovalPane.this.purchaseOrderDataList.getOriginalList().stream().filter(v -> v.approvedStatus == 1).count() > 0L && PurchaseRequestApprovalPane.this.purchaseOrderDataList.getOriginalList().stream().filter(v -> v.approvedStatus == 2).count() == 0L) {
                        PurchaseRequestApprovalPane.this.post();
                    } else {
                        PurchaseRequestApprovalPane.this.mainPage.showNotification(NotificationType.Information, "You can either approve or decline all per post ", PurchaseRequestApprovalPane.this);
                    }
                } else {
                    PurchaseRequestApprovalPane.this.mainPage.showNotification(NotificationType.Information, "Nothing to approve", PurchaseRequestApprovalPane.this);
                }
            }
        });
        this.table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.disableProperty().bind((ObservableValue)Bindings.select((ObservableValue)row.itemProperty(), (String[])new String[]{"State"}).isEqualTo((Object)ObjectState.Removed));
            return row;
        });
        this.loadMine(false);
    }

    void loadMine(final boolean showNotification) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String url = PurchaseRequestApprovalPane.this.santa.syncSetting.getBEURL() + "RPurchaseOrder/GetMyPendingRequests";
                            HttpGet httpGet = new HttpGet(url);
                            HttpHost proxy = new HttpHost("127.0.0.1", 8888, "http");
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                            BasicNameValuePair param1 = new BasicNameValuePair("email", PurchaseRequestApprovalPane.this.currentUser.getUserName());
                            listParam.add(param1);
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
                            httpGet.setURI(uri);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                System.out.println(result);
                                JSONArray ra = new JSONArray(result);
                                PurchaseOrderDataList podl = new PurchaseOrderDataList(PurchaseRequestApprovalPane.this.da);
                                if (ra.length() > 0) {
                                    for (int i = 0; i < ra.length(); ++i) {
                                        JSONObject jSONObject = ra.getJSONObject(i);
                                        PurchaseOrder po = new PurchaseOrder(PurchaseRequestApprovalPane.this.da);
                                        po.DocEntry = jSONObject.isNull("DocEntry") ? 0 : jSONObject.getInt("DocEntry");
                                        po.DockNum = jSONObject.isNull("DocNum") ? 0 : jSONObject.getInt("DocNum");
                                        po.CurrentEditStage = jSONObject.isNull("CurrentEditStage") ? "" : jSONObject.getString("CurrentEditStage");
                                        po.CurrentCloseStage = jSONObject.isNull("CurrentCloseStage") ? "" : jSONObject.getString("CurrentCloseStage");
                                        po.CurrentEditStatus = jSONObject.isNull("CurrentEditStatus") ? "" : jSONObject.getString("CurrentEditStatus");
                                        po.CurrentCloseStatus = jSONObject.isNull("CurrentCloseStatus") ? "" : jSONObject.getString("CurrentCloseStatus");
                                        po.BaseDocumentNum = jSONObject.isNull("BaseDocumentNum") ? 0 : jSONObject.getInt("BaseDocumentNum");
                                        po.setTotal(jSONObject.isNull("DocTotal") ? 0.0 : jSONObject.getDouble("DocTotal"));
                                        po.setCode(jSONObject.isNull("Code") ? "" : jSONObject.getString("Code"));
                                        po.setSupplierCode(jSONObject.isNull("VendorId") ? "" : jSONObject.getString("VendorId"));
                                        po.setSupplierName(jSONObject.isNull("VendorName") ? "" : jSONObject.getString("VendorName"));
                                        po.editTemplateDescriptionProperty().set((Object)(jSONObject.isNull("EditTemplateDescription") ? "" : jSONObject.getString("EditTemplateDescription")));
                                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                        Date dt = df.parse(jSONObject.getString("DocDate"));
                                        po.setDateCreated(new Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("DeliveryDate"));
                                        po.setDueDate(new Date(dt.getTime()));
                                        po.setCurrency(jSONObject.isNull("Currency") ? "" : jSONObject.getString("Currency"));
                                        po.setStatus(jSONObject.isNull("Status") ? "" : jSONObject.getString("Status"));
                                        po.createCommentProperty().set((Object)(jSONObject.isNull("Comment") ? "" : jSONObject.getString("Comment")));
                                        po.createdByProperty().set((Object)(jSONObject.isNull("PurchasingOfficer") ? "" : jSONObject.getString("PurchasingOfficer")));
                                        po.setParentTemplateDescription(jSONObject.isNull("ApprovalTemplateDescription") ? "" : jSONObject.getString("ApprovalTemplateDescription"));
                                        po.setPurchaseType(jSONObject.isNull("PurchaseType") ? "" : jSONObject.getString("PurchaseType"));
                                        po.setPaymentTerm(jSONObject.isNull("PaymentTerm") ? "" : jSONObject.getString("PaymentTerm"));
                                        po.OrderNoProperty().set((Object)(jSONObject.isNull("OrderNo") ? "" : jSONObject.getString("OrderNo")));
                                        po.setCurrentStage(jSONObject.isNull("CurrentStage") ? "" : jSONObject.getString("CurrentStage"));
                                        po.canEditProperty().set(jSONObject.isNull("CanEdit") ? false : jSONObject.getBoolean("CanEdit"));
                                        po.syncErrorProperty().set((Object)(jSONObject.isNull("SyncError") ? "" : jSONObject.getString("SyncError")));
                                        po.setCreateComment(jSONObject.isNull("Comment") ? "" : jSONObject.getString("Comment"));
                                        po.setSapCode(jSONObject.isNull("SAPCode") ? "" : jSONObject.getString("SAPCode"));
                                        JSONArray lineArray = jSONObject.getJSONArray("LineItems");
                                        for (int j = 0; j < lineArray.length(); ++j) {
                                            JSONObject jsono = lineArray.getJSONObject(j);
                                            PurchaseLineItem purchaseLineItem = new PurchaseLineItem(PurchaseRequestApprovalPane.this.da);
                                            purchaseLineItem.setParentPurchase(po);
                                            purchaseLineItem.setLineNumber(jsono.isNull("LineNumber") ? 0 : jsono.getInt("LineNumber"));
                                            purchaseLineItem.setBaseLineNumber(jsono.isNull("BaseLineNumber") ? 0 : jsono.getInt("BaseLineNumber"));
                                            purchaseLineItem.setItemCode(jsono.isNull("ItemCode") ? "" : jsono.getString("ItemCode"));
                                            purchaseLineItem.setQuantity(jsono.isNull("Qty") ? 0 : jsono.getInt("Qty"));
                                            purchaseLineItem.setEditQty(jsono.isNull("EditQty") ? 0 : jsono.getInt("EditQty"));
                                            purchaseLineItem.setOpenQty(jsono.isNull("OpenQty") ? 0 : jsono.getInt("OpenQty"));
                                            purchaseLineItem.setPrice(jsono.isNull("UnitPrice") ? 0.0 : jsono.getDouble("UnitPrice"));
                                            purchaseLineItem.setEditPrice(jsono.isNull("EditPrice") ? 0.0 : jsono.getDouble("EditPrice"));
                                            purchaseLineItem.setCostCenter(jsono.isNull("CostCentre") ? "" : jsono.getString("CostCentre"));
                                            purchaseLineItem.setStoreCode(jsono.isNull("StoreCode") ? "" : jsono.getString("StoreCode"));
                                            purchaseLineItem.setTaxCode(jsono.isNull("TaxCode") ? "" : jsono.getString("TaxCode"));
                                            purchaseLineItem.setItemName(jsono.isNull("ItemName") ? "" : jsono.getString("ItemName"));
                                            purchaseLineItem.setCurrency(jsono.isNull("Currency") ? "" : jsono.getString("Currency"));
                                            purchaseLineItem.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            purchaseLineItem.setIsDeleted(jsono.isNull("Deleted") ? false : jsono.getBoolean("Deleted"));
                                            purchaseLineItem.setState(purchaseLineItem.getIsDeleted() != false ? ObjectState.Removed : ObjectState.New);
                                            purchaseLineItem.lastPurchasePriceProperty().set(jsono.isNull("LastPurchasePrice") ? 0.0 : jsono.getDouble("LastPurchasePrice"));
                                            purchaseLineItem.lastPurchaseDateProperty().set((Object)(jsono.isNull("LastPurchaseDate") ? "" : jsono.getString("LastPurchaseDate")));
                                            purchaseLineItem.soldOutMonthProperty().set(jsono.isNull("SoldOutMonth") ? 0 : jsono.getInt("SoldOutMonth"));
                                            purchaseLineItem.lastPurchaseCurrencyProperty().set((Object)(jsono.isNull("LastPurchaseCurrency") ? "" : jsono.getString("LastPurchaseCurrency")));
                                            purchaseLineItem.currentQtyProperty().set(jsono.isNull("CurrentQty") ? 0 : jsono.getInt("CurrentQty"));
                                            po.getItems().add((Object)purchaseLineItem);
                                        }
                                        JSONArray historiesArray = jSONObject.getJSONArray("histories");
                                        for (int j = 0; j < historiesArray.length(); ++j) {
                                            JSONObject jsono = historiesArray.getJSONObject(j);
                                            POApprovalHistory pOApprovalHistory = new POApprovalHistory(PurchaseRequestApprovalPane.this.da);
                                            pOApprovalHistory.setStage(jsono.isNull("Stage") ? "" : jsono.getString("Stage"));
                                            pOApprovalHistory.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            pOApprovalHistory.setApprovingUser(jsono.isNull("ApprovingUser") ? "" : jsono.getString("ApprovingUser"));
                                            dt = df.parse(jsono.getString("DateCreated"));
                                            pOApprovalHistory.setDateCreated(new Date(dt.getTime()));
                                            pOApprovalHistory.setRemark(jsono.isNull("Remark") ? "" : jsono.getString("Remark"));
                                            pOApprovalHistory.setActionTaken(jsono.isNull("ActionTaken") ? "" : jsono.getString("ActionTaken"));
                                            po.getHistories().add((Object)pOApprovalHistory);
                                        }
                                        po.resetNumbering();
                                        podl.getOriginalList().add((Object)po);
                                    }
                                    Platform.runLater(() -> {
                                        PurchaseRequestApprovalPane.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseRequestApprovalPane.this.table.getItems().clear();
                                        PurchaseRequestApprovalPane.this.purchaseOrderDataList.getOriginalList().clear();
                                        PurchaseRequestApprovalPane.this.purchaseOrderDataList.getOriginalList().addAll(podl.getOriginalList());
                                        PurchaseRequestApprovalPane.this.table.refresh();
                                        PurchaseRequestApprovalPane.this.list.setItems(PurchaseRequestApprovalPane.this.purchaseOrderDataList.getOriginalList());
                                        PurchaseRequestApprovalPane.this.list.refresh();
                                        PurchaseRequestApprovalPane.this.resetControl();
                                        if (showNotification) {
                                            PurchaseRequestApprovalPane.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", PurchaseRequestApprovalPane.this);
                                        }
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        PurchaseRequestApprovalPane.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseRequestApprovalPane.this.table.getItems().clear();
                                        PurchaseRequestApprovalPane.this.purchaseOrderDataList.getOriginalList().clear();
                                        PurchaseRequestApprovalPane.this.table.refresh();
                                        PurchaseRequestApprovalPane.this.list.setItems(PurchaseRequestApprovalPane.this.purchaseOrderDataList.getOriginalList());
                                        PurchaseRequestApprovalPane.this.list.refresh();
                                        PurchaseRequestApprovalPane.this.mainPage.showNotification(NotificationType.Information, "No Purchase Request Found", PurchaseRequestApprovalPane.this);
                                        PurchaseRequestApprovalPane.this.resetControl();
                                    });
                                }
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    PurchaseRequestApprovalPane.this.stackPane.getChildren().remove((Object)box);
                                    PurchaseRequestApprovalPane.this.mainPage.showNotification(NotificationType.Error, fullError, PurchaseRequestApprovalPane.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                PurchaseRequestApprovalPane.this.stackPane.getChildren().remove((Object)box);
                                PurchaseRequestApprovalPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), PurchaseRequestApprovalPane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void post() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            BufferedReader br;
                            Object url = PurchaseRequestApprovalPane.this.santa.syncSetting.getBEURL();
                            url = (String)url + "RPurchaseOrder/ApproveRequests";
                            JSONObject js = new JSONObject();
                            js.put("ApprovingUser", (Object)PurchaseRequestApprovalPane.this.currentUser.getUserName());
                            js.put("ApprovalComment", (Object)PurchaseRequestApprovalPane.this.approvalComment.getText());
                            PurchaseOrderDataList podl = new PurchaseOrderDataList(PurchaseRequestApprovalPane.this.da);
                            podl.getOriginalList().addAll((Collection)PurchaseRequestApprovalPane.this.purchaseOrderDataList.getOriginalList().stream().filter(v -> v.approvedStatus > 0 && v.getSyncFlag() == false).collect(Collectors.toList()));
                            boolean approved = false;
                            if (podl.getOriginalList().stream().filter(v -> v.approvedStatus == 1).count() == (long)podl.getOriginalList().size()) {
                                approved = true;
                            }
                            js.put("Approved", approved);
                            JSONArray jSONArray = new JSONArray();
                            for (PurchaseOrder purchaseOrder1 : podl.getOriginalList()) {
                                JSONObject job = new JSONObject();
                                job.put("DocNum", purchaseOrder1.DockNum);
                                job.put("DocEntry", purchaseOrder1.DocEntry);
                                job.put("BaseDocumentNum", purchaseOrder1.BaseDocumentNum);
                                job.put("VendorId", (Object)purchaseOrder1.getSupplierCode());
                                job.put("VendorName", (Object)purchaseOrder1.getSupplierName());
                                job.put("DocDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(purchaseOrder1.getDateCreated()));
                                job.put("DeliveryDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(purchaseOrder1.getDueDate()));
                                job.put("Currency", (Object)purchaseOrder1.getCurrency());
                                job.put("Status", (Object)purchaseOrder1.getStatus());
                                job.put("Code", (Object)purchaseOrder1.getCode());
                                PurchaseRequestApprovalPane.this.dockTotal = 0.0;
                                purchaseOrder1.getItems().forEach(v -> {
                                    if (v.getLineNumber() == -1 && v.getPrice() == 0.0 && v.editPriceProperty().get() > 0.0) {
                                        v.setPrice(v.editPriceProperty().get());
                                        v.setQuantity(v.editQtyProperty().get());
                                    }
                                    if (purchaseOrder1.getPurchaseType().equals(PurchaseType.Service.name())) {
                                        v.setLineTotal(v.getPrice());
                                    }
                                    if (v.getState() != ObjectState.Removed) {
                                        PurchaseRequestApprovalPane.this.dockTotal += v.getLineTotal();
                                    }
                                });
                                job.put("DocTotal", PurchaseRequestApprovalPane.this.dockTotal);
                                job.put("Comment", purchaseOrder1.createCommentProperty().get());
                                job.put("PurchasingOfficer", purchaseOrder1.createdByProperty().get());
                                job.put("ApprovalTemplateDescription", (Object)purchaseOrder1.getParentTemplateDescription());
                                job.put("EditTemplateDescription", purchaseOrder1.editTemplateDescriptionProperty().get());
                                job.put("PurchaseType", (Object)purchaseOrder1.getPurchaseType());
                                job.put("PaymentTerm", (Object)purchaseOrder1.getPaymentTerm());
                                job.put("OrderNo", purchaseOrder1.OrderNoProperty().get());
                                JSONArray jab = new JSONArray();
                                for (PurchaseLineItem purchaseLineItem : purchaseOrder1.getItems()) {
                                    JSONObject joItem = new JSONObject();
                                    joItem.put("LineNumber", purchaseLineItem.getLineNumber());
                                    joItem.put("BaseLineNumber", purchaseLineItem.getBaseLineNumber());
                                    joItem.put("ItemCode", (Object)purchaseLineItem.getItemCode());
                                    joItem.put("Qty", purchaseLineItem.getQuantity());
                                    joItem.put("EditQty", purchaseLineItem.editQtyProperty().get());
                                    joItem.put("OpenQty", purchaseLineItem.getOpenQty());
                                    joItem.put("UnitPrice", purchaseLineItem.getPrice());
                                    joItem.put("EditPrice", purchaseLineItem.editPriceProperty().get());
                                    joItem.put("CostCentre", (Object)purchaseLineItem.getCostCenter());
                                    joItem.put("StoreCode", (Object)purchaseLineItem.getStoreCode());
                                    joItem.put("TaxCode", (Object)purchaseLineItem.getTaxCode());
                                    joItem.put("ItemName", (Object)purchaseLineItem.getItemName());
                                    joItem.put("Currency", (Object)purchaseLineItem.getCurrency());
                                    joItem.put("LineTotal", purchaseLineItem.getQuantity() > 0 ? (double)purchaseLineItem.getQuantity() * purchaseLineItem.getPrice() : purchaseLineItem.getPrice());
                                    joItem.put("Code", (Object)purchaseLineItem.getCode());
                                    joItem.put("Deleted", purchaseLineItem.getState() == ObjectState.Removed);
                                    jab.put((Object)joItem);
                                }
                                job.put("LineItems", (Object)jab);
                                jSONArray.put((Object)job);
                            }
                            js.put("Requests", (Object)jSONArray);
                            HttpPost httpPost = new HttpPost((String)url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            File f = Santa.writePayLoadToFileAll(js.toString());
                            HttpEntity reqEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("payload", f, ContentType.DEFAULT_BINARY, f.getName()).build();
                            httpPost.setEntity(reqEntity);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                Platform.runLater(() -> {
                                    for (int i = 0; i < ra.length(); ++i) {
                                        try {
                                            JSONObject jsono = ra.getJSONObject(i);
                                            String poCode = jsono.isNull("POCode") ? "" : jsono.getString("POCode");
                                            String poErrorMsg = jsono.isNull("ErrMessage") ? "" : jsono.getString("ErrMessage");
                                            PurchaseOrder po = PurchaseRequestApprovalPane.this.purchaseOrderDataList.getOriginalList().stream().filter(v -> v.getCode().equals(poCode)).findAny().orElse(null);
                                            if (po == null) continue;
                                            po.syncErrorProperty().set((Object)poErrorMsg);
                                            po.setSyncFlag(((String)po.syncErrorProperty().get()).isEmpty());
                                            continue;
                                        }
                                        catch (Exception ex) {
                                            PurchaseRequestApprovalPane.this.stackPane.getChildren().remove((Object)PurchaseRequestApprovalPane.this.progressContainer);
                                            PurchaseRequestApprovalPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), PurchaseRequestApprovalPane.this);
                                            Logger.getLogger(PurchaseRequestApprovalPane.class.getName()).log(Level.SEVERE, null, ex.getLocalizedMessage());
                                            return;
                                        }
                                    }
                                    PurchaseRequestApprovalPane.this.list.refresh();
                                    PurchaseRequestApprovalPane.this.stackPane.getChildren().remove((Object)box);
                                    PurchaseRequestApprovalPane.this.resetControl();
                                    PurchaseRequestApprovalPane.this.loadMine(true);
                                });
                            } else {
                                String output;
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    PurchaseRequestApprovalPane.this.stackPane.getChildren().remove((Object)box);
                                    PurchaseRequestApprovalPane.this.mainPage.showNotification(NotificationType.Error, fullError, PurchaseRequestApprovalPane.this);
                                });
                            }
                        }
                        catch (Exception ex) {
                            Platform.runLater(() -> {
                                PurchaseRequestApprovalPane.this.stackPane.getChildren().remove((Object)box);
                                PurchaseRequestApprovalPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), PurchaseRequestApprovalPane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void resetControl() {
        this.lblCurrStage.setText("");
        this.lblStatus.setText("");
        this.lblCurrency.setText("");
        this.lblTotal.setText("");
        this.txtAreaPoComment.clear();
        this.vbHistory.getChildren().clear();
    }

    void showDialog() {
        this.dialog = new JFXDialog(this.stackPane, (Region)new PurchaseOrderDialog(this), JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }
}

