/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.POApprovalHistory;
import com.xputertechnologies.santa.PurchaseDeliveryNote;
import com.xputertechnologies.santa.PurchaseLineItem;
import com.xputertechnologies.santa.PurchaseOrder;
import com.xputertechnologies.santa.PurchaseType;
import com.xputertechnologies.santa.PurchaseTypeEnum;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.list.PurchaseOrderDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.ui.IPurchasePane;
import com.xputertechnologies.santa.ui.MailControl;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PDNCreateEditDialog;
import com.xputertechnologies.santa.ui.PurchaseOrderApprovalEditDialog;
import com.xputertechnologies.santa.ui.PurchaseOrderDialog;
import com.xputertechnologies.santa.ui.PurchaseOrderHistory;
import com.xputertechnologies.santa.ui.PurchaseOrderPane;
import com.xputertechnologies.santa.ui.PurchaseRequestApprovalPane;
import com.xputertechnologies.santa.ui.Santa;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class PurchaseOrderClosePane
extends IPurchasePane {
    @FXML
    JFXDatePicker dpStartDate;
    @FXML
    VBox vbHistory;
    @FXML
    Label lblCurrency;
    @FXML
    Label lblTotal;
    @FXML
    JFXListView<PurchaseOrder> list;
    @FXML
    JFXTextArea approvalComment;
    @FXML
    private TableView<PurchaseLineItem> table;
    @FXML
    private JFXButton btnReload;
    @FXML
    private JFXButton btnSearch;
    @FXML
    private JFXButton btnCancelPO;
    @FXML
    public StackPane stackPane;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colPrice;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colCostCenter;
    @FXML
    private TableColumn colTaxCode;
    @FXML
    private TableColumn colQty;
    PurchaseOrderDataList purchaseOrderDataList = null;
    VBox progressContainer;
    @FXML
    private JFXTextField tbSearch;
    String str = "";
    double dockTotal = 0.0;

    public PurchaseOrderClosePane(Santa app) {
        super("PurchaseOrderClosePane.fxml", app);
        this.title = "Purchase Cancel";
        this.purchaseTypeEnum = PurchaseTypeEnum.PDN;
        if (this.santa.Products.isEmpty()) {
            try {
                this.santa.Products.addAll(StockItemList.selectAllYuProducts(this.da));
            }
            catch (SQLException ex) {
                Logger.getLogger(PurchaseOrderPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.btnReload.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.REFRESH).color(Color.WHITE).size(15.0));
        this.btnCancelPO.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CLOSE).color(Color.WHITE).size(15.0));
        this.purchaseOrderDataList = new PurchaseOrderDataList(this.da);
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.colCostCenter.setCellValueFactory((Callback)new PropertyValueFactory("costCenter"));
        this.colTaxCode.setCellValueFactory((Callback)new PropertyValueFactory("taxCode"));
        this.lblTotal.setText("");
        this.lblCurrency.setText("");
        this.dpStartDate.setValue((Object)LocalDate.now());
        this.list.setItems(this.purchaseOrderDataList.getOriginalList());
        this.list.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PurchaseOrder>(){

            public void changed(ObservableValue<? extends PurchaseOrder> observable, PurchaseOrder oldValue, PurchaseOrder newValue) {
                if (newValue != null) {
                    PurchaseOrderClosePane.this.table.setItems(newValue.getItems());
                    PurchaseOrderClosePane.this.table.refresh();
                    PurchaseOrderClosePane.this.vbHistory.getChildren().clear();
                    newValue.getHistories().forEach(v -> PurchaseOrderClosePane.this.vbHistory.getChildren().add((Object)new PurchaseOrderHistory(PurchaseOrderClosePane.this.santa, (POApprovalHistory)v)));
                    PurchaseOrderClosePane.this.lblCurrency.setText(newValue.getCurrency());
                    newValue.recalculateTotal();
                    PurchaseOrderClosePane.this.lblTotal.textProperty().bindBidirectional((Property)newValue.totalProperty(), PurchaseOrderClosePane.this.dConverter);
                }
            }
        });
        this.list.setCellFactory((Callback)new Callback<ListView<PurchaseOrder>, ListCell<PurchaseOrder>>(){

            public ListCell<PurchaseOrder> call(ListView<PurchaseOrder> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<PurchaseOrder> cell = new ListCell<PurchaseOrder>(){

                    public void updateItem(PurchaseOrder po, boolean empty) {
                        super.updateItem((Object)po, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            Label code = new Label();
                            if (((String)po.syncErrorProperty().get()).isEmpty() && po.getSyncFlag().booleanValue()) {
                                code.setTextFill((Paint)Color.web((String)"#00A86B"));
                            } else if (!((String)po.syncErrorProperty().get()).isEmpty()) {
                                code.setTextFill((Paint)Color.web((String)"#FF0000"));
                            }
                            Label overDueLabel = new Label();
                            long endTime = new Date().getTime();
                            long curTime = po.getDueDate().getTime();
                            long diff = endTime - curTime;
                            long datediff = TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
                            overDueLabel.setText(Long.toString(datediff) + " Day(s) Ago");
                            overDueLabel.setStyle("  -fx-font-size: 10px; -fx-font-weight: bold;");
                            overDueLabel.setTextFill((Paint)Color.web((String)"#FF0000"));
                            code.setText(po.getCode());
                            HBox bLabel = new HBox(new Node[]{code});
                            bLabel.setAlignment(Pos.CENTER_LEFT);
                            HBox hBoxRight = new HBox(10.0);
                            hBoxRight.setMinSize(-1.0, -1.0);
                            hBoxRight.setAlignment(Pos.CENTER);
                            JFXButton closeBtn = new JFXButton();
                            closeBtn.setGraphic((Node)PurchaseOrderClosePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.UNLOCK).color(Color.web((String)"#09FA60")).size(18.0));
                            closeBtn.setOnAction(v -> {
                                if (po.approvedStatus == 0) {
                                    closeBtn.setGraphic((Node)PurchaseOrderClosePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.LOCK).color(Color.web((String)"#FF0000")).size(18.0));
                                    po.approvedStatus = 1;
                                } else {
                                    closeBtn.setGraphic((Node)PurchaseOrderClosePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.UNLOCK).color(Color.web((String)"#09FA60")).size(18.0));
                                    po.approvedStatus = 0;
                                }
                            });
                            JFXButton sendRemainder = new JFXButton();
                            sendRemainder.setTooltip(new Tooltip("Send Reminder Mail"));
                            sendRemainder.setGraphic((Node)PurchaseOrderClosePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.ENVELOPE).color(Color.web((String)"#4FC4F6")).size(18.0));
                            sendRemainder.setOnAction(v -> {
                                PurchaseOrderClosePane.this.dialog = new JFXDialog(PurchaseOrderClosePane.this.stackPane, (Region)new MailControl(PurchaseOrderClosePane.this, null), JFXDialog.DialogTransition.CENTER);
                                PurchaseOrderClosePane.this.dialog.setOverlayClose(false);
                                PurchaseOrderClosePane.this.dialog.show();
                            });
                            HBox root = new HBox();
                            root.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
                            code.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
                            Pane spacer = new Pane();
                            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                            spacer.setMinSize(10.0, 1.0);
                            hBoxRight.getChildren().addAll((Object[])new Node[]{overDueLabel, sendRemainder, closeBtn});
                            root.getChildren().addAll((Object[])new Node[]{bLabel, spacer, hBoxRight});
                            tooltip.setText((String)po.syncErrorProperty().get());
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)root);
                        }
                    }
                };
                return cell;
            }
        });
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2 && event.getTarget() instanceof Label) {
                    PurchaseOrderClosePane.this.purchaseOrder = (PurchaseOrder)PurchaseOrderClosePane.this.list.getSelectionModel().getSelectedItem();
                    PurchaseOrderClosePane.this.readOnly = true;
                    PurchaseOrderClosePane.this.dialog = new JFXDialog(PurchaseOrderClosePane.this.stackPane, (Region)new PurchaseOrderApprovalEditDialog(PurchaseOrderClosePane.this), JFXDialog.DialogTransition.CENTER);
                    PurchaseOrderClosePane.this.dialog.setOverlayClose(false);
                    PurchaseOrderClosePane.this.dialog.show();
                }
            }
        });
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryViewEdit = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                            this.btn.setGraphic((Node)PurchaseOrderClosePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(15.0));
                            this.btn.setStyle("-fx-background-color: #4FC4F6;");
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setOnAction(event -> {
                                PurchaseOrderClosePane.this.purchaseOrder = (PurchaseOrder)PurchaseOrderClosePane.this.list.getSelectionModel().getSelectedItem();
                                PurchaseOrderClosePane.this.selectedStock = req;
                                PurchaseOrderClosePane.this.showDialog();
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.btnReload.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PurchaseOrderClosePane.this.tbSearch.clear();
                PurchaseOrderClosePane.this.load(false);
            }
        });
        this.tbSearch.clear();
        this.load(false);
        this.btnSearch.setOnAction(v -> {
            if (!this.tbSearch.getText().isEmpty()) {
                this.load(false);
            }
        });
        this.btnCancelPO.setOnAction(c -> {
            if (this.purchaseOrderDataList.getOriginalList().stream().filter(d -> d.approvedStatus > 0).findAny().orElse(null) != null) {
                List<PurchaseOrder> pos = this.purchaseOrderDataList.getOriginalList().stream().filter(d -> d.approvedStatus > 0).collect(Collectors.toList());
                this.str = "";
                pos.forEach(x -> {
                    this.str = this.str + x.getCode() + ",";
                });
                this.mainPage.showNotification(NotificationType.Warning, "Are you sure you want to cancel " + this.str.substring(0, this.str.length() - 1) + " Request(s)?", this);
            } else {
                this.mainPage.showNotification(NotificationType.Warning, "No Purchase selected to cancel", this);
            }
        });
    }

    void load(final boolean showNotification) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String url = PurchaseOrderClosePane.this.santa.syncSetting.getBEURL() + "RPurchaseOrder/GetPurchaseRequestsOverdue";
                            HttpGet httpGet = new HttpGet(url);
                            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                            BasicNameValuePair param1 = new BasicNameValuePair("searchString", PurchaseOrderClosePane.this.tbSearch.getText());
                            listParam.add(param1);
                            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            LocalDateTime Strtdatetime = LocalDate.of(((LocalDate)PurchaseOrderClosePane.this.dpStartDate.getValue()).getYear(), ((LocalDate)PurchaseOrderClosePane.this.dpStartDate.getValue()).getMonth().getValue(), ((LocalDate)PurchaseOrderClosePane.this.dpStartDate.getValue()).getDayOfMonth()).atTime(0, 0, 0);
                            String fromDt = format.format(java.sql.Date.from(Strtdatetime.atZone(ZoneId.systemDefault()).toInstant()));
                            BasicNameValuePair param2 = new BasicNameValuePair("startDate", fromDt);
                            listParam.add(param2);
                            URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
                            httpGet.setURI(uri);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                PurchaseOrderDataList podl = new PurchaseOrderDataList(PurchaseOrderClosePane.this.da);
                                if (ra.length() > 0) {
                                    for (int i = 0; i < ra.length(); ++i) {
                                        JSONObject jSONObject = ra.getJSONObject(i);
                                        PurchaseOrder po = new PurchaseOrder(PurchaseOrderClosePane.this.da);
                                        po.DocEntry = jSONObject.isNull("DocEntry") ? 0 : jSONObject.getInt("DocEntry");
                                        po.DockNum = jSONObject.isNull("DocNum") ? 0 : jSONObject.getInt("DocNum");
                                        po.BaseDocumentNum = jSONObject.isNull("BaseDocumentNum") ? 0 : jSONObject.getInt("BaseDocumentNum");
                                        po.setTotal(jSONObject.isNull("DocTotal") ? 0.0 : jSONObject.getDouble("DocTotal"));
                                        po.setCode(jSONObject.isNull("Code") ? "" : jSONObject.getString("Code"));
                                        po.setSupplierCode(jSONObject.isNull("VendorId") ? "" : jSONObject.getString("VendorId"));
                                        po.setSupplierName(jSONObject.isNull("VendorName") ? "" : jSONObject.getString("VendorName"));
                                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                        Date dt = df.parse(jSONObject.getString("DocDate"));
                                        po.setDateCreated(new Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("DeliveryDate"));
                                        po.setDueDate(new Date(dt.getTime()));
                                        po.setCurrency(jSONObject.isNull("Currency") ? "" : jSONObject.getString("Currency"));
                                        po.setStatus(jSONObject.isNull("Status") ? "" : jSONObject.getString("Status"));
                                        po.createCommentProperty().set((Object)(jSONObject.isNull("Comment") ? "" : jSONObject.getString("Comment")));
                                        po.createdByProperty().set((Object)(jSONObject.isNull("PurchasingOfficer") ? "" : jSONObject.getString("PurchasingOfficer")));
                                        po.setParentTemplateDescription(jSONObject.isNull("ApprovalTemplateDescription") ? "" : jSONObject.getString("ApprovalTemplateDescription"));
                                        po.setPurchaseType(jSONObject.isNull("PurchaseType") ? "" : jSONObject.getString("PurchaseType"));
                                        po.setPaymentTerm(jSONObject.isNull("PaymentTerm") ? "" : jSONObject.getString("PaymentTerm"));
                                        po.OrderNoProperty().set((Object)(jSONObject.isNull("OrderNo") ? "" : jSONObject.getString("OrderNo")));
                                        JSONArray lineArray = jSONObject.getJSONArray("LineItems");
                                        for (int j = 0; j < lineArray.length(); ++j) {
                                            JSONObject jsono = lineArray.getJSONObject(j);
                                            PurchaseLineItem purchaseLineItem = new PurchaseLineItem(PurchaseOrderClosePane.this.da);
                                            purchaseLineItem.setParentPurchase(po);
                                            purchaseLineItem.setLineNumber(jsono.isNull("LineNumber") ? 0 : jsono.getInt("LineNumber"));
                                            purchaseLineItem.setBaseLineNumber(jsono.isNull("BaseLineNumber") ? 0 : jsono.getInt("BaseLineNumber"));
                                            purchaseLineItem.setItemCode(jsono.isNull("ItemCode") ? "" : jsono.getString("ItemCode"));
                                            purchaseLineItem.setQuantity(jsono.isNull("Qty") ? 0 : jsono.getInt("Qty"));
                                            purchaseLineItem.setOpenQty(jsono.isNull("OpenQty") ? 0 : jsono.getInt("OpenQty"));
                                            purchaseLineItem.setPrice(jsono.isNull("UnitPrice") ? 0.0 : jsono.getDouble("UnitPrice"));
                                            purchaseLineItem.setCostCenter(jsono.isNull("CostCentre") ? "" : jsono.getString("CostCentre"));
                                            purchaseLineItem.setStoreCode(jsono.isNull("StoreCode") ? "" : jsono.getString("StoreCode"));
                                            purchaseLineItem.setTaxCode(jsono.isNull("TaxCode") ? "" : jsono.getString("TaxCode"));
                                            purchaseLineItem.setItemName(jsono.isNull("ItemName") ? "" : jsono.getString("ItemName"));
                                            purchaseLineItem.setCurrency(jsono.isNull("Currency") ? "" : jsono.getString("Currency"));
                                            purchaseLineItem.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            po.getItems().add((Object)purchaseLineItem);
                                        }
                                        JSONArray historiesArray = jSONObject.getJSONArray("histories");
                                        for (int j = 0; j < historiesArray.length(); ++j) {
                                            JSONObject jsono = historiesArray.getJSONObject(j);
                                            POApprovalHistory pOApprovalHistory = new POApprovalHistory(PurchaseOrderClosePane.this.da);
                                            pOApprovalHistory.setStage(jsono.isNull("Stage") ? "" : jsono.getString("Stage"));
                                            pOApprovalHistory.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            pOApprovalHistory.setApprovingUser(jsono.isNull("ApprovingUser") ? "" : jsono.getString("ApprovingUser"));
                                            dt = df.parse(jsono.getString("DateCreated"));
                                            pOApprovalHistory.setDateCreated(new Date(dt.getTime()));
                                            pOApprovalHistory.setRemark(jsono.isNull("Remark") ? "" : jsono.getString("Remark"));
                                            pOApprovalHistory.setActionTaken(jsono.isNull("ActionTaken") ? "" : jsono.getString("ActionTaken"));
                                            po.getHistories().add((Object)pOApprovalHistory);
                                        }
                                        JSONArray delievryNotesArray = jSONObject.getJSONArray("DeliveryNotes");
                                        for (int j = 0; j < delievryNotesArray.length(); ++j) {
                                            JSONObject jsono = delievryNotesArray.getJSONObject(j);
                                            PurchaseDeliveryNote pdn = new PurchaseDeliveryNote(PurchaseOrderClosePane.this.da);
                                            pdn.setSapCode(jsono.isNull("SAPCode") ? "" : jsono.getString("SAPCode"));
                                            pdn.DocEntry = jsono.isNull("DocEntry") ? 0 : jsono.getInt("DocEntry");
                                            pdn.DockNum = jsono.isNull("DocNum") ? 0 : jsono.getInt("DocNum");
                                            pdn.BaseDocumentNum = jsono.isNull("BaseDocumentNum") ? 0 : jsono.getInt("BaseDocumentNum");
                                            pdn.setTotal(jsono.isNull("DocTotal") ? 0.0 : jsono.getDouble("DocTotal"));
                                            pdn.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            pdn.setSupplierCode(jsono.isNull("VendorId") ? "" : jsono.getString("VendorId"));
                                            pdn.setSupplierName(jsono.isNull("VendorName") ? "" : jsono.getString("VendorName"));
                                            dt = df.parse(jsono.getString("DocDate"));
                                            pdn.setDateCreated(new Date(dt.getTime()));
                                            dt = df.parse(jsono.getString("DeliveryDate"));
                                            pdn.setDueDate(new Date(dt.getTime()));
                                            pdn.setStatus(jsono.isNull("Status") ? "" : jsono.getString("Status"));
                                            pdn.createCommentProperty().set((Object)(jsono.isNull("Comment") ? "" : jsono.getString("Comment")));
                                            pdn.createdByProperty().set((Object)(jsono.isNull("PurchasingOfficer") ? "" : jsono.getString("PurchasingOfficer")));
                                            pdn.OrderNoProperty().set((Object)(jsono.isNull("OrderNo") ? "" : jsono.getString("OrderNo")));
                                            JSONArray lineArrayPdn = jsono.getJSONArray("LineItems");
                                            for (int k = 0; k < lineArrayPdn.length(); ++k) {
                                                JSONObject jsonoItem = lineArrayPdn.getJSONObject(k);
                                                PurchaseLineItem purchaseLineItem = new PurchaseLineItem(PurchaseOrderClosePane.this.da);
                                                purchaseLineItem.setParentPurchase(pdn);
                                                purchaseLineItem.setLineNumber(jsonoItem.isNull("LineNumber") ? 0 : jsonoItem.getInt("LineNumber"));
                                                purchaseLineItem.setBaseLineNumber(jsonoItem.isNull("BaseLineNumber") ? 0 : jsonoItem.getInt("BaseLineNumber"));
                                                purchaseLineItem.setItemCode(jsonoItem.isNull("ItemCode") ? "" : jsonoItem.getString("ItemCode"));
                                                purchaseLineItem.setQuantity(jsonoItem.isNull("Qty") ? 0 : jsonoItem.getInt("Qty"));
                                                purchaseLineItem.setOpenQty(jsonoItem.isNull("OpenQty") ? 0 : jsonoItem.getInt("OpenQty"));
                                                purchaseLineItem.setPrice(jsonoItem.isNull("UnitPrice") ? 0.0 : jsonoItem.getDouble("UnitPrice"));
                                                purchaseLineItem.setCostCenter(jsonoItem.isNull("CostCentre") ? "" : jsonoItem.getString("CostCentre"));
                                                purchaseLineItem.setStoreCode(jsonoItem.isNull("StoreCode") ? "" : jsonoItem.getString("StoreCode"));
                                                purchaseLineItem.setTaxCode(jsonoItem.isNull("TaxCode") ? "" : jsonoItem.getString("TaxCode"));
                                                purchaseLineItem.setItemName(jsonoItem.isNull("ItemName") ? "" : jsonoItem.getString("ItemName"));
                                                purchaseLineItem.setCurrency(jsonoItem.isNull("Currency") ? "" : jsonoItem.getString("Currency"));
                                                purchaseLineItem.setCode(jsonoItem.isNull("Code") ? "" : jsonoItem.getString("Code"));
                                                pdn.getItems().add((Object)purchaseLineItem);
                                            }
                                            po.getDeleveryNotes().add((Object)pdn);
                                        }
                                        po.resetNumbering();
                                        podl.getOriginalList().add((Object)po);
                                    }
                                    Platform.runLater(() -> {
                                        PurchaseOrderClosePane.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseOrderClosePane.this.table.getItems().clear();
                                        PurchaseOrderClosePane.this.purchaseOrderDataList.getOriginalList().clear();
                                        PurchaseOrderClosePane.this.purchaseOrderDataList.getOriginalList().addAll(podl.getOriginalList());
                                        PurchaseOrderClosePane.this.list.setItems(PurchaseOrderClosePane.this.purchaseOrderDataList.getOriginalList());
                                        PurchaseOrderClosePane.this.list.refresh();
                                        if (showNotification) {
                                            PurchaseOrderClosePane.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", PurchaseOrderClosePane.this);
                                        }
                                        PurchaseOrderClosePane.this.resetControl();
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        PurchaseOrderClosePane.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseOrderClosePane.this.table.getItems().clear();
                                        PurchaseOrderClosePane.this.purchaseOrderDataList.getOriginalList().clear();
                                        PurchaseOrderClosePane.this.table.refresh();
                                        PurchaseOrderClosePane.this.list.setItems(PurchaseOrderClosePane.this.purchaseOrderDataList.getOriginalList());
                                        PurchaseOrderClosePane.this.list.refresh();
                                        if (showNotification) {
                                            PurchaseOrderClosePane.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", PurchaseOrderClosePane.this);
                                        } else {
                                            PurchaseOrderClosePane.this.mainPage.showNotification(NotificationType.Information, "No Purchase Request Found", PurchaseOrderClosePane.this);
                                        }
                                    });
                                }
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    PurchaseOrderClosePane.this.stackPane.getChildren().remove((Object)box);
                                    PurchaseOrderClosePane.this.mainPage.showNotification(NotificationType.Error, fullError, PurchaseOrderClosePane.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                PurchaseOrderClosePane.this.stackPane.getChildren().remove((Object)box);
                                PurchaseOrderClosePane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), PurchaseOrderClosePane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void resetControl() {
        this.lblCurrency.setText("");
        this.lblTotal.setText("");
        this.table.getItems().clear();
        this.table.refresh();
        this.vbHistory.getChildren().clear();
    }

    void post() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String output;
                            BufferedReader br;
                            Object url = PurchaseOrderClosePane.this.santa.syncSetting.getBEURL();
                            url = (String)url + "RPurchaseOrder/CancelPOs";
                            JSONObject js = new JSONObject();
                            js.put("ApprovingUser", (Object)PurchaseOrderClosePane.this.currentUser.getUserName());
                            js.put("ApprovalComment", (Object)PurchaseOrderClosePane.this.approvalComment.getText());
                            PurchaseOrderDataList podl = new PurchaseOrderDataList(PurchaseOrderClosePane.this.da);
                            podl.getOriginalList().addAll((Collection)PurchaseOrderClosePane.this.purchaseOrderDataList.getOriginalList().stream().filter(v -> v.approvedStatus > 0 && v.getSyncFlag() == false).collect(Collectors.toList()));
                            boolean approved = false;
                            if (podl.getOriginalList().stream().filter(v -> v.approvedStatus == 1).count() == (long)podl.getOriginalList().size()) {
                                approved = true;
                            }
                            js.put("Approved", approved);
                            JSONArray jSONArray = new JSONArray();
                            for (PurchaseOrder purchaseOrder1 : podl.getOriginalList()) {
                                JSONObject job = new JSONObject();
                                job.put("DocNum", purchaseOrder1.DockNum);
                                job.put("DocEntry", purchaseOrder1.DocEntry);
                                job.put("BaseDocumentNum", purchaseOrder1.BaseDocumentNum);
                                job.put("VendorId", (Object)purchaseOrder1.getSupplierCode());
                                job.put("VendorName", (Object)purchaseOrder1.getSupplierName());
                                job.put("DocDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(purchaseOrder1.getDateCreated()));
                                job.put("DeliveryDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(purchaseOrder1.getDueDate()));
                                job.put("Currency", (Object)purchaseOrder1.getCurrency());
                                job.put("Status", (Object)purchaseOrder1.getStatus());
                                job.put("Code", (Object)purchaseOrder1.getCode());
                                PurchaseOrderClosePane.this.dockTotal = 0.0;
                                purchaseOrder1.getItems().forEach(v -> {
                                    if (purchaseOrder1.getPurchaseType().equals(PurchaseType.Service.name())) {
                                        v.setLineTotal(v.getPrice());
                                    }
                                    if (!v.getState().equals(ObjectState.Removed.name())) {
                                        PurchaseOrderClosePane.this.dockTotal += v.getLineTotal();
                                    }
                                });
                                job.put("DocTotal", PurchaseOrderClosePane.this.dockTotal);
                                job.put("Comment", purchaseOrder1.createCommentProperty().get());
                                job.put("PurchasingOfficer", purchaseOrder1.createdByProperty().get());
                                job.put("ApprovalTemplateDescription", (Object)purchaseOrder1.getParentTemplateDescription());
                                job.put("PurchaseType", (Object)purchaseOrder1.getPurchaseType());
                                job.put("PaymentTerm", (Object)purchaseOrder1.getPaymentTerm());
                                job.put("OrderNo", purchaseOrder1.OrderNoProperty().get());
                                JSONArray jab = new JSONArray();
                                for (PurchaseLineItem purchaseLineItem : purchaseOrder1.getItems()) {
                                    JSONObject joItem = new JSONObject();
                                    joItem.put("LineNumber", -1);
                                    joItem.put("BaseLineNumber", purchaseLineItem.getBaseLineNumber());
                                    joItem.put("ItemCode", (Object)purchaseLineItem.getItemCode());
                                    joItem.put("Qty", purchaseLineItem.getQuantity());
                                    joItem.put("OpenQty", purchaseLineItem.getOpenQty());
                                    joItem.put("UnitPrice", purchaseLineItem.getPrice());
                                    joItem.put("CostCentre", (Object)purchaseLineItem.getCostCenter());
                                    joItem.put("StoreCode", (Object)purchaseLineItem.getStoreCode());
                                    joItem.put("TaxCode", (Object)purchaseLineItem.getTaxCode());
                                    joItem.put("ItemName", (Object)purchaseLineItem.getItemName());
                                    joItem.put("Currency", (Object)purchaseLineItem.getCurrency());
                                    joItem.put("LineTotal", purchaseLineItem.getQuantity() > 0 ? (double)purchaseLineItem.getQuantity() * purchaseLineItem.getPrice() : purchaseLineItem.getPrice());
                                    joItem.put("Code", (Object)purchaseLineItem.getCode());
                                    joItem.put("Deleted", purchaseOrder1.getState() == ObjectState.Removed);
                                    jab.put((Object)joItem);
                                }
                                job.put("LineItems", (Object)jab);
                                jSONArray.put((Object)job);
                            }
                            js.put("Requests", (Object)jSONArray);
                            HttpPost httpPost = new HttpPost((String)url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            StringEntity stringEntity = new StringEntity(js.toString());
                            httpPost.setEntity((HttpEntity)stringEntity);
                            httpPost.setHeader("Content-type", "application/json");
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                Platform.runLater(() -> {
                                    for (int i = 0; i < ra.length(); ++i) {
                                        try {
                                            JSONObject jsono = ra.getJSONObject(i);
                                            String poCode = jsono.isNull("POCode") ? "" : jsono.getString("POCode");
                                            String poErrorMsg = jsono.isNull("ErrMessage") ? "" : jsono.getString("ErrMessage");
                                            PurchaseOrder po = PurchaseOrderClosePane.this.purchaseOrderDataList.getOriginalList().stream().filter(v -> v.getCode().equals(poCode)).findAny().orElse(null);
                                            if (po == null) continue;
                                            po.syncErrorProperty().set((Object)poErrorMsg);
                                            po.setSyncFlag(((String)po.syncErrorProperty().get()).isEmpty());
                                            continue;
                                        }
                                        catch (Exception ex) {
                                            Logger.getLogger(PurchaseRequestApprovalPane.class.getName()).log(Level.SEVERE, null, ex.getLocalizedMessage());
                                        }
                                    }
                                    PurchaseOrderClosePane.this.table.refresh();
                                    PurchaseOrderClosePane.this.stackPane.getChildren().remove((Object)box);
                                    PurchaseOrderClosePane.this.tbSearch.clear();
                                    PurchaseOrderClosePane.this.load(true);
                                });
                            } else {
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    PurchaseOrderClosePane.this.stackPane.getChildren().remove((Object)box);
                                    PurchaseOrderClosePane.this.mainPage.showNotification(NotificationType.Error, fullError, PurchaseOrderClosePane.this);
                                });
                            }
                        }
                        catch (Exception ex) {
                            Platform.runLater(() -> {
                                PurchaseOrderClosePane.this.stackPane.getChildren().remove((Object)box);
                                PurchaseOrderClosePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), PurchaseOrderClosePane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void showDialog() {
        this.dialog = new JFXDialog(this.stackPane, (Region)new PurchaseOrderDialog(this), JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    public void showDialogEdit() {
        this.dialog = new JFXDialog(this.stackPane, (Region)new PDNCreateEditDialog(this, true), JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    public void showDialogNew() {
        this.dialog = new JFXDialog(this.stackPane, (Region)new PurchaseOrderDialog(this), JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    @Override
    public void yes() {
        this.post();
    }
}

