/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDatePicker;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.NameValueObjectType;
import com.xputertechnologies.santa.ui.IPurchasePane;
import com.xputertechnologies.santa.ui.UIParent;
import java.time.ZoneId;
import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import org.controlsfx.control.textfield.TextFields;

public class PurchaseOrderApprovalEditDialog
extends UIParent {
    @FXML
    private JFXComboBox<NameValueObject> cmbPayType;
    @FXML
    private JFXComboBox<NameValueObject> cmbCurrency;
    @FXML
    private JFXComboBox<String> cmbSupplier;
    @FXML
    private JFXDatePicker dueDate;
    @FXML
    private JFXButton btnDone;
    @FXML
    private JFXButton btnCancel;
    IPurchasePane parent;
    ObservableList<String> suppliersList = FXCollections.observableArrayList();

    public PurchaseOrderApprovalEditDialog(final IPurchasePane parent) {
        super("PurchaseOrderApprovalEditDialog.fxml", parent.santa);
        this.santa = parent.santa;
        this.title = "Purcahse Order Edit";
        if (parent.readOnly) {
            this.cmbSupplier.setEditable(false);
            this.cmbPayType.setEditable(false);
            this.cmbCurrency.setEditable(false);
            this.dueDate.setEditable(false);
            this.btnDone.setVisible(false);
        }
        this.parent = parent;
        ObservableList<NameValueObject> paymentTerms = NameValueObject.select(NameValueObjectType.PaymentTerm.name(), this.da);
        final ObservableList<NameValueObject> suppliers = NameValueObject.select(NameValueObjectType.Supplier.name(), this.da);
        ObservableList<NameValueObject> currencies = NameValueObject.select(NameValueObjectType.Currencies.name(), this.da);
        suppliers.forEach(c -> this.suppliersList.add((Object)c.getData()));
        this.cmbSupplier.setItems(this.suppliersList);
        this.cmbSupplier.setEditable(true);
        TextFields.bindAutoCompletion((TextField)this.cmbSupplier.getEditor(), (Collection)this.cmbSupplier.getItems());
        this.cmbPayType.setItems(paymentTerms);
        this.cmbCurrency.setItems(currencies);
        if (parent.purchaseOrder.getSupplierCode() != null && !parent.purchaseOrder.getSupplierCode().isEmpty()) {
            this.cmbSupplier.getSelectionModel().select((Object)suppliers.stream().filter(k -> k.getKey().equals(parent.purchaseOrder.getSupplierCode())).findAny().get().getData());
        }
        if (parent.purchaseOrder.getPaymentTerm() != null && !parent.purchaseOrder.getPaymentTerm().isEmpty()) {
            this.cmbPayType.getSelectionModel().select((Object)paymentTerms.stream().filter(k -> k.getKey().equals(parent.purchaseOrder.getPaymentTerm())).findAny().get());
        }
        if (parent.purchaseOrder.getCurrency() != null && !parent.purchaseOrder.getCurrency().isEmpty()) {
            this.cmbCurrency.getSelectionModel().select((Object)currencies.stream().filter(k -> k.getKey().equals(parent.purchaseOrder.getCurrency())).findAny().get());
        }
        this.dueDate.setValue((Object)parent.purchaseOrder.getDueDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        this.cmbSupplier.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null && suppliers.stream().filter(x -> x.getData().equals(newValue)).count() > 0L) {
                    parent.purchaseOrder.setSupplierCode(suppliers.stream().filter(x -> x.getData().equals(newValue)).findAny().get().getKey());
                    parent.purchaseOrder.setSupplierName(newValue);
                }
            }
        });
        this.cmbPayType.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (newValue != null) {
                    parent.purchaseOrder.setPaymentTerm(newValue.getKey());
                }
            }
        });
        this.cmbCurrency.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<NameValueObject>(){

            public void changed(ObservableValue<? extends NameValueObject> observable, NameValueObject oldValue, NameValueObject newValue) {
                if (newValue != null) {
                    parent.purchaseOrder.setCurrency(newValue.getKey());
                }
            }
        });
        this.btnCancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.dialog.close();
            }
        });
        this.btnDone.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.dialog.close();
            }
        });
    }
}

