/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.ExcelReportObject;
import com.xputertechnologies.santa.NameValueObject;
import com.xputertechnologies.santa.NameValueObjectType;
import com.xputertechnologies.santa.POActionMapEnum;
import com.xputertechnologies.santa.POApprovalHistory;
import com.xputertechnologies.santa.PurchaseDeliveryNote;
import com.xputertechnologies.santa.PurchaseItemSerial;
import com.xputertechnologies.santa.PurchaseLineItem;
import com.xputertechnologies.santa.PurchaseOrder;
import com.xputertechnologies.santa.PurchaseType;
import com.xputertechnologies.santa.PurchaseTypeEnum;
import com.xputertechnologies.santa.StockItemData;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.POActionMapDataList;
import com.xputertechnologies.santa.list.PurchaseItemSerialDataList;
import com.xputertechnologies.santa.list.PurchaseLineItemDataList;
import com.xputertechnologies.santa.list.PurchaseOrderDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.IPurchasePane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PDNCreateEditDialog;
import com.xputertechnologies.santa.ui.PDNViewDialog;
import com.xputertechnologies.santa.ui.PurchaseOrderApprovalEditDialog;
import com.xputertechnologies.santa.ui.PurchaseOrderDialog;
import com.xputertechnologies.santa.ui.PurchaseOrderPane;
import com.xputertechnologies.santa.ui.PurchaseRequestApprovalPane;
import com.xputertechnologies.santa.ui.SalesReturnPaneAudit;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.TempRoleManagement;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PurchaseDeliveryNotePane
extends IPurchasePane {
    @FXML
    Label lblCurrency;
    @FXML
    Label lblTotal;
    @FXML
    JFXListView<PurchaseOrder> list;
    @FXML
    JFXTextArea closeComment;
    @FXML
    private TableView<PurchaseLineItem> table;
    @FXML
    private JFXButton btnReload;
    @FXML
    private JFXButton btnSearch;
    @FXML
    private JFXButton btnClosePO;
    @FXML
    public StackPane stackPane;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colPrice;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colCostCenter;
    @FXML
    private TableColumn colTaxCode;
    @FXML
    private TableColumn colQty;
    @FXML
    private TableColumn colTaxAmt;
    @FXML
    private TableColumn colOpenQty;
    PurchaseOrderDataList purchaseOrderDataList = null;
    VBox progressContainer;
    @FXML
    private JFXButton btnLoadGrpo;
    @FXML
    private JFXButton btnDelGrpo;
    @FXML
    private JFXDatePicker from;
    @FXML
    private JFXDatePicker to;
    @FXML
    private JFXTextField tbSearch;
    POActionMapDataList pOActionMapDataList;
    String str = "";
    double dockTotal = 0.0;

    public PurchaseDeliveryNotePane(final Santa app) {
        super("PurchaseDeliveryNotePane.fxml", app);
        this.title = "Purchase Delivery Note";
        this.pOActionMapDataList = new POActionMapDataList(this.da);
        this.pOActionMapDataList.selectAll();
        this.purchaseTypeEnum = PurchaseTypeEnum.PDN;
        if (this.santa.Products.isEmpty()) {
            try {
                this.santa.Products.addAll(StockItemList.selectAllYuProducts(this.da));
            }
            catch (SQLException ex) {
                Logger.getLogger(PurchaseOrderPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        final ObservableList<NameValueObject> costcenters = NameValueObject.select(NameValueObjectType.CostCentre.name(), this.da);
        final ObservableList<NameValueObject> taxCodes = NameValueObject.select(NameValueObjectType.TaxCodes.name(), this.da);
        this.from.setValue((Object)LocalDate.now().minusDays(1L));
        this.to.setValue((Object)LocalDate.now());
        this.btnReload.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.REFRESH).color(Color.WHITE).size(15.0));
        this.btnClosePO.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CLOSE).color(Color.WHITE).size(15.0));
        this.btnDelGrpo.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.TRASH).color(Color.WHITE).size(15.0));
        this.btnLoadGrpo.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.REPLY_ALL).color(Color.WHITE).size(15.0));
        this.purchaseOrderDataList = new PurchaseOrderDataList(this.da);
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.colCostCenter.setCellValueFactory((Callback)new PropertyValueFactory("costCenter"));
        this.colTaxCode.setCellValueFactory((Callback)new PropertyValueFactory("taxCode"));
        this.colOpenQty.setCellValueFactory((Callback)new PropertyValueFactory("openQty"));
        this.colTaxAmt.setCellValueFactory((Callback)new PropertyValueFactory("tax"));
        this.lblTotal.setText("");
        this.lblCurrency.setText("");
        this.list.setItems(this.purchaseOrderDataList.getOriginalList());
        this.list.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PurchaseOrder>(){

            public void changed(ObservableValue<? extends PurchaseOrder> observable, PurchaseOrder oldValue, PurchaseOrder newValue) {
                if (newValue != null) {
                    PurchaseDeliveryNotePane.this.table.setItems(newValue.getItems());
                    PurchaseDeliveryNotePane.this.table.refresh();
                    newValue.recalculateTotal();
                    PurchaseDeliveryNotePane.this.lblCurrency.setText(newValue.getCurrency());
                    PurchaseDeliveryNotePane.this.lblTotal.setText(General.formatDecimalToMoneyString(newValue.getTotalAmount()));
                }
            }
        });
        this.list.setCellFactory((Callback)new Callback<ListView<PurchaseOrder>, ListCell<PurchaseOrder>>(){

            public ListCell<PurchaseOrder> call(ListView<PurchaseOrder> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<PurchaseOrder> cell = new ListCell<PurchaseOrder>(){

                    public void updateItem(PurchaseOrder po, boolean empty) {
                        super.updateItem((Object)po, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            Label code = new Label();
                            if (((String)po.syncErrorProperty().get()).isEmpty() && po.getSyncFlag().booleanValue()) {
                                code.setTextFill((Paint)Color.web((String)"#00A86B"));
                            } else if (!((String)po.syncErrorProperty().get()).isEmpty()) {
                                code.setTextFill((Paint)Color.web((String)"#FF0000"));
                            }
                            code.setText(po.getCode());
                            HBox bLabel = new HBox(new Node[]{code});
                            bLabel.setAlignment(Pos.CENTER_LEFT);
                            HBox hBoxRight = new HBox(10.0);
                            hBoxRight.setMinSize(-1.0, -1.0);
                            hBoxRight.setAlignment(Pos.CENTER);
                            JFXButton viewPdn = new JFXButton();
                            viewPdn.setOnAction(v -> {
                                PurchaseDeliveryNotePane.this.purchaseOrder = po;
                                PurchaseDeliveryNotePane.this.dialog = new JFXDialog(PurchaseDeliveryNotePane.this.stackPane, (Region)new PDNViewDialog(PurchaseDeliveryNotePane.this), JFXDialog.DialogTransition.CENTER);
                                PurchaseDeliveryNotePane.this.dialog.setOverlayClose(false);
                                PurchaseDeliveryNotePane.this.dialog.show();
                            });
                            viewPdn.setTooltip(new Tooltip("View Inbound(s)"));
                            JFXButton newPDn = new JFXButton();
                            newPDn.setGraphic((Node)PurchaseDeliveryNotePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS).color(Color.web((String)"#7D3C98")).size(18.0));
                            viewPdn.setGraphic((Node)PurchaseDeliveryNotePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.web((String)"#00A86B")).size(18.0));
                            newPDn.setOnAction(v -> {
                                PurchaseDeliveryNotePane.this.purchaseOrder = po;
                                PurchaseDeliveryNotePane.this.dialog = new JFXDialog(PurchaseDeliveryNotePane.this.stackPane, (Region)new PDNCreateEditDialog(PurchaseDeliveryNotePane.this, false), JFXDialog.DialogTransition.CENTER);
                                PurchaseDeliveryNotePane.this.dialog.setOverlayClose(false);
                                PurchaseDeliveryNotePane.this.dialog.show();
                            });
                            JFXButton editPDn = new JFXButton();
                            editPDn.setTooltip(new Tooltip("Edit PO"));
                            editPDn.setGraphic((Node)PurchaseDeliveryNotePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.PENCIL).color(Color.web((String)"#4FC4F6")).size(18.0));
                            editPDn.setOnAction(v -> {
                                PurchaseDeliveryNotePane.this.purchaseOrder = po;
                                PurchaseDeliveryNotePane.this.showDialogEdit();
                            });
                            JFXButton expexcel = new JFXButton();
                            expexcel.setTooltip(new Tooltip("Export PO to Excel"));
                            expexcel.setGraphic((Node)PurchaseDeliveryNotePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.FILE_EXCEL_ALT).color(Color.web((String)"#7D3C98")).size(18.0));
                            expexcel.setOnAction(v -> {
                                PurchaseDeliveryNotePane.this.purchaseOrder = po;
                                ExcelReportObject excelReportObject = new ExcelReportObject();
                                excelReportObject.getHeaders().addAll(Arrays.asList("PO Code", "Supplier Name", "Item Name", "Item Code", "Qty", "Price", "Tax Amount"));
                                for (PurchaseLineItem item : PurchaseDeliveryNotePane.this.purchaseOrder.getItems()) {
                                    ArrayList<String> lst = new ArrayList<String>();
                                    lst.addAll(Arrays.asList(PurchaseDeliveryNotePane.this.purchaseOrder.getCode(), PurchaseDeliveryNotePane.this.purchaseOrder.getSupplierName(), item.getItemName(), item.getItemCode(), Integer.toString(item.getQuantity()), Double.toString(item.getPrice()), Double.toString(item.taxProperty().get())));
                                    excelReportObject.getValues().add(lst);
                                }
                                if (General.writeToExcel(app.stage, excelReportObject)) {
                                    PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Success, "P.O Exported", PurchaseDeliveryNotePane.this);
                                }
                            });
                            JFXButton closePDn = new JFXButton();
                            closePDn.setTooltip(new Tooltip("Close PO"));
                            closePDn.setGraphic((Node)PurchaseDeliveryNotePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.UNLOCK).color(Color.web((String)"#09FA60")).size(18.0));
                            closePDn.setOnAction(v -> {
                                if (po.approvedStatus == 0) {
                                    closePDn.setGraphic((Node)PurchaseDeliveryNotePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.LOCK).color(Color.web((String)"#FF0000")).size(18.0));
                                    po.approvedStatus = 1;
                                } else {
                                    closePDn.setGraphic((Node)PurchaseDeliveryNotePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.UNLOCK).color(Color.web((String)"#09FA60")).size(18.0));
                                    po.approvedStatus = 0;
                                }
                            });
                            newPDn.setTooltip(new Tooltip("Create new Inbound"));
                            viewPdn.setDisable(po.getSyncFlag().booleanValue());
                            viewPdn.setDisable(po.getSyncFlag().booleanValue());
                            HBox root = new HBox();
                            root.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
                            code.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
                            Pane spacer = new Pane();
                            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                            spacer.setMinSize(10.0, 1.0);
                            hBoxRight.getChildren().add((Object)expexcel);
                            if (!po.getDeleveryNotes().isEmpty()) {
                                hBoxRight.getChildren().add((Object)viewPdn);
                            }
                            if (TempRoleManagement.canEditPO(UserType.valueOf(PurchaseDeliveryNotePane.this.mainPage.currentUser.getRoleDescription()))) {
                                hBoxRight.getChildren().add((Object)editPDn);
                            }
                            hBoxRight.getChildren().addAll((Object[])new Node[]{closePDn, newPDn});
                            root.getChildren().addAll((Object[])new Node[]{bLabel, spacer, hBoxRight});
                            tooltip.setText((String)po.syncErrorProperty().get());
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)root);
                        }
                    }
                };
                return cell;
            }
        });
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2 && event.getTarget() instanceof Label) {
                    PurchaseDeliveryNotePane.this.purchaseOrder = (PurchaseOrder)PurchaseDeliveryNotePane.this.list.getSelectionModel().getSelectedItem();
                    PurchaseDeliveryNotePane.this.readOnly = true;
                    PurchaseDeliveryNotePane.this.dialog = new JFXDialog(PurchaseDeliveryNotePane.this.stackPane, (Region)new PurchaseOrderApprovalEditDialog(PurchaseDeliveryNotePane.this), JFXDialog.DialogTransition.CENTER);
                    PurchaseDeliveryNotePane.this.dialog.setOverlayClose(false);
                    PurchaseDeliveryNotePane.this.dialog.show();
                }
            }
        });
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryViewEdit = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                            this.btn.setGraphic((Node)PurchaseDeliveryNotePane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(15.0));
                            this.btn.setStyle("-fx-background-color: #4FC4F6;");
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setOnAction(event -> {
                                PurchaseDeliveryNotePane.this.purchaseOrder = (PurchaseOrder)PurchaseDeliveryNotePane.this.list.getSelectionModel().getSelectedItem();
                                PurchaseDeliveryNotePane.this.selectedStock = req;
                                PurchaseDeliveryNotePane.this.showDialog();
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryCostCenter = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final Label label = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getCostCenter().isEmpty()) {
                                this.label.setText(costcenters.stream().filter(x -> x.getKey().equals(req.getCostCenter())).findAny().get().getData());
                            }
                            this.setGraphic((Node)this.label);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colCostCenter.setCellFactory((Callback)cellFactoryCostCenter);
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryTax = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final Label label = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getCostCenter().isEmpty()) {
                                this.label.setText(taxCodes.stream().filter(x -> x.getKey().equals(req.getTaxCode())).findAny().get().getData());
                            }
                            this.setGraphic((Node)this.label);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colTaxCode.setCellFactory((Callback)cellFactoryTax);
        this.btnReload.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PurchaseDeliveryNotePane.this.tbSearch.clear();
                PurchaseDeliveryNotePane.this.loadMine(false);
            }
        });
        this.btnClosePO.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (!PurchaseDeliveryNotePane.this.closeComment.getText().isEmpty()) {
                    if (PurchaseDeliveryNotePane.this.purchaseOrderDataList.getOriginalList().stream().filter(d -> d.approvedStatus > 0).findAny().orElse(null) != null) {
                        List<PurchaseOrder> pos = PurchaseDeliveryNotePane.this.purchaseOrderDataList.getOriginalList().stream().filter(d -> d.approvedStatus > 0).collect(Collectors.toList());
                        PurchaseDeliveryNotePane.this.str = "";
                        pos.forEach(x -> {
                            PurchaseDeliveryNotePane.this.str = PurchaseDeliveryNotePane.this.str + x.getCode() + ",";
                        });
                        PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Warning, "Are you sure you want to close " + PurchaseDeliveryNotePane.this.str.substring(0, PurchaseDeliveryNotePane.this.str.length() - 1) + " Request(s)?", PurchaseDeliveryNotePane.this);
                    } else {
                        PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, "No Purchase selected to close", PurchaseDeliveryNotePane.this);
                    }
                } else {
                    PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, "Please specify comment and try again", PurchaseDeliveryNotePane.this);
                }
            }
        });
        this.tbSearch.clear();
        this.loadMine(false);
        this.btnSearch.setOnAction(v -> this.loadMine(false));
        this.btnDelGrpo.setOnAction(x -> {
            if (this.list.getSelectionModel().getSelectedItem() != null) {
                this.deleteSavedPOlocally((PurchaseOrder)this.list.getSelectionModel().getSelectedItem(), true);
            }
        });
        this.btnLoadGrpo.setOnAction(x -> this.loadSavedGrpO());
    }

    public void deleteSavedPOlocally(PurchaseOrder po, boolean showmsg) {
        PurchaseOrderDataList pdndl = new PurchaseOrderDataList(this.da);
        pdndl.selectAll("Select * From PurchaseOrder where code=? and isSaveForPDN=?", new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, po.getCode()), new ParameterValue("isSaveForPDN", JDBCType.CHAR, po.getIsSaveForPDN())});
        if (pdndl.getOriginalList().size() > 0) {
            try {
                StockItemList.deleteAll("delete from PurchaseOrder where code=? and isSaveForPDN=?", new ParameterValue[]{new ParameterValue("Code", JDBCType.VARCHAR, po.getCode()), new ParameterValue("isSaveForPDN", JDBCType.CHAR, po.getIsSaveForPDN())}, this.da);
                pdndl.getOriginalList().forEach(p -> {
                    try {
                        StockItemList.deleteAll("delete From PurchaseLineItem where parentCode=?", new ParameterValue[]{new ParameterValue("parentCode", JDBCType.VARCHAR, p.getCode())}, this.da);
                    }
                    catch (Exception ex) {
                        this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
                    }
                });
                this.mainPage.showNotification(NotificationType.Success, po.getCode() + " deleted successfully", this);
                this.purchaseOrderDataList.getOriginalList().remove((Object)po);
                this.list.setItems(this.purchaseOrderDataList.getOriginalList());
                this.table.getItems().clear();
                this.table.refresh();
                this.lblCurrency.setText("");
                this.lblTotal.setText("");
                this.list.refresh();
            }
            catch (Exception ex) {
                this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            }
        } else if (showmsg) {
            this.mainPage.showNotification(NotificationType.Information, "The selected P.O canot be deleted, because it's not save locally", this);
        }
    }

    public void savePOlocally(PurchaseOrder po) {
        try {
            this.deleteSavedPOlocally(po, false);
            po.setState(ObjectState.New);
            po.setIsSaveForPDN(true);
            PurchaseOrderDataList podl = new PurchaseOrderDataList(this.da);
            PurchaseLineItemDataList plidl = new PurchaseLineItemDataList(this.da);
            PurchaseItemSerialDataList pisdl = new PurchaseItemSerialDataList(this.da);
            podl.getOriginalList().add((Object)po);
            po.getItems().forEach(x -> {
                x.setState(ObjectState.New);
                x.setQtySaved(x.qtyChangeableProperty().get());
                x.setParentCode(po.getCode());
                plidl.getOriginalList().add(x);
                x.getSerials().forEach(se -> {
                    se.setParentCode(x.getCode());
                    se.setState(ObjectState.New);
                    pisdl.getOriginalList().add(se);
                });
            });
            podl.update();
            plidl.update();
            pisdl.update();
            this.mainPage.showNotification(NotificationType.Success, "G.R.P.O saved successfully", this);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
    }

    void loadSavedGrpO() {
        this.purchaseOrderDataList.getOriginalList().clear();
        this.purchaseOrderDataList.selectAll("Select * from PurchaseOrder where isSaveForPDN=?", new ParameterValue[]{new ParameterValue("isSaveForPDN", JDBCType.CHAR, true)});
        if (this.purchaseOrderDataList.getOriginalList().size() > 0) {
            this.purchaseOrderDataList.getOriginalList().forEach(x -> {
                if (x.getItems().size() == 0) {
                    x.loadPurchaseItem();
                }
                x.getItems().forEach(z -> x.setTotalAmount(x.getTotalAmount() + z.getTax() + z.getLineTotal()));
            });
        } else {
            this.mainPage.showNotification(NotificationType.Information, "No G.R.P.O found", this);
        }
        this.list.setItems(this.purchaseOrderDataList.getOriginalList());
        this.list.refresh();
        this.table.getItems().clear();
        this.table.refresh();
        this.lblCurrency.setText("");
        this.lblTotal.setText("");
    }

    void loadMine(final boolean showNotification) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String output;
                            StringBuilder stringBuilder;
                            BufferedReader br;
                            String url = PurchaseDeliveryNotePane.this.santa.syncSetting.getBEURL() + "RPurchaseOrder/GetRequestsForDeliveryNote";
                            HttpGet httpGet = new HttpGet(url);
                            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                            if (!PurchaseDeliveryNotePane.this.tbSearch.getText().isEmpty()) {
                                BasicNameValuePair param1 = new BasicNameValuePair("searchString", PurchaseDeliveryNotePane.this.tbSearch.getText());
                                listParam.add(param1);
                            } else {
                                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                LocalDateTime Strtdatetime = LocalDate.of(((LocalDate)PurchaseDeliveryNotePane.this.from.getValue()).getYear(), ((LocalDate)PurchaseDeliveryNotePane.this.from.getValue()).getMonth().getValue(), ((LocalDate)PurchaseDeliveryNotePane.this.from.getValue()).getDayOfMonth()).atTime(0, 0, 0);
                                LocalDateTime Enddatetime = LocalDate.of(((LocalDate)PurchaseDeliveryNotePane.this.to.getValue()).getYear(), ((LocalDate)PurchaseDeliveryNotePane.this.to.getValue()).getMonth().getValue(), ((LocalDate)PurchaseDeliveryNotePane.this.to.getValue()).getDayOfMonth()).atTime(23, 59, 0);
                                String fromDt = format.format(java.sql.Date.from(Strtdatetime.atZone(ZoneId.systemDefault()).toInstant()));
                                String toDt = format.format(java.sql.Date.from(Enddatetime.atZone(ZoneId.systemDefault()).toInstant()));
                                BasicNameValuePair param2 = new BasicNameValuePair("startDate", fromDt);
                                listParam.add(param2);
                                BasicNameValuePair param3 = new BasicNameValuePair("endDate", toDt);
                                listParam.add(param3);
                            }
                            URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
                            httpGet.setURI(uri);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                PurchaseOrderDataList podl = new PurchaseOrderDataList(PurchaseDeliveryNotePane.this.da);
                                if (ra.length() > 0) {
                                    for (int i = 0; i < ra.length(); ++i) {
                                        JSONObject jSONObject = ra.getJSONObject(i);
                                        PurchaseOrder po = new PurchaseOrder(PurchaseDeliveryNotePane.this.da);
                                        po.DocEntry = jSONObject.isNull("DocEntry") ? 0 : jSONObject.getInt("DocEntry");
                                        po.DockNum = jSONObject.isNull("DocNum") ? 0 : jSONObject.getInt("DocNum");
                                        po.BaseDocumentNum = jSONObject.isNull("BaseDocumentNum") ? 0 : jSONObject.getInt("BaseDocumentNum");
                                        po.CurrentEditStage = jSONObject.isNull("CurrentEditStage") ? "" : jSONObject.getString("CurrentEditStage");
                                        po.setTotal(jSONObject.isNull("DocTotal") ? 0.0 : jSONObject.getDouble("DocTotal"));
                                        po.setCode(jSONObject.isNull("Code") ? "" : jSONObject.getString("Code"));
                                        po.setSupplierCode(jSONObject.isNull("VendorId") ? "" : jSONObject.getString("VendorId"));
                                        po.setSupplierName(jSONObject.isNull("VendorName") ? "" : jSONObject.getString("VendorName"));
                                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                        po.setSapCode(jSONObject.isNull("SAPCode") ? "" : jSONObject.getString("SAPCode"));
                                        Date dt = df.parse(jSONObject.getString("DocDate"));
                                        po.setDateCreated(new Date(dt.getTime()));
                                        dt = df.parse(jSONObject.getString("DeliveryDate"));
                                        po.setDueDate(new Date(dt.getTime()));
                                        po.setCurrency(jSONObject.isNull("Currency") ? "" : jSONObject.getString("Currency"));
                                        po.setStatus(jSONObject.isNull("Status") ? "" : jSONObject.getString("Status"));
                                        po.createCommentProperty().set((Object)(jSONObject.isNull("Comment") ? "" : jSONObject.getString("Comment")));
                                        po.createdByProperty().set((Object)(jSONObject.isNull("PurchasingOfficer") ? "" : jSONObject.getString("PurchasingOfficer")));
                                        po.setParentTemplateDescription(jSONObject.isNull("ApprovalTemplateDescription") ? "" : jSONObject.getString("ApprovalTemplateDescription"));
                                        po.setPurchaseType(jSONObject.isNull("PurchaseType") ? "" : jSONObject.getString("PurchaseType"));
                                        po.setPaymentTerm(jSONObject.isNull("PaymentTerm") ? "" : jSONObject.getString("PaymentTerm"));
                                        po.OrderNoProperty().set((Object)(jSONObject.isNull("OrderNo") ? "" : jSONObject.getString("OrderNo")));
                                        JSONArray lineArray = jSONObject.getJSONArray("LineItems");
                                        for (int j = 0; j < lineArray.length(); ++j) {
                                            JSONObject jsono = lineArray.getJSONObject(j);
                                            PurchaseLineItem purchaseLineItem = new PurchaseLineItem(PurchaseDeliveryNotePane.this.da);
                                            purchaseLineItem.setParentPurchase(po);
                                            purchaseLineItem.setLineNumber(jsono.isNull("LineNumber") ? 0 : jsono.getInt("LineNumber"));
                                            purchaseLineItem.setBaseLineNumber(jsono.isNull("BaseLineNumber") ? 0 : jsono.getInt("BaseLineNumber"));
                                            purchaseLineItem.setItemCode(jsono.isNull("ItemCode") ? "" : jsono.getString("ItemCode"));
                                            purchaseLineItem.setQuantity(jsono.isNull("Qty") ? 0 : jsono.getInt("Qty"));
                                            purchaseLineItem.editQtyProperty().set(purchaseLineItem.getQuantity());
                                            purchaseLineItem.setOpenQty(jsono.isNull("OpenQty") ? 0 : jsono.getInt("OpenQty"));
                                            purchaseLineItem.setPrice(jsono.isNull("UnitPrice") ? 0.0 : jsono.getDouble("UnitPrice"));
                                            purchaseLineItem.editPriceProperty().set(purchaseLineItem.getPrice());
                                            purchaseLineItem.approved = true;
                                            purchaseLineItem.setCostCenter(jsono.isNull("CostCentre") ? "" : jsono.getString("CostCentre"));
                                            purchaseLineItem.setStoreCode(jsono.isNull("StoreCode") ? "" : jsono.getString("StoreCode"));
                                            purchaseLineItem.setTaxCode(jsono.isNull("TaxCode") ? "" : jsono.getString("TaxCode"));
                                            purchaseLineItem.setItemName(jsono.isNull("ItemName") ? "" : jsono.getString("ItemName"));
                                            purchaseLineItem.setCurrency(jsono.isNull("Currency") ? "" : jsono.getString("Currency"));
                                            purchaseLineItem.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            purchaseLineItem.setTax(jsono.isNull("TaxAmount") ? 0.0 : jsono.getDouble("TaxAmount"));
                                            po.getItems().add((Object)purchaseLineItem);
                                        }
                                        JSONArray historiesArray = jSONObject.getJSONArray("histories");
                                        for (int j = 0; j < historiesArray.length(); ++j) {
                                            JSONObject jsono = historiesArray.getJSONObject(j);
                                            POApprovalHistory pOApprovalHistory = new POApprovalHistory(PurchaseDeliveryNotePane.this.da);
                                            pOApprovalHistory.setStage(jsono.isNull("Stage") ? "" : jsono.getString("Stage"));
                                            pOApprovalHistory.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            pOApprovalHistory.setApprovingUser(jsono.isNull("ApprovingUser") ? "" : jsono.getString("ApprovingUser"));
                                            dt = df.parse(jsono.getString("DateCreated"));
                                            pOApprovalHistory.setDateCreated(new Date(dt.getTime()));
                                            pOApprovalHistory.setRemark(jsono.isNull("Remark") ? "" : jsono.getString("Remark"));
                                            pOApprovalHistory.setActionTaken(jsono.isNull("ActionTaken") ? "" : jsono.getString("ActionTaken"));
                                            po.getHistories().add((Object)pOApprovalHistory);
                                        }
                                        JSONArray delievryNotesArray = jSONObject.getJSONArray("DeliveryNotes");
                                        for (int j = 0; j < delievryNotesArray.length(); ++j) {
                                            JSONObject jsono = delievryNotesArray.getJSONObject(j);
                                            PurchaseDeliveryNote pdn = new PurchaseDeliveryNote(PurchaseDeliveryNotePane.this.da);
                                            pdn.setSapCode(jsono.isNull("SAPCode") ? "" : jsono.getString("SAPCode"));
                                            pdn.DocEntry = jsono.isNull("DocEntry") ? 0 : jsono.getInt("DocEntry");
                                            pdn.DockNum = jsono.isNull("DocNum") ? 0 : jsono.getInt("DocNum");
                                            pdn.BaseDocumentNum = jsono.isNull("BaseDocumentNum") ? 0 : jsono.getInt("BaseDocumentNum");
                                            pdn.setTotal(jsono.isNull("DocTotal") ? 0.0 : jsono.getDouble("DocTotal"));
                                            pdn.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                                            pdn.setSupplierCode(jsono.isNull("VendorId") ? "" : jsono.getString("VendorId"));
                                            pdn.setSupplierName(jsono.isNull("VendorName") ? "" : jsono.getString("VendorName"));
                                            dt = df.parse(jsono.getString("DocDate"));
                                            pdn.setDateCreated(new Date(dt.getTime()));
                                            dt = df.parse(jsono.getString("DeliveryDate"));
                                            pdn.setDueDate(new Date(dt.getTime()));
                                            pdn.setStatus(jsono.isNull("Status") ? "" : jsono.getString("Status"));
                                            pdn.createCommentProperty().set((Object)(jsono.isNull("Comment") ? "" : jsono.getString("Comment")));
                                            pdn.createdByProperty().set((Object)(jsono.isNull("PurchasingOfficer") ? "" : jsono.getString("PurchasingOfficer")));
                                            pdn.OrderNoProperty().set((Object)(jsono.isNull("OrderNo") ? "" : jsono.getString("OrderNo")));
                                            JSONArray lineArrayPdn = jsono.getJSONArray("LineItems");
                                            for (int k = 0; k < lineArrayPdn.length(); ++k) {
                                                JSONObject jsonoItem = lineArrayPdn.getJSONObject(k);
                                                PurchaseLineItem purchaseLineItem = new PurchaseLineItem(PurchaseDeliveryNotePane.this.da);
                                                purchaseLineItem.setParentPurchase(pdn);
                                                purchaseLineItem.setLineNumber(jsonoItem.isNull("LineNumber") ? 0 : jsonoItem.getInt("LineNumber"));
                                                purchaseLineItem.setBaseLineNumber(jsonoItem.isNull("BaseLineNumber") ? 0 : jsonoItem.getInt("BaseLineNumber"));
                                                purchaseLineItem.setItemCode(jsonoItem.isNull("ItemCode") ? "" : jsonoItem.getString("ItemCode"));
                                                purchaseLineItem.setQuantity(jsonoItem.isNull("Qty") ? 0 : jsonoItem.getInt("Qty"));
                                                purchaseLineItem.setOpenQty(jsonoItem.isNull("OpenQty") ? 0 : jsonoItem.getInt("OpenQty"));
                                                purchaseLineItem.setPrice(jsonoItem.isNull("UnitPrice") ? 0.0 : jsonoItem.getDouble("UnitPrice"));
                                                purchaseLineItem.setCostCenter(jsonoItem.isNull("CostCentre") ? "" : jsonoItem.getString("CostCentre"));
                                                purchaseLineItem.setStoreCode(jsonoItem.isNull("StoreCode") ? "" : jsonoItem.getString("StoreCode"));
                                                purchaseLineItem.setTaxCode(jsonoItem.isNull("TaxCode") ? "" : jsonoItem.getString("TaxCode"));
                                                purchaseLineItem.setItemName(jsonoItem.isNull("ItemName") ? "" : jsonoItem.getString("ItemName"));
                                                purchaseLineItem.setCurrency(jsonoItem.isNull("Currency") ? "" : jsonoItem.getString("Currency"));
                                                purchaseLineItem.setCode(jsonoItem.isNull("Code") ? "" : jsonoItem.getString("Code"));
                                                purchaseLineItem.setTax(jsonoItem.isNull("TaxAmount") ? 0.0 : jsonoItem.getDouble("TaxAmount"));
                                                purchaseLineItem.lineTotalWithTaxProperty().set(purchaseLineItem.getQuantity() == 0 ? purchaseLineItem.getPrice() + purchaseLineItem.getTax() : purchaseLineItem.getPrice() * (double)purchaseLineItem.getQuantity() + purchaseLineItem.getTax());
                                                System.out.print(po.getCode() + " Delivery note Tax amount" + purchaseLineItem.getTax());
                                                pdn.getItems().add((Object)purchaseLineItem);
                                            }
                                            po.getDeleveryNotes().add((Object)pdn);
                                        }
                                        po.resetNumbering();
                                        podl.getOriginalList().add((Object)po);
                                    }
                                    Platform.runLater(() -> {
                                        PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseDeliveryNotePane.this.table.getItems().clear();
                                        PurchaseDeliveryNotePane.this.purchaseOrderDataList.getOriginalList().clear();
                                        PurchaseDeliveryNotePane.this.purchaseOrderDataList.getOriginalList().addAll(podl.getOriginalList());
                                        PurchaseDeliveryNotePane.this.table.refresh();
                                        podl.getOriginalList().forEach(x -> x.getItems().forEach(z -> x.setTotalAmount(x.getTotalAmount() + z.getTax() + z.getLineTotal())));
                                        PurchaseDeliveryNotePane.this.lblCurrency.setText("");
                                        PurchaseDeliveryNotePane.this.lblTotal.setText("");
                                        PurchaseDeliveryNotePane.this.list.setItems(PurchaseDeliveryNotePane.this.purchaseOrderDataList.getOriginalList());
                                        PurchaseDeliveryNotePane.this.list.refresh();
                                        if (showNotification) {
                                            PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", PurchaseDeliveryNotePane.this);
                                        }
                                        PurchaseDeliveryNotePane.this.tbSearch.clear();
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseDeliveryNotePane.this.table.getItems().clear();
                                        PurchaseDeliveryNotePane.this.purchaseOrderDataList.getOriginalList().clear();
                                        PurchaseDeliveryNotePane.this.lblCurrency.setText("");
                                        PurchaseDeliveryNotePane.this.lblTotal.setText("");
                                        PurchaseDeliveryNotePane.this.table.refresh();
                                        PurchaseDeliveryNotePane.this.list.setItems(PurchaseDeliveryNotePane.this.purchaseOrderDataList.getOriginalList());
                                        PurchaseDeliveryNotePane.this.list.refresh();
                                        if (showNotification) {
                                            PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", PurchaseDeliveryNotePane.this);
                                        } else {
                                            PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Information, "No Purchase Request Found", PurchaseDeliveryNotePane.this);
                                        }
                                    });
                                }
                            } else {
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                    PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, fullError, PurchaseDeliveryNotePane.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), PurchaseDeliveryNotePane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void closePO(boolean shownotification) {
        final PurchaseOrderDataList podl = new PurchaseOrderDataList(this.da);
        podl.getOriginalList().addAll((Collection)this.purchaseOrderDataList.getOriginalList().stream().filter(v -> v.approvedStatus > 0 && v.getSyncFlag() == false).collect(Collectors.toList()));
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            BufferedReader br;
                            Object url = PurchaseDeliveryNotePane.this.santa.syncSetting.getBEURL();
                            url = (String)url + "RPurchaseOrder/CreatePurchaseRequests";
                            JSONArray jSONArray = new JSONArray();
                            for (PurchaseOrder purchaseOrder1 : podl.getOriginalList()) {
                                JSONObject job = new JSONObject();
                                job.put("DocNum", purchaseOrder1.DockNum);
                                job.put("DocEntry", purchaseOrder1.DocEntry);
                                job.put("BaseDocumentNum", purchaseOrder1.BaseDocumentNum);
                                job.put("VendorId", (Object)purchaseOrder1.getSupplierCode());
                                job.put("VendorName", (Object)purchaseOrder1.getSupplierName());
                                job.put("DocDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(purchaseOrder1.getDateCreated()));
                                job.put("DeliveryDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(purchaseOrder1.getDueDate()));
                                job.put("Currency", (Object)purchaseOrder1.getCurrency());
                                job.put("Status", (Object)purchaseOrder1.getStatus());
                                job.put("Code", (Object)purchaseOrder1.getCode());
                                job.put("Action", (Object)POActionMapEnum.ClosePO.name());
                                job.put("CloseComment", (Object)PurchaseDeliveryNotePane.this.closeComment.getText());
                                PurchaseDeliveryNotePane.this.dockTotal = 0.0;
                                purchaseOrder1.getItems().forEach(v -> {
                                    if (purchaseOrder1.getPurchaseType().equals(PurchaseType.Service.name())) {
                                        v.setLineTotal(v.getPrice());
                                    }
                                    if (!v.getState().equals(ObjectState.Removed.name())) {
                                        PurchaseDeliveryNotePane.this.dockTotal += v.getLineTotal();
                                    }
                                });
                                job.put("DocTotal", PurchaseDeliveryNotePane.this.dockTotal);
                                job.put("Comment", purchaseOrder1.createCommentProperty().get());
                                job.put("PurchasingOfficer", purchaseOrder1.createdByProperty().get());
                                job.put("ApprovalTemplateDescription", (Object)purchaseOrder1.getParentTemplateDescription());
                                job.put("PurchaseType", (Object)purchaseOrder1.getPurchaseType());
                                job.put("PaymentTerm", (Object)purchaseOrder1.getPaymentTerm());
                                job.put("OrderNo", purchaseOrder1.OrderNoProperty().get());
                                JSONArray jab = new JSONArray();
                                for (PurchaseLineItem purchaseLineItem : purchaseOrder1.getItems()) {
                                    JSONObject joItem = new JSONObject();
                                    joItem.put("LineNumber", -1);
                                    joItem.put("BaseLineNumber", purchaseLineItem.getBaseLineNumber());
                                    joItem.put("ItemCode", (Object)purchaseLineItem.getItemCode());
                                    joItem.put("Qty", purchaseLineItem.getQuantity());
                                    joItem.put("OpenQty", purchaseLineItem.getOpenQty());
                                    joItem.put("UnitPrice", purchaseLineItem.getPrice());
                                    joItem.put("CostCentre", (Object)purchaseLineItem.getCostCenter());
                                    joItem.put("StoreCode", (Object)purchaseLineItem.getStoreCode());
                                    joItem.put("TaxCode", (Object)purchaseLineItem.getTaxCode());
                                    joItem.put("ItemName", (Object)purchaseLineItem.getItemName());
                                    joItem.put("Currency", (Object)purchaseLineItem.getCurrency());
                                    joItem.put("LineTotal", purchaseLineItem.getQuantity() > 0 ? (double)purchaseLineItem.getQuantity() * purchaseLineItem.getPrice() : purchaseLineItem.getPrice());
                                    joItem.put("Code", (Object)purchaseLineItem.getCode());
                                    joItem.put("Deleted", purchaseOrder1.getState() == ObjectState.Removed);
                                    jab.put((Object)joItem);
                                }
                                job.put("LineItems", (Object)jab);
                                jSONArray.put((Object)job);
                            }
                            HttpPost httpPost = new HttpPost((String)url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            File f = Santa.writePayLoadToFileAll(jSONArray.toString());
                            HttpEntity reqEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("payload", f, ContentType.DEFAULT_BINARY, f.getName()).build();
                            httpPost.setEntity(reqEntity);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                Platform.runLater(() -> {
                                    for (int i = 0; i < ra.length(); ++i) {
                                        try {
                                            JSONObject jsono = ra.getJSONObject(i);
                                            String poCode = jsono.isNull("POCode") ? "" : jsono.getString("POCode");
                                            String poErrorMsg = jsono.isNull("ErrMessage") ? "" : jsono.getString("ErrMessage");
                                            PurchaseOrder po = PurchaseDeliveryNotePane.this.purchaseOrderDataList.getOriginalList().stream().filter(v -> v.getCode().equals(poCode)).findAny().orElse(null);
                                            if (po == null) continue;
                                            po.syncErrorProperty().set((Object)poErrorMsg);
                                            po.setSyncFlag(((String)po.syncErrorProperty().get()).isEmpty());
                                            continue;
                                        }
                                        catch (Exception ex) {
                                            Logger.getLogger(PurchaseRequestApprovalPane.class.getName()).log(Level.SEVERE, null, ex.getLocalizedMessage());
                                        }
                                    }
                                    PurchaseDeliveryNotePane.this.table.refresh();
                                    PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                    PurchaseDeliveryNotePane.this.tbSearch.clear();
                                    PurchaseDeliveryNotePane.this.closeComment.clear();
                                    PurchaseDeliveryNotePane.this.loadMine(true);
                                });
                            } else {
                                String output;
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                    PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, fullError, PurchaseDeliveryNotePane.this);
                                });
                            }
                        }
                        catch (Exception ex) {
                            Platform.runLater(() -> {
                                PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), PurchaseDeliveryNotePane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void post() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            BufferedReader br;
                            Object url = PurchaseDeliveryNotePane.this.santa.syncSetting.getBEURL();
                            url = (String)url + "RPurchaseOrder/CreateGRPOFromPO";
                            JSONObject job = new JSONObject();
                            job.put("DocNum", PurchaseDeliveryNotePane.this.purchaseOrder.DockNum);
                            job.put("DocEntry", PurchaseDeliveryNotePane.this.purchaseOrder.DocEntry);
                            job.put("BaseDocumentNum", PurchaseDeliveryNotePane.this.purchaseOrder.BaseDocumentNum);
                            job.put("VendorId", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getSupplierCode());
                            job.put("VendorName", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getSupplierName());
                            job.put("DocDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(PurchaseDeliveryNotePane.this.purchaseOrder.getDateCreated()));
                            job.put("DeliveryDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(PurchaseDeliveryNotePane.this.purchaseOrder.getDueDate()));
                            job.put("Currency", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getCurrency());
                            job.put("Status", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getStatus());
                            job.put("Code", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getCode());
                            PurchaseDeliveryNotePane.this.dockTotal = 0.0;
                            PurchaseDeliveryNotePane.this.purchaseOrder.getItems().forEach(v -> {
                                if (PurchaseDeliveryNotePane.this.purchaseOrder.getPurchaseType().equals((Object)PurchaseType.Service)) {
                                    v.setLineTotal(v.getPrice());
                                }
                                PurchaseDeliveryNotePane.this.dockTotal += v.getLineTotal();
                            });
                            job.put("DocTotal", PurchaseDeliveryNotePane.this.dockTotal);
                            job.put("Comment", PurchaseDeliveryNotePane.this.purchaseOrder.createCommentProperty().get());
                            job.put("PurchasingOfficer", (Object)PurchaseDeliveryNotePane.this.currentUser.getUserName());
                            job.put("ApprovalTemplateDescription", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getParentTemplateDescription());
                            job.put("PurchaseType", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getPurchaseType());
                            job.put("PaymentTerm", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getPaymentTerm());
                            job.put("OrderNo", PurchaseDeliveryNotePane.this.purchaseOrder.OrderNoProperty().get());
                            JSONArray jab = new JSONArray();
                            for (PurchaseLineItem purchaseLineItem : PurchaseDeliveryNotePane.this.purchaseOrder.getItems()) {
                                JSONObject joItem = new JSONObject();
                                joItem.put("LineNumber", purchaseLineItem.getLineNumber());
                                joItem.put("BaseLineNumber", purchaseLineItem.getBaseLineNumber());
                                joItem.put("ItemCode", (Object)purchaseLineItem.getItemCode());
                                joItem.put("Qty", purchaseLineItem.getQtyChangeable());
                                joItem.put("UnitPrice", purchaseLineItem.getPrice());
                                joItem.put("OpenQty", purchaseLineItem.getOpenQty());
                                joItem.put("CostCentre", (Object)purchaseLineItem.getCostCenter());
                                joItem.put("StoreCode", (Object)purchaseLineItem.getStoreCode());
                                joItem.put("TaxCode", (Object)purchaseLineItem.getTaxCode());
                                joItem.put("ItemName", (Object)purchaseLineItem.getItemName());
                                joItem.put("Currency", (Object)purchaseLineItem.getCurrency());
                                joItem.put("LineTotal", purchaseLineItem.getQuantity() > 0 ? (double)purchaseLineItem.getQuantity() * purchaseLineItem.getPrice() : purchaseLineItem.getPrice());
                                joItem.put("Code", (Object)purchaseLineItem.getCode());
                                joItem.put("Deleted", PurchaseDeliveryNotePane.this.purchaseOrder.getState().equals(ObjectState.Removed.name()));
                                JSONArray jsona = new JSONArray();
                                for (PurchaseItemSerial serial : purchaseLineItem.getSerials()) {
                                    JSONObject jsono = new JSONObject();
                                    jsono.put("ItemCode", (Object)serial.getItemCode());
                                    jsono.put("Quantity", 1);
                                    jsono.put("Serial", (Object)serial.getSerial());
                                    jsona.put((Object)jsono);
                                }
                                joItem.put("Serials", (Object)jsona);
                                jab.put((Object)joItem);
                            }
                            job.put("LineItems", (Object)jab);
                            HttpPost httpPost = new HttpPost((String)url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            File f = Santa.writePayLoadToFileAll(job.toString());
                            HttpEntity reqEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("payload", f, ContentType.DEFAULT_BINARY, f.getName()).build();
                            httpPost.setEntity(reqEntity);
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                String output;
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                    if (result.contains("Error")) {
                                        PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, result, PurchaseDeliveryNotePane.this);
                                    } else {
                                        PurchaseDeliveryNotePane.this.purchaseOrder.setSyncFlag(true);
                                        PurchaseDeliveryNotePane.this.tbSearch.clear();
                                        PurchaseDeliveryNotePane.this.loadMine(true);
                                    }
                                });
                            } else {
                                String output;
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                    PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, fullError, PurchaseDeliveryNotePane.this);
                                });
                            }
                        }
                        catch (Exception ex) {
                            Platform.runLater(() -> {
                                PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), PurchaseDeliveryNotePane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void editPo() {
        if (!this.purchaseOrder.remark.isEmpty()) {
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            box.setAlignment(Pos.CENTER);
            this.progressContainer = box;
            this.stackPane.getChildren().add((Object)box);
            Service service = new Service(){

                protected Task createTask() {
                    return new Task(){

                        protected Object call() throws Exception {
                            try {
                                Object url = PurchaseDeliveryNotePane.this.santa.syncSetting.getBEURL();
                                url = (String)url + "RPurchaseOrder/CreatePurchaseRequests";
                                JSONArray jSONArray = new JSONArray();
                                JSONObject job = new JSONObject();
                                job.put("DocNum", PurchaseDeliveryNotePane.this.purchaseOrder.DockNum);
                                job.put("DocEntry", PurchaseDeliveryNotePane.this.purchaseOrder.DocEntry);
                                job.put("BaseDocumentNum", PurchaseDeliveryNotePane.this.purchaseOrder.BaseDocumentNum);
                                job.put("VendorId", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getSupplierCode());
                                job.put("VendorName", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getSupplierName());
                                job.put("DocDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(PurchaseDeliveryNotePane.this.purchaseOrder.getDateCreated()));
                                job.put("DeliveryDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(PurchaseDeliveryNotePane.this.purchaseOrder.getDueDate()));
                                job.put("Currency", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getCurrency());
                                job.put("Status", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getStatus());
                                job.put("Code", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getCode());
                                job.put("EditComment", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.remark);
                                job.put("Action", (Object)POActionMapEnum.EditPODecrease.name());
                                PurchaseDeliveryNotePane.this.dockTotal = 0.0;
                                PurchaseDeliveryNotePane.this.purchaseOrder.getItems().forEach(v -> {
                                    if (v.getLineNumber() == -1 && v.getPrice() == 0.0 && v.editPriceProperty().get() > 0.0) {
                                        v.setPrice(v.editPriceProperty().get());
                                        v.setQuantity(v.editQtyProperty().get());
                                    }
                                    if (PurchaseDeliveryNotePane.this.purchaseOrder.getPurchaseType().equals(PurchaseType.Service.name())) {
                                        v.setLineTotal(v.getPrice());
                                    }
                                    if (v.getState() != ObjectState.Removed) {
                                        PurchaseDeliveryNotePane.this.dockTotal += v.getLineTotal();
                                    }
                                    v.setCurrency(PurchaseDeliveryNotePane.this.purchaseOrder.getCurrency());
                                });
                                job.put("DocTotal", PurchaseDeliveryNotePane.this.dockTotal);
                                job.put("Comment", PurchaseDeliveryNotePane.this.purchaseOrder.createCommentProperty().get());
                                job.put("PurchasingOfficer", (Object)PurchaseDeliveryNotePane.this.currentUser.getUserName());
                                job.put("ApprovalTemplateDescription", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getParentTemplateDescription());
                                job.put("EditTemplateDescription", PurchaseDeliveryNotePane.this.purchaseOrder.editTemplateDescriptionProperty().get());
                                job.put("PurchaseType", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getPurchaseType());
                                job.put("PaymentTerm", (Object)PurchaseDeliveryNotePane.this.purchaseOrder.getPaymentTerm());
                                job.put("OrderNo", PurchaseDeliveryNotePane.this.purchaseOrder.OrderNoProperty().get());
                                JSONArray jab = new JSONArray();
                                for (PurchaseLineItem purchaseLineItem : PurchaseDeliveryNotePane.this.purchaseOrder.getItems()) {
                                    JSONObject joItem = new JSONObject();
                                    joItem.put("LineNumber", purchaseLineItem.getLineNumber());
                                    joItem.put("BaseLineNumber", purchaseLineItem.getBaseLineNumber());
                                    joItem.put("ItemCode", (Object)purchaseLineItem.getItemCode());
                                    joItem.put("editQty", purchaseLineItem.editQtyProperty().get());
                                    joItem.put("OpenQty", purchaseLineItem.getOpenQty());
                                    joItem.put("Qty", purchaseLineItem.getQuantity());
                                    joItem.put("UnitPrice", purchaseLineItem.getPrice());
                                    joItem.put("editPrice", purchaseLineItem.editPriceProperty().get());
                                    joItem.put("CostCentre", (Object)purchaseLineItem.getCostCenter());
                                    joItem.put("StoreCode", (Object)purchaseLineItem.getStoreCode());
                                    joItem.put("TaxCode", (Object)purchaseLineItem.getTaxCode());
                                    joItem.put("ItemName", (Object)purchaseLineItem.getItemName());
                                    joItem.put("Currency", (Object)purchaseLineItem.getCurrency());
                                    joItem.put("LineTotal", purchaseLineItem.getQuantity() > 0 ? (double)purchaseLineItem.getQuantity() * purchaseLineItem.getPrice() : purchaseLineItem.getPrice());
                                    joItem.put("Code", (Object)purchaseLineItem.getCode());
                                    joItem.put("Deleted", purchaseLineItem.getState() == ObjectState.Removed);
                                    joItem.put("StoreCode", (Object)purchaseLineItem.getStoreCode());
                                    jab.put((Object)joItem);
                                }
                                job.put("LineItems", (Object)jab);
                                jSONArray.put((Object)job);
                                HttpPost httpPost = new HttpPost((String)url);
                                RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                                CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                                File f = Santa.writePayLoadToFileAll(jSONArray.toString());
                                HttpEntity reqEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("payload", f, ContentType.DEFAULT_BINARY, f.getName()).build();
                                httpPost.setEntity(reqEntity);
                                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                                if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                    String output;
                                    BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                    StringBuilder stringBuilder = new StringBuilder();
                                    System.out.println("Output from Server .... \n");
                                    while ((output = br.readLine()) != null) {
                                        System.out.println(output);
                                        stringBuilder.append(output + "\n");
                                    }
                                    br.close();
                                    httpClient.getConnectionManager().shutdown();
                                    String result = stringBuilder.toString();
                                    JSONArray ra = new JSONArray(result);
                                    Platform.runLater(() -> {
                                        try {
                                            JSONObject jsono = ra.getJSONObject(0);
                                            if (jsono != null) {
                                                if (jsono.isNull("ErrMessage") || jsono.getString("ErrMessage").isEmpty()) {
                                                    String pOCode = jsono.getString("POCode");
                                                    PurchaseDeliveryNotePane.this.purchaseOrder.setSyncFlag(Boolean.TRUE);
                                                    PurchaseDeliveryNotePane.this.table.refresh();
                                                    PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                                    PurchaseDeliveryNotePane.this.tbSearch.clear();
                                                    PurchaseDeliveryNotePane.this.loadMine(true);
                                                } else {
                                                    PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                                    PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, jsono.getString("ErrMessage"), PurchaseDeliveryNotePane.this);
                                                    PurchaseDeliveryNotePane.this.purchaseOrder.getItems().removeIf(d -> d.getState() == ObjectState.Removed);
                                                }
                                            }
                                        }
                                        catch (JSONException ex) {
                                            PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                            PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), PurchaseDeliveryNotePane.this);
                                        }
                                    });
                                } else {
                                    String output;
                                    BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                    StringBuilder stringBuilder = new StringBuilder();
                                    while ((output = br.readLine()) != null) {
                                        System.out.println(output);
                                        stringBuilder.append(output + "\n");
                                    }
                                    br.close();
                                    String fullError = stringBuilder.toString();
                                    Platform.runLater(() -> {
                                        PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, fullError, PurchaseDeliveryNotePane.this);
                                    });
                                }
                            }
                            catch (Exception ex) {
                                Platform.runLater(() -> {
                                    PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                    PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), PurchaseDeliveryNotePane.this);
                                });
                            }
                            return null;
                        }
                    };
                }
            };
            progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
            service.start();
        } else {
            this.mainPage.showNotification(NotificationType.Error, "Please specify comment and try again", this);
        }
    }

    void showDialog() {
        this.dialog = new JFXDialog(this.stackPane, (Region)new PurchaseOrderDialog(this), JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    public void showDialogEdit() {
        this.dialog = new JFXDialog(this.stackPane, (Region)new PDNCreateEditDialog(this, true), JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    public void showDialogNew() {
        this.dialog = new JFXDialog(this.stackPane, (Region)new PurchaseOrderDialog(this), JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    @Override
    public void yes() {
        this.closePO(false);
    }

    @Override
    public void loadProduct(final String itemCode, final PurchaseOrderDialog purchaseOrderDialog) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        HttpGet httpget = null;
                        try {
                            String url = PurchaseDeliveryNotePane.this.santa.syncSetting.getBEURL();
                            httpget = new HttpGet(url + "RProduct/GetSAPItemsByItemCode?itemCode=" + itemCode);
                            CloseableHttpClient client = HttpClientBuilder.create().build();
                            httpget.setHeader("Content-type", "application/json");
                            HttpResponse response = client.execute((HttpUriRequest)httpget);
                            if (response.getStatusLine().getStatusCode() == 200) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                client.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                System.out.println("String " + result);
                                JSONArray ra = new JSONArray(result);
                                System.out.println("JSon " + ra.toString());
                                if (ra.length() > 0) {
                                    ArrayList<StockItemData> list = new ArrayList<StockItemData>();
                                    for (int i = 0; i < ra.length(); ++i) {
                                        JSONObject jo = ra.getJSONObject(i);
                                        StockItemData stkData = new StockItemData();
                                        stkData.setDescription(jo.isNull("ItemName") ? "" : jo.getString("ItemName"));
                                        stkData.setItemCode(jo.isNull("ItemCode") ? "" : jo.getString("ItemCode"));
                                        list.add(stkData);
                                    }
                                    StockItemList.insertYudalaProduct(list, PurchaseDeliveryNotePane.this.da);
                                    list.forEach(x -> PurchaseDeliveryNotePane.this.santa.Products.removeIf(xy -> xy.getItemCode().equals(x.getItemCode())));
                                    PurchaseDeliveryNotePane.this.santa.Products.addAll(list);
                                    Platform.runLater(() -> {
                                        purchaseOrderDialog.populateResult((StockItemData)list.get(0));
                                        PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                        PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Information, "no result found", PurchaseDeliveryNotePane.this);
                                    });
                                }
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, fullError, PurchaseDeliveryNotePane.this);
                                    PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                PurchaseDeliveryNotePane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), PurchaseDeliveryNotePane.this);
                                PurchaseDeliveryNotePane.this.stackPane.getChildren().remove((Object)box);
                                Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, e);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }
}

