/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.ExcelReportObject;
import com.xputertechnologies.santa.IWebCallBack;
import com.xputertechnologies.santa.RequestTypeEnum;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.WebRequest;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PromoVoucherDialog;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class PromoVoucher
extends UIParent {
    @FXML
    private StackPane stackPane;
    @FXML
    TableView<com.xputertechnologies.santa.PromoVoucher> table;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colVoucherCode;
    @FXML
    private TableColumn colDateCreated;
    @FXML
    private TableColumn colValidFrom;
    @FXML
    private TableColumn colValidTill;
    @FXML
    private TableColumn colDateUsed;
    @FXML
    private TableColumn colStore;
    @FXML
    private MenuItem menuAll;
    @FXML
    private MenuItem menuUsed;
    @FXML
    private MenuItem menuUnUsed;
    @FXML
    private TableColumn colCustomerName;
    @FXML
    private TableColumn colCustomerCode;
    @FXML
    private TableColumn colvoucherCreator;
    @FXML
    private TableColumn colStoreuser;
    @FXML
    private TableColumn colIsUsed;
    @FXML
    private TableColumn colRemark;
    @FXML
    private TableColumn colStatus;
    @FXML
    private TableColumn colInvoice;
    @FXML
    private TableColumn colamt;
    @FXML
    private TableColumn colamtmin;
    @FXML
    private JFXButton btnSave;
    @FXML
    private JFXButton btnNew;
    @FXML
    private JFXButton btnEdit;
    @FXML
    private JFXButton btnReload;
    JFXDialog dialog;
    boolean isEdit = false;

    public PromoVoucher(Santa app) {
        super("PromoVoucher.fxml", app);
        this.santa = app;
        this.title = "Promo Voucher";
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colVoucherCode.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.colDateCreated.setCellValueFactory((Callback)new PropertyValueFactory("dateCreated"));
        this.colValidFrom.setCellValueFactory((Callback)new PropertyValueFactory("validFrom"));
        this.colValidTill.setCellValueFactory((Callback)new PropertyValueFactory("validTill"));
        this.colDateUsed.setCellValueFactory((Callback)new PropertyValueFactory("dateUsed"));
        this.colCustomerName.setCellValueFactory((Callback)new PropertyValueFactory("customerName"));
        this.colStore.setCellValueFactory((Callback)new PropertyValueFactory("storeName"));
        this.colCustomerCode.setCellValueFactory((Callback)new PropertyValueFactory("customerCode"));
        this.colvoucherCreator.setCellValueFactory((Callback)new PropertyValueFactory("createdBy"));
        this.colStoreuser.setCellValueFactory((Callback)new PropertyValueFactory("storeUser"));
        this.colIsUsed.setCellValueFactory((Callback)new PropertyValueFactory("isUsed"));
        this.colRemark.setCellValueFactory((Callback)new PropertyValueFactory("remark"));
        this.colStatus.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.colamt.setCellValueFactory((Callback)new PropertyValueFactory("promoVoucherAmt"));
        this.colamtmin.setCellValueFactory((Callback)new PropertyValueFactory("minAmt"));
        this.colInvoice.setCellValueFactory((Callback)new PropertyValueFactory("invoiceNumber"));
        Callback<TableColumn<com.xputertechnologies.santa.PromoVoucher, String>, TableCell<com.xputertechnologies.santa.PromoVoucher, String>> cellFactoryVieSync = new Callback<TableColumn<com.xputertechnologies.santa.PromoVoucher, String>, TableCell<com.xputertechnologies.santa.PromoVoucher, String>>(){

            public TableCell call(TableColumn<com.xputertechnologies.santa.PromoVoucher, String> param) {
                TableCell<com.xputertechnologies.santa.PromoVoucher, String> cell = new TableCell<com.xputertechnologies.santa.PromoVoucher, String>(){
                    final Label lbl = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            com.xputertechnologies.santa.PromoVoucher req = (com.xputertechnologies.santa.PromoVoucher)this.getTableView().getItems().get(this.getIndex());
                            this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                            if (!req.getStatus().equals("Pending")) {
                                this.lbl.setText("Posted");
                                this.lbl.setStyle("-fx-background-color: #00A86B;-fx-text-fill: #FFFFFF;-fx-font-size: 12.0px;");
                            } else {
                                this.lbl.setText("Pending");
                                this.lbl.setStyle("-fx-background-color: #FF0000;-fx-text-fill: #FFFFFF;-fx-font-size: 12.0px;");
                            }
                            this.setGraphic((Node)this.lbl);
                            this.setTooltip(new Tooltip("Pending post to server"));
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colStatus.setCellFactory((Callback)cellFactoryVieSync);
        this.colamt.setCellFactory(col -> new TableCell<com.xputertechnologies.santa.PromoVoucher, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.colValidFrom.setCellFactory(column -> {
            TableCell<com.xputertechnologies.santa.PromoVoucher, Date> cell = new TableCell<com.xputertechnologies.santa.PromoVoucher, Date>(){
                private SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy");

                protected void updateItem(Date item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty) {
                        this.setText(null);
                    } else {
                        this.setText(this.format.format(item));
                    }
                }
            };
            return cell;
        });
        this.colValidTill.setCellFactory(column -> {
            TableCell<com.xputertechnologies.santa.PromoVoucher, Date> cell = new TableCell<com.xputertechnologies.santa.PromoVoucher, Date>(){
                private SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy");

                protected void updateItem(Date item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty) {
                        this.setText(null);
                    } else {
                        this.setText(this.format.format(item));
                    }
                }
            };
            return cell;
        });
        this.colDateCreated.setCellFactory(column -> {
            TableCell<com.xputertechnologies.santa.PromoVoucher, Date> cell = new TableCell<com.xputertechnologies.santa.PromoVoucher, Date>(){
                private SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy");

                protected void updateItem(Date item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty) {
                        this.setText(null);
                    } else {
                        this.setText(this.format.format(item));
                    }
                }
            };
            return cell;
        });
        this.colDateUsed.setCellFactory(column -> {
            TableCell<com.xputertechnologies.santa.PromoVoucher, Date> cell = new TableCell<com.xputertechnologies.santa.PromoVoucher, Date>(){
                private SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy");

                protected void updateItem(Date item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty) {
                        this.setText(null);
                    } else {
                        this.setText(this.format.format(item));
                    }
                }
            };
            return cell;
        });
        this.colIsUsed.setCellFactory(column -> {
            TableCell<com.xputertechnologies.santa.PromoVoucher, Boolean> cell = new TableCell<com.xputertechnologies.santa.PromoVoucher, Boolean>(){
                final Label lbl = new Label();

                protected void updateItem(Boolean item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty) {
                        this.setText(null);
                    } else if (item.booleanValue()) {
                        this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                        this.lbl.setGraphic((Node)PromoVoucher.this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK).color(Color.GREEN).size(12.0));
                        this.setGraphic((Node)this.lbl);
                        this.setTooltip(new Tooltip("Voucher Used"));
                        this.setAlignment(Pos.CENTER);
                        this.setText(null);
                    } else {
                        this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                        this.lbl.setGraphic((Node)PromoVoucher.this.fontAwesome.create((Enum)FontAwesome.Glyph.PAUSE).color(Color.HOTPINK).size(12.0));
                        this.setGraphic((Node)this.lbl);
                        this.setTooltip(new Tooltip("Voucher not used"));
                        this.setAlignment(Pos.CENTER);
                        this.setText(null);
                    }
                }
            };
            return cell;
        });
        this.btnSave.setOnAction(c -> {
            if (this.table.getItems().stream().filter(x -> x.getStatus().equals("Pending")).count() > 0L) {
                this.saveVoucher();
            }
        });
        this.btnNew.setOnAction(c -> {
            this.isEdit = false;
            this.voucherDlg();
        });
        this.btnEdit.setDisable(true);
        this.btnEdit.setOnAction(c -> {
            this.isEdit = true;
            this.voucherDlg();
        });
        this.btnReload.setOnAction(c -> this.reloadVoucher());
        this.menuAll.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (PromoVoucher.this.table.getItems().size() > 0) {
                    PromoVoucher.this.export(ExportVoucher.All);
                }
            }
        });
        this.menuUnUsed.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (PromoVoucher.this.table.getItems().size() > 0) {
                    PromoVoucher.this.export(ExportVoucher.UnUsed);
                }
            }
        });
        this.menuUsed.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (PromoVoucher.this.table.getItems().size() > 0) {
                    PromoVoucher.this.export(ExportVoucher.Used);
                }
            }
        });
    }

    void export(ExportVoucher exportVoucher) {
        ExcelReportObject excelReportObject = new ExcelReportObject();
        excelReportObject.getHeaders().addAll(Arrays.asList("S/N", "Voucher", "Amount", "Min Amount", "Date Created", "Valid From", "Valid Till", "Date Used", "Store", "Invoice Number", "Customer Name", "Customer Code", "Voucher Creator", "Store User", "Is Used", "Remark"));
        ObservableList items = FXCollections.observableArrayList();
        switch (exportVoucher) {
            case All: {
                this.table.getItems().forEach(val -> items.add(val));
                break;
            }
            case UnUsed: {
                this.table.getItems().stream().filter(s -> s.getIsUsed() == false).collect(Collectors.toList()).forEach(val -> items.add(val));
                break;
            }
            case Used: {
                this.table.getItems().stream().filter(s -> s.getIsUsed() == true).collect(Collectors.toList()).forEach(val -> items.add(val));
                break;
            }
        }
        for (com.xputertechnologies.santa.PromoVoucher item : items) {
            ArrayList<String> lst = new ArrayList<String>();
            lst.addAll(Arrays.asList(item.getSn(), item.getCode(), String.valueOf(item.getPromoVoucherAmt()), String.valueOf(item.getMinAmt()), item.getDateCreated().toString(), item.getValidFrom().toString(), item.getValidTill().toString(), item.getIsUsed() == true ? item.getDateUsed().toString() : "Not Used", item.getStoreName(), item.getInvoiceNumber(), item.getCustomerName(), item.getCustomerCode(), item.getCreatedBy(), item.getStoreUser(), item.getIsUsed() == true ? "Yes" : "No", item.getRemark()));
            excelReportObject.getValues().add(lst);
        }
        if (General.writeToExcel(this.santa.stage, excelReportObject)) {
            this.mainPage.showNotification(NotificationType.Success, "Voucher(s) Exported", this);
        }
    }

    void saveVoucher() {
        if (this.table.getItems().stream().filter(x -> x.getStatus().equals("Pending")).count() > 0L) {
            final List promoVouchers = this.table.getItems().stream().filter(x -> x.getStatus().equals("Pending")).collect(Collectors.toList());
            JFXProgressBar progressIndicator = new JFXProgressBar();
            progressIndicator.setProgress(-1.0);
            final VBox box = new VBox(new Node[]{progressIndicator});
            box.setAlignment(Pos.CENTER);
            this.stackPane.getChildren().add((Object)box);
            Service service = new Service(){

                protected Task createTask() {
                    return new Task(){

                        protected Object call() throws Exception {
                            try {
                                Object url = PromoVoucher.this.santa.syncSetting.getBEURL();
                                url = (String)url + "RSaleOrder/PostVoucher";
                                JSONArray jSONArray = new JSONArray();
                                for (com.xputertechnologies.santa.PromoVoucher voucher : promoVouchers) {
                                    JSONObject job = new JSONObject();
                                    job.put("code", (Object)voucher.getCode());
                                    job.put("validTill", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(voucher.getValidTill()));
                                    job.put("validFrom", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(voucher.getValidFrom()));
                                    job.put("remark", (Object)voucher.getRemark());
                                    job.put("createdBy", (Object)voucher.getCreatedBy());
                                    job.put("promoVoucherAmt", voucher.getPromoVoucherAmt());
                                    job.put("minAmt", voucher.getMinAmt());
                                    job.put("isUsed", false);
                                    job.put("status", (Object)"Posted");
                                    jSONArray.put((Object)job);
                                }
                                new WebRequest(WebRequest.CREATE_PROMOVOUCHER, RequestTypeEnum.POST, jSONArray.toString(), null, new IWebCallBack(){

                                    @Override
                                    public void onSuccess(String data) {
                                        promoVouchers.forEach(v -> v.setStatus("Posted"));
                                        Platform.runLater(() -> {
                                            PromoVoucher.this.table.refresh();
                                            PromoVoucher.this.stackPane.getChildren().remove((Object)box);
                                            PromoVoucher.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", PromoVoucher.this);
                                        });
                                    }

                                    @Override
                                    public void onError(String data) {
                                        Platform.runLater(() -> {
                                            System.out.println(data);
                                            PromoVoucher.this.stackPane.getChildren().remove((Object)box);
                                            PromoVoucher.this.mainPage.showNotification(NotificationType.Error, data, PromoVoucher.this);
                                        });
                                    }

                                    @Override
                                    public void onTimeOut(String data) {
                                        Platform.runLater(() -> {
                                            System.out.println(data);
                                            PromoVoucher.this.stackPane.getChildren().remove((Object)box);
                                            PromoVoucher.this.mainPage.showNotification(NotificationType.Error, data, PromoVoucher.this);
                                        });
                                    }
                                }).execute(false);
                            }
                            catch (Exception ex) {
                                Platform.runLater(() -> {
                                    System.out.println(ex.getMessage());
                                    PromoVoucher.this.stackPane.getChildren().remove((Object)box);
                                    PromoVoucher.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), PromoVoucher.this);
                                });
                            }
                            return null;
                        }
                    };
                }
            };
            progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
            service.start();
        } else {
            this.mainPage.showNotification(NotificationType.Information, "No new voucher to post", this);
        }
    }

    void voucherDlg() {
        this.dialog = new JFXDialog(this.stackPane, (Region)new PromoVoucherDialog(this), JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    void reloadVoucher() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        final ObservableList promoVouchers = FXCollections.observableArrayList();
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            new WebRequest(WebRequest.GET_ALL_PROMOVOUCHER, RequestTypeEnum.GET, null, null, new IWebCallBack(){

                                @Override
                                public void onSuccess(String data) {
                                    try {
                                        JSONArray ra = new JSONArray(data);
                                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                        if (ra.length() > 0) {
                                            for (int i = 0; i < ra.length(); ++i) {
                                                JSONObject jSONObject = ra.getJSONObject(i);
                                                com.xputertechnologies.santa.PromoVoucher voucher = new com.xputertechnologies.santa.PromoVoucher();
                                                voucher.setDateCreated(df.parse(jSONObject.isNull("createdAt") ? "" : jSONObject.getString("createdAt")));
                                                if (!jSONObject.isNull("dateUsed") && !jSONObject.getString("dateUsed").isEmpty()) {
                                                    voucher.setDateUsed(df.parse(jSONObject.getString("dateUsed")));
                                                }
                                                voucher.setCode(jSONObject.isNull("code") ? "" : jSONObject.getString("code"));
                                                voucher.setRemark(jSONObject.isNull("remark") ? "" : jSONObject.getString("remark"));
                                                voucher.setValidTill(df.parse(jSONObject.isNull("validTill") ? "" : jSONObject.getString("validTill")));
                                                voucher.setValidFrom(df.parse(jSONObject.isNull("validFrom") ? "" : jSONObject.getString("validFrom")));
                                                voucher.setCreatedBy(jSONObject.isNull("createdBy") ? "" : jSONObject.getString("createdBy"));
                                                voucher.setIsUsed(jSONObject.isNull("isUsed") ? false : jSONObject.getBoolean("isUsed"));
                                                voucher.setCustomerName(jSONObject.isNull("customerName") ? "" : jSONObject.getString("customerName"));
                                                voucher.setCustomerCode(jSONObject.isNull("customerCode") ? "" : jSONObject.getString("customerCode"));
                                                voucher.setStoreUser(jSONObject.isNull("storeUser") ? "" : jSONObject.getString("storeUser"));
                                                String storeCode = jSONObject.isNull("storeCode") ? "" : jSONObject.getString("storeCode");
                                                StoreDataList storeDataList = new StoreDataList(PromoVoucher.this.da);
                                                storeDataList.selectAll(PromoVoucher.this.da);
                                                voucher.setStoreName("");
                                                Store st = storeDataList.getOriginalList().stream().filter(x -> x.getCode().equalsIgnoreCase(storeCode)).findAny().orElse(null);
                                                if (st != null && !st.getName().equals("null")) {
                                                    voucher.setStoreName(st.getName());
                                                }
                                                voucher.setPromoVoucherAmt(jSONObject.isNull("promoVoucherAmt") ? 0.0 : jSONObject.getDouble("promoVoucherAmt"));
                                                voucher.setMinAmt(jSONObject.isNull("minAmt") ? 0.0 : jSONObject.getDouble("minAmt"));
                                                voucher.setInvoiceNumber(jSONObject.isNull("invoiceNumber") ? "" : jSONObject.getString("invoiceNumber"));
                                                voucher.setSn(String.valueOf(i + 1));
                                                voucher.setStatus("Posted");
                                                promoVouchers.add((Object)voucher);
                                            }
                                            Platform.runLater(() -> {
                                                PromoVoucher.this.stackPane.getChildren().remove((Object)box);
                                                PromoVoucher.this.table.setItems(promoVouchers);
                                                PromoVoucher.this.table.refresh();
                                            });
                                        } else {
                                            Platform.runLater(() -> {
                                                PromoVoucher.this.stackPane.getChildren().remove((Object)box);
                                                PromoVoucher.this.table.getItems().clear();
                                                PromoVoucher.this.table.refresh();
                                                PromoVoucher.this.mainPage.showNotification(NotificationType.Information, "No Voucher Found", PromoVoucher.this);
                                            });
                                        }
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(PromoVoucher.class.getName()).log(Level.SEVERE, null, ex);
                                        Platform.runLater(() -> {
                                            System.out.println(data);
                                            PromoVoucher.this.stackPane.getChildren().remove((Object)box);
                                            PromoVoucher.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), PromoVoucher.this);
                                        });
                                    }
                                }

                                @Override
                                public void onError(String data) {
                                    Platform.runLater(() -> {
                                        System.out.println(data);
                                        PromoVoucher.this.stackPane.getChildren().remove((Object)box);
                                        PromoVoucher.this.mainPage.showNotification(NotificationType.Error, data, PromoVoucher.this);
                                    });
                                }

                                @Override
                                public void onTimeOut(String data) {
                                    Platform.runLater(() -> {
                                        System.out.println(data);
                                        PromoVoucher.this.stackPane.getChildren().remove((Object)box);
                                        PromoVoucher.this.mainPage.showNotification(NotificationType.Error, data, PromoVoucher.this);
                                    });
                                }
                            }).execute(false);
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                PromoVoucher.this.stackPane.getChildren().remove((Object)box);
                                PromoVoucher.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), PromoVoucher.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    static enum ExportVoucher {
        All,
        Used,
        UnUsed;

    }
}

