/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.Company;
import com.xputertechnologies.santa.Maker;
import com.xputertechnologies.santa.Size;
import com.xputertechnologies.santa.StockItem;
import com.xputertechnologies.santa.StockPreload;
import com.xputertechnologies.santa.Type;
import com.xputertechnologies.santa.Unit;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.ui.ConfigurationPageContainerPane;
import com.xputertechnologies.santa.ui.MainPage;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;

public class Preload
extends UIParent {
    DataAccess da;
    @FXML
    private TreeView<String> CategoryTree;
    @FXML
    private TableView<StockItem> StockItemTable;
    @FXML
    private TableColumn<StockItem, String> NameCol = new TableColumn("Name");
    @FXML
    private TableColumn<StockItem, Boolean> SelectedCol = new TableColumn("SELECTED");
    @FXML
    private CheckBox SelectAllCheckBox = new CheckBox("Select All");
    @FXML
    private Button PopulateButton;
    @FXML
    private TextField SearchTextField = new TextField();
    private ArrayList<String> CategoryTreeList = new ArrayList();
    private ArrayList<String> mainGroups = new ArrayList();
    private ArrayList<String> TempGroups = new ArrayList();
    private ArrayList<StockItem> CategoryTableList = new ArrayList();
    private ArrayList<String> selectedItems = new ArrayList();
    private ObservableList<StockItem> originalItems;
    private Statement s = null;
    private Connection con = null;
    private String tableName = "items";
    private TreeItem<String> BaseTresItem = new TreeItem();
    private TreeItem<String> Type = new TreeItem();
    private TreeItem<String> Size = new TreeItem();
    private TreeItem<String> Item = new TreeItem();
    private TreeItem<String> root = new TreeItem((Object)"Makers");
    int nodeLevel;
    String selectedString;
    private StockPreload mainLevel;
    private ConfigurationPageContainerPane ParentConfigPagePane = null;
    Company company;
    MainPage mainPage;
    public StockItemList stockItemList = null;
    ObservableList<StockItem> tempOriginalItems;
    EventHandler<ActionEvent> handler = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            CheckBox cb = (CheckBox)event.getSource();
            TableColumn column = (TableColumn)cb.getUserData();
            if (cb.isSelected()) {
                for (int i = 0; i < Preload.this.StockItemTable.getItems().size(); ++i) {
                    ((StockItem)Preload.this.StockItemTable.getItems().get(i)).isActiveProperty().set(true);
                }
            } else {
                for (int i = 0; i < Preload.this.StockItemTable.getItems().size(); ++i) {
                    ((StockItem)Preload.this.StockItemTable.getItems().get(i)).isActiveProperty().set(false);
                }
            }
        }
    };
    CheckBox cb;

    public Preload(ConfigurationPageContainerPane cpcp, MainPage mainPage) {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("Preload.fxml"));
        fxmlLoader.setRoot((Object)this);
        fxmlLoader.setController((Object)this);
        try {
            fxmlLoader.load();
            if (cpcp != null) {
                this.santa = cpcp.santa;
                this.ParentConfigPagePane = cpcp;
                this.company = this.ParentConfigPagePane.company;
                this.PopulateButton.setVisible(false);
            } else {
                this.santa = mainPage.santa;
                this.mainPage = mainPage;
                this.company = mainPage.currentUser.getParentCompany();
                this.PopulateButton.setVisible(true);
                this.title = "Preload Page";
            }
            this.da = this.santa.daPreload;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.CategoryTree.setRoot(this.root);
        this.CategoryTree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.CategoryTree.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<String>>(){

            public void changed(ObservableValue<? extends TreeItem<String>> observableValue, TreeItem<String> oldItem, TreeItem<String> newItem) {
                if (newItem != null) {
                    int i;
                    String SelectedItem = (String)newItem.getValue();
                    if (SelectedItem == null) {
                        return;
                    }
                    Preload.this.CategoryTree;
                    Preload.this.nodeLevel = TreeView.getNodeLevel(newItem);
                    String[] values = new String[Preload.this.nodeLevel];
                    if (Preload.this.nodeLevel != 0) {
                        values[Preload.this.nodeLevel - 1] = SelectedItem;
                        for (i = 0; i < Preload.this.nodeLevel - 1; ++i) {
                            newItem = newItem.getParent();
                            if (Preload.this.nodeLevel == 0) continue;
                            values[i] = (String)newItem.getValue();
                        }
                    }
                    if (Preload.this.nodeLevel == 1) {
                        try {
                            for (i = 0; i < Preload.this.CategoryTableList.size(); ++i) {
                                if (((StockItem)Preload.this.CategoryTableList.get(i)).getIsActive()) continue;
                                Preload.this.CategoryTableList.remove(i);
                                --i;
                            }
                            Preload.this.setUpTree(SelectedItem, values);
                            if (newItem.getChildren().size() > 0) {
                                for (TreeItem treeItemstring : newItem.getChildren()) {
                                    treeItemstring.expandedProperty().set(true);
                                    treeItemstring.expandedProperty().set(false);
                                    Preload.this.loadAllItemsForMaker((TreeItem<String>)treeItemstring);
                                }
                                Preload.this.StockItemTable.setItems(Preload.this.originalItems);
                                Preload.this.setTableModel();
                            }
                        }
                        catch (SQLException ex) {
                            Logger.getLogger(Preload.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else if (Preload.this.nodeLevel == 3) {
                        try {
                            Preload.this.setUpTree(SelectedItem, values);
                        }
                        catch (SQLException ex) {
                            Logger.getLogger(Preload.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        });
        this.SearchTextField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    Preload.this.Search();
                }
            }
        });
        this.PopulateButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Preload.this.comitTodb();
            }
        });
    }

    private void loadAllItemsForMaker(TreeItem<String> values) throws SQLException {
        for (TreeItem treeItemstring : values.getChildren()) {
            String[] tempValue = new String[]{(String)values.getValue(), (String)values.getParent().getValue(), (String)treeItemstring.getValue()};
            this.loadTableItems(tempValue, this.tableName, true);
        }
    }

    private void getCheckedItems() {
        if (this.StockItemTable.getItems() == null) {
            return;
        }
        this.selectedItems.clear();
        for (int i = 0; i < this.StockItemTable.getItems().size(); ++i) {
            if (!((StockItem)this.StockItemTable.getItems().get(i)).getIsActive()) continue;
            this.selectedItems.add(((StockItem)this.StockItemTable.getItems().get(i)).getName());
        }
    }

    public void loadMainGroup() {
        this.mainGroups.clear();
        this.mainLevel = new StockPreload();
        try {
            this.mainLevel.getMakers().addAll(Maker.LoadMakers(this.da));
            this.setUpMainGroup();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setUpMainGroup() {
        if (this.mainLevel.getMakers().size() > 0) {
            for (int i = 0; i < this.mainLevel.getMakers().size(); ++i) {
                this.BaseTresItem = new TreeItem((Object)this.mainLevel.getMakers().get(i).getMaker());
                this.BaseTresItem.getChildren().add((Object)new TreeItem());
                this.root.getChildren().add(this.BaseTresItem);
                this.BaseTresItem.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        BooleanProperty bp = (BooleanProperty)observable;
                        TreeItem t = (TreeItem)bp.getBean();
                        String SelectedItem = (String)t.getValue();
                        Preload.this.CategoryTree;
                        Preload.this.nodeLevel = TreeView.getNodeLevel((TreeItem)t);
                        String[] values = new String[Preload.this.nodeLevel];
                        if (Preload.this.nodeLevel != 0) {
                            values[Preload.this.nodeLevel - 1] = SelectedItem;
                            for (int i = 0; i < Preload.this.nodeLevel - 1; ++i) {
                                t = t.getParent();
                                if (Preload.this.nodeLevel == 0) continue;
                                values[i] = (String)t.getValue();
                            }
                        }
                        try {
                            Preload.this.setUpTree(SelectedItem, values);
                        }
                        catch (SQLException ex) {
                            Logger.getLogger(Preload.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                });
            }
        }
    }

    private void loadTableItems(String[] values, String tableName, boolean loadAll) throws SQLException {
        int i;
        boolean isSelected = false;
        Random randomNumber = new Random();
        int maxValue = 1000;
        this.getCheckedItems();
        if (!loadAll) {
            for (i = 0; i < this.CategoryTableList.size(); ++i) {
                if (this.CategoryTableList.get(i).getIsActive()) continue;
                this.CategoryTableList.remove(i);
                --i;
            }
        }
        block1: for (i = 0; i < this.mainLevel.getMakers().size(); ++i) {
            if (!this.mainLevel.getMakers().get(i).getMaker().equals(values[1])) continue;
            for (int j = 0; j < this.mainLevel.getMakers().get(i).getTypes().size(); ++j) {
                if (!this.mainLevel.getMakers().get(i).getTypes().get(j).getType().equals(values[0])) continue;
                for (int k = 0; k < this.mainLevel.getMakers().get(i).getTypes().get(j).getSizes().size(); ++k) {
                    if (!this.mainLevel.getMakers().get(i).getTypes().get(j).getSizes().get(k).getSize().equals(values[2])) continue;
                    if (!this.mainLevel.getMakers().get((int)i).getTypes().get((int)j).getSizes().get((int)k).isLoaded) {
                        String query = "SELECT DISTINCT Name From " + tableName + " WHERE Maker=? and Type=? and Size=?";
                        ParameterValue[] parameterValues = new ParameterValue[]{new ParameterValue("Maker", JDBCType.VARCHAR, this.mainLevel.getMakers().get(i).getMaker()), new ParameterValue("Type", JDBCType.VARCHAR, this.mainLevel.getMakers().get(i).getTypes().get(j).getType()), new ParameterValue("Size", JDBCType.VARCHAR, this.mainLevel.getMakers().get(i).getTypes().get(j).getSizes().get(k).getSize())};
                        for (String string : StockPreload.LoadColumnGen(this.da, query, parameterValues, "Name")) {
                            StockItem si;
                            isSelected = false;
                            String typ = string;
                            if (typ == null) continue;
                            this.mainLevel.getMakers().get(i).getTypes().get(j).getSizes().get(k).getListStringObject().add(typ);
                            String barCode = typ + "/" + String.valueOf(randomNumber.nextInt(maxValue));
                            if (this.checkifAlreadyAdded(typ, this.mainLevel.getMakers().get(i).getMaker(), this.mainLevel.getMakers().get(i).getTypes().get(j).getType(), this.mainLevel.getMakers().get(i).getTypes().get(j).getSizes().get(k).getSize()) || (si = new StockItem(typ, values[1], values[0], values[2], isSelected, this.company)).existInStockItem()) continue;
                            this.CategoryTableList.add(si);
                        }
                        this.mainLevel.getMakers().get((int)i).getTypes().get((int)j).getSizes().get((int)k).isLoaded = true;
                        break block1;
                    }
                    for (String string : this.mainLevel.getMakers().get(i).getTypes().get(j).getSizes().get(k).getListStringObject()) {
                        isSelected = false;
                        String typ = string;
                        if (typ == null) continue;
                        String barCode = typ + "/" + String.valueOf(randomNumber.nextInt(maxValue));
                        if (this.checkifAlreadyAdded(typ, this.mainLevel.getMakers().get(i).getMaker(), this.mainLevel.getMakers().get(i).getTypes().get(j).getType(), this.mainLevel.getMakers().get(i).getTypes().get(j).getSizes().get(k).getSize())) continue;
                        StockItem si = new StockItem(typ, values[1], values[0], values[2], isSelected, this.company);
                        this.CategoryTableList.add(si);
                    }
                    break block1;
                }
                break block1;
            }
            break;
        }
        this.originalItems = FXCollections.observableArrayList(this.CategoryTableList);
    }

    private boolean checkifAlreadyAdded(String itemName, String maker, String type, String size) {
        for (int i = 0; i < this.CategoryTableList.size(); ++i) {
            if (!this.CategoryTableList.get(i).getName().equals(itemName) || !this.CategoryTableList.get(i).getSize().equals(size) || !this.CategoryTableList.get(i).getMaker().equals(maker) || !this.CategoryTableList.get(i).getType().equals(type)) continue;
            if (!this.CategoryTableList.get(i).getIsActive()) {
                this.CategoryTableList.remove(i);
            }
            return true;
        }
        return false;
    }

    private void setUpTree(String SelectedItem, String[] values) throws SQLException {
        block2 : switch (this.nodeLevel) {
            case 1: {
                String param = "maker";
                if (this.mainLevel.getMakers().size() <= 0) break;
                try {
                    this.getLevelItems(param, values, this.tableName, "Type");
                    for (int j = 0; j < this.mainLevel.getMakers().size(); ++j) {
                        if (!SelectedItem.equals(this.mainLevel.getMakers().get(j).getMaker()) || this.mainLevel.getMakers().get((int)j).isLoaded) continue;
                        for (int i = 0; i < this.mainLevel.getMakers().get(j).getTypes().size(); ++i) {
                            this.Type = new TreeItem((Object)this.mainLevel.getMakers().get(j).getTypes().get(i).getType());
                            this.Type.getChildren().add((Object)new TreeItem());
                            this.Type.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                                    BooleanProperty bp = (BooleanProperty)observable;
                                    TreeItem t = (TreeItem)bp.getBean();
                                    String SelectedItem = (String)t.getValue();
                                    Preload.this.CategoryTree;
                                    Preload.this.nodeLevel = TreeView.getNodeLevel((TreeItem)t);
                                    String[] values = new String[Preload.this.nodeLevel];
                                    if (Preload.this.nodeLevel != 0) {
                                        values[Preload.this.nodeLevel - 1] = SelectedItem;
                                        for (int i = 0; i < Preload.this.nodeLevel - 1; ++i) {
                                            t = t.getParent();
                                            if (Preload.this.nodeLevel == 0) continue;
                                            values[i] = (String)t.getValue();
                                        }
                                    }
                                    try {
                                        Preload.this.setUpTree(SelectedItem, values);
                                    }
                                    catch (SQLException ex) {
                                        Logger.getLogger(Preload.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                            });
                            ((TreeItem)this.root.getChildren().get(j)).getChildren().add(this.Type);
                        }
                        ((TreeItem)this.root.getChildren().get(j)).getChildren().remove(0);
                        this.mainLevel.getMakers().get((int)j).isLoaded = true;
                        break block2;
                    }
                    break;
                }
                catch (SQLException ex) {
                    Logger.getLogger(Preload.class.getName()).log(Level.SEVERE, null, ex);
                    break;
                }
            }
            case 2: {
                String param = "Type";
                int m = 0;
                int ty = 0;
                this.getLevelItems(param, values, this.tableName, "Size");
                block11: for (int j = 0; j < this.mainLevel.getMakers().size(); ++j) {
                    if (!values[0].equals(this.mainLevel.getMakers().get(j).getMaker())) continue;
                    m = j;
                    for (int i = 0; i < this.mainLevel.getMakers().get(j).getTypes().size(); ++i) {
                        if (values[1].equals(this.mainLevel.getMakers().get(j).getTypes().get(i).getType()) && !this.mainLevel.getMakers().get((int)j).getTypes().get((int)i).isLoaded) {
                            ty = i;
                            for (int k = 0; k < this.mainLevel.getMakers().get(j).getTypes().get(i).getSizes().size(); ++k) {
                                TreeItem Syze = new TreeItem((Object)this.mainLevel.getMakers().get(j).getTypes().get(i).getSizes().get(k).getSize());
                                Syze.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                                        BooleanProperty bp = (BooleanProperty)observable;
                                        TreeItem t = (TreeItem)bp.getBean();
                                        String SelectedItem = (String)t.getValue();
                                        Preload.this.CategoryTree;
                                        Preload.this.nodeLevel = TreeView.getNodeLevel((TreeItem)t);
                                        String[] values = new String[Preload.this.nodeLevel];
                                        if (Preload.this.nodeLevel != 0) {
                                            values[Preload.this.nodeLevel - 1] = SelectedItem;
                                            for (int i = 0; i < Preload.this.nodeLevel - 1; ++i) {
                                                t = t.getParent();
                                                if (Preload.this.nodeLevel == 0) continue;
                                                values[i] = (String)t.getValue();
                                            }
                                        }
                                    }
                                });
                                ((TreeItem)((TreeItem)this.root.getChildren().get(j)).getChildren().get(i)).getChildren().add((Object)Syze);
                            }
                            if (this.mainLevel.getMakers().get((int)j).getTypes().get((int)ty).isLoaded) continue;
                            ((TreeItem)((TreeItem)this.root.getChildren().get(j)).getChildren().get(ty)).getChildren().remove(0);
                            this.mainLevel.getMakers().get((int)j).getTypes().get((int)ty).isLoaded = true;
                            continue block11;
                        }
                        if (values[1].equals(this.mainLevel.getMakers().get(j).getTypes().get(i).getType()) && this.mainLevel.getMakers().get((int)j).getTypes().get((int)i).isLoaded) continue block11;
                    }
                }
                break;
            }
            case 3: {
                try {
                    this.loadTableItems(values, this.tableName, false);
                    this.StockItemTable.setItems(this.originalItems);
                    this.setTableModel();
                    break;
                }
                catch (SQLException ex) {
                    Logger.getLogger(Preload.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void getLevelItems(String param, String[] values, String tableName, String selection) throws SQLException {
        block14: {
            Object query;
            block16: {
                boolean outermostExit;
                block15: {
                    query = "";
                    this.CategoryTreeList.clear();
                    outermostExit = false;
                    if (values.length != 1) break block15;
                    query = "SELECT DISTINCT " + selection + " From " + tableName + " WHERE " + param + " = ?";
                    for (String string : StockPreload.LoadColumnGen(this.da, (String)query, new ParameterValue[]{new ParameterValue(param, JDBCType.VARCHAR, values[0])}, selection)) {
                        String typ = string;
                        if (typ != null) {
                            Type type = new Type(typ);
                            for (int i = 0; i < this.mainLevel.getMakers().size(); ++i) {
                                if (!this.mainLevel.getMakers().get(i).getMaker().equals(values[0])) continue;
                                if (this.mainLevel.getMakers().get((int)i).isLoaded) {
                                    outermostExit = true;
                                    break;
                                }
                                this.mainLevel.getMakers().get(i).getTypes().add(type);
                                break;
                            }
                        }
                        if (!outermostExit) continue;
                        break block14;
                    }
                    break block14;
                }
                if (values.length != 2) break block16;
                query = "SELECT DISTINCT " + selection + " From " + tableName + " WHERE " + param + " = ? and Maker=?";
                for (int i = 0; i < this.mainLevel.getMakers().size(); ++i) {
                    if (!this.mainLevel.getMakers().get(i).getMaker().equals(values[0])) continue;
                    for (int j = 0; j < this.mainLevel.getMakers().get(i).getTypes().size(); ++j) {
                        if (this.mainLevel.getMakers().get(i).getTypes().get(j).getType().equals(values[1])) {
                            for (String string : StockPreload.LoadColumnGen(this.da, (String)query, new ParameterValue[]{new ParameterValue(param, JDBCType.VARCHAR, values[1]), new ParameterValue("Maker", JDBCType.VARCHAR, values[0])}, selection)) {
                                String typ = string;
                                if (typ == null) continue;
                                if (this.mainLevel.getMakers().get((int)i).getTypes().get((int)j).isLoaded) {
                                    outermostExit = true;
                                    break block14;
                                }
                                Size siz = new Size(typ);
                                this.mainLevel.getMakers().get(i).getTypes().get(j).getSizes().add(siz);
                            }
                            break block14;
                        }
                        if (!outermostExit) {
                            continue;
                        }
                        break block14;
                    }
                    break block14;
                }
                break block14;
            }
            if (values.length != 3) break block14;
            query = "SELECT DISTINCT " + selection + " From " + tableName + " WHERE Maker=? and Type=? and Size=?";
            for (int i = 0; i < this.mainLevel.getMakers().size(); ++i) {
                if (!this.mainLevel.getMakers().get(i).getMaker().equals(values[1])) continue;
                for (int j = 0; j < this.mainLevel.getMakers().get(i).getTypes().size(); ++j) {
                    if (!this.mainLevel.getMakers().get(i).getTypes().get(j).getType().equals(values[0])) continue;
                    for (int k = 0; k < this.mainLevel.getMakers().get(i).getTypes().get(j).getSizes().size(); ++k) {
                        if (!this.mainLevel.getMakers().get(i).getTypes().get(j).getSizes().get(k).getSize().equals(values[2])) continue;
                        for (String string : StockPreload.LoadColumnGen(this.da, (String)query, new ParameterValue[]{new ParameterValue("Maker", JDBCType.VARCHAR, values[1]), new ParameterValue("Type", JDBCType.VARCHAR, values[0]), new ParameterValue("Size", JDBCType.VARCHAR, values[2])}, selection)) {
                            String typ = string;
                            if (typ == null) continue;
                            this.mainLevel.getMakers().get(i).getTypes().get(j).getSizes().get(k).getListStringObject().add(typ);
                        }
                        break block14;
                    }
                    break block14;
                }
                break;
            }
        }
    }

    @FXML
    private void SelectAllCheckBoxOnAction(ActionEvent event) {
        if (this.SelectAllCheckBox.isSelected() && this.originalItems != null) {
            boolean checked = true;
            for (StockItem si : this.originalItems) {
                si.setIsActive(checked);
            }
        }
    }

    private void comitTodb() {
        this.getCheckedItems();
        this.tempOriginalItems = FXCollections.observableArrayList();
        if (this.originalItems != null) {
            for (StockItem stockItem : this.originalItems) {
                if (!stockItem.getIsActive()) continue;
                stockItem.setDbAccess(this.santa.da);
                stockItem.setParentUnit(new Unit("Pieces", Float.valueOf(1.0f), this.da));
                this.tempOriginalItems.add((Object)stockItem);
            }
        }
        if (this.tempOriginalItems.size() > 0) {
            this.stockItemList = new StockItemList(this.santa.da);
            this.stockItemList.getOriginalList().addAll(this.tempOriginalItems);
            try {
                if (this.ParentConfigPagePane != null && this.ParentConfigPagePane.keepItemList != null) {
                    for (StockItem item : this.stockItemList.getOriginalList()) {
                        if (!this.ParentConfigPagePane.keepItemList.getOriginalList().contains((Object)item)) continue;
                        item.setState(ObjectState.Unchanged);
                    }
                    for (StockItem item : this.ParentConfigPagePane.keepItemList.getOriginalList()) {
                        if (this.stockItemList.getOriginalList().contains((Object)item)) continue;
                        item.setState(ObjectState.Removed);
                        item.setDbAccess(this.santa.da);
                        this.stockItemList.getOriginalList().add((Object)item);
                    }
                }
                this.stockItemList.update();
                if (this.ParentConfigPagePane != null) {
                    this.ParentConfigPagePane.keepItemList.getOriginalList().clear();
                    for (StockItem object : this.stockItemList.getOriginalList()) {
                        StockItem temp = new StockItem(this.santa.da);
                        temp.setItemCode(object.getItemCode());
                        temp.setCostPrice(object.getCostPrice());
                        temp.setName(object.getName());
                        temp.setMaker(object.getMaker());
                        temp.setParentCompany(object.getParentCompany());
                        temp.setParentUnit(object.getParentUnit());
                        temp.setSellingPrice(object.getSellingPrice());
                        temp.setSize(object.getSize());
                        temp.setType(object.getType());
                        this.ParentConfigPagePane.keepItemList.getOriginalList().add((Object)temp);
                    }
                }
                this.originalItems.clear();
                if (this.mainPage != null) {
                    this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
                }
            }
            catch (Exception ex) {
                this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            }
        }
    }

    @FXML
    private void SearchButtonOnAction(ActionEvent event) {
        this.Search();
    }

    private void Search() {
        if (this.mainLevel == null) {
            this.mainLevel = new StockPreload();
        }
        String SearchValue = this.SearchTextField.getText();
        if (this.root.getChildren().size() > 0) {
            this.StockItemTable.getItems().clear();
            this.root.getChildren().clear();
            this.CategoryTableList.clear();
            this.mainLevel.getMakers().clear();
        }
        if ("".equals(SearchValue)) {
            this.loadMainGroup();
            return;
        }
        this.mainGroups.clear();
        for (String preload : StockPreload.LoadColumn(this.da, "SELECT DISTINCT maker FROM items WHERE ", this.SearchTextField.getText())) {
            this.mainLevel.getMakers().add(new Maker(preload));
        }
        this.setUpMainGroup();
    }

    @FXML
    private void TrimListButtonOnAction(ActionEvent event) {
        this.trimList();
    }

    public void trimList() {
        this.selectedItems.clear();
        this.getCheckedItems();
        for (int i = 0; i < this.StockItemTable.getItems().size(); ++i) {
            boolean isThere = false;
            for (int j = 0; j < this.selectedItems.size(); ++j) {
                if (!(((StockItem)this.StockItemTable.getItems().get(i)).getName() == null ? this.selectedItems.get(j) == null : ((StockItem)this.StockItemTable.getItems().get(i)).getName().equals(this.selectedItems.get(j)))) continue;
                isThere = true;
            }
            if (isThere) continue;
            this.originalItems.remove(i);
            --i;
        }
    }

    private void setTableModel() {
        this.NameCol.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.SelectedCol.setCellValueFactory((Callback)new PropertyValueFactory("isSelected"));
        this.cb = new CheckBox();
        this.cb.setOnAction(this.handler);
        this.SelectedCol.setGraphic((Node)this.cb);
        this.SelectedCol.setCellFactory((Callback)new Callback<TableColumn<StockItem, Boolean>, TableCell<StockItem, Boolean>>(){

            public TableCell<StockItem, Boolean> call(TableColumn<StockItem, Boolean> param) {
                return new CheckBoxTableCell<StockItem, Boolean>();
            }
        });
        this.StockItemTable.getColumns().setAll((Object[])new TableColumn[]{this.NameCol, this.SelectedCol});
    }

    @Override
    void completeControl() {
        this.comitTodb();
    }

    @Override
    void closeNotification() {
        this.mainPage.closeNotification();
    }

    public static class CheckBoxTableCell<S, T>
    extends TableCell<S, T> {
        private final CheckBox checkBox = new CheckBox();
        private ObservableValue<T> ov;

        public CheckBoxTableCell() {
            this.checkBox.setAlignment(Pos.CENTER);
            this.setAlignment(Pos.CENTER);
            this.setGraphic((Node)this.checkBox);
        }

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.setGraphic((Node)this.checkBox);
                if (this.ov instanceof BooleanProperty) {
                    this.checkBox.selectedProperty().unbindBidirectional((Property)((BooleanProperty)this.ov));
                }
                this.ov = this.getTableColumn().getCellObservableValue(this.getIndex());
                if (this.ov instanceof BooleanProperty) {
                    this.checkBox.selectedProperty().bindBidirectional((Property)((BooleanProperty)this.ov));
                }
            }
        }
    }
}

