/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.xputertechnologies.santa.ManualPendingStatus;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.SaleStatus;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.ISalePane;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.SalesPaneB2B;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;

public class PendingManualSaleItem
extends UIParent {
    @FXML
    private Label lblCusName;
    @FXML
    private Label lblItemCount;
    @FXML
    private Label lblAmt;
    @FXML
    private Label lblDate;
    @FXML
    private Label lblInvoice;
    @FXML
    private Label lblStatus;
    @FXML
    private JFXButton btnSell;
    @FXML
    private JFXButton btnRemove;
    @FXML
    private JFXButton btnReload;
    @FXML
    private FlowPane vbApprovals;
    JFXDialog dialog = null;
    public Sale sale;

    public PendingManualSaleItem(Santa app, Sale sale, ISalePane sp) {
        super("PendingManualSaleItem.fxml", app);
        this.santa = app;
        this.sale = sale;
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String saleDateString = format.format(sale.getTransactionDate());
        this.lblAmt.setText(General.toNaira() + General.formatDecimalToMoneyString(sale.getAmountPaid()));
        this.lblCusName.setText(sale.getCustomerName());
        this.lblItemCount.setText(String.valueOf(sale.getSaleItemsList().size()) + " Item(s)");
        this.lblDate.setText(saleDateString);
        this.lblStatus.setText(sale.getManualSaleStatus());
        this.lblInvoice.setText(String.valueOf(sale.getInvoiceNumber()));
        if (sale.getManualSaleStatus() == ManualPendingStatus.Approved.toString()) {
            this.btnSell.setText("Sell");
            this.setStyle("-fx-background-color:Green");
        } else if (sale.getManualSaleStatus().equals(ManualPendingStatus.Pending.name()) || sale.getManualSaleStatus().equals(ManualPendingStatus.Created.name())) {
            this.btnSell.setText("Send for Approval");
        } else if (sale.getManualSaleStatus().equals(ManualPendingStatus.Declined.name())) {
            this.btnSell.setText("Remove");
        }
        String css = "-fx-text-fill:white;-fx-background-color:Green";
        this.btnRemove.setVisible(sale.getManualSaleStatus().equals(ManualPendingStatus.Created.name()));
        this.btnRemove.setOnAction(ev -> {
            if (sp instanceof SalesPane) {
                ((SalesPane)sp).removeSale(this);
            }
            if (sp instanceof SalesPaneB2B) {
                ((SalesPaneB2B)sp).removeSale(this);
            }
        });
        this.btnSell.setOnAction(ev -> {
            if (sale.getManualSaleStatus().equals(ManualPendingStatus.Approved.toString()) || sale.getManualSaleStatus().equals(ManualPendingStatus.Completed.name())) {
                sp.setSale(sale);
                sale.setState(ObjectState.Changed);
                if (sp instanceof SalesPane) {
                    sale.setManualSaleStatus(ManualPendingStatus.Completed.name());
                    if (sale.getPaymentTerm() == null || sale.getPaymentTerm().isEmpty()) {
                        if (!(sale.getCreditDescription().isEmpty() && sale.getCreditToken().isEmpty() || sale.getCreditDescription().equals("Easy Buy"))) {
                            try {
                                sale.setManualSaleStatus(ManualPendingStatus.Completed.name());
                                Sale ss = sale.CloneForInvoice();
                                ss.setDbAccess(this.da);
                                ss.setSaleItemsList(sale.getSaleItemsList());
                                ((SalesPane)sp).printInvoice(ss);
                                ((SalesPane)sp).saveAndRemove(this);
                            }
                            catch (Exception ex) {
                                Logger.getLogger(PendingManualSaleItem.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        } else {
                            ((SalesPane)sp).showPayment(false);
                        }
                    } else {
                        ((SalesPane)sp).saveAndRemove(this);
                    }
                }
                if (sp instanceof SalesPaneB2B) {
                    sale.setManualSaleStatus(ManualPendingStatus.Completed.name());
                    if (sale.getPaymentTerm() == null || sale.getPaymentTerm().isEmpty()) {
                        ((SalesPaneB2B)sp).showPayment(false);
                    } else {
                        ((SalesPaneB2B)sp).saveAndRemove(this);
                    }
                }
            } else if (sale.getManualSaleStatus().equals(ManualPendingStatus.Pending.name()) || sale.getManualSaleStatus().equals(ManualPendingStatus.Created.name())) {
                if (sp instanceof SalesPane) {
                    if (sale.getManualSaleStatus().equals(ManualPendingStatus.Pending.name())) {
                        ((SalesPane)sp).resendManualSaleMail(sale);
                    } else {
                        ((SalesPane)sp).pushSale(sale);
                    }
                }
                if (sp instanceof SalesPaneB2B) {
                    if (sale.getManualSaleStatus().equals(ManualPendingStatus.Pending.name())) {
                        ((SalesPaneB2B)sp).resendManualSaleMail(sale);
                    } else {
                        ((SalesPaneB2B)sp).pushSale(sale);
                    }
                }
            } else if (sale.getManualSaleStatus().equals(ManualPendingStatus.Declined.toString())) {
                sale.setSaleComment("Manual sale declined");
                sale.setManualSaleStatus(ManualPendingStatus.Declined.name());
                sale.setSaleStatus(SaleStatus.CANCELLED.name());
                sale.setSyncFlag(true);
                sale.setState(ObjectState.Changed);
                if (sp instanceof SalesPane) {
                    ((SalesPane)sp).removeSale(this);
                }
                if (sp instanceof SalesPaneB2B) {
                    ((SalesPaneB2B)sp).removeSale(this);
                }
            }
        });
        this.btnReload.setOnAction(ev -> {
            if (sp instanceof SalesPane) {
                ((SalesPane)sp).loadSale(sale);
            }
            if (sp instanceof SalesPaneB2B) {
                ((SalesPaneB2B)sp).loadSale(sale);
            }
        });
        this.setAppOrRej();
    }

    public void setAppOrRej() {
        block3: {
            String[] splits;
            String css;
            String rejs;
            block2: {
                String[] splits2;
                this.vbApprovals.getChildren().clear();
                String apps = this.sale.getApprovals();
                rejs = this.sale.getSalesRejectedBy();
                css = "-fx-text-fill:white;-fx-background-color:green;-fx-padding: 5 5 5 5;";
                if (apps == null || apps.equals("NULL") || apps.isEmpty()) break block2;
                for (String split : splits2 = apps.split(",")) {
                    Label lbl = new Label(split);
                    lbl.setMaxWidth(210.0);
                    lbl.setStyle(css);
                    this.vbApprovals.getChildren().add((Object)lbl);
                }
                break block3;
            }
            if (rejs == null || rejs.equals("NULL") || rejs.isEmpty()) break block3;
            for (String split : splits = rejs.split(",")) {
                Label lbl = new Label(split);
                lbl.setMaxWidth(210.0);
                css = "-fx-text-fill:white;-fx-background-color:red;-fx-padding: 5 5 5 5;";
                lbl.setStyle(css);
                this.vbApprovals.getChildren().add((Object)lbl);
            }
        }
    }
}

