/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.BatchSale;
import com.xputertechnologies.santa.BatchStatusEnum;
import com.xputertechnologies.santa.PaymentBatch;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.BatchSaleDataList;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.list.PaymentBatchDataList;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.IGenericInterface;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PaymentBatchNew;
import com.xputertechnologies.santa.ui.PurchaseOrderPaneViewerPane;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.TempRoleManagement;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class PaymentBatchPane
extends IGenericInterface {
    @FXML
    private StackPane stackPane;
    @FXML
    private JFXDatePicker fromDate;
    @FXML
    private JFXDatePicker toDate;
    @FXML
    private JFXTextField txtSearch;
    @FXML
    private JFXButton btnSearch;
    @FXML
    private JFXButton btnNew;
    @FXML
    private JFXComboBox<?> cmbFilter;
    @FXML
    private JFXButton btnPostPending;
    @FXML
    private TableView<PaymentBatch> table;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colBatchCode;
    @FXML
    private TableColumn colBatchDate;
    @FXML
    private TableColumn colBatchUser;
    @FXML
    private TableColumn colAmount;
    @FXML
    private TableColumn colAmountDeposited;
    @FXML
    private TableColumn colTellerNo;
    @FXML
    private TableColumn colStatus;
    @FXML
    private TableColumn colSales;
    @FXML
    private TableColumn colDel;
    @FXML
    private TableColumn colPost;
    PaymentBatchDataList paymentBatchDataList;

    public PaymentBatchPane(Santa santa) {
        super("PaymentBatchPane.fxml", santa);
        this.santa = santa;
        this.title = "Payment Batching Page";
        this.fromDate.setValue((Object)LocalDate.now());
        this.toDate.setValue((Object)LocalDate.now());
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colBatchCode.setCellValueFactory((Callback)new PropertyValueFactory("batchCode"));
        this.colAmount.setCellValueFactory((Callback)new PropertyValueFactory("amount"));
        this.colAmountDeposited.setCellValueFactory((Callback)new PropertyValueFactory("amountDeposited"));
        this.colBatchDate.setCellValueFactory((Callback)new PropertyValueFactory("dateCreated"));
        this.colBatchUser.setCellValueFactory((Callback)new PropertyValueFactory("batchUser"));
        this.colStatus.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.colTellerNo.setCellValueFactory((Callback)new PropertyValueFactory("tellerNo"));
        this.colAmount.setCellFactory(col -> new TableCell<PaymentBatch, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.colAmountDeposited.setCellFactory(col -> new TableCell<PaymentBatch, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.paymentBatchDataList = new PaymentBatchDataList(this.da);
        this.search();
        this.btnNew.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS).color(Color.WHITE).size(15.0));
        this.btnPostPending.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.EXTERNAL_LINK).color(Color.WHITE).size(15.0));
        Callback<TableColumn<PaymentBatch, String>, TableCell<PaymentBatch, String>> cellFactoryDel = new Callback<TableColumn<PaymentBatch, String>, TableCell<PaymentBatch, String>>(){

            public TableCell call(TableColumn<PaymentBatch, String> param) {
                TableCell<PaymentBatch, String> cell = new TableCell<PaymentBatch, String>(){
                    final JFXButton btn = new JFXButton("Delete");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            final PaymentBatch req = (PaymentBatch)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getSyncFlag().booleanValue()) {
                                this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                                this.btn.setGraphic((Node)PaymentBatchPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.TRASH).color(Color.WHITE).size(10.0));
                                this.btn.setStyle("-fx-background-color: #FF0000;-fx-font-size: 10px;");
                                this.btn.setVisible(true);
                                this.btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                    public void handle(ActionEvent event) {
                                        PaymentBatchPane.this.delete(req);
                                    }
                                });
                                this.setGraphic((Node)this.btn);
                                this.setAlignment(Pos.CENTER);
                                this.setText(null);
                            } else {
                                this.btn.setVisible(false);
                            }
                        }
                    }
                };
                return cell;
            }
        };
        this.colDel.setCellFactory((Callback)cellFactoryDel);
        Callback<TableColumn<PaymentBatch, String>, TableCell<PaymentBatch, String>> cellFactorycolSales = new Callback<TableColumn<PaymentBatch, String>, TableCell<PaymentBatch, String>>(){

            public TableCell call(TableColumn<PaymentBatch, String> param) {
                TableCell<PaymentBatch, String> cell = new TableCell<PaymentBatch, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            final PaymentBatch req = (PaymentBatch)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                            if (!req.getSyncFlag().booleanValue()) {
                                this.btn.setText("Edit");
                                this.btn.setGraphic((Node)PaymentBatchPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.PENCIL).color(Color.WHITE).size(10.0));
                                this.btn.setStyle("-fx-background-color: #4FC4F6;-fx-font-size: 10px;");
                            } else {
                                this.btn.setText("View");
                                this.btn.setGraphic((Node)PaymentBatchPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.WHITE).size(10.0));
                                this.btn.setStyle("-fx-background-color: #4FC4F6;-fx-font-size: 10px;");
                            }
                            this.btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                public void handle(ActionEvent event) {
                                    PaymentBatchPane.this.selectedPaymentBatch = req;
                                    PaymentBatchPane.this.editView();
                                }
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colSales.setCellFactory((Callback)cellFactorycolSales);
        Callback<TableColumn<PaymentBatch, String>, TableCell<PaymentBatch, String>> cellFactorypost = new Callback<TableColumn<PaymentBatch, String>, TableCell<PaymentBatch, String>>(){

            public TableCell call(TableColumn<PaymentBatch, String> param) {
                TableCell<PaymentBatch, String> cell = new TableCell<PaymentBatch, String>(){
                    final JFXButton btn = new JFXButton("Post");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            final PaymentBatch req = (PaymentBatch)this.getTableView().getItems().get(this.getIndex());
                            if (!req.getSyncFlag().booleanValue() && req.getStatus().equals(BatchStatusEnum.Linked.name()) || TempRoleManagement.adminOnly(UserType.valueOf(PaymentBatchPane.this.mainPage.currentUser.getRoleDescription()))) {
                                this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                                this.btn.setGraphic((Node)PaymentBatchPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EXTERNAL_LINK).color(Color.WHITE).size(10.0));
                                this.btn.setStyle("-fx-background-color: #00A86B;-fx-font-size: 10px;");
                                this.btn.setVisible(true);
                                this.btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                    public void handle(ActionEvent event) {
                                        ArrayList<PaymentBatch> list = new ArrayList<PaymentBatch>();
                                        list.add(req);
                                        PaymentBatchPane.this.post(list);
                                    }
                                });
                                this.setGraphic((Node)this.btn);
                                this.setAlignment(Pos.CENTER);
                                this.setText(null);
                            } else {
                                this.btn.setVisible(false);
                            }
                        }
                    }
                };
                return cell;
            }
        };
        this.colPost.setCellFactory((Callback)cellFactorypost);
        Callback<TableColumn<PaymentBatch, String>, TableCell<PaymentBatch, String>> cellFactoryStatus = new Callback<TableColumn<PaymentBatch, String>, TableCell<PaymentBatch, String>>(){

            public TableCell call(TableColumn<PaymentBatch, String> param) {
                TableCell<PaymentBatch, String> cell = new TableCell<PaymentBatch, String>(){
                    final Label lbl = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            PaymentBatch req = (PaymentBatch)this.getTableView().getItems().get(this.getIndex());
                            if (req.getStatus().equals(BatchStatusEnum.Created.name())) {
                                this.lbl.setStyle("-fx-background-color:#FC02DD;-fx-font-size: 12.0px;-fx-text-fill:white;");
                            } else if (req.getStatus().equals(BatchStatusEnum.Linked.name())) {
                                this.lbl.setStyle("-fx-background-color:#34b962;-fx-font-size: 12.0px;-fx-text-fill:white;");
                            } else if (req.getStatus().equals(BatchStatusEnum.Posted.name())) {
                                this.lbl.setStyle("-fx-background-color:#CCFFFF;-fx-font-size: 12.0px;-fx-text-fill:black;");
                            }
                            this.lbl.setText(req.getStatus());
                            this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                            this.setGraphic((Node)this.lbl);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colStatus.setCellFactory((Callback)cellFactoryStatus);
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.txtSearch, t -> {
            List<SearchClass> result = this.searchData(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<SearchClass>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<SearchClass> event) {
                PaymentBatchPane.this.populateSearch(((SearchClass)event.getCompletion()).getUniqueString());
            }
        });
        this.btnNew.setOnAction(c -> {
            try {
                this.selectedPaymentBatch = null;
                this.dialog = new JFXDialog();
                this.dialog.setDialogContainer(this.stackPane);
                this.dialog.setContent((Region)new PaymentBatchNew(this));
                this.dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
                this.dialog.setOverlayClose(false);
                this.dialog.show();
            }
            catch (Exception ex) {
                Logger.getLogger(PurchaseOrderPaneViewerPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.btnPostPending.setOnAction(c -> {
            List<PaymentBatch> list = PaymentBatchDataList.selectAllPendingPostingPaymentBaqtch(this.da);
            if (list.isEmpty()) {
                this.mainPage.showNotification(NotificationType.Information, "No Pending Payment Batch", this);
            } else {
                this.post(list);
            }
        });
        this.btnSearch.setOnAction(v -> this.search());
        this.table.setItems(this.paymentBatchDataList.getOriginalList());
    }

    private void post(final List<PaymentBatch> list) {
        final String url = this.santa.syncSetting.getBEURL() + "RBatchPayment/CreateBatchPayment";
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            JSONArray jSONArray = new JSONArray();
                            for (PaymentBatch payBatch : list) {
                                JSONObject job = new JSONObject();
                                job.put("Code", (Object)payBatch.getBatchCode());
                                job.put("BatchUser", (Object)payBatch.getBatchUser());
                                job.put("Status", (Object)BatchStatusEnum.Posted.name());
                                job.put("StoreCode", (Object)payBatch.getStore());
                                job.put("TellerNo", (Object)payBatch.getTellerNo());
                                job.put("TotalAmount", payBatch.getAmount());
                                job.put("AmountDeposited", payBatch.getAmountDeposited());
                                job.put("DateCreated", (Object)payBatch.getDateCreated());
                                job.put("Bank", (Object)payBatch.getBankName());
                                job.put("BankAccount", (Object)payBatch.getAccountNo());
                                job.put("Comment", (Object)payBatch.getRemark());
                                job.put("AuditStatus", (Object)(payBatch.getAmountDeposited() != payBatch.getAmount() ? "Failed" : "Pending"));
                                JSONArray sales = new JSONArray();
                                for (BatchSale batchSale : payBatch.getBatchSales()) {
                                    JSONObject jsono = new JSONObject();
                                    jsono.put("Code", (Object)batchSale.getBatchCode());
                                    jsono.put("InvoiceNumber", (Object)batchSale.getInvoiceNumber());
                                    jsono.put("SalesChannel", (Object)batchSale.getSalesChannel());
                                    jsono.put("CashAmount", batchSale.getAmount());
                                    jsono.put("BalanceNotCash", batchSale.getAmountNotCash());
                                    sales.put((Object)jsono);
                                }
                                job.put("Sales", (Object)sales);
                                jSONArray.put((Object)job);
                            }
                            HttpPost httpPost = new HttpPost(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            System.out.println(jSONArray.toString());
                            StringEntity stringEntity = new StringEntity(jSONArray.toString());
                            httpPost.setEntity((HttpEntity)stringEntity);
                            httpPost.setHeader("Content-type", "application/json");
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                Platform.runLater(() -> {
                                    try {
                                        PaymentBatchDataList payDataList = new PaymentBatchDataList(PaymentBatchPane.this.da);
                                        list.forEach(val -> {
                                            val.setSyncFlag(true);
                                            val.setSyncError("");
                                            val.setStatus(BatchStatusEnum.Posted.name());
                                            payDataList.getOriginalList().add(val);
                                        });
                                        payDataList.update();
                                        list.forEach(c -> {
                                            PaymentBatch found = PaymentBatchPane.this.paymentBatchDataList.getOriginalList().stream().filter(x -> x.getBatchCode().equals(c.getBatchCode())).findAny().get();
                                            found.setSyncFlag(true);
                                        });
                                        PaymentBatchPane.this.table.refresh();
                                        PaymentBatchPane.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", PaymentBatchPane.this);
                                        PaymentBatchPane.this.stackPane.getChildren().remove((Object)box);
                                    }
                                    catch (Exception ex) {
                                        PaymentBatchPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), PaymentBatchPane.this);
                                    }
                                });
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    PaymentBatchPane.this.stackPane.getChildren().remove((Object)box);
                                    PaymentBatchPane.this.mainPage.showNotification(NotificationType.Error, fullError, PaymentBatchPane.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                PaymentBatchPane.this.stackPane.getChildren().remove((Object)box);
                                PaymentBatchPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), PaymentBatchPane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    public void done(PaymentBatch paymentBatch) {
        boolean isNew = paymentBatch.getState().equals((Object)ObjectState.New);
        if (!isNew) {
            int index = this.paymentBatchDataList.getOriginalList().indexOf((Object)this.paymentBatchDataList.getOriginalList().stream().filter(x -> x.getBatchCode().equals(paymentBatch.getBatchCode())).findAny().get());
            this.paymentBatchDataList.getOriginalList().remove(index);
            this.paymentBatchDataList.getOriginalList().add(index, (Object)paymentBatch);
        }
        PaymentBatchDataList paymentBatchDataList1 = new PaymentBatchDataList(this.da);
        paymentBatch.setStatus(paymentBatch.getTellerNo().isEmpty() ? BatchStatusEnum.Created.name() : BatchStatusEnum.Linked.name());
        paymentBatchDataList1.getOriginalList().add((Object)paymentBatch);
        BatchSaleDataList batchSaleDataList = new BatchSaleDataList(this.da);
        batchSaleDataList.getOriginalList().addAll(paymentBatch.getBatchSales());
        try {
            this.da.start();
            paymentBatchDataList1.update();
            batchSaleDataList.update();
            if (isNew) {
                this.currentUser.getParentCompany().setLastPaymentBatchCount(this.currentUser.getParentCompany().getLastPaymentBatchCount() + 1);
                CompanyDataList comapCompanyDataList = new CompanyDataList(this.da);
                comapCompanyDataList.getOriginalList().add((Object)this.currentUser.getParentCompany());
                comapCompanyDataList.update();
            }
            this.da.end();
            this.paymentBatchDataList.resetNumbering();
            this.table.refresh();
            this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
        this.dialog.close();
    }

    private void viewSales(PaymentBatch paymentBatch) {
        this.dialog = new JFXDialog();
        this.dialog.setDialogContainer(this.stackPane);
        this.dialog.setContent((Region)new PaymentBatchNew(this));
        this.dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    private void editView() {
        this.dialog = new JFXDialog();
        this.dialog.setDialogContainer(this.stackPane);
        this.dialog.setContent((Region)new PaymentBatchNew(this));
        this.dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    private void delete(PaymentBatch paymentBatch) {
        PaymentBatchDataList paymentBatchDataList1 = new PaymentBatchDataList(this.da);
        paymentBatch.setState(ObjectState.Removed);
        paymentBatchDataList1.getOriginalList().add((Object)paymentBatch);
        try {
            paymentBatchDataList1.update();
            this.paymentBatchDataList.getOriginalList().remove((Object)paymentBatch);
            this.paymentBatchDataList.resetNumbering();
            this.table.refresh();
            this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
    }

    @Override
    public void populateSearch(String SearchValue) {
        PaymentBatchDataList paymentBatchDataList1 = new PaymentBatchDataList(this.da);
        paymentBatchDataList1.selectAll("Select * from PaymentBatch where batchCode=?", new ParameterValue[]{new ParameterValue("batchCode", JDBCType.VARCHAR, SearchValue)});
        if (paymentBatchDataList1.getOriginalList().size() == 1) {
            PaymentBatch found = this.paymentBatchDataList.getOriginalList().stream().filter(c -> c.getBatchCode().equals(((PaymentBatch)paymentBatchDataList1.getOriginalList().get(0)).getBatchCode())).findAny().orElse(null);
            if (found == null) {
                this.paymentBatchDataList.getOriginalList().add((Object)((PaymentBatch)paymentBatchDataList1.getOriginalList().get(0)));
                this.table.refresh();
            } else {
                this.paymentBatchDataList.getOriginalList().remove((Object)found);
                this.paymentBatchDataList.getOriginalList().add(0, (Object)found);
                this.table.refresh();
                this.table.getSelectionModel().select((Object)found);
            }
            this.paymentBatchDataList.resetNumbering();
        }
    }

    @Override
    public List<SearchClass> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<SearchClass>();
        }
        try {
            return PaymentBatchDataList.searchAutoComplete(searchString, this.da);
        }
        catch (SQLException ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<SearchClass>();
        }
    }

    private void search() {
        this.paymentBatchDataList.getOriginalList().clear();
        this.paymentBatchDataList.getOriginalList().addAll(PaymentBatchDataList.SearchByDate(Date.valueOf((LocalDate)this.fromDate.getValue()), Date.valueOf((LocalDate)this.toDate.getValue()), this.da).getOriginalList());
        this.paymentBatchDataList.resetNumbering();
    }
}

