/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXTextArea;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.AccountDetail;
import com.xputertechnologies.santa.AccountPaymentType;
import com.xputertechnologies.santa.BatchSale;
import com.xputertechnologies.santa.PaymentBatch;
import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.list.AccountDetailDataList;
import com.xputertechnologies.santa.list.BatchSaleDataList;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.IGenericInterface;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PaymentBatchPane;
import com.xputertechnologies.santa.ui.SalesPane;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.Date;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.glyphfont.FontAwesome;

public class PaymentBatchNew
extends UIParent {
    protected StringConverter<? extends Number> dConverter = new DoubleStringConverter(){

        public String toString(Double object) {
            if (object != null) {
                return General.formatDecimalToMoneyString(object);
            }
            return null;
        }

        public Double fromString(String string) {
            Double d = 0.0;
            if (!string.isEmpty()) {
                string = string.replace(",", "");
                d = Double.parseDouble(string);
            }
            return d;
        }
    };
    @FXML
    private JFXCheckBox chkAllow;
    @FXML
    private StackPane stackPane;
    @FXML
    private JFXDatePicker fromDate;
    @FXML
    private JFXDatePicker toDate;
    @FXML
    private JFXTextField txSearch;
    @FXML
    private JFXTextField tbAmtDeposited;
    @FXML
    private JFXTextArea txArearemark;
    @FXML
    private JFXButton btnSearch;
    @FXML
    private JFXButton btnClear;
    @FXML
    private TableView<BatchSale> table;
    @FXML
    private JFXComboBox<AccountDetail> cmbBank;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colInvoiceNo;
    @FXML
    private TableColumn colAmount;
    @FXML
    private TableColumn colAmountNotCash;
    @FXML
    private TableColumn colChannel;
    @FXML
    private TableColumn colDel;
    @FXML
    private JFXTextField tbTeller;
    @FXML
    private Label lblTotalAmt;
    @FXML
    private JFXButton btnDone;
    @FXML
    private JFXButton btnCancel;
    @FXML
    private HBox hboxHeader;
    @FXML
    private HBox hbTitle;
    @FXML
    private VBox vbContainer;
    PaymentBatch paymentBatch;
    IGenericInterface parent;
    boolean allow;

    public PaymentBatchNew(IGenericInterface parent) {
        super("PaymentBatchNew.fxml", parent.santa);
        this.santa = parent.santa;
        this.title = "New Payment Batch";
        this.parent = parent;
        AccountDetailDataList accts = new AccountDetailDataList(this.da);
        accts.selectAllOnlyCash();
        this.fromDate.setValue((Object)LocalDate.now());
        this.toDate.setValue((Object)LocalDate.now());
        this.btnDone.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CHECK).color(Color.WHITE).size(15.0));
        this.btnClear.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.TRASH).color(Color.WHITE).size(15.0));
        this.btnCancel.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.CLOSE).color(Color.WHITE).size(15.0));
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.txSearch, t -> {
            List<SearchClass> result = this.searchData(t.getUserText());
            return result.size() > 25 ? result.subList(0, 24) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<SearchClass>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<SearchClass> event) {
                PaymentBatchNew.this.populateSearch(((SearchClass)event.getCompletion()).getUniqueString());
            }
        });
        this.chkAllow.selectedProperty().addListener((obs, wasSelected, isNowSelected) -> {
            this.allow = isNowSelected;
            if (!isNowSelected.booleanValue()) {
                this.paymentBatch.setAmountDeposited(this.paymentBatch.getAmount());
            }
        });
        this.btnCancel.setOnAction(val -> {
            try {
                parent.dialog.close();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        });
        this.paymentBatch = !parent.isReadOnly ? (parent.selectedPaymentBatch == null ? new PaymentBatch(this.currentUser.getUserName(), this.currentUser.getParentCompany().getStoreCode(), this.da) : parent.selectedPaymentBatch.deepClone()) : parent.selectedPaymentBatch;
        this.paymentBatch.resetNumbering();
        if (this.paymentBatch.getBankName() != null && !this.paymentBatch.getBankName().isEmpty()) {
            if (accts.getOriginalList().isEmpty()) {
                AccountDetail accountDetail = new AccountDetail(this.paymentBatch.getAccountNo(), this.paymentBatch.getBankName(), AccountPaymentType.Cash.name(), true, this.da);
                accts.getOriginalList().add((Object)accountDetail);
            }
            this.cmbBank.getSelectionModel().select((Object)accts.getOriginalList().stream().filter(k -> k.getAccName().equals(this.paymentBatch.getBankName())).findAny().get());
        }
        if (this.paymentBatch.getAmountDeposited() > this.paymentBatch.getAmount()) {
            this.allow = true;
        }
        this.chkAllow.setSelected(this.allow);
        this.tbTeller.textProperty().bindBidirectional((Property)this.paymentBatch.tellerNoProperty());
        this.txArearemark.textProperty().bindBidirectional((Property)this.paymentBatch.remarkProperty());
        this.tbAmtDeposited.textProperty().bindBidirectional((Property)this.paymentBatch.amountDepositedProperty(), this.dConverter);
        this.lblTotalAmt.textProperty().bind((ObservableValue)this.paymentBatch.totalAmountBinding);
        this.table.setItems(this.paymentBatch.getBatchSales());
        this.tbTeller.setDisable(this.paymentBatch.getSyncFlag().booleanValue());
        this.cmbBank.setItems(accts.getOriginalList());
        this.cmbBank.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<AccountDetail>(){

            public void changed(ObservableValue<? extends AccountDetail> observable, AccountDetail oldValue, AccountDetail newValue) {
                PaymentBatchNew.this.paymentBatch.setBankName(newValue.getAccName());
                PaymentBatchNew.this.paymentBatch.setAccountNo(newValue.getAccNumber());
            }
        });
        if (this.paymentBatch.getSyncFlag().booleanValue()) {
            this.vbContainer.getChildren().remove((Object)this.hboxHeader);
            this.btnDone.setVisible(false);
            this.table.getColumns().remove((Object)this.colDel);
            this.btnCancel.setText("Close");
            this.cmbBank.setDisable(true);
            this.tbAmtDeposited.setDisable(true);
            this.txArearemark.setEditable(false);
            this.chkAllow.setDisable(true);
        } else {
            this.vbContainer.getChildren().remove((Object)this.hbTitle);
        }
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colAmount.setCellValueFactory((Callback)new PropertyValueFactory("amount"));
        this.colAmountNotCash.setCellValueFactory((Callback)new PropertyValueFactory("amountNotCash"));
        this.colChannel.setCellValueFactory((Callback)new PropertyValueFactory("salesChannel"));
        this.colInvoiceNo.setCellValueFactory((Callback)new PropertyValueFactory("invoiceNumber"));
        this.colAmount.setCellFactory(col -> new TableCell<BatchSale, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        Callback<TableColumn<BatchSale, String>, TableCell<BatchSale, String>> cellFactoryDel = new Callback<TableColumn<BatchSale, String>, TableCell<BatchSale, String>>(){

            public TableCell call(TableColumn<BatchSale, String> param) {
                TableCell<BatchSale, String> cell = new TableCell<BatchSale, String>(){
                    final JFXButton btn = new JFXButton("Delete");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            final BatchSale req = (BatchSale)this.getTableView().getItems().get(this.getIndex());
                            if (!PaymentBatchNew.this.paymentBatch.getSyncFlag().booleanValue()) {
                                this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                                this.btn.setGraphic((Node)PaymentBatchNew.this.fontAwesome.create((Enum)FontAwesome.Glyph.TRASH).color(Color.WHITE).size(10.0));
                                this.btn.setStyle("-fx-background-color: #FF0000;-fx-font-size: 10px;");
                                this.btn.setVisible(true);
                                this.btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                    public void handle(ActionEvent event) {
                                        PaymentBatchNew.this.delete(req);
                                    }
                                });
                                this.setGraphic((Node)this.btn);
                                this.setAlignment(Pos.CENTER);
                                this.setText(null);
                            } else {
                                this.btn.setVisible(false);
                            }
                        }
                    }
                };
                return cell;
            }
        };
        this.colDel.setCellFactory((Callback)cellFactoryDel);
        this.btnDone.setOnAction(val -> {
            if (this.validate()) {
                if (parent.selectedPaymentBatch == null) {
                    ((PaymentBatchPane)parent).paymentBatchDataList.getOriginalList().add((Object)this.paymentBatch);
                } else {
                    ((PaymentBatchPane)parent).selectedPaymentBatch = this.paymentBatch;
                }
                ((PaymentBatchPane)parent).done(this.paymentBatch);
            } else {
                this.mainPage.showNotification(NotificationType.Error, this.errorMessage, parent);
            }
        });
        this.btnSearch.setOnAction(v -> this.search());
        this.btnClear.setOnAction(v -> {
            this.paymentBatch.getBatchSales().clear();
            this.paymentBatch.resetNumbering();
            this.table.refresh();
        });
        this.tbAmtDeposited.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                Double i = Double.valueOf(newValue);
                if (!(i >= 0.0 && i <= this.paymentBatch.getAmount() || this.allow)) {
                    ((StringProperty)observable).setValue(oldValue);
                }
            }
            catch (Exception e) {
                ((StringProperty)observable).setValue(oldValue);
            }
        });
        this.tbAmtDeposited.addEventFilter(KeyEvent.KEY_TYPED, General.decimal_validation());
    }

    private void search() {
        this.paymentBatch.getBatchSales().clear();
        BatchSaleDataList saleList = BatchSaleDataList.SearchSaleNotBatch("", Date.valueOf((LocalDate)this.fromDate.getValue()), Date.valueOf((LocalDate)this.toDate.getValue()), this.da);
        saleList.getOriginalList().forEach(sale -> {
            sale.setBatchCode(this.paymentBatch.getBatchCode());
            this.paymentBatch.getBatchSales().add(sale);
        });
        this.paymentBatch.resetNumbering();
        this.table.refresh();
    }

    private void delete(BatchSale paymentBatch1) {
        BatchSaleDataList paymentBatchDataList1 = new BatchSaleDataList(this.da);
        paymentBatch1.setState(ObjectState.Removed);
        paymentBatchDataList1.getOriginalList().add((Object)paymentBatch1);
        try {
            paymentBatchDataList1.update();
            this.paymentBatch.getBatchSales().remove((Object)paymentBatch1);
            this.table.refresh();
        }
        catch (Exception ex) {
            this.parent.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this.parent);
        }
        this.paymentBatch.resetNumbering();
    }

    private void viewItems(BatchSale paymentBatch1) {
    }

    boolean validate() {
        this.errorMessage = "";
        if (!this.paymentBatch.getTellerNo().isEmpty() && this.paymentBatch.getBankName().isEmpty()) {
            this.errorMessage = "Please select bank ";
        }
        if (!this.paymentBatch.getTellerNo().isEmpty() && this.paymentBatch.getRemark().isEmpty()) {
            this.errorMessage = this.errorMessage + "\n Please supply remark";
        }
        return this.errorMessage.isEmpty();
    }

    @Override
    public void populateSearch(String SearchValue) {
        BatchSaleDataList saleList = BatchSaleDataList.SearchSaleNotBatch(SearchValue, null, null, this.da);
        if (saleList.getOriginalList().size() == 1) {
            BatchSale found = this.paymentBatch.getBatchSales().stream().filter(c -> c.getInvoiceNumber().equals(((BatchSale)saleList.getOriginalList().get(0)).getInvoiceNumber())).findAny().orElse(null);
            if (found == null) {
                BatchSale batchSale = (BatchSale)saleList.getOriginalList().get(0);
                batchSale.setBatchCode(this.paymentBatch.getBatchCode());
                this.paymentBatch.getBatchSales().add((Object)batchSale);
                this.paymentBatch.resetNumbering();
                this.table.refresh();
            } else {
                this.paymentBatch.getBatchSales().remove((Object)found);
                this.paymentBatch.getBatchSales().add(0, (Object)found);
                this.table.refresh();
                this.table.getSelectionModel().select((Object)found);
            }
        }
    }

    @Override
    public List<SearchClass> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<SearchClass>();
        }
        try {
            return BatchSaleDataList.selectAutoComplete(searchString, this.da);
        }
        catch (SQLException ex) {
            Logger.getLogger(SalesPane.class.getName()).log(Level.SEVERE, null, ex);
            return new ArrayList<SearchClass>();
        }
    }
}

