/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXTextArea;
import com.xputertechnologies.santa.PurchaseItemSerial;
import com.xputertechnologies.santa.PurchaseLineItem;
import com.xputertechnologies.santa.PurchaseOrder;
import com.xputertechnologies.santa.PurchaseType;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.list.ApprovalDataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.ui.CustomEditableTableColumnNumberDouble;
import com.xputertechnologies.santa.ui.CustomEditableTableColumnNumberInteger;
import com.xputertechnologies.santa.ui.CustomEditableTableColumnsPurchaseItemCodeAutocomplete;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.IConfirmDialogParent;
import com.xputertechnologies.santa.ui.IPurchasePane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PurchaseDeliveryNotePane;
import com.xputertechnologies.santa.ui.SalesReturnPaneAudit;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.controlsfx.glyphfont.FontAwesome;

public class PDNCreateEditDialog
extends UIParent
implements IConfirmDialogParent {
    @FXML
    private HBox hbTotal;
    @FXML
    private Label lblTotal;
    @FXML
    private Label lblCurrency;
    @FXML
    private JFXTextArea txAreaComment;
    @FXML
    private TextField tbSerial;
    @FXML
    private JFXListView<PurchaseItemSerial> listSerial;
    @FXML
    private HBox hbox;
    @FXML
    private JFXButton btnPost;
    @FXML
    private JFXButton btnCancel;
    @FXML
    private JFXButton btnSaveCont;
    @FXML
    private JFXButton btnNew;
    @FXML
    private JFXButton btnFillQty;
    @FXML
    private JFXButton btnClearSerial;
    @FXML
    JFXListView<PurchaseOrder> list;
    @FXML
    private TableView<PurchaseLineItem> table;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colItemCode;
    @FXML
    private TableColumn colPrice;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colQty;
    @FXML
    private TableColumn colOpenQty;
    @FXML
    private TableColumn colDel;
    @FXML
    private TableColumn colEdit;
    @FXML
    private TableColumn colTaxamt;
    IPurchasePane parent;
    protected StringConverter<? extends Number> dConverter = new DoubleStringConverter(){

        public String toString(Double object) {
            if (object != null) {
                return General.formatDecimalToMoneyString(object);
            }
            return null;
        }

        public Double fromString(String string) {
            Double d = 0.0;
            if (!string.isEmpty()) {
                string = string.replace(",", "");
                d = Double.parseDouble(string);
            }
            return d;
        }
    };
    @FXML
    private VBox vbScan;
    @FXML
    private HBox hbTableScan;
    JFXDialog dialog;
    PurchaseItemSerial found = null;

    public PDNCreateEditDialog(final IPurchasePane parent, final boolean isEdit) {
        super("PDNCreateEditDialog.fxml", parent.santa);
        this.santa = parent.santa;
        this.title = "Product";
        this.parent = parent;
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        this.colDescription.setEditable(isEdit);
        this.colItemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        this.colItemCode.setEditable(isEdit);
        this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.colOpenQty.setCellValueFactory((Callback)new PropertyValueFactory("openQty"));
        this.colTaxamt.setCellValueFactory((Callback)new PropertyValueFactory("tax"));
        this.btnNew.setVisible(isEdit);
        this.lblTotal.setText("");
        this.lblCurrency.setText("");
        if (isEdit) {
            parent.purchaseOrder.recalculateTotal();
            this.lblTotal.textProperty().bindBidirectional((Property)parent.purchaseOrder.totalProperty(), this.dConverter);
            this.lblCurrency.setText(parent.purchaseOrder.getCurrency());
            this.hbox.getChildren().remove((Object)this.btnSaveCont);
            this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("editQty"));
            this.colPrice.setCellValueFactory((Callback)new PropertyValueFactory("editPrice"));
            ApprovalDataList approvalDataList = new ApprovalDataList(this.da);
            approvalDataList.selectAll(this.da);
            this.txAreaComment.setText(parent.purchaseOrder.remark);
            this.hbox.getChildren().removeAll((Object[])new Node[]{this.btnFillQty});
            this.hbTableScan.getChildren().remove((Object)this.vbScan);
        } else {
            this.hbox.getChildren().removeAll((Object[])new Node[]{this.btnNew});
            this.table.getColumns().remove((Object)this.colEdit);
            this.colQty.setCellValueFactory((Callback)new PropertyValueFactory("qtyChangeable"));
            this.txAreaComment.setVisible(false);
            this.lblTotal.setText(General.formatDecimalToMoneyString(parent.purchaseOrder.getTotalAmount()));
        }
        this.listSerial.setCellFactory((Callback)new Callback<ListView<PurchaseItemSerial>, ListCell<PurchaseItemSerial>>(){

            public ListCell<PurchaseItemSerial> call(ListView<PurchaseItemSerial> param) {
                final Tooltip tooltip = new Tooltip();
                ListCell<PurchaseItemSerial> cell = new ListCell<PurchaseItemSerial>(){

                    public void updateItem(PurchaseItemSerial serial, boolean empty) {
                        super.updateItem((Object)serial, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(null);
                            Label code = new Label();
                            code.setText(serial.getSerial());
                            HBox bLabel = new HBox(new Node[]{code});
                            bLabel.setAlignment(Pos.CENTER_LEFT);
                            HBox hBoxRight = new HBox(10.0);
                            hBoxRight.setMinSize(-1.0, -1.0);
                            hBoxRight.setAlignment(Pos.CENTER);
                            JFXButton del = new JFXButton();
                            del.setButtonType(JFXButton.ButtonType.RAISED);
                            del.setGraphic((Node)PDNCreateEditDialog.this.fontAwesome.create((Enum)FontAwesome.Glyph.TRASH).color(Color.RED).size(15.0));
                            del.setOnAction(v -> {
                                ((PurchaseLineItem)PDNCreateEditDialog.this.table.getSelectionModel().getSelectedItem()).qtyChangeableProperty().set(((PurchaseLineItem)PDNCreateEditDialog.this.table.getSelectionModel().getSelectedItem()).qtyChangeableProperty().get() - 1);
                                PDNCreateEditDialog.this.listSerial.getItems().remove((Object)serial);
                                PDNCreateEditDialog.this.listSerial.refresh();
                            });
                            Pane spacer = new Pane();
                            spacer.setMinSize(10.0, 1.0);
                            HBox root = new HBox();
                            root.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
                            code.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
                            HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
                            hBoxRight.getChildren().addAll((Object[])new Node[]{del});
                            root.getChildren().addAll((Object[])new Node[]{bLabel, spacer, hBoxRight});
                            this.setTooltip(tooltip);
                            this.setGraphic((Node)root);
                        }
                    }
                };
                return cell;
            }
        });
        this.tbSerial.setOnAction(v -> {
            if (this.table.getSelectionModel().getSelectedItem() != null && !this.tbSerial.getText().isEmpty()) {
                PurchaseLineItem purchaseItem = (PurchaseLineItem)this.table.getSelectionModel().getSelectedItem();
                if (purchaseItem.getOpenQty() > purchaseItem.getSerials().size()) {
                    PurchaseItemSerial ser = this.checkIfserialExistInPO();
                    if (ser != null && purchaseItem.getSerials().stream().filter(z -> z.getSerial().equals(this.tbSerial.getText().trim())).count() == 0L) {
                        this.showDialogConfirm();
                    } else if (purchaseItem.getSerials().stream().filter(x -> x.getSerial().equals(this.tbSerial.getText().trim())).count() == 0L) {
                        PurchaseItemSerial serailItem = new PurchaseItemSerial(this.da);
                        serailItem.setItemCode(purchaseItem.getItemCode());
                        serailItem.setParentCode(purchaseItem.getCode());
                        serailItem.setSerial(this.tbSerial.getText().trim());
                        purchaseItem.getSerials().add((Object)serailItem);
                        if (purchaseItem.qtyChangeableProperty().get() < purchaseItem.getQuantity()) {
                            purchaseItem.qtyChangeableProperty().set(purchaseItem.qtyChangeableProperty().get() + 1);
                        }
                        this.tbSerial.clear();
                        this.tbSerial.requestFocus();
                        this.listSerial.refresh();
                    } else if (!this.tbSerial.getText().isEmpty()) {
                        this.tbSerial.clear();
                        this.tbSerial.requestFocus();
                        this.listSerial.getSelectionModel().select((Object)purchaseItem.getSerials().stream().filter(p -> p.getSerial().equals(this.tbSerial.getText().trim())).findAny().get());
                    }
                } else {
                    this.tbSerial.clear();
                    this.tbSerial.requestFocus();
                    this.mainPage.showNotification(NotificationType.Information, "All open quantity scaned", parent);
                }
            } else {
                this.mainPage.showNotification(NotificationType.Error, !this.tbSerial.getText().isEmpty() ? "Please select purchase Item" : "Serial box cannot be empty ", parent);
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PurchaseLineItem>(){

            public void changed(ObservableValue<? extends PurchaseLineItem> observable, PurchaseLineItem oldValue, PurchaseLineItem newValue) {
                if (newValue != null) {
                    PDNCreateEditDialog.this.listSerial.setItems(newValue.getSerials());
                }
            }
        });
        if (parent.purchaseOrder.getPurchaseType().equals(PurchaseType.Service.name())) {
            this.colItemCode.setVisible(false);
            this.colOpenQty.setVisible(false);
            this.colQty.setVisible(false);
        }
        if (this.santa.Products.isEmpty()) {
            try {
                this.santa.Products.addAll(StockItemList.selectAllYuProducts(this.da));
            }
            catch (SQLException ex) {
                Logger.getLogger(SalesReturnPaneAudit.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.disableProperty().bind((ObservableValue)Bindings.select((ObservableValue)row.itemProperty(), (String[])new String[]{"State"}).isEqualTo((Object)ObjectState.Removed));
            return row;
        });
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryViewEdit = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                            this.btn.setGraphic((Node)PDNCreateEditDialog.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(15.0));
                            this.btn.setStyle("-fx-background-color: #4FC4F6;");
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setOnAction(v -> {
                                parent.selectedStock = req;
                                parent.dialog.close();
                                ((PurchaseDeliveryNotePane)parent).showDialogNew();
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colEdit.setCellFactory((Callback)cellFactoryViewEdit);
        Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>> cellFactoryViewDelete = new Callback<TableColumn<PurchaseLineItem, String>, TableCell<PurchaseLineItem, String>>(){

            public TableCell call(TableColumn<PurchaseLineItem, String> param) {
                TableCell<PurchaseLineItem, String> cell = new TableCell<PurchaseLineItem, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.btn.setButtonType(JFXButton.ButtonType.RAISED);
                            this.btn.setGraphic((Node)PDNCreateEditDialog.this.fontAwesome.create((Enum)FontAwesome.Glyph.TIMES).color(Color.RED).size(15.0));
                            PurchaseLineItem req = (PurchaseLineItem)this.getTableView().getItems().get(this.getIndex());
                            if (req.getState().equals(ObjectState.Removed.name())) {
                                this.getTableRow().setDisable(false);
                            }
                            this.btn.setOnAction(event -> {
                                if (req.getLineNumber() == -1) {
                                    parent.purchaseOrder.getItems().remove((Object)req);
                                } else {
                                    req.setState(ObjectState.Removed);
                                    parent.purchaseOrder.recalculateTotal();
                                }
                                PDNCreateEditDialog.this.table.refresh();
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colDel.setCellFactory((Callback)cellFactoryViewDelete);
        Callback priceFactory = param -> new CustomEditableTableColumnNumberDouble(this);
        this.colPrice.setCellFactory(priceFactory);
        Callback qtyFactory = param -> new CustomEditableTableColumnNumberInteger(this);
        this.colQty.setCellFactory(qtyFactory);
        this.colDel.setVisible(isEdit);
        if (isEdit) {
            Callback itemCodeFactory = param -> new CustomEditableTableColumnsPurchaseItemCodeAutocomplete(this.santa.Products);
            this.colItemCode.setCellFactory(itemCodeFactory);
        }
        this.btnClearSerial.setOnAction(v -> {
            if (this.table.getSelectionModel().getSelectedItem() != null) {
                ((PurchaseLineItem)this.table.getSelectionModel().getSelectedItem()).getSerials().clear();
                ((PurchaseLineItem)this.table.getSelectionModel().getSelectedItem()).qtyChangeableProperty().set(0);
                this.table.refresh();
            }
        });
        this.btnNew.setOnAction(v -> {
            parent.dialog.close();
            parent.selectedStock = null;
            ((PurchaseDeliveryNotePane)parent).showDialogNew();
        });
        this.btnFillQty.setOnAction(x -> {
            this.table.getItems().forEach(c -> c.qtyChangeableProperty().set(c.getOpenQty()));
            this.table.refresh();
        });
        parent.purchaseOrder.getItems().forEach(c -> c.qtyChangeableProperty().set(0));
        this.table.setItems(parent.purchaseOrder.getItems());
        this.table.getItems().forEach(x -> x.qtyChangeableProperty().set(x.getQtySaved()));
        this.btnPost.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.EXTERNAL_LINK).color(Color.WHITE).size(15.0));
        this.btnCancel.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.TIMES).color(Color.WHITE).size(15.0));
        this.btnNew.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.PLUS).color(Color.WHITE).size(15.0));
        this.btnSaveCont.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.SAVE).color(Color.WHITE).size(15.0));
        this.btnSaveCont.setOnAction(x -> ((PurchaseDeliveryNotePane)parent).savePOlocally(parent.purchaseOrder));
        this.btnPost.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.dialog.close();
                if (isEdit) {
                    parent.purchaseOrder.remark = PDNCreateEditDialog.this.txAreaComment.getText();
                    ((PurchaseDeliveryNotePane)parent).editPo();
                } else {
                    ((PurchaseDeliveryNotePane)parent).post();
                }
            }
        });
        this.btnCancel.setOnAction(c -> parent.dialog.close());
    }

    PurchaseItemSerial checkIfserialExistInPO() {
        this.found = null;
        this.parent.purchaseOrder.getItems().forEach(z -> z.getSerials().forEach(c -> {
            if (c.getSerial().equals(this.tbSerial.getText().trim())) {
                this.found = c;
            }
        }));
        return this.found;
    }

    public void showDialogConfirm() {
    }

    @Override
    public void okConfirmDialog() {
        this.dialog.close();
        PurchaseLineItem purchaseItem = (PurchaseLineItem)this.table.getSelectionModel().getSelectedItem();
        if (purchaseItem.getSerials().stream().filter(x -> x.getSerial().equals(this.tbSerial.getText().trim())).count() == 0L) {
            PurchaseItemSerial serailItem = new PurchaseItemSerial(this.da);
            serailItem.setItemCode(purchaseItem.getItemCode());
            serailItem.setParentCode(purchaseItem.getCode());
            serailItem.setSerial(this.tbSerial.getText().trim());
            purchaseItem.getSerials().add((Object)serailItem);
            if (purchaseItem.qtyChangeableProperty().get() < purchaseItem.getQuantity()) {
                purchaseItem.qtyChangeableProperty().set(purchaseItem.qtyChangeableProperty().get() + 1);
            }
            this.tbSerial.clear();
            this.tbSerial.requestFocus();
            this.listSerial.refresh();
        }
    }

    @Override
    public void noConfirmDialog() {
        this.dialog.close();
        this.tbSerial.clear();
        this.tbSerial.requestFocus();
    }
}

