/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXPasswordField;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.User;
import com.xputertechnologies.santa.UserType;
import com.xputertechnologies.santa.list.CompanyDataList;
import com.xputertechnologies.santa.ui.MainPage;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.TempRoleManagement;
import com.xputertechnologies.santa.ui.UIParent;
import java.net.URISyntaxException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import org.controlsfx.glyphfont.FontAwesome;

public class LoginPane
extends UIParent {
    int number_of_trials;
    public VBox anchorPane;
    @FXML
    private DatePicker dp;
    @FXML
    private ImageView logo;
    @FXML
    JFXTextField usernametxt;
    @FXML
    private JFXPasswordField passwordtxt;
    @FXML
    JFXButton loginbutton;
    @FXML
    private HBox hblbErrDatePicker;
    @FXML
    private HBox hbBusinessClose;
    @FXML
    private Label lblerror;
    User currUser;
    int b;

    public LoginPane(Santa santa, String passed) throws Exception {
        super("LoginPane.fxml", santa);
        this.loginbutton.setDefaultButton(true);
        this.logo.setImage(new Image("/com/xputertechnologies/santa/ui/Images/kongapink.png"));
        this.loginbutton.setGraphic((Node)this.fontAwesome.create((Enum)FontAwesome.Glyph.SIGN_IN).color(Color.WHITE));
        this.loginbutton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    LoginPane.this.login();
                    if (LoginPane.this.currUser != null && (LoginPane.this.currUser.getRoleDescription().equals(UserType.StockManager.name()) || LoginPane.this.currUser.getRoleDescription().equals(UserType.SalesPerson.name()) || LoginPane.this.currUser.getRoleDescription().equals(UserType.SalesManager.name()))) {
                        LoginPane.this.checkDateDifferences();
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(LoginPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    public void checkDateDifferences() {
        if (this.b < 0) {
            final Dialog dialog = new Dialog();
            ObservableList obl = FXCollections.observableArrayList();
            long interval = 86400000L;
            long endTime = new java.util.Date().getTime();
            for (long curTime = Timestamp.valueOf(this.currUser.getParentCompany().getCurrentDay().atStartOfDay()).getTime(); curTime <= endTime; curTime += interval) {
                obl.add((Object)new SimpleDateFormat("dd-MMM-yyyy").format(new Date(curTime)));
            }
            final TableView table = new TableView();
            table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
            TableColumn dateCol = new TableColumn("Date");
            dateCol.setCellValueFactory((Callback)new PropertyValueFactory("DUMMY"));
            table.getColumns().addAll(new Object[]{dateCol});
            Callback<TableColumn<String, String>, TableCell<String, String>> cellFactoryView = new Callback<TableColumn<String, String>, TableCell<String, String>>(){

                public TableCell call(TableColumn<String, String> param) {
                    TableCell<String, String> cell = new TableCell<String, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            if (empty) {
                                this.setGraphic(null);
                                this.setText(null);
                            } else {
                                final String value = (String)this.getTableView().getItems().get(this.getIndex());
                                Button btn = new Button(value);
                                btn.setTooltip(new Tooltip("Click to close business for " + value));
                                if (this.getIndex() > 0) {
                                    btn.setDisable(true);
                                }
                                btn.setOnAction(event -> {
                                    table.getItems().removeIf(new Predicate(){

                                        public boolean test(Object t) {
                                            if (t.toString().equals(value)) {
                                                try {
                                                    Calendar c = Calendar.getInstance();
                                                    c.setTime(new SimpleDateFormat("dd-MMM-yyyy").parse(t.toString()));
                                                    c.add(5, 1);
                                                    if (c.getTime().compareTo(new java.util.Date()) <= 0) {
                                                        LoginPane.this.currUser.getParentCompany().setCurrentDay(new Date(c.getTime().getTime()).toLocalDate());
                                                        CompanyDataList companyDataList = new CompanyDataList(LoginPane.this.da);
                                                        LoginPane.this.currUser.getParentCompany().setCloseOfBusiness(false);
                                                        companyDataList.getOriginalList().add((Object)LoginPane.this.currUser.getParentCompany());
                                                        companyDataList.update();
                                                    }
                                                }
                                                catch (ParseException ex) {
                                                    Logger.getLogger(LoginPane.class.getName()).log(Level.SEVERE, null, ex);
                                                }
                                                catch (Exception ex) {
                                                    Logger.getLogger(LoginPane.class.getName()).log(Level.SEVERE, null, ex);
                                                }
                                            }
                                            return t.toString().equals(value);
                                        }
                                    });
                                    table.refresh();
                                    if (table.getItems().size() == 0) {
                                        dialog.close();
                                        LoginPane.this.enterNow();
                                    }
                                });
                                this.setGraphic((Node)btn);
                                this.setAlignment(Pos.CENTER);
                                this.setText(null);
                            }
                        }
                    };
                    return cell;
                }
            };
            dateCol.setCellFactory((Callback)cellFactoryView);
            table.setItems(obl);
            dialog.initStyle(StageStyle.UTILITY);
            dialog.initOwner((Window)this.santa.stage);
            dialog.setTitle("Close Of Business Days");
            dialog.setResizable(true);
            dialog.getDialogPane().setContent((Node)table);
            ButtonType ok = new ButtonType("Close", ButtonBar.ButtonData.FINISH);
            dialog.getDialogPane().setStyle("   -fx-background-repeat: repeat;    -fx-background-color: #394264;    -fx-padding: 8px 8px 16px 8px;");
            dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ok});
            Optional result = dialog.showAndWait();
            this.enterNow();
        } else if (this.b > 0) {
            this.lblerror.setText("Application Date(" + new SimpleDateFormat("dd-MMM-yyyy").format(new Date(Timestamp.valueOf(this.currUser.getParentCompany().getCurrentDay().atStartOfDay()).getTime())) + ") must not  greater than System date,Please contact Admin.");
            this.lblerror.setVisible(true);
            this.loginbutton.setDisable(true);
        } else {
            this.enterNow();
        }
    }

    public void enterNow() {
        try {
            this.santa.currentUser = this.currUser;
            MainPage mp = new MainPage(this.santa);
            mp.btnBusinessDate.setText("Business Date: " + new SimpleDateFormat("d-MMM-yyyy").format(Date.valueOf(this.santa.currentUser.getParentCompany().getCurrentDay())));
            this.santa.showScene(mp);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(LoginPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void checkIfBusinessday() {
    }

    public void login() throws SQLException, URISyntaxException {
        this.currUser = User.validateUser(this.usernametxt.getText(), this.passwordtxt.getText(), this.santa.da);
        if (this.currUser != null) {
            this.b = this.currUser.getParentCompany().getCurrentDay().compareTo(LocalDate.now());
            this.lblerror.setVisible(false);
            if (TempRoleManagement.canRoleOverBusinessDay(UserType.valueOf(this.currUser.getRoleDescription()))) {
                this.currUser.getParentCompany().setCurrentDay(new java.util.Date().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                this.currUser.getParentCompany().setCloseOfBusiness(false);
                CompanyDataList cdl = new CompanyDataList(this.da);
                this.currUser.getParentCompany().setCloseOfBusiness(false);
                cdl.getOriginalList().add((Object)this.currUser.getParentCompany());
                try {
                    cdl.update();
                }
                catch (Exception ex) {
                    Logger.getLogger(LoginPane.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.enterNow();
            } else if (this.currUser.getRoleDescription().equals(UserType.Administrator.name())) {
                if (this.b < 0 || this.b > 0) {
                    this.lblerror.setText("Application date less or greater than system date");
                    this.lblerror.setVisible(true);
                    this.dp.setVisible(true);
                    this.dp.setValue((Object)((LocalDate)this.currUser.getParentCompany().currentDayProperty().get()));
                    this.dp.setOnAction(event -> {
                        try {
                            this.currUser.getParentCompany().setCurrentDay((LocalDate)this.dp.getValue());
                            this.currUser.getParentCompany().setCloseOfBusiness(false);
                            CompanyDataList cdl = new CompanyDataList(this.da);
                            this.currUser.getParentCompany().setCloseOfBusiness(false);
                            cdl.getOriginalList().add((Object)this.currUser.getParentCompany());
                            cdl.update();
                            this.enterNow();
                        }
                        catch (Exception ex1) {
                            Logger.getLogger(LoginPane.class.getName()).log(Level.SEVERE, null, ex1);
                        }
                    });
                } else {
                    this.enterNow();
                }
            }
        } else {
            ++this.number_of_trials;
            this.lblerror.setText("Username or Password does not match," + this.number_of_trials + " attempt(s)");
            this.lblerror.setVisible(true);
            if (this.number_of_trials == 4) {
                this.loginbutton.setDisable(true);
            }
        }
    }
}

