/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.effects.JFXDepthManager;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public abstract class JFXNotificationBar
extends Region {
    private static final double MIN_HEIGHT = 40.0;
    private final ScrollPane pane;
    private final HBox paneGeneral;
    private final VBox paneImage;
    private final HBox paneBody;
    private static final EventType<Event> ON_SHOWING = new EventType(Event.ANY, "NOTIFICATION_PANE_ON_SHOWING");
    private static final EventType<Event> ON_SHOWN = new EventType(Event.ANY, "NOTIFICATION_PANE_ON_SHOWN");
    private static final EventType<Event> ON_HIDING = new EventType(Event.ANY, "NOTIFICATION_PANE_ON_HIDING");
    private static final EventType<Event> ON_HIDDEN = new EventType(Event.ANY, "NOTIFICATION_PANE_ON_HIDDEN");
    public DoubleProperty transition = new SimpleDoubleProperty(){

        protected void invalidated() {
            JFXNotificationBar.this.requestContainerLayout();
        }
    };
    private final Duration TRANSITION_DURATION = new Duration(350.0);
    private Timeline timeline;
    private double transitionStartValue;

    public void requestContainerLayout() {
        this.layoutChildren();
    }

    public String getTitle() {
        return "";
    }

    public boolean isCloseButtonVisible() {
        return true;
    }

    public abstract String getText();

    public abstract String getTypeNotification();

    public abstract Node getGraphic();

    public abstract void hide();

    public abstract boolean isShowing();

    public abstract boolean isShowFromTop();

    public abstract double getContainerHeight();

    public abstract void relocateInParent(double var1, double var3);

    public JFXNotificationBar() {
        String mesaggeStr;
        this.getStyleClass().add((Object)"notification-bar");
        this.setVisible(this.isShowing());
        this.pane = new ScrollPane();
        this.pane.setFitToWidth(true);
        this.pane.setFitToHeight(true);
        this.pane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.pane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.pane.getStyleClass().add((Object)"pane");
        this.getChildren().setAll((Object[])new Node[]{this.pane});
        this.paneGeneral = new HBox();
        this.paneImage = new VBox();
        this.paneImage.setAlignment(Pos.CENTER);
        ImageView imageView = (ImageView)this.getGraphic();
        imageView.setFitHeight(45.0);
        imageView.setFitWidth(45.0);
        JFXDepthManager.setDepth((Node)imageView, (int)2);
        this.paneImage.getChildren().add((Object)imageView);
        this.paneImage.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        this.paneBody = new HBox();
        HBox.setHgrow((Node)this.paneBody, (Priority)Priority.ALWAYS);
        VBox paneText = new VBox();
        paneText.setMinHeight(50.0);
        paneText.setPrefWidth(300.0);
        paneText.setSpacing(10.0);
        HBox.setHgrow((Node)paneText, (Priority)Priority.ALWAYS);
        String titleStr = this.getTitle();
        if (titleStr != null && !titleStr.isEmpty()) {
            Label title = new Label(this.getTitle());
            title.getStyleClass().add((Object)"title");
            title.setWrapText(true);
            paneText.getChildren().add((Object)title);
        }
        if ((mesaggeStr = this.getText()) != null && !mesaggeStr.isEmpty()) {
            Label message = new Label(this.getText());
            message.getStyleClass().add((Object)"message");
            message.setWrapText(true);
            paneText.getChildren().add((Object)message);
        }
        VBox paneButtonClose = new VBox();
        JFXButton closeBtn = new JFXButton();
        closeBtn.setTextFill((Paint)Color.WHITE);
        closeBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                JFXNotificationBar.this.hide();
            }
        });
        closeBtn.requestFocus();
        closeBtn.requestLayout();
        closeBtn.getStyleClass().setAll((Object[])new String[]{"close-button"});
        StackPane graphic = new StackPane();
        graphic.getStyleClass().setAll((Object[])new String[]{"graphic"});
        closeBtn.setGraphic((Node)graphic);
        closeBtn.setRipplerFill((Paint)Color.WHITE);
        closeBtn.setStyle("-fx-background-radius: 20");
        closeBtn.setMinSize(20.0, 20.0);
        closeBtn.setPrefSize(20.0, 20.0);
        paneButtonClose.getChildren().add((Object)closeBtn);
        this.paneBody.getChildren().add((Object)paneText);
        this.paneBody.getChildren().add((Object)paneButtonClose);
        this.paneBody.setPadding(new Insets(10.0));
        switch (this.getTypeNotification()) {
            case "SUCCESS": {
                this.paneImage.setStyle("-fx-background-color: #78A840;");
                this.paneBody.setStyle("-fx-background-color: #8BC34A;");
                break;
            }
            case "MESSAGE": {
                this.paneImage.setStyle("-fx-background-color: #0392D3;");
                this.paneBody.setStyle("-fx-background-color: #03A9F4;");
                break;
            }
            case "ERROR": {
                this.paneImage.setStyle("-fx-background-color: #D33A2F;");
                this.paneBody.setStyle("-fx-background-color: #F44336;");
                break;
            }
            case "WARNING": {
                this.paneImage.setStyle("-fx-background-color: #FFC107;");
                this.paneBody.setStyle("-fx-background-color: #DCA706;");
                break;
            }
            case "INFO": {
                this.paneImage.setStyle("-fx-background-color: #168AC5;");
                this.paneBody.setStyle("-fx-background-color: #19AAF3;");
            }
        }
        this.updatePane();
    }

    private void updatePane() {
        this.paneGeneral.getChildren().clear();
        this.paneGeneral.getChildren().add((Object)this.paneImage);
        this.paneGeneral.getChildren().add((Object)this.paneBody);
        this.pane.setContent((Node)this.paneGeneral);
    }

    protected void layoutChildren() {
        double w = this.getWidth();
        double h = this.computePrefHeight(-1.0);
        double notificationBarHeight = this.prefHeight(w);
        double notificationMinHeight = this.minHeight(w);
        if (this.isShowFromTop()) {
            this.pane.resize(w, h);
            this.relocateInParent(0.0, (this.transition.get() - 1.0) * notificationMinHeight);
        } else {
            this.pane.resize(w, notificationBarHeight);
            this.relocateInParent(0.0, this.getContainerHeight() - notificationBarHeight);
        }
    }

    protected double computeMinHeight(double width) {
        return Math.max(super.computePrefHeight(width), 40.0);
    }

    protected double computePrefHeight(double width) {
        return Math.max(this.pane.prefHeight(width), this.minHeight(width)) * this.transition.get();
    }

    public void doShow() {
        this.transitionStartValue = 0.0;
        this.doAnimationTransition();
    }

    public void doHide() {
        this.transitionStartValue = 1.0;
        this.doAnimationTransition();
    }

    private void doAnimationTransition() {
        KeyFrame k2;
        KeyFrame k1;
        Duration duration;
        if (this.timeline != null && this.timeline.getStatus() != Animation.Status.STOPPED) {
            duration = this.timeline.getCurrentTime();
            duration = duration == Duration.ZERO ? this.TRANSITION_DURATION : duration;
            this.transitionStartValue = this.transition.get();
            this.timeline.stop();
        } else {
            duration = this.TRANSITION_DURATION;
        }
        this.timeline = new Timeline();
        this.timeline.setCycleCount(1);
        if (this.isShowing()) {
            k1 = new KeyFrame(Duration.ZERO, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    JFXNotificationBar.this.setCache(true);
                    JFXNotificationBar.this.setVisible(true);
                    JFXNotificationBar.this.pane.fireEvent(new Event(ON_SHOWING));
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)this.transitionStartValue)});
            k2 = new KeyFrame(duration, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    JFXNotificationBar.this.pane.setCache(false);
                    JFXNotificationBar.this.pane.fireEvent(new Event(ON_SHOWN));
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)1, Interpolator.EASE_OUT)});
        } else {
            k1 = new KeyFrame(Duration.ZERO, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    JFXNotificationBar.this.pane.setCache(true);
                    JFXNotificationBar.this.pane.fireEvent(new Event(ON_HIDING));
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)this.transitionStartValue)});
            k2 = new KeyFrame(duration, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    JFXNotificationBar.this.setCache(false);
                    JFXNotificationBar.this.setVisible(false);
                    JFXNotificationBar.this.pane.fireEvent(new Event(ON_HIDDEN));
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)0, Interpolator.EASE_IN)});
        }
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{k1, k2});
        this.timeline.play();
    }
}

