/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.Income;
import com.xputertechnologies.santa.core.ObjectState;
import com.xputertechnologies.santa.ui.IncomeContainer;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import com.xputertechnologies.santa.ui.UnitPane;
import java.sql.Date;
import java.time.LocalDate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;

public class IncomePane
extends UIParent {
    @FXML
    private Button addNewUnitbut;
    @FXML
    private DatePicker dpFrom;
    @FXML
    private DatePicker dpTo;
    @FXML
    private Button btnSearch;
    @FXML
    private Button donebut;
    @FXML
    public VBox expenseVbrep;
    @FXML
    private Label lblTotal;
    com.xputertechnologies.santa.ui.Income cu;
    Income income = null;

    public IncomePane(Santa app) throws Exception {
        super("IncomePane.fxml", app);
        this.title = "Income Page";
        this.dpFrom.setValue((Object)LocalDate.now());
        this.dpTo.setValue((Object)LocalDate.now());
        this.income = new Income(this.da);
        this.addNewUnitbut.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    IncomePane.this.createUnit();
                }
                catch (Exception ex) {
                    Logger.getLogger(UnitPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.donebut.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                IncomePane.this.done();
            }
        });
        this.btnSearch.setOnAction(event -> this.search());
        this.lblTotal.textProperty().bind((ObservableValue)this.income.totalAmountBinding);
    }

    private void search() {
        Income inc = new Income(this.da);
        this.income.getIncomeItemsList().getOriginalList().clear();
        this.income.getIncomeItemsList().getOriginalList().addAll(inc.search(Date.valueOf((LocalDate)this.dpFrom.getValue()), Date.valueOf((LocalDate)this.dpTo.getValue()), this.da));
        this.expenseVbrep.getChildren().clear();
        for (Income unit : this.income.getIncomeItemsList().getOriginalList()) {
            this.expenseVbrep.getChildren().add((Object)new IncomeContainer(unit, this, this.santa));
        }
    }

    public void createUnit() throws Exception {
        Income income = new Income(this.da);
        income.setParentCompany(this.mainPage.currentUser.getParentCompany());
        income.dateProperty().set((Object)Date.valueOf(this.mainPage.currentUser.getParentCompany().getCurrentDay()));
        income.setParentUser(this.mainPage.currentUser);
        this.cu = new com.xputertechnologies.santa.ui.Income(this, income, false);
        this.mainPage.hbCenter.setContent((Node)this.cu);
        this.mainPage.hbBottom.setVisible(true);
    }

    private void done() {
        if (this.validateControl() && this.needToSave) {
            try {
                this.income.getIncomeItemsList().update();
                this.mainPage.showNotification(NotificationType.Success, "Operation Successful", this);
            }
            catch (Exception ex) {
                this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
            }
        }
    }

    @Override
    void closeNotification() {
        this.mainPage.closeNotification();
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        this.needToSave = false;
        for (Income sa : this.income.getIncomeItemsList().getOriginalList()) {
            if (sa.getState() != ObjectState.Changed && sa.getState() != ObjectState.New) continue;
            this.needToSave = true;
            break;
        }
        return true;
    }

    @Override
    void yes() {
        try {
            this.done();
            this.mainPage.isToMenu = true;
            this.closeNotification();
            this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
            this.mainPage.hbBottom.setVisible(false);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
    }

    @Override
    void no() {
        this.mainPage.isToMenu = true;
        this.closeNotification();
        this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
        this.mainPage.hbBottom.setVisible(false);
    }

    @Override
    void completeControl() {
        this.mainPage.isToMenu = false;
        this.mainPage.showNotification(NotificationType.Warning, "Do you want to save change(s)", this);
    }
}

