/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.IncomeContainer;
import com.xputertechnologies.santa.ui.IncomePane;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.Connection;
import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.dbunit.database.DatabaseConnection;

public class Income
extends UIParent {
    public static DataAccess da;
    private static Connection con;
    private static DatabaseConnection dc;
    @FXML
    private Button cancelbutton;
    @FXML
    private Button btnAddNew;
    @FXML
    private TextField desTxt;
    @FXML
    private TextField amtTxt;
    private IncomePane incomePane;
    private com.xputertechnologies.santa.Income income = null;
    StringConverter<? extends Number> dconverter = new DoubleStringConverter();

    public Income(IncomePane incomePane, com.xputertechnologies.santa.Income income, boolean launch) throws Exception {
        super("Income.fxml", incomePane.santa);
        this.incomePane = incomePane;
        this.mainParent = incomePane;
        this.income = income;
        this.hasParent = true;
        this.desTxt.textProperty().bindBidirectional((Property)income.descriptionProperty());
        this.amtTxt.textProperty().bindBidirectional((Property)income.amountProperty(), this.dconverter);
        this.cancelbutton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Income.this.cancel();
            }
        });
        this.btnAddNew.setOnAction(event -> this.addNewIncome());
        if (launch) {
            incomePane.mainPage.hbCenter.setContent((Node)this);
            incomePane.mainPage.hbBottom.setVisible(true);
        }
        this.amtTxt.addEventFilter(KeyEvent.KEY_TYPED, General.vaalidateTextBoxInput());
        this.amtTxt.addEventFilter(KeyEvent.KEY_TYPED, General.numeric_Validation(10));
    }

    private void addNewIncome() {
        if (this.validateControl() && this.needToSave && !this.income.isEdit) {
            this.income.isEdit = true;
            this.incomePane.income.getIncomeItemsList().getOriginalList().add((Object)this.income);
            this.incomePane.expenseVbrep.getChildren().add((Object)new IncomeContainer(this.income, this.incomePane, this.santa));
            try {
                this.incomePane.createUnit();
            }
            catch (Exception ex) {
                this.incomePane.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this.incomePane);
            }
        } else {
            this.incomePane.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
        }
    }

    private void done() {
        if (this.validateControl() && this.needToSave && !this.income.isEdit) {
            this.income.isEdit = true;
            this.incomePane.income.getIncomeItemsList().getOriginalList().add((Object)this.income);
            this.incomePane.expenseVbrep.getChildren().add((Object)new IncomeContainer(this.income, this.incomePane, this.santa));
        } else {
            this.incomePane.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
        }
    }

    private void cancel() {
        this.incomePane.mainPage.hbCenter.setContent((Node)this.mainParent);
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        this.needToSave = false;
        if (this.desTxt.getText() != null && !this.desTxt.getText().trim().isEmpty() && Double.valueOf(this.amtTxt.getText()) > 0.0) {
            this.needToSave = true;
        }
        if (this.desTxt.getText() == null || this.desTxt.getText().trim().isEmpty()) {
            this.errorMessage = this.errorMessage + "Income description must not be empty\n";
        }
        if (Double.valueOf(this.amtTxt.getText()) == 0.0 || Double.valueOf(this.amtTxt.getText()) < 0.0) {
            this.errorMessage = this.errorMessage + "Income amount must not be zero";
        }
        return this.errorMessage.equals("");
    }

    @Override
    void completeControl() {
        this.done();
    }
}

