/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.Customer;
import com.xputertechnologies.santa.CustomerPayment;
import com.xputertechnologies.santa.Sale;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.list.CustomerDataList;
import com.xputertechnologies.santa.list.CustomerPaymentDataList;
import com.xputertechnologies.santa.list.IncomeDataList;
import com.xputertechnologies.santa.list.SaleList;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import java.sql.Connection;
import java.sql.Date;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.dataset.IDataSet;

public class CustomerPaymentPane
extends UIParent {
    private static Connection con;
    private static IDataSet dataSet;
    private static DatabaseConnection dc;
    public Customer customer;
    public SaleList saleList;
    public CustomerPaymentDataList custPytList;
    public IncomeDataList incomeList;
    @FXML
    public VBox CustomervbRepeatingControl;
    @FXML
    HBox pBox;
    @FXML
    public TextField amountTxtfield;
    @FXML
    public TableColumn<Sale, Double> balanceCol;
    @FXML
    public TextField balancetxtfield;
    @FXML
    public TableColumn<Sale, String> commentNoColumn;
    @FXML
    public Button collectButton;
    @FXML
    public TableColumn<Sale, Date> date;
    @FXML
    public TableView<Sale> debtTable;
    @FXML
    public TableView<CustomerPayment> table2;
    @FXML
    public Button loadDebtorButton;
    @FXML
    public Button searchButton;
    @FXML
    public TextField searchTxtfield;
    @FXML
    private TableColumn<CustomerPayment, String> staffCol;
    @FXML
    private Tab paymentTab;
    @FXML
    private Tab salesTab;
    @FXML
    private TableColumn<CustomerPayment, Integer> invoiceNoColumn;
    @FXML
    private TableColumn<CustomerPayment, Date> date2;
    @FXML
    private TableColumn<CustomerPayment, Double> AmountCol;
    private ArrayList<ParameterValue> tempParamValue = new ArrayList();
    public CustomerPaymentDataList paymentList;

    public CustomerPaymentPane(Santa app) throws Exception {
        super("CustomerPaymentPane.fxml", app);
        this.title = "Customer Payment Page";
        this.commentNoColumn.setCellValueFactory((Callback)new PropertyValueFactory("comment"));
        this.date.setCellValueFactory((Callback)new PropertyValueFactory("newDate"));
        this.balanceCol.setCellValueFactory((Callback)new PropertyValueFactory("balance"));
        this.staffCol.setCellValueFactory((Callback)new PropertyValueFactory("receivingStaff"));
        this.invoiceNoColumn.setCellValueFactory((Callback)new PropertyValueFactory("invoiceNumber"));
        this.date2.setCellValueFactory((Callback)new PropertyValueFactory("date"));
        this.AmountCol.setCellValueFactory((Callback)new PropertyValueFactory("amountPaid"));
        this.collectButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CustomerPaymentPane.this.collectBalance();
            }
        });
        this.salesTab.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                CustomerPaymentPane.this.salesInit();
            }
        });
        this.paymentTab.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                CustomerPaymentPane.this.paymentInit();
                CustomerPaymentPane.this.refreshPaymentHistory();
            }
        });
        this.searchButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    CustomerPaymentPane.this.search();
                }
                catch (Exception ex) {
                    Logger.getLogger(CustomerPaymentPane.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        this.loadDebtorButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CustomerPaymentPane.this.customer = null;
                CustomerPaymentPane.this.saleList = null;
                CustomerPaymentPane.this.loadDebtors();
            }
        });
        this.amountTxtfield.addEventFilter(KeyEvent.KEY_TYPED, General.vaalidateTextBoxInput());
        this.amountTxtfield.addEventFilter(KeyEvent.KEY_TYPED, General.numeric_Validation(10));
    }

    private void collectBalance() {
        if (this.validateControl() && this.needToSave) {
            try {
                this.balancetxtfield.setText(String.valueOf(this.customer.collectBalance(this.saleList, this.mainPage.currentUser, Float.valueOf(this.amountTxtfield.getText()).floatValue())));
                this.amountTxtfield.setText("0.0");
                this.saleList.getOriginalList().removeIf((Predicate)new Predicate<Sale>(){

                    @Override
                    public boolean test(Sale t) {
                        return t.balanceProperty().get() == 0.0;
                    }
                });
                this.debtTable.setItems(this.saleList.getOriginalList());
                this.mainPage.showNotification(NotificationType.Information, "Operation Successful", this);
            }
            catch (Exception e) {
                this.mainPage.showNotification(NotificationType.Error, e.getMessage(), this);
            }
        }
    }

    private void refreshPaymentHistory() {
        this.paymentList = new CustomerPaymentDataList(this.da);
        this.paymentList = CustomerPayment.Search(this.customer.getName(), this.da);
        this.table2.setItems(this.paymentList.getOriginalList());
    }

    private void search() throws Exception {
        this.customer = null;
        this.saleList = null;
        this.tempParamValue.clear();
        this.CustomervbRepeatingControl.getChildren().clear();
        this.debtTable.getItems().clear();
        this.table2.getItems().clear();
        this.balancetxtfield.setText("0.0");
        this.amountTxtfield.setText("0.0");
        CustomerDataList customerDataList = Customer.SearchCustomers(this.searchTxtfield.getText(), this.da);
        for (Customer cust : customerDataList.getOriginalList()) {
            com.xputertechnologies.santa.ui.CustomerPayment cu = new com.xputertechnologies.santa.ui.CustomerPayment(cust, this);
            this.CustomervbRepeatingControl.getChildren().addAll((Object[])new Node[]{cu});
        }
    }

    private void salesInit() {
        this.amountTxtfield.setVisible(true);
        this.balancetxtfield.setVisible(true);
        this.collectButton.setVisible(true);
        this.pBox.setVisible(true);
    }

    private void paymentInit() {
        this.amountTxtfield.setVisible(false);
        this.balancetxtfield.setVisible(false);
        this.collectButton.setVisible(false);
        this.pBox.setVisible(false);
    }

    private void loadDebtors() {
        this.debtTable.getItems().clear();
        this.table2.getItems().clear();
        this.CustomervbRepeatingControl.getChildren().clear();
        this.debtTable.getItems().clear();
        this.balancetxtfield.setText("0.0");
        this.amountTxtfield.setText("0.0");
        CustomerDataList customerDataList = Customer.LoadDebtors(this.da);
        for (Customer customer : customerDataList.getOriginalList()) {
            try {
                com.xputertechnologies.santa.ui.CustomerPayment cu = new com.xputertechnologies.santa.ui.CustomerPayment(customer, this);
                this.CustomervbRepeatingControl.getChildren().add((Object)cu);
            }
            catch (Exception ex) {
                Logger.getLogger(CustomerPaymentPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    void yes() {
        try {
            this.collectBalance();
            this.mainPage.isToMenu = true;
            this.closeNotification();
            this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
            this.mainPage.hbBottom.setVisible(false);
        }
        catch (Exception ex) {
            this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), this);
        }
    }

    @Override
    void no() {
        this.mainPage.isToMenu = true;
        this.closeNotification();
        this.mainPage.hbCenter.setContent((Node)this.mainPage.menuControl);
        this.mainPage.hbBottom.setVisible(false);
    }

    @Override
    void closeNotification() {
        this.mainPage.closeNotification();
    }

    @Override
    void completeControl() {
        this.mainPage.isToMenu = false;
        this.mainPage.showNotification(NotificationType.Warning, "Do you want to collect customer payment for the selected sale", this);
    }

    @Override
    boolean validateControl() {
        this.errorMessage = "";
        this.needToSave = false;
        if (this.CustomervbRepeatingControl.getChildren().size() > 0 && !this.balancetxtfield.getText().equals("0.0") && Double.valueOf(this.amountTxtfield.getText()) != 0.0) {
            this.needToSave = true;
        }
        if (this.needToSave) {
            if (this.saleList.getOriginalList().size() == 0) {
                this.errorMessage = this.errorMessage + "No item to collect \n";
            }
            if (Double.valueOf(this.amountTxtfield.getText()) == 0.0 || Double.valueOf(this.amountTxtfield.getText()) < 0.0) {
                this.errorMessage = this.errorMessage + "Please specify amount recieved from the customer";
            }
            if (!this.errorMessage.equals("")) {
                this.mainPage.showNotification(NotificationType.Error, this.errorMessage, this);
                return false;
            }
        }
        return true;
    }
}

