/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.SaleItem;
import com.xputertechnologies.santa.Store;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;

public class CustomEditableTableColumnsSaleItemStorenameAutocomplete<T extends DbEntity>
extends TableCell<T, String> {
    private TextField textField;
    List<Store> source;
    String storeCode;

    CustomEditableTableColumnsSaleItemStorenameAutocomplete(List<Store> source, String storeCode) {
        this.source = source.stream().filter(p -> p.getCode().equals(storeCode) || p.getCode().equals("02") || p.getCode().equals("07")).collect(Collectors.toList());
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.textField);
            this.textField.selectAll();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText((String)this.getItem());
        this.setGraphic(null);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(item);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getString());
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(this.getString());
            this.setGraphic(null);
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.setOnAction(e -> this.commitEdit(this.textField.getText()));
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.textField, t -> {
            List<Store> result = this.searchData(t.getUserText());
            return result.size() > 30 ? result.subList(0, 29) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<Store>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<Store> event) {
                CustomEditableTableColumnsSaleItemStorenameAutocomplete.this.textField.setText(((Store)event.getCompletion()).getName());
                SaleItem req = (SaleItem)CustomEditableTableColumnsSaleItemStorenameAutocomplete.this.getTableView().getItems().get(CustomEditableTableColumnsSaleItemStorenameAutocomplete.this.getIndex());
                req.setStoreCode(((Store)event.getCompletion()).getCode());
                req.setStoreName(((Store)event.getCompletion()).getName());
            }
        });
        this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                System.out.println("Commiting " + this.textField.getText());
                this.commitEdit(this.textField.getText());
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : (String)this.getItem();
    }

    public List<Store> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<Store>();
        }
        List result = this.source.stream().filter(e -> e.getName().toLowerCase().contains(searchString.toLowerCase())).collect(Collectors.toList());
        LinkedList searchResult = new LinkedList();
        searchResult.addAll(result.isEmpty() && result.size() > 0 ? this.source : result);
        return searchResult.subList(0, searchResult.size());
    }
}

