/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.Account;
import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.SaleAccountDetailResolver;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;

public class CustomEditableTableColumnsAutocomplete<T extends DbEntity>
extends TableCell<T, String> {
    private TextField textField;
    List<Account> source;

    CustomEditableTableColumnsAutocomplete(List<Account> source) {
        this.source = source;
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.textField);
            this.textField.selectAll();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText((String)this.getItem());
        this.setGraphic(null);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(item);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getString());
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(this.getString());
            this.setGraphic(null);
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.setOnAction(e -> this.commitEdit(this.textField.getText()));
        AutoCompletionBinding autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.textField, t -> {
            List<Account> result = this.searchData(t.getUserText());
            return result.size() > 30 ? result.subList(0, 29) : result;
        });
        autoCompletionBinding.setOnAutoCompleted((EventHandler)new EventHandler<AutoCompletionBinding.AutoCompletionEvent<Account>>(){

            public void handle(AutoCompletionBinding.AutoCompletionEvent<Account> event) {
                CustomEditableTableColumnsAutocomplete.this.textField.setText(((Account)event.getCompletion()).getName());
                SaleAccountDetailResolver req = (SaleAccountDetailResolver)CustomEditableTableColumnsAutocomplete.this.getTableView().getItems().get(CustomEditableTableColumnsAutocomplete.this.getIndex());
                req.setAccNumber(((Account)event.getCompletion()).getAccNumber());
                req.setAccountName(((Account)event.getCompletion()).getName());
            }
        });
        this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                System.out.println("Commiting " + this.textField.getText());
                this.commitEdit(this.textField.getText());
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : (String)this.getItem();
    }

    public List<Account> searchData(String searchString) {
        if (searchString == null || searchString.equals("")) {
            return new ArrayList<Account>();
        }
        List result = this.source.stream().filter(e -> e.getName().toLowerCase().contains(searchString.toLowerCase())).collect(Collectors.toList());
        LinkedList searchResult = new LinkedList();
        searchResult.addAll(result.isEmpty() && result.size() > 0 ? this.source : result);
        return searchResult.subList(0, searchResult.size());
    }
}

