/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.DbEntity;
import com.xputertechnologies.santa.ui.UIParent;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;

public class CustomEditableTableColumns<T extends DbEntity>
extends TableCell<T, String> {
    public TextField textField;

    CustomEditableTableColumns() {
    }

    CustomEditableTableColumns(UIParent parent) {
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.textField);
            this.textField.selectAll();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText((String)this.getItem());
        this.setGraphic(null);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(item);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.getString());
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(this.getString());
            this.setGraphic(null);
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.setOnAction(e -> this.commitEdit(this.textField.getText()));
        this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                System.out.println("Commiting " + this.textField.getText());
                this.commitEdit(this.textField.getText());
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : (String)this.getItem();
    }
}

