/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.UIParentBorderPane;
import com.xputertechnologies.santa.ui.UIParent;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;

public class AutoCompleteTextField
extends TextField {
    private final SortedSet<SearchClass> entries;
    private ContextMenu entriesPopup;
    public Node container;
    Point2D txtCoords;
    private BooleanProperty isSelected = new SimpleBooleanProperty();

    public AutoCompleteTextField() {
        this.entries = new TreeSet<SearchClass>();
        this.entriesPopup = new ContextMenu();
        this.entriesPopup.setMaxSize(200.0, 200.0);
        this.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String s, String s2) {
                if (AutoCompleteTextField.this.getText() != null) {
                    if (AutoCompleteTextField.this.getText().length() == 0 || AutoCompleteTextField.this.container == null) {
                        AutoCompleteTextField.this.entriesPopup.hide();
                    } else {
                        AutoCompleteTextField.this.isSelected.set(false);
                        AutoCompleteTextField.this.entries.clear();
                        LinkedList searchResult = new LinkedList();
                        if (AutoCompleteTextField.this.container instanceof UIParent) {
                            AutoCompleteTextField.this.entries.addAll(((UIParent)AutoCompleteTextField.this.container).searchData(s2));
                        } else {
                            AutoCompleteTextField.this.entries.addAll(((UIParentBorderPane)AutoCompleteTextField.this.container).searchData(s2));
                        }
                        List filteredEntries = AutoCompleteTextField.this.entries.stream().filter(e -> e.getUniqueString().toLowerCase().contains(AutoCompleteTextField.this.getText().toLowerCase())).collect(Collectors.toList());
                        searchResult.addAll(filteredEntries.size() == 0 && AutoCompleteTextField.this.entries.size() > 0 ? AutoCompleteTextField.this.entries : filteredEntries);
                        if (AutoCompleteTextField.this.entries.size() > 0) {
                            AutoCompleteTextField.this.populatePopup(searchResult);
                            if (!AutoCompleteTextField.this.entriesPopup.isShowing()) {
                                AutoCompleteTextField.this.entriesPopup.show((Node)AutoCompleteTextField.this, Side.BOTTOM, 0.0, 0.0);
                            }
                        } else {
                            AutoCompleteTextField.this.entriesPopup.hide();
                        }
                    }
                }
            }
        });
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean aBoolean, Boolean aBoolean2) {
                AutoCompleteTextField.this.entriesPopup.hide();
            }
        });
        this.txtCoords = this.localToScene(0.0, 0.0);
    }

    public Boolean getReturnAll() {
        return this.isSelected.get();
    }

    public void setReturnAll(Boolean isSelected) {
        this.isSelected.set(isSelected.booleanValue());
    }

    public BooleanProperty modifiedProperty() {
        return this.isSelected;
    }

    public SortedSet<SearchClass> getEntries() {
        return this.entries;
    }

    private void populatePopup(List<SearchClass> searchResult) {
        LinkedList<CustomMenuItem> menuItems = new LinkedList<CustomMenuItem>();
        int maxEntries = 25;
        int count = Math.min(searchResult.size(), maxEntries);
        for (int i = 0; i < count; ++i) {
            final SearchClass result = searchResult.get(i);
            Label entryLabel = new Label(result.toString());
            CustomMenuItem item = new CustomMenuItem((Node)entryLabel, true);
            item.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    AutoCompleteTextField.this.setText(result.toString());
                    AutoCompleteTextField.this.entriesPopup.hide();
                    if (AutoCompleteTextField.this.container instanceof UIParent) {
                        ((UIParent)AutoCompleteTextField.this.container).populateSearch(result.getUniqueString());
                    } else {
                        ((UIParentBorderPane)AutoCompleteTextField.this.container).populateSearch(result.getUniqueString());
                    }
                }
            });
            menuItems.add(item);
        }
        this.entriesPopup.getItems().clear();
        this.entriesPopup.getItems().addAll(menuItems);
    }
}

