/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.Approval;
import com.xputertechnologies.santa.report.ApprovalType;
import com.xputertechnologies.santa.ui.ApprovalPane;
import com.xputertechnologies.santa.ui.UIParent;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;

public class ApprovalDialog
extends UIParent {
    @FXML
    private JFXTextField tbDescription;
    @FXML
    private JFXCheckBox chkEnable;
    @FXML
    private JFXComboBox<String> cmbType;
    @FXML
    private JFXButton btnDone;
    @FXML
    private JFXButton btnNew;
    @FXML
    private JFXButton btnCancel;
    Approval approval;
    ApprovalPane parent;

    public ApprovalDialog(final ApprovalPane parent) {
        super("ApprovalDialog.fxml", parent.santa);
        this.santa = parent.santa;
        this.title = "Approval Template";
        this.parent = parent;
        this.approval = parent.approval == null ? new Approval(this.da) : parent.approval;
        ObservableList options = FXCollections.observableArrayList();
        for (int i = 0; i < ApprovalType.values().length; ++i) {
            options.add((Object)ApprovalType.values()[i].name());
        }
        this.cmbType.setItems(options);
        this.tbDescription.textProperty().bindBidirectional((Property)this.approval.descriptionProperty());
        this.cmbType.getSelectionModel().select(-1);
        if (!this.approval.getType().isEmpty()) {
            this.cmbType.getSelectionModel().select((Object)this.approval.getType());
        }
        this.cmbType.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null && !newValue.isEmpty()) {
                    ApprovalDialog.this.approval.setType(newValue);
                }
            }
        });
        this.chkEnable.selectedProperty().bindBidirectional((Property)this.approval.isDisableProperty());
        this.btnCancel.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.dialog.close();
            }
        });
        this.btnDone.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (parent.approval == null || !parent.approval.getDescription().equals(ApprovalDialog.this.approval.getDescription())) {
                    parent.approvalList.getOriginalList().add((Object)ApprovalDialog.this.approval);
                }
                parent.dialog.close();
            }
        });
        this.btnNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ApprovalDialog.this.rebind();
            }
        });
    }

    public void rebind() {
        this.tbDescription.textProperty().unbindBidirectional((Property)this.approval.descriptionProperty());
        this.cmbType.getSelectionModel().select(-1);
        this.chkEnable.selectedProperty().unbindBidirectional((Property)this.approval.isDisableProperty());
        if (this.parent.approval == null || !this.parent.approval.getDescription().equals(this.approval.getDescription())) {
            this.parent.approvalList.getOriginalList().add((Object)this.approval);
        }
        this.approval = new Approval(this.parent.da);
        this.tbDescription.textProperty().bindBidirectional((Property)this.approval.descriptionProperty());
        this.chkEnable.selectedProperty().bindBidirectional((Property)this.approval.isDisableProperty());
    }
}

