/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextArea;
import com.xputertechnologies.santa.IDBEntity;
import com.xputertechnologies.santa.Request;
import com.xputertechnologies.santa.RequestStatus;
import com.xputertechnologies.santa.RequestType;
import com.xputertechnologies.santa.RequestitemSerial;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.TransferSAPDockHistory;
import com.xputertechnologies.santa.WebRequest;
import com.xputertechnologies.santa.list.RequestDataList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.report.ReportType;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.ReportPane;
import com.xputertechnologies.santa.ui.RequestItem;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.SyncData;
import com.xputertechnologies.santa.ui.TransferDocHistory;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdminTransferView
extends UIParent {
    @FXML
    JFXComboBox cmbReqType;
    @FXML
    JFXComboBox<Store> cmbStore;
    @FXML
    JFXDatePicker toDate;
    @FXML
    JFXDatePicker fromDate;
    @FXML
    private TableView<Request> tbRequest;
    @FXML
    private TableColumn colreqFrom;
    @FXML
    private TableColumn colStoreName;
    @FXML
    private TableColumn colDate;
    @FXML
    private TableColumn colStatus;
    @FXML
    private TableColumn colUser;
    @FXML
    private TableColumn colReportType;
    @FXML
    private TableColumn colDel;
    @FXML
    private TableColumn colView;
    @FXML
    private TableColumn colSn;
    @FXML
    JFXButton btnSearch;
    @FXML
    JFXButton btnGit;
    @FXML
    JFXButton btnGitOld;
    @FXML
    StackPane stackPane;
    @FXML
    JFXTextArea txASearch;
    @FXML
    VBox vbHistory;
    VBox progressContainer;
    StoreDataList storeDataList;
    RequestDataList requestDataList;
    Request selectedRequestRow;
    boolean isDeclineClicked;
    boolean UserCanApprove;
    String url;

    public AdminTransferView(Santa app) {
        super("AdminTransferView.fxml", app);
        this.requestDataList = new RequestDataList(this.da);
        this.isDeclineClicked = false;
        this.UserCanApprove = false;
        this.santa = app;
        this.title = "Transfer View";
        this.fromDate.setValue((Object)LocalDate.now());
        this.toDate.setValue((Object)LocalDate.now());
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.colreqFrom.setCellValueFactory((Callback)new PropertyValueFactory("fromStoreName"));
        this.colStoreName.setCellValueFactory((Callback)new PropertyValueFactory("toStoreName"));
        this.colDate.setCellValueFactory((Callback)new PropertyValueFactory("requestDate"));
        this.colStatus.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.colUser.setCellValueFactory((Callback)new PropertyValueFactory("originatedUser"));
        this.colReportType.setCellValueFactory((Callback)new PropertyValueFactory("requestType"));
        this.colView.setCellValueFactory((Callback)new PropertyValueFactory("DUMMY"));
        this.colDel.setCellValueFactory((Callback)new PropertyValueFactory("isDeleted"));
        ObservableList options = FXCollections.observableArrayList();
        for (int i = 0; i < RequestStatus.values().length; ++i) {
            options.add((Object)RequestStatus.values()[i].name());
        }
        options.add(0, (Object)"All");
        options.add(options.size(), (Object)"Not Deleted");
        this.cmbReqType.setItems(options);
        this.cmbReqType.getSelectionModel().select(0);
        this.cmbReqType.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (newValue != null) {
                    ObservableList requestList = FXCollections.observableArrayList();
                    if (newValue.toString().equals("All")) {
                        AdminTransferView.this.tbRequest.setItems(AdminTransferView.this.requestDataList.getOriginalList());
                    } else if (newValue.toString().equals("Not Deleted")) {
                        requestList.addAll((Collection)AdminTransferView.this.requestDataList.getOriginalList().stream().filter(p -> !p.isDeleted).collect(Collectors.toList()));
                        AdminTransferView.this.tbRequest.setItems(requestList);
                    } else if (AdminTransferView.this.requestDataList.getOriginalList().size() > 0) {
                        requestList.addAll((Collection)AdminTransferView.this.requestDataList.getOriginalList().stream().filter(p -> p.getStatus().equals(newValue.toString())).collect(Collectors.toList()));
                        AdminTransferView.this.tbRequest.setItems(requestList);
                    }
                    AdminTransferView.this.tbRequest.refresh();
                }
            }
        });
        this.storeDataList = new StoreDataList(this.da);
        this.storeDataList.selectAll("Select *from store", this.da.getEmptyParameterValues());
        this.storeDataList.getOriginalList().add(0, (Object)new Store("All", "001", "", "", "", this.da));
        this.cmbStore.setItems(this.storeDataList.getOriginalList());
        this.btnSearch.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AdminTransferView.this.loadRequests();
            }
        });
        this.btnGit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AdminTransferView.this.generateGIT(false);
            }
        });
        this.btnGitOld.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AdminTransferView.this.generateGIT(true);
            }
        });
        Callback<TableColumn<Request, String>, TableCell<Request, String>> cellFactory = new Callback<TableColumn<Request, String>, TableCell<Request, String>>(){

            public TableCell call(TableColumn p) {
                TableCell<Request, String> cell = new TableCell<Request, String>(){
                    final Label lbl = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            Request req = (Request)this.getTableView().getItems().get(this.getIndex());
                            if (req.getStatus().equals(RequestStatus.CANCELLED.name())) {
                                this.lbl.setStyle("-fx-background-color:lightcoral;-fx-font-size: 12.0px;");
                            } else if (req.getStatus().equals(RequestStatus.PENDING.name())) {
                                this.lbl.setStyle("-fx-background-color:#FC02DD;-fx-font-size: 12.0px;");
                            } else if (req.getStatus().equals(RequestStatus.DECLINED.name())) {
                                this.lbl.setStyle("-fx-background-color:#FF0000;-fx-font-size: 12.0px;");
                            } else if (req.getStatus().equals(RequestStatus.APPROVED.name())) {
                                this.lbl.setStyle("-fx-background-color:#34b962;-fx-font-size: 12.0px;");
                                Tooltip tooltip = new Tooltip(req.getApprovingUser());
                                this.lbl.setTooltip(tooltip);
                            } else if (req.getStatus().equals(RequestStatus.COMPLETED.name())) {
                                this.lbl.setStyle("-fx-background-color:#CCFFFF;-fx-font-size: 12.0px;");
                            } else if (req.getStatus().equals(RequestStatus.RELEASED.name())) {
                                this.lbl.setStyle("-fx-background-color:#0afff5;-fx-font-size: 12.0px;");
                            } else if (req.getStatus().equals(RequestStatus.ACCEPTED.name())) {
                                this.lbl.setStyle("-fx-background-color:#B5C460;-fx-font-size: 12.0px;");
                            }
                            this.lbl.setText(req.getStatus());
                            this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                            this.setGraphic((Node)this.lbl);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colStatus.setCellFactory((Callback)cellFactory);
        Callback<TableColumn<Request, String>, TableCell<Request, String>> cellFactoryDel = new Callback<TableColumn<Request, String>, TableCell<Request, String>>(){

            public TableCell call(TableColumn<Request, String> param) {
                TableCell<Request, String> cell = new TableCell<Request, String>(){
                    final Label lbl = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            Request req = (Request)this.getTableView().getItems().get(this.getIndex());
                            if (req.isDeleted) {
                                this.lbl.setStyle("-fx-background-color:#FF0000;-fx-font-size: 11.0px;");
                                this.lbl.setText("YES");
                            } else {
                                this.lbl.setStyle("-fx-background-color:#00A86B;-fx-font-size: 11.0px;");
                                this.lbl.setText("NO");
                            }
                            this.lbl.setTextFill((Paint)Color.web((String)"#FFFFFF"));
                            this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                            this.setGraphic((Node)this.lbl);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colDel.setCellFactory((Callback)cellFactoryDel);
        Callback<TableColumn<Request, String>, TableCell<Request, String>> cellFactoryView = new Callback<TableColumn<Request, String>, TableCell<Request, String>>(){

            public TableCell call(TableColumn<Request, String> param) {
                TableCell<Request, String> cell = new TableCell<Request, String>(){
                    final JFXButton btn = new JFXButton("View");

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            Request req = (Request)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setStyle("-fx-background-color: #4FC4F6;");
                            this.btn.setOnAction(event -> {
                                Dialog dialog = new Dialog();
                                dialog.initStyle(StageStyle.UTILITY);
                                dialog.initOwner((Window)AdminTransferView.this.santa.stage);
                                dialog.setTitle("Transfer Item(s)");
                                dialog.setResizable(true);
                                dialog.getDialogPane().setContent((Node)new RequestItem(AdminTransferView.this.santa, req, AdminTransferView.this));
                                dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL});
                                dialog.show();
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colView.setCellFactory((Callback)cellFactoryView);
        this.btnSearch.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (AdminTransferView.this.cmbStore.getSelectionModel().getSelectedItem() != null) {
                    AdminTransferView.this.loadRequests();
                } else {
                    AdminTransferView.this.mainPage.showNotification(NotificationType.Error, "Please Select store", AdminTransferView.this);
                }
            }
        });
        this.tbRequest.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Request>(){

            public void changed(ObservableValue<? extends Request> observable, Request oldValue, Request newValue) {
                if (newValue != null) {
                    AdminTransferView.this.vbHistory.getChildren().clear();
                    for (TransferSAPDockHistory docHistory : newValue.getDocHistories()) {
                        AdminTransferView.this.vbHistory.getChildren().add((Object)new TransferDocHistory(AdminTransferView.this.santa, docHistory));
                    }
                }
            }
        });
    }

    void Accept(final Request request) {
        request.setApprovingUser(this.currentUser.getUserName());
        ProgressBar progressIndicator = new ProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            Object url = AdminTransferView.this.santa.syncSetting.getBEURL();
                            url = (String)url + "RRequest/ApproveRequests";
                            JSONArray jSONArray = new JSONArray();
                            JSONObject job = new JSONObject();
                            job.put("Code", (Object)request.getCode());
                            job.put("Reason", (Object)request.getReason());
                            job.put("Status", (Object)request.getStatus());
                            job.put("Reason", (Object)request.getReason());
                            job.put("StoreCode", (Object)request.getFromStoreCode());
                            job.put("DocEntry", request.getDocEntry());
                            job.put("ApprovalDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new java.util.Date()));
                            job.put("ReleaseComment", (Object)request.getReleaseComment());
                            job.put("ReleasingUser", (Object)request.getReleasingUser());
                            job.put("ApprovalComment", (Object)request.getApprovalComment());
                            job.put("AcceptComment", (Object)request.getAcceptedComment());
                            job.put("AcceptingUser", (Object)request.getAcceptingUser());
                            job.put("ApprovingUser", (Object)request.getApprovingUser());
                            job.put("RequestType", (Object)request.getRequestType());
                            job.put("OriginatingUser", (Object)request.getoriginatedUser());
                            job.put("DestinationStore", (Object)request.getToStoreCode());
                            job.put("LastUpdatedDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new java.util.Date()));
                            job.put("RequestDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new java.util.Date()));
                            JSONArray jab = new JSONArray();
                            for (com.xputertechnologies.santa.RequestItem requestItem : request.getItems()) {
                                JSONObject joItem = new JSONObject();
                                joItem.put("RequestCode", (Object)request.getCode());
                                joItem.put("Quantity", requestItem.getQuantity());
                                joItem.put("DestinationStore", (Object)request.getToStoreCode());
                                joItem.put("ReleasedQty", requestItem.getReleasedQuantity());
                                joItem.put("ApprovedQty", (Object)requestItem.getApprovedQty());
                                joItem.put("AcceptedQty", (Object)requestItem.getAcceptedQty());
                                joItem.put("ItemCode", (Object)requestItem.getItemCode());
                                joItem.put("ItemName", (Object)requestItem.getItemName());
                                joItem.put("Code", (Object)requestItem.getCode());
                                joItem.put("Serials", (Object)new JSONArray());
                                jab.put((Object)joItem);
                            }
                            job.put("RequestItems", (Object)jab);
                            jSONArray.put((Object)job);
                            HttpPost httpPost = new HttpPost((String)url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            StringEntity stringEntity = new StringEntity(jSONArray.toString());
                            httpPost.setEntity((HttpEntity)stringEntity);
                            httpPost.setHeader("Content-type", "application/json");
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                Platform.runLater(() -> {
                                    AdminTransferView.this.tbRequest.refresh();
                                    AdminTransferView.this.stackPane.getChildren().remove((Object)box);
                                    String destntStoreName = request.getRequestType().equals((Object)RequestType.Inbound) ? request.getFromStoreName() : request.getFromStoreName();
                                    AdminTransferView.this.mainPage.showNotification(NotificationType.Success, "Stock Transfer Request " + request.getCode() + " For " + destntStoreName + " has been " + request.getStatus(), AdminTransferView.this);
                                });
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                AdminTransferView.this.mainPage.showNotification(NotificationType.Error, fullError, AdminTransferView.this);
                                Platform.runLater(() -> AdminTransferView.this.stackPane.getChildren().remove((Object)box));
                            }
                        }
                        catch (Exception ex) {
                            AdminTransferView.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), AdminTransferView.this);
                            Platform.runLater(() -> AdminTransferView.this.stackPane.getChildren().remove((Object)box));
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void loadRequests() {
        this.tbRequest.getItems().clear();
        this.vbHistory.getChildren().clear();
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        String store = ((Store)AdminTransferView.this.cmbStore.getSelectionModel().getSelectedItem()).getName().equals("All") ? "All" : ((Store)AdminTransferView.this.cmbStore.getSelectionModel().getSelectedItem()).getCode();
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        LocalDateTime Strtdatetime = LocalDate.of(((LocalDate)AdminTransferView.this.fromDate.getValue()).getYear(), ((LocalDate)AdminTransferView.this.fromDate.getValue()).getMonth().getValue(), ((LocalDate)AdminTransferView.this.fromDate.getValue()).getDayOfMonth()).atTime(0, 0, 0);
                        LocalDateTime Enddatetime = LocalDate.of(((LocalDate)AdminTransferView.this.toDate.getValue()).getYear(), ((LocalDate)AdminTransferView.this.toDate.getValue()).getMonth().getValue(), ((LocalDate)AdminTransferView.this.toDate.getValue()).getDayOfMonth()).atTime(23, 59, 0);
                        String fromDt = format.format(Date.from(Strtdatetime.atZone(ZoneId.systemDefault()).toInstant()));
                        String toDt = format.format(Date.from(Enddatetime.atZone(ZoneId.systemDefault()).toInstant()));
                        String url = WebRequest.GET_TRANSFERS_WITH_DATE + "/" + fromDt + "/" + toDt + "/" + store;
                        if (!AdminTransferView.this.txASearch.getText().isEmpty()) {
                            JSONObject param = new JSONObject().put("recId", (Object)AdminTransferView.this.txASearch.getText());
                            url = WebRequest.GET_TRANSFERS + "?condition=" + param.toString();
                        }
                        SyncData syncData = new SyncData(AdminTransferView.this.santa, AdminTransferView.this.da, AdminTransferView.this.santa.currentUser.getParentCompany());
                        syncData.getRequest(AdminTransferView.this.santa.syncSetting, url, true, new IDBEntity<Request>(){

                            @Override
                            public void onSuccess(ObservableList<Request> data) {
                                if (data.isEmpty()) {
                                    Platform.runLater(() -> {
                                        AdminTransferView.this.stackPane.getChildren().remove((Object)box);
                                        AdminTransferView.this.mainPage.showNotification(NotificationType.Information, "No Request Found", AdminTransferView.this);
                                    });
                                } else {
                                    AdminTransferView.this.stackPane.getChildren().remove((Object)box);
                                    AdminTransferView.this.vbHistory.getChildren().clear();
                                    AdminTransferView.this.tbRequest.setItems(data);
                                    AdminTransferView.this.tbRequest.refresh();
                                    AdminTransferView.this.cmbReqType.getSelectionModel().select(0);
                                    AdminTransferView.this.txASearch.clear();
                                }
                            }

                            @Override
                            public void onError(String data) {
                                AdminTransferView.this.stackPane.getChildren().remove((Object)box);
                                AdminTransferView.this.mainPage.showNotification(NotificationType.Error, data.equals("Read timed out") ? "Unable to fulfil your request at the moment , Please try again" : data, AdminTransferView.this);
                            }

                            @Override
                            public void onTimeOut(String data) {
                                AdminTransferView.this.stackPane.getChildren().remove((Object)box);
                                AdminTransferView.this.mainPage.showNotification(NotificationType.Error, "Unable to fulfil your request at the moment , Please try again", AdminTransferView.this);
                            }
                        });
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    void generateGIT(boolean old) {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        this.url = !old ? this.santa.syncSetting.getBEURL() + "RRequest/GetGITReport" : this.santa.syncSetting.getBEURL() + "RRequest/GetOldGITReport";
        progressIndicator.setProgress(-1.0);
        try {
            HttpGet httpGet = new HttpGet(this.url);
            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
            httpGet.setHeader("Content-type", "application/json");
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                System.out.println("Output from Server .... \n");
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                httpClient.getConnectionManager().shutdown();
                String result = stringBuilder.toString();
                JSONArray ra = new JSONArray(result);
                if (ra.length() > 0) {
                    System.out.println(ra);
                    RequestDataList requestDataListGIT = new RequestDataList(this.da);
                    for (int i = 0; i < ra.length(); ++i) {
                        JSONObject jSONObject = ra.getJSONObject(i);
                        Request request = new Request(this.da);
                        request.setCode(jSONObject.isNull("Code") ? "" : jSONObject.getString("Code"));
                        request.setReason(jSONObject.isNull("Reason") ? "" : jSONObject.getString("Reason"));
                        request.setStatus(jSONObject.isNull("Status") ? "" : jSONObject.getString("Status"));
                        request.setFromStoreCode(jSONObject.isNull("StoreCode") ? "" : jSONObject.getString("StoreCode"));
                        request.setRequestType(jSONObject.isNull("RequestType") ? "" : jSONObject.getString("RequestType"));
                        request.setOriginatedUser(jSONObject.isNull("OriginatingUser") ? "" : jSONObject.getString("OriginatingUser"));
                        request.isDeleted = jSONObject.isNull("Deleted") ? false : jSONObject.getBoolean("Deleted");
                        request.setDocEntry(jSONObject.isNull("DocEntry") ? 0 : jSONObject.getInt("DocEntry"));
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                        java.util.Date dt = df.parse(jSONObject.getString("DateAccepted"));
                        request.setDateAccept(new Date(dt.getTime()));
                        dt = df.parse(jSONObject.getString("LastUpdatedDate"));
                        request.setLastUpdatedDate(new Date(dt.getTime()));
                        dt = df.parse(jSONObject.getString("ApprovalDate"));
                        request.approvalDateProperty().set((Object)new Date(dt.getTime()));
                        dt = df.parse(jSONObject.getString("ReleaseDate"));
                        request.releaseDateProperty().set((Object)new Date(dt.getTime()));
                        dt = df.parse(jSONObject.getString("RequestDate"));
                        request.requestDateProperty().set((Object)new Date(dt.getTime()));
                        dt = df.parse(jSONObject.getString("ReturnDate"));
                        request.returnDateProperty().set((Object)new Date(dt.getTime()));
                        request.setApprovingUser(jSONObject.isNull("ApprovingUser") ? "" : jSONObject.getString("ApprovingUser"));
                        request.setReleasingUser(jSONObject.isNull("ReleasingUser") ? "" : jSONObject.getString("ReleasingUser"));
                        request.setAcceptingUser(jSONObject.isNull("AcceptingUser") ? "" : jSONObject.getString("AcceptingUser"));
                        request.setApprovalComment(jSONObject.isNull("ApprovalComment") ? "" : jSONObject.getString("ApprovalComment"));
                        request.setReleaseComment(jSONObject.isNull("ReleaseComment") ? "" : jSONObject.getString("ReleaseComment"));
                        request.setAcceptedComment(jSONObject.isNull("AcceptComment") ? "" : jSONObject.getString("AcceptComment"));
                        request.setToStoreCode(jSONObject.isNull("DestinationStore") ? "" : jSONObject.getString("DestinationStore"));
                        request.setReturningUser(jSONObject.isNull("ReturningUser") ? "" : jSONObject.getString("ReturningUser"));
                        request.setReturningComment(jSONObject.isNull("ReturningComment") ? "" : jSONObject.getString("ReturningComment"));
                        Store StoreFrom = this.storeDataList.getOriginalList().stream().filter(v -> v.getCode().equals(request.getFromStoreCode())).findAny().orElse(null);
                        request.setFromStoreName(StoreFrom == null ? (request.getFromStoreCode().equals("01") ? "Main Ware House" : "") : StoreFrom.getName());
                        Store StoreTo = this.storeDataList.getOriginalList().stream().filter(v -> v.getCode().equals(request.getToStoreCode())).findAny().orElse(null);
                        request.fromStoreNameProperty().set((Object)(StoreTo == null ? (request.getToStoreCode().equals("01") ? "Main Ware House" : "") : StoreTo.getName()));
                        JSONArray requestArray = jSONObject.getJSONArray("RequestItems");
                        for (int j = 0; j < requestArray.length(); ++j) {
                            JSONObject jsono = requestArray.getJSONObject(j);
                            com.xputertechnologies.santa.RequestItem requestItem = new com.xputertechnologies.santa.RequestItem(this.da);
                            requestItem.setRequestCode(jsono.isNull("Code") ? "" : jSONObject.getString("Code"));
                            requestItem.setQuantity(jsono.isNull("Quantity") ? 0 : jsono.getInt("Quantity"));
                            requestItem.setReason(jsono.isNull("Reason") ? "" : jsono.getString("Reason"));
                            requestItem.setReleasedQuantity(jsono.isNull("ReleasedQty") ? 0 : jsono.getInt("ReleasedQty"));
                            requestItem.setItemCode(jsono.isNull("ItemCode") ? "" : jsono.getString("ItemCode"));
                            requestItem.setItemName(jsono.isNull("ItemName") ? "" : jsono.getString("ItemName"));
                            requestItem.setOriginatedStore(jsono.isNull("OriginatingStore") ? "" : jsono.getString("OriginatingStore"));
                            requestItem.setToStoreInitQty(jsono.isNull("DestinationStoreQty") ? 0 : jsono.getInt("DestinationStoreQty"));
                            requestItem.setApprovedQty(jsono.isNull("ApprovedQty") ? 0 : jsono.getInt("ApprovedQty"));
                            requestItem.setAcceptedQty(jsono.isNull("AcceptedQty") ? 0 : jsono.getInt("AcceptedQty"));
                            requestItem.setReturnedQty(jsono.isNull("ReturnedQty") ? 0 : jsono.getInt("ReturnedQty"));
                            requestItem.setCode(jsono.isNull("Code") ? "" : jsono.getString("Code"));
                            JSONArray jSONArray = jsono.getJSONArray("Serials");
                            for (int k = 0; k < jSONArray.length(); ++k) {
                                JSONObject jsono1 = jSONArray.getJSONObject(k);
                                RequestitemSerial requestitemSerial = new RequestitemSerial(this.da);
                                requestitemSerial.setRequestItemCode(jsono1.isNull("RequestItemCode") ? "" : jsono1.getString("RequestItemCode"));
                                requestitemSerial.setSerial(jsono1.isNull("Serial") ? "" : jsono1.getString("Serial"));
                                requestitemSerial.setItemCode(jsono1.isNull("ItemCode") ? "" : jsono1.getString("ItemCode"));
                                requestitemSerial.setIsAccepted(jsono1.isNull("IsAccepted") ? false : jsono1.getBoolean("IsAccepted"));
                                requestitemSerial.setSysSerial(jsono1.isNull("SysSerial") ? 0 : jsono1.getInt("SysSerial"));
                                requestItem.getSerials().add((Object)requestitemSerial);
                            }
                            request.getItems().add((Object)requestItem);
                        }
                        requestDataListGIT.getOriginalList().add((Object)request);
                    }
                    Platform.runLater(() -> {
                        try {
                            JFXDialog dialog = new JFXDialog();
                            dialog.setDialogContainer(this.stackPane);
                            dialog.setContent((Region)new ReportPane(this.santa, ReportType.GIT, dialog, requestDataListGIT.getOriginalList()));
                            dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
                            dialog.setOverlayClose(false);
                            dialog.show();
                        }
                        catch (Exception ex) {
                            Logger.getLogger(AdminTransferView.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    });
                } else {
                    Platform.runLater(() -> this.mainPage.showNotification(NotificationType.Information, "No GIT Pending Found", this));
                }
            } else {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((output = br.readLine()) != null) {
                    System.out.println(output);
                    stringBuilder.append(output + "\n");
                }
                br.close();
                String fullError = stringBuilder.toString();
                Platform.runLater(() -> this.mainPage.showNotification(NotificationType.Error, fullError, this));
            }
        }
        catch (Exception e) {
            Platform.runLater(() -> this.mainPage.showNotification(NotificationType.Error, e.getMessage(), this));
        }
    }

    @Override
    public void yes() {
        if (this.selectedRequestRow != null && !this.isDeclineClicked) {
            this.selectedRequestRow.setStatus(RequestStatus.APPROVED.name());
            this.Accept(this.selectedRequestRow);
        } else if (this.selectedRequestRow != null && this.isDeclineClicked) {
            this.selectedRequestRow.setStatus(RequestStatus.DECLINED.name());
            this.Accept(this.selectedRequestRow);
        }
    }
}

