/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXDatePicker;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.jfoenix.controls.JFXTextField;
import com.xputertechnologies.santa.BatchSale;
import com.xputertechnologies.santa.BatchStatusEnum;
import com.xputertechnologies.santa.PaymentBatch;
import com.xputertechnologies.santa.PaymentBatchHistory;
import com.xputertechnologies.santa.Store;
import com.xputertechnologies.santa.list.PaymentBatchDataList;
import com.xputertechnologies.santa.list.StoreDataList;
import com.xputertechnologies.santa.ui.AdminPaymentBatchEdit;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.IGenericInterface;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.PaymentBatchHistoryItem;
import com.xputertechnologies.santa.ui.PaymentBatchNew;
import com.xputertechnologies.santa.ui.Santa;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.controlsfx.glyphfont.FontAwesome;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdminPaymentBatchPane
extends IGenericInterface {
    @FXML
    private StackPane stackPane;
    @FXML
    private JFXDatePicker fromDate;
    @FXML
    private JFXDatePicker toDate;
    @FXML
    private JFXTextField txASearch;
    @FXML
    private JFXComboBox<Store> cmbStore;
    @FXML
    private JFXButton btnSearch;
    @FXML
    private JFXButton btnPost;
    @FXML
    private JFXComboBox<?> cmbFilter;
    @FXML
    private TableView<PaymentBatch> table;
    @FXML
    private TableColumn colSn;
    @FXML
    private TableColumn colStoreName;
    @FXML
    private TableColumn colBatchCode;
    @FXML
    private TableColumn colTellerNo;
    @FXML
    private TableColumn colAmountDeposited;
    @FXML
    private TableColumn colStatus;
    @FXML
    private TableColumn colBatchDate;
    @FXML
    private TableColumn colBatchUser;
    @FXML
    private TableColumn colAmount;
    @FXML
    private VBox vbHistory;
    @FXML
    private TableColumn colSales;
    PaymentBatchDataList paymentBatchDataList;
    StoreDataList storeDataList = null;

    public AdminPaymentBatchPane(final Santa santa) {
        super("AdminPaymentBatchPane.fxml", santa);
        this.santa = santa;
        this.title = "Payment Batching Page";
        this.fromDate.setValue((Object)LocalDate.now().minusDays(2L));
        this.toDate.setValue((Object)LocalDate.now());
        this.storeDataList = new StoreDataList(this.da);
        this.storeDataList.selectAll(this.da);
        Store store = new Store(this.da);
        store.setCode("-1");
        store.setName("All Stores");
        this.storeDataList.getOriginalList().add(0, (Object)store);
        this.cmbStore.setItems(this.storeDataList.getOriginalList());
        this.colSn.setCellValueFactory((Callback)new PropertyValueFactory("sn"));
        this.colBatchCode.setCellValueFactory((Callback)new PropertyValueFactory("batchCode"));
        this.colAmount.setCellValueFactory((Callback)new PropertyValueFactory("amount"));
        this.colAmountDeposited.setCellValueFactory((Callback)new PropertyValueFactory("amountDeposited"));
        this.colBatchDate.setCellValueFactory((Callback)new PropertyValueFactory("dateCreatedString"));
        this.colBatchUser.setCellValueFactory((Callback)new PropertyValueFactory("batchUser"));
        this.colTellerNo.setCellValueFactory((Callback)new PropertyValueFactory("tellerNo"));
        this.colStoreName.setCellValueFactory((Callback)new PropertyValueFactory("store"));
        Callback<TableColumn<PaymentBatch, String>, TableCell<PaymentBatch, String>> cellFactorycolStatus = new Callback<TableColumn<PaymentBatch, String>, TableCell<PaymentBatch, String>>(){

            public TableCell call(TableColumn<PaymentBatch, String> param) {
                TableCell<PaymentBatch, String> cell = new TableCell<PaymentBatch, String>(){
                    final JFXButton btn = new JFXButton();
                    final Label lbl = new Label();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            final PaymentBatch req = (PaymentBatch)this.getTableView().getItems().get(this.getIndex());
                            if (req.getStatus().equals("Passed")) {
                                this.lbl.setText(req.getStatus());
                                this.lbl.setGraphic((Node)AdminPaymentBatchPane.this.fontAwesome.create('\uf087').color(Color.GREEN).size(15.0));
                                this.lbl.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
                                this.setGraphic((Node)this.lbl);
                            } else {
                                this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                                this.btn.setText("Edit");
                                this.btn.setGraphic((Node)AdminPaymentBatchPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EDIT).color(Color.WHITE).size(10.0));
                                if (req.getStatus().equals(BatchStatusEnum.Pending.name())) {
                                    this.btn.setStyle("-fx-background-color: #FC02DD;-fx-font-size: 10px;");
                                } else if (req.getStatus().equals(BatchStatusEnum.Failed.name()) || req.getStatus().isEmpty()) {
                                    this.btn.setStyle("-fx-background-color: #FF0000;-fx-font-size: 10px;");
                                }
                                this.btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                    public void handle(ActionEvent event) {
                                        AdminPaymentBatchPane.this.selectedPaymentBatch = req;
                                        AdminPaymentBatchPane.this.editPaymentBatch();
                                    }
                                });
                                this.setGraphic((Node)this.btn);
                            }
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colStatus.setCellFactory((Callback)cellFactorycolStatus);
        this.colAmount.setCellFactory(col -> new TableCell<PaymentBatch, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        this.colAmountDeposited.setCellFactory(col -> new TableCell<PaymentBatch, Number>(){

            public void updateItem(Number price, boolean empty) {
                super.updateItem((Object)price, empty);
                if (empty) {
                    this.setText(null);
                } else if (price != null) {
                    this.setText(General.formatDecimalToMoneyString(price.doubleValue()));
                }
            }
        });
        Callback<TableColumn<PaymentBatch, String>, TableCell<PaymentBatch, String>> cellFactorycolSales = new Callback<TableColumn<PaymentBatch, String>, TableCell<PaymentBatch, String>>(){

            public TableCell call(TableColumn<PaymentBatch, String> param) {
                TableCell<PaymentBatch, String> cell = new TableCell<PaymentBatch, String>(){
                    final JFXButton btn = new JFXButton();

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            final PaymentBatch req = (PaymentBatch)this.getTableView().getItems().get(this.getIndex());
                            this.btn.setButtonType(JFXButton.ButtonType.FLAT);
                            this.btn.setText("View");
                            this.btn.setGraphic((Node)AdminPaymentBatchPane.this.fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.WHITE).size(10.0));
                            this.btn.setStyle("-fx-background-color: #4FC4F6;-fx-font-size: 10px;");
                            this.btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                public void handle(ActionEvent event) {
                                    AdminPaymentBatchPane.this.selectedPaymentBatch = req;
                                    AdminPaymentBatchPane.this.editView();
                                }
                            });
                            this.setGraphic((Node)this.btn);
                            this.setAlignment(Pos.CENTER);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.colSales.setCellFactory((Callback)cellFactorycolSales);
        this.paymentBatchDataList = new PaymentBatchDataList(this.da);
        this.table.setItems(this.paymentBatchDataList.getOriginalList());
        this.btnSearch.setOnAction(a -> this.search());
        this.btnPost.setOnAction(v -> {
            if (this.paymentBatchDataList.getOriginalList().stream().filter(c -> !c.getAdminRemark().isEmpty()).count() > 0L) {
                this.post();
            } else {
                this.mainPage.showNotification(NotificationType.Information, "No data to post", this);
            }
        });
        this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<PaymentBatch>(){

            public void changed(ObservableValue<? extends PaymentBatch> observable, PaymentBatch oldValue, PaymentBatch newValue) {
                if (newValue != null) {
                    AdminPaymentBatchPane.this.vbHistory.getChildren().clear();
                    for (PaymentBatchHistory docHistory : newValue.getHistories()) {
                        AdminPaymentBatchPane.this.vbHistory.getChildren().add((Object)new PaymentBatchHistoryItem(santa, docHistory));
                    }
                }
            }
        });
    }

    private void post() {
        final String url = this.santa.syncSetting.getBEURL() + "RBatchPayment/CreateBatchPayment";
        final List list = this.paymentBatchDataList.getOriginalList().stream().filter(c -> !c.getAdminRemark().isEmpty()).collect(Collectors.toList());
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            JSONArray jSONArray = new JSONArray();
                            for (PaymentBatch payBatch : list) {
                                JSONObject job = new JSONObject();
                                job.put("Code", (Object)payBatch.getBatchCode());
                                job.put("BatchUser", (Object)payBatch.getBatchUser());
                                job.put("Status", (Object)BatchStatusEnum.Posted.name());
                                job.put("StoreCode", (Object)payBatch.getStore());
                                job.put("TellerNo", (Object)payBatch.getTellerNo());
                                job.put("TotalAmount", payBatch.getAmount());
                                job.put("InitialAmount", payBatch.initialAmt);
                                job.put("CurrentAmount", payBatch.getCurrentAmt() + payBatch.initialAmt);
                                job.put("DateCreated", (Object)payBatch.getDateCreated());
                                job.put("Bank", (Object)payBatch.getBankName());
                                job.put("BankAccount", (Object)payBatch.getAccountNo());
                                job.put("Comment", (Object)payBatch.getAdminRemark());
                                job.put("AuditStatus", (Object)payBatch.getStatus());
                                JSONArray sales = new JSONArray();
                                for (BatchSale batchSale : payBatch.getBatchSales()) {
                                    JSONObject jsono = new JSONObject();
                                    jsono.put("Code", (Object)batchSale.getBatchCode());
                                    jsono.put("InvoiceNumber", (Object)batchSale.getInvoiceNumber());
                                    jsono.put("SalesChannel", (Object)batchSale.getSalesChannel());
                                    jsono.put("CashAmount", batchSale.getAmount());
                                    jsono.put("BalanceNotCash", batchSale.getAmountNotCash());
                                    sales.put((Object)jsono);
                                }
                                job.put("Sales", (Object)sales);
                                jSONArray.put((Object)job);
                            }
                            HttpPost httpPost = new HttpPost(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            System.out.println(jSONArray.toString());
                            StringEntity stringEntity = new StringEntity(jSONArray.toString());
                            httpPost.setEntity((HttpEntity)stringEntity);
                            httpPost.setHeader("Content-type", "application/json");
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                Platform.runLater(() -> {
                                    try {
                                        list.forEach(c -> {
                                            PaymentBatch found = AdminPaymentBatchPane.this.paymentBatchDataList.getOriginalList().stream().filter(x -> x.getBatchCode().equals(c.getBatchCode())).findAny().get();
                                            found.setAdminRemark("");
                                        });
                                        AdminPaymentBatchPane.this.table.refresh();
                                        AdminPaymentBatchPane.this.mainPage.showNotification(NotificationType.Success, "Operation Successful", AdminPaymentBatchPane.this);
                                        AdminPaymentBatchPane.this.stackPane.getChildren().remove((Object)box);
                                    }
                                    catch (Exception ex) {
                                        AdminPaymentBatchPane.this.mainPage.showNotification(NotificationType.Error, ex.getMessage(), AdminPaymentBatchPane.this);
                                    }
                                });
                            } else {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    AdminPaymentBatchPane.this.stackPane.getChildren().remove((Object)box);
                                    AdminPaymentBatchPane.this.mainPage.showNotification(NotificationType.Error, fullError, AdminPaymentBatchPane.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                AdminPaymentBatchPane.this.stackPane.getChildren().remove((Object)box);
                                AdminPaymentBatchPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), AdminPaymentBatchPane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    private void search() {
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            String output;
                            StringBuilder stringBuilder;
                            BufferedReader br;
                            String url = AdminPaymentBatchPane.this.santa.syncSetting.getBEURL() + "RBatchPayment/GetPayments";
                            HttpGet httpGet = new HttpGet(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            ArrayList<BasicNameValuePair> listParam = new ArrayList<BasicNameValuePair>();
                            if (!((Store)AdminPaymentBatchPane.this.cmbStore.getSelectionModel().getSelectedItem()).getCode().equals("-1")) {
                                BasicNameValuePair param1 = new BasicNameValuePair("storeCode", ((Store)AdminPaymentBatchPane.this.cmbStore.getSelectionModel().getSelectedItem()).getCode());
                                listParam.add(param1);
                            }
                            if (!AdminPaymentBatchPane.this.txASearch.getText().isEmpty()) {
                                BasicNameValuePair param2 = new BasicNameValuePair("searchString", AdminPaymentBatchPane.this.txASearch.getText().trim());
                                listParam.add(param2);
                            } else {
                                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                LocalDateTime Strtdatetime = LocalDate.of(((LocalDate)AdminPaymentBatchPane.this.fromDate.getValue()).getYear(), ((LocalDate)AdminPaymentBatchPane.this.fromDate.getValue()).getMonth().getValue(), ((LocalDate)AdminPaymentBatchPane.this.fromDate.getValue()).getDayOfMonth()).atTime(0, 0, 0);
                                LocalDateTime Enddatetime = LocalDate.of(((LocalDate)AdminPaymentBatchPane.this.toDate.getValue()).getYear(), ((LocalDate)AdminPaymentBatchPane.this.toDate.getValue()).getMonth().getValue(), ((LocalDate)AdminPaymentBatchPane.this.toDate.getValue()).getDayOfMonth()).atTime(23, 59, 0);
                                String fromDt = format.format(Date.from(Strtdatetime.atZone(ZoneId.systemDefault()).toInstant()));
                                String toDt = format.format(Date.from(Enddatetime.atZone(ZoneId.systemDefault()).toInstant()));
                                BasicNameValuePair param2 = new BasicNameValuePair("startDate", fromDt);
                                listParam.add(param2);
                                BasicNameValuePair param3 = new BasicNameValuePair("endDate", toDt);
                                listParam.add(param3);
                            }
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            URI uri = new URIBuilder(httpGet.getURI()).addParameters(listParam).build();
                            httpGet.setURI(uri);
                            System.out.println(uri.getQuery());
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 204) {
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                AdminPaymentBatchPane.this.paymentBatchDataList.getOriginalList().clear();
                                if (ra.length() > 0) {
                                    System.out.print(ra);
                                    for (int i = 0; i < ra.length(); ++i) {
                                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
                                        JSONObject jSONObject = ra.getJSONObject(i);
                                        PaymentBatch stck = new PaymentBatch(AdminPaymentBatchPane.this.da);
                                        stck.setBatchCode(jSONObject.isNull("Code") ? "" : jSONObject.getString("Code"));
                                        stck.setBatchUser(jSONObject.isNull("BatchUser") ? "" : jSONObject.getString("BatchUser"));
                                        stck.setStatus(jSONObject.isNull("AuditStatus") ? "" : jSONObject.getString("AuditStatus"));
                                        stck.setStore(jSONObject.isNull("StoreCode") ? "" : jSONObject.getString("StoreCode"));
                                        stck.setTellerNo(jSONObject.isNull("TellerNo") ? "" : jSONObject.getString("TellerNo"));
                                        stck.setAmount(jSONObject.isNull("TotalAmount") ? 0.0 : jSONObject.getDouble("TotalAmount"));
                                        stck.setDateCreated(df.parse(jSONObject.isNull("DateCreated") ? "" : jSONObject.getString("DateCreated")));
                                        stck.dateCreatedStringProperty().set((Object)new SimpleDateFormat("yyyy-MM-dd").format(stck.getDateCreated()));
                                        stck.setBankName(jSONObject.isNull("Bank") ? "" : jSONObject.getString("Bank"));
                                        stck.setAccountNo(jSONObject.isNull("BankAccount") ? "" : jSONObject.getString("BankAccount"));
                                        stck.setRemark(jSONObject.isNull("Comment") ? "" : jSONObject.getString("Comment"));
                                        stck.setAmountDeposited(jSONObject.isNull("AmountDeposited") ? 0.0 : jSONObject.getDouble("AmountDeposited"));
                                        stck.setSyncFlag(true);
                                        stck.setStore(AdminPaymentBatchPane.this.storeDataList.getOriginalList().stream().filter(c -> c.getCode().equals(stck.getStore())).findAny().get().getName());
                                        stck.initialAmt = jSONObject.isNull("InitialAmount") ? 0.0 : jSONObject.getDouble("InitialAmount");
                                        stck.setCurrentAmt(jSONObject.isNull("CurrentAmount") ? 0.0 : jSONObject.getDouble("CurrentAmount"));
                                        stck.initialAmountDeposited = jSONObject.isNull("AmountDeposited") ? 0.0 : jSONObject.getDouble("AmountDeposited");
                                        JSONArray sales = jSONObject.getJSONArray("Sales");
                                        for (int j = 0; j < sales.length(); ++j) {
                                            JSONObject sale = sales.getJSONObject(j);
                                            BatchSale batchSale = new BatchSale(AdminPaymentBatchPane.this.da);
                                            batchSale.setBatchCode(stck.getBatchCode());
                                            batchSale.setInvoiceNumber(sale.isNull("InvoiceNumber") ? "" : Integer.toString(sale.getInt("InvoiceNumber")));
                                            batchSale.setSalesChannel(sale.isNull("SalesChannel") ? "" : sale.getString("SalesChannel"));
                                            batchSale.setAmountNotCash(sale.isNull("BalanceNotCash") ? 0.0 : sale.getDouble("BalanceNotCash"));
                                            batchSale.setAmount(sale.isNull("CashAmount") ? 0.0 : sale.getDouble("CashAmount"));
                                            stck.getBatchSales().add((Object)batchSale);
                                        }
                                        JSONArray histories = jSONObject.getJSONArray("PaymentHistories");
                                        for (int j = 0; j < histories.length(); ++j) {
                                            JSONObject sale = histories.getJSONObject(j);
                                            PaymentBatchHistory history = new PaymentBatchHistory();
                                            history.setComment(sale.isNull("Comment") ? "" : sale.getString("Comment"));
                                            history.setUser(sale.isNull("AuditUser") ? "" : sale.getString("AuditUser"));
                                            java.util.Date dt = df.parse(sale.getString("Date"));
                                            history.setDate(new SimpleDateFormat("yyyy-MM-dd hh:mm a").format(dt));
                                            history.setCurrentAmt(sale.isNull("CurrentAmount") ? 0.0 : sale.getDouble("CurrentAmount"));
                                            history.setPreviousAmt(sale.isNull("InitialAmount") ? 0.0 : sale.getDouble("InitialAmount"));
                                            stck.getHistories().add((Object)history);
                                        }
                                        AdminPaymentBatchPane.this.paymentBatchDataList.getOriginalList().add((Object)stck);
                                    }
                                    System.out.println("Finish");
                                    Platform.runLater(() -> {
                                        AdminPaymentBatchPane.this.stackPane.getChildren().remove((Object)box);
                                        AdminPaymentBatchPane.this.vbHistory.getChildren().clear();
                                        AdminPaymentBatchPane.this.paymentBatchDataList.resetNumbering();
                                        AdminPaymentBatchPane.this.table.refresh();
                                        AdminPaymentBatchPane.this.txASearch.clear();
                                    });
                                } else {
                                    Platform.runLater(() -> {
                                        AdminPaymentBatchPane.this.stackPane.getChildren().remove((Object)box);
                                        AdminPaymentBatchPane.this.table.getItems().clear();
                                        AdminPaymentBatchPane.this.table.refresh();
                                        AdminPaymentBatchPane.this.txASearch.clear();
                                        AdminPaymentBatchPane.this.mainPage.showNotification(NotificationType.Information, "No Request Found", AdminPaymentBatchPane.this);
                                    });
                                }
                            } else {
                                br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                stringBuilder = new StringBuilder();
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                String fullError = stringBuilder.toString();
                                Platform.runLater(() -> {
                                    AdminPaymentBatchPane.this.stackPane.getChildren().remove((Object)box);
                                    AdminPaymentBatchPane.this.mainPage.showNotification(NotificationType.Error, fullError, AdminPaymentBatchPane.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                AdminPaymentBatchPane.this.stackPane.getChildren().remove((Object)box);
                                AdminPaymentBatchPane.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), AdminPaymentBatchPane.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }

    private void editView() {
        this.isReadOnly = true;
        this.dialog = new JFXDialog();
        this.dialog.setDialogContainer(this.stackPane);
        this.dialog.setContent((Region)new PaymentBatchNew(this));
        this.dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    private void editPaymentBatch() {
        this.dialog = new JFXDialog();
        this.dialog.setDialogContainer(this.stackPane);
        this.dialog.setContent((Region)new AdminPaymentBatchEdit(this));
        this.dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }
}

