/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXProgressBar;
import com.xputertechnologies.santa.RequestApprovalUser;
import com.xputertechnologies.santa.ui.AdminMailConfigDialog;
import com.xputertechnologies.santa.ui.NotificationType;
import com.xputertechnologies.santa.ui.Santa;
import com.xputertechnologies.santa.ui.UIParent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdminMailConfig
extends UIParent {
    @FXML
    public TableView<RequestApprovalUser> table;
    @FXML
    private StackPane stackPane;
    @FXML
    FlowPane fpSale;
    @FXML
    FlowPane fpTransfer;
    VBox progressContainer;
    boolean isNew = true;
    JFXDialog dialog;
    RequestApprovalUser selectedUser;
    ObservableList<RequestApprovalUser> list = FXCollections.observableArrayList();

    public AdminMailConfig(Santa app) {
        super("AdminMailConfig.fxml", app);
        this.title = "Admin. Mail Config Page";
    }

    public void showDialog() {
        this.dialog = new JFXDialog();
        this.dialog.setDialogContainer(this.stackPane);
        this.dialog.setContent((Region)new AdminMailConfigDialog(this));
        this.dialog.setTransitionType(JFXDialog.DialogTransition.CENTER);
        this.dialog.setOverlayClose(false);
        this.dialog.show();
    }

    void loadRequestUsers() {
        this.table.getItems().clear();
        final String url = this.santa.syncSetting.getBEURL() + "RRequest/GetApprovingUsers";
        JFXProgressBar progressIndicator = new JFXProgressBar();
        progressIndicator.setProgress(-1.0);
        final VBox box = new VBox(new Node[]{progressIndicator});
        box.setAlignment(Pos.CENTER);
        this.progressContainer = box;
        this.stackPane.getChildren().add((Object)box);
        Service service = new Service(){

            protected Task createTask() {
                return new Task(){

                    protected Object call() throws Exception {
                        try {
                            HttpGet httpGet = new HttpGet(url);
                            RequestConfig defaultRequestConfig = RequestConfig.custom().setConnectTimeout(Santa.connectionTimeOut).setSocketTimeout(Santa.socketTimeOut).setConnectionRequestTimeout(Santa.socketTimeOut).build();
                            httpGet.setHeader("Content-type", "application/json");
                            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
                            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                            if (response.getStatusLine().getStatusCode() == 200) {
                                String output;
                                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                                StringBuilder stringBuilder = new StringBuilder();
                                System.out.println("Output from Server .... \n");
                                while ((output = br.readLine()) != null) {
                                    System.out.println(output);
                                    stringBuilder.append(output + "\n");
                                }
                                br.close();
                                httpClient.getConnectionManager().shutdown();
                                String result = stringBuilder.toString();
                                JSONArray ra = new JSONArray(result);
                                AdminMailConfig.this.list.clear();
                                for (int i = 0; i < ra.length(); ++i) {
                                    JSONObject jaJSONObject = ra.getJSONObject(i);
                                    RequestApprovalUser rau = new RequestApprovalUser(AdminMailConfig.this.da);
                                    rau.setSn(i + 1);
                                    rau.setEmail(jaJSONObject.getString("Email"));
                                    rau.setName(jaJSONObject.getString("Name"));
                                    rau.setIsEnable(jaJSONObject.getBoolean("Enabled"));
                                    rau.setOperationType(jaJSONObject.isNull("UserType") ? "" : jaJSONObject.getString("UserType"));
                                    AdminMailConfig.this.list.add((Object)rau);
                                }
                                Platform.runLater(() -> {
                                    AdminMailConfig.this.stackPane.getChildren().remove((Object)box);
                                    AdminMailConfig.this.table.refresh();
                                });
                            } else {
                                String fullError = response.getStatusLine().getReasonPhrase();
                                Platform.runLater(() -> {
                                    AdminMailConfig.this.stackPane.getChildren().remove((Object)box);
                                    AdminMailConfig.this.mainPage.showNotification(NotificationType.Error, fullError, AdminMailConfig.this);
                                });
                            }
                        }
                        catch (Exception e) {
                            Platform.runLater(() -> {
                                AdminMailConfig.this.stackPane.getChildren().remove((Object)box);
                                AdminMailConfig.this.mainPage.showNotification(NotificationType.Error, e.getMessage(), AdminMailConfig.this);
                            });
                        }
                        return null;
                    }
                };
            }
        };
        progressIndicator.progressProperty().bind((ObservableValue)service.progressProperty());
        service.start();
    }
}

