/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.ui;

import com.xputertechnologies.santa.AccountDetail;
import com.xputertechnologies.santa.AccountPaymentType;
import com.xputertechnologies.santa.ui.DecimalNumberTextBox;
import com.xputertechnologies.santa.ui.General;
import com.xputertechnologies.santa.ui.UIControlBase;
import javafx.beans.property.Property;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;

public class AccountDetailItemPane
extends UIControlBase {
    public AccountDetail accountDetail;
    StringConverter<? extends Number> dConverter = new DoubleStringConverter();
    @FXML
    private DecimalNumberTextBox tfAmount;
    @FXML
    private TextField tbchequeNumber;
    @FXML
    private Label naira;
    @FXML
    private Label lblType;
    @FXML
    private VBox vbCheque;
    @FXML
    private HBox hb;

    public AccountDetailItemPane(AccountDetail accountDetail) {
        this.naira.setText(General.toNaira());
        this.accountDetail = accountDetail;
        if (!accountDetail.getAccType().equals("Cheque")) {
            this.hb.getChildren().remove((Object)this.vbCheque);
        } else {
            this.tbchequeNumber.textProperty().bindBidirectional((Property)this.accountDetail.chequeNumber);
        }
        this.tfAmount.textProperty().bindBidirectional((Property)this.accountDetail.amountProperty(), this.dConverter);
        this.tfAmount.setMin(0.0);
        General.selectAll(this.tfAmount);
        ObservableList optionsAcctType = FXCollections.observableArrayList();
        for (int i = 0; i < AccountPaymentType.values().length; ++i) {
            optionsAcctType.add((Object)AccountPaymentType.values()[i].name());
        }
        this.lblType.setText(accountDetail.getAccType());
    }
}

