/*
 * Decompiled with CFR 0.152.
 */
package com.xputertechnologies.santa.list;

import com.xputertechnologies.santa.SearchClass;
import com.xputertechnologies.santa.SyncSetting;
import com.xputertechnologies.santa.core.DataAccess;
import com.xputertechnologies.santa.core.ParameterValue;
import com.xputertechnologies.santa.core.SearchCondition;
import com.xputertechnologies.santa.list.DataList;
import com.xputertechnologies.santa.list.StockItemList;
import com.xputertechnologies.santa.list.UserDataList;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SyncSettingDataList
extends DataList<SyncSetting> {
    public DataAccess dataAccess;

    public SyncSettingDataList(DataAccess da) {
        this.dataAccess = da;
        this.t = new SyncSetting(da);
    }

    public SyncSettingDataList() {
    }

    @Override
    public void select() {
    }

    public void selectAll(String query, DataAccess da) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = da.select(query, da.getEmptyParameterValues());
            if (rs != null) {
                while (rs.next()) {
                    SyncSetting syncSetting = new SyncSetting(rs.getString("ERPENDPOINT"), rs.getString("endPoint"), rs.getInt("syncInterval"), rs.getTimestamp("custDateLastSync"), rs.getTimestamp("custDateLastRead"), rs.getTimestamp("saleDateLastSync"), rs.getTimestamp("prodDateLastRead"), rs.getTimestamp("transferLastDateRead"), this.getDataAccess());
                    syncSetting.vClone = syncSetting.clone();
                    this.getOriginalList().add((Object)syncSetting);
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static SyncSetting getSyncSetting(DataAccess da) {
        SyncSetting syncSetting = null;
        try {
            String query = "Select * From SyncSetting";
            ResultSet rs = da.select(query, da.getEmptyParameterValues());
            if (rs != null) {
                while (rs.next()) {
                    syncSetting = new SyncSetting(rs.getString("ERPENDPOINT"), rs.getString("endPoint"), rs.getInt("syncInterval"), rs.getTimestamp("custDateLastSync"), rs.getTimestamp("custDateLastRead"), rs.getTimestamp("saleDateLastSync"), rs.getTimestamp("prodDateLastRead"), rs.getTimestamp("transferLastDateRead"), da);
                    syncSetting.vClone = syncSetting.clone();
                }
                rs.close();
                da.closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
        return syncSetting;
    }

    @Override
    public void selectAll(String query, ParameterValue[] param) {
        try {
            this.getOriginalList().clear();
            ResultSet rs = this.getDataAccess().select(query, param);
            if (rs != null) {
                while (rs.next()) {
                    SyncSetting syncSetting = new SyncSetting(rs.getString("ERPENDPOINT"), rs.getString("endPoint"), rs.getInt("syncInterval"), rs.getTimestamp("custDateLastSync"), rs.getTimestamp("custDateLastRead"), rs.getTimestamp("saleDateLastSync"), rs.getTimestamp("prodDateLastRead"), rs.getTimestamp("transferLastDateRead"), this.getDataAccess());
                    syncSetting.vClone = syncSetting.clone();
                    this.getOriginalList().add((Object)syncSetting);
                }
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UserDataList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void select(SearchCondition searchCondition, boolean forward, boolean reset) {
        DataAccess dt = this.getDataAccess();
        if (reset) {
            this.currentPage = 0;
        }
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Object query = "Select First " + 50 + " Skip " + 50 * this.currentPage + " Distinct * From \"Log\" Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        query = (String)query + "order by dateLog ASC";
        ParameterValue[] parameterValue = searchCondition.ConvertoparameterValuesArray();
        ResultSet rs = dt.select((String)query, parameterValue);
        try {
            if (rs != null) {
                while (rs.next()) {
                    SyncSetting syncSetting = new SyncSetting(rs.getString("ERPENDPOINT"), rs.getString("endPoint"), rs.getInt("syncInterval"), rs.getTimestamp("custDateLastSync"), rs.getTimestamp("custDateLastRead"), rs.getTimestamp("saleDateLastSync"), rs.getTimestamp("prodDateLastRead"), rs.getTimestamp("transferLastDateRead"), this.getDataAccess());
                    syncSetting.vClone = syncSetting.clone();
                    this.getOriginalList().add((Object)syncSetting);
                }
                this.currentPage = forward ? ++this.currentPage : (this.currentPage > 0 ? (this.currentPage = this.currentPage - 1) : 0);
                rs.close();
                this.getDataAccess().closeConnection();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ArrayList<SearchClass> selectAutoComplete(String searchString, DataAccess dt) throws SQLException {
        ParameterValue[] parameterValue;
        ArrayList<SearchClass> result = new ArrayList<SearchClass>();
        ArrayList<ParameterValue> tempParamValue = new ArrayList<ParameterValue>();
        tempParamValue.add(new ParameterValue("firstName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("lastName", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("roleDescription", JDBCType.VARCHAR, "%" + searchString + "%"));
        tempParamValue.add(new ParameterValue("userName", JDBCType.VARCHAR, "%" + searchString + "%"));
        SearchCondition searchCondition = new SearchCondition();
        searchCondition.setParametersvalues(tempParamValue);
        Object query = "Select Distinct * From \"User\" Where ";
        for (ParameterValue pv : searchCondition.getParametersvalues()) {
            query = (String)query + pv.getParameterName() + " like ? or ";
        }
        query = ((String)query).substring(0, ((String)query).length() - 3);
        ResultSet rs = dt.select((String)(query = (String)query + "order by firstName ASC"), parameterValue = searchCondition.ConvertoparameterValuesArray());
        if (rs != null) {
            try {
                while (rs.next()) {
                    result.add(new SearchClass(rs.getString("userName"), rs.getString("firstName") + " " + rs.getString("lastName") + "[" + rs.getString("userName") + "]"));
                }
                rs.close();
                dt.closeConnection();
            }
            catch (Exception ex) {
                if (rs != null) {
                    rs.close();
                    dt.closeConnection();
                }
                Logger.getLogger(StockItemList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return result;
    }
}

